#version unofficial MegaPov 0.5;   

#macro Lighting(Color)
texture {
pigment {
slope <1,-1/2,-1> 
color_map {
[.25 rgb Color*1.25 filter .625]
[.3  rgb Color*1.25 filter .75]
[.5  rgb Color*1.25 filter .75]      
[.55 rgb Color*1.25 filter .875]       
[.75 rgb Color*1.25 filter .875]
[.95  rgb Color*1.25 filter 1]
}  
}
finish {ambient 1.5 diffuse 0}     
} 
#end

#declare RobeTx1 =    
texture {pigment {rgb <1,1,0>/2} finish {ambient 1 diffuse 0}}
texture {
pigment {
slope <1/2,-1/2,-1> 
color_map {
[.25 rgb <1,1,.5> filter .625]
[.3  rgb <1,1,.5> filter .75]
[.5  rgb <1,1,.5> filter .75]      
[.55 rgb <1,1,.5> filter .875]       
[.75 rgb <1,1,.5> filter .875]
[.9  rgb <1,1,.5> filter 1]
}  
}
finish {ambient 1.5 diffuse 0 brilliance 0}     
} 
   
#declare RobeTx2 =    
texture {pigment {rgb <.015,.015,.3>} finish {ambient .5 diffuse 0}}
texture {
pigment {
slope <1/2,-1/2,-1> 
color_map {
[.25 rgb <.25,.25,1> filter .625]
[.3  rgb <.25,.25,1> filter .8]
[.5  rgb <.25,.25,1> filter .8]      
[.55 rgb <.25,.25,1> filter .925]       
[.75 rgb <.25,.25,1> filter .925]
[.9  rgb <.25,.25,1> filter 1]
}  
}
finish {ambient 1.5 diffuse 0 brilliance 0}     
}
 
 
#declare RobeTex = 
texture {
image_pattern {png "robepattern1" interpolate 2} 
texture_map 
{
[0 RobeTx2]
[1 RobeTx1]
}
scale 2*x
scale 1/3 //scale 4 warp {turbulence 1} scale 1/4             
scale 3.5 
translate 25
rotate -45*z                  
translate <0,1/4,0>
}


 
#declare RobeTex1 =    
texture {RobeTx2} 

#declare RobeTex2 =    
texture {
pigment {rgb -10}
finish {ambient 0 diffuse 0 brilliance 0}     
}  

#declare Breathing =
spline {
cubic_spline
0,0
.25,1
.5,0
.75,1
1,0
}




#if (EyeBalance > 0)
#declare EB1 = abs(EyeBalance)
#else                        
#declare EB1 = 0
#end 
    
#if (EyeBalance < 0)
#declare EB2 = abs(EyeBalance)
#else                        
#declare EB2 = 0
#end
#declare Hogwire =
union {
#declare RightEye = 
difference {
sphere {0,.925 scale <1/3,1/2+.025,1/2.8> rotate -30*z translate <-1/4,1/2,-.8>} 
disc {0,-x,2}
disc {0,-y,2 rotate 30*z translate (-.5+(Lids*(1-EB2)))*y rotate -30*z translate <-1/4,1/2,-.9>}
}  
#declare LeftEye = 
difference {
sphere {0,.925 scale <1/3,1/2+.025,1/2.8> rotate 30*z translate <1/4,1/2,-.8>} 
disc {0,x,2}
disc {0,-y,2 rotate -30*z translate (-.5+(Lids*(1-EB1)))*y rotate 30*z translate <1/4,1/2,-.9>}
}
//The face =
union {
difference {
blob { threshold .1 
sphere {0,1,1/2   scale <1,1.25,.875> translate y/2}            
sphere {0,1.1,1/4 scale <1,1.25,.875> translate y/2}   
sphere {0,1.2,1/4 scale <1,1.25,.875> translate y/2} 
cylinder {y/2,-y*1.5,.4,1 translate z/2}
sphere {0,1,1/4 scale <1/2,1/2,3/4> translate -z*1.25 translate -y/8}
sphere {0,1,1/8 scale <1,2/3,1> translate -z*.75 translate -y/8}        
sphere {0,1,1/4 scale <1/2,1/2,3/4> translate -z*.5 translate -y/8 }
sphere {0,1,1/8 scale <1,2/3,1> translate -z*.25 translate -y/8}   
sphere {0,1,1/4 scale <1/3,.6,3/4> translate -z*.75 }
sphere {0,1,1/8 scale <1/3,.7,1> translate -z*.5} 
sphere {0,1,1/4 scale <.4,.4,.2> rotate -45*y translate <.9,.3,0>}    
sphere {0,1,-1/2 scale <.3,.3,.2> rotate -60*y translate <1,.2,-.075>} 
sphere {0,1.25,-1 scale <.2,.2,.1> rotate -80*y translate <.925,.25,-.15>}
sphere {0,1,1/4 scale <.4,.4,.2> rotate 45*y translate <-.9,.3,0>}    
sphere {0,1,-1/2 scale <.3,.3,.2> rotate 60*y translate <-1,.2,-.075>}    
sphere {0,1.25,-1 scale <.2,.2,.1> rotate 80*y translate <-.925,.25,-.15>}
//Eyes
sphere {0,1,40 scale <.3,1/2,1/3> rotate 30*z translate <1/4,1/2,-.75>} 
sphere {0,1,40 scale <.3,1/2,1/3> rotate -30*z translate <-1/4,1/2,-.75>} 
}
object {RightEye}
object {LeftEye} 
texture { 
pigment {rgb <1,.8,.6>}
//finish {ambient <.6,.4,.4> diffuse .5 brilliance 0}              
finish {ambient <.6,.4,.4>/2 diffuse 0}    
}
Lighting(<1,.65,.45>)

}
union {
difference {
sphere {0,.85}      
sphere {0,.2 translate <0,0,-.9> rotate <EyeRotate.x,-EyeRotate.y,EyeRotate.z> rotate -30*z pigment {rgb 0}}
//sphere {0,.05 scale z/2 translate vtransform(<0,0,-.1>,rotate 30*z scale z/3 rotate 45) translate <0,0,-.85>  pigment {rgb 10}}
scale <1/3,1/2+.025,1/3> rotate 30*z translate <1/4-.005,1/2,-.75>
}
difference {
sphere {0,.85}      
sphere {0,.2 translate <0,0,-.9> rotate EyeRotate rotate -30*z pigment {rgb 0}}
//sphere {0,.05 scale z/2 translate vtransform(<0,0,-.1>,rotate 30*z scale z/3 rotate 45) translate <0,0,-.85>  pigment {rgb 10}}
scale <1/3,1/2+.025,1/3> rotate 30*z translate <1/4-.005,1/2,-.75>
scale -x
}
texture {
pigment {rgb 1}
//finish {ambient .75 diffuse .25 brilliance 0}  
finish {ambient .5 diffuse 0}}
Lighting(1)
}
#declare BW1 = spline {cubic_spline 0,0 .5,1 1,.5}
#declare BW2 = spline {cubic_spline 0,0 .25,1 1,0}
#declare BW3 = spline {cubic_spline 0,0 .75,1 1,.75}    
#declare BeardSpline = 
spline {
cubic_spline
0,0 
.5,<0,-1/2-1/10*MouthOpen,-.3>
.75,<-.3,-3/4,-.5>      +(.2*x*BW3(MouthWidth))     +(.2*x*BW1(MouthOpen))+(-y/10*MouthOpen)
.875,<.1,-.875,-.75>   +(-.15*x*BW1(MouthWidth))      +(-.15*x*BW2(MouthOpen))+(-y/15*MouthOpen)
1,<0,-1,-1>           +(.05*x*BW2(MouthWidth))      +(.05*x*BW3(MouthOpen))+(-y/20*MouthOpen)
}      
union {
blob {threshold .1       
#declare C=0
#declare N=60
#while (C<N)
sphere {0,(1-C/N)*.975,1/2 scale <.875,1,.5>
translate (BeardSpline(C/N))*<1,2,1>
}
#declare C=C+1
#end 
//Mouth
cylinder {0,-y/2*MouthOpen+.0001*y,.5,1 scale <MouthWidth/2+1/2,1/2,1> translate <0,-.8,-.225>  } 
cylinder {0,-y/2,.25 ,-1   /4*(MouthOpen) scale <MouthWidth,.35*MouthOpen+.0001,2> translate <0,-.75,-.3>      pigment {rgb -.75}}
cylinder {0,-y/2,.275,-1.5 /4*(MouthOpen) scale <MouthWidth,.35*MouthOpen+.0001,2> translate <0,-.75,-.3>  pigment {rgb -.75}}
cylinder {0,-y/2,.3  ,-1.5 /4*(MouthOpen) scale <MouthWidth,.35*MouthOpen+.0001,2> translate <0,-.75,-.3>  pigment {rgb -.75}}
cylinder {0,-y/2,.325,-1   /4*(MouthOpen) scale <MouthWidth,.35*MouthOpen+.0001,1> translate <0,-.75,-.3>      pigment {rgb -.75}}
//Sideburns
sphere {0,1,1 scale <.3,.75,1/6> translate <.75,.25,0>} 
sphere {0,1,1 scale <.4,.75,1/6> translate <.65,0,-.1>}    
sphere {0,1,1 scale <.5,.5,1/4> rotate 20*x  translate <.45,-.4,-.15>} 
sphere {0,1,1 scale <.3,1/4,1/2> translate <.75,.625,.25>}   
sphere {0,1,1 scale <.3,1/4,1/2> translate <.75,.75,.25>} 

sphere {0,1,1 scale <.3,.75,1/6> translate <-.75,.25,0>} 
sphere {0,1,1 scale <.4,.75,1/6> translate <-.65,0,-.1>}    
sphere {0,1,1 scale <.5,.5,1/4> rotate 20*x  translate <-.45,-.4,-.15>} 
sphere {0,1,1 scale <.3,1/4,1/2> translate <-.75,.625,.25>} 
sphere {0,1,1 scale <.3,1/4,1/2> translate <-.75,.75,.25>} 
}
blob {
threshold .1
//Eyebrows
sphere {0,1,1 scale <.375,.2,.25> rotate -10*z translate <.4,.75,-.65>}     
sphere {0,1,1 scale <.375,.15,.25> rotate 5*z translate <.4,.85,-.65>}  
sphere {0,1,1 scale <.25,.15,.2> rotate 65*z translate <.15,.95,-.65>}  
sphere {0,1,1 scale <.25,.1,.2> rotate 35*z translate <.2,.9,-.65>}  
translate -.2*y                
translate .15*Lids*y  
translate (-.35+(1-EB1)*.35)*y
}
blob {
threshold .1
//Eyebrows
sphere {0,1,1 scale <.375,.2,.25> rotate -10*z translate <.4,.75,-.65>}     
sphere {0,1,1 scale <.375,.15,.25> rotate 5*z translate <.4,.85,-.65>}  
sphere {0,1,1 scale <.25,.15,.2> rotate 65*z translate <.15,.95,-.65>}  
sphere {0,1,1 scale <.25,.1,.2> rotate 35*z translate <.2,.9,-.65>}  
scale -x  
translate -.2*y  
translate .15*Lids*y 
translate (-.35+(1-EB2)*.35)*y
} 
texture {
pigment {rgb <1,.9,.75>}
finish {ambient .25 diffuse 0}}
Lighting(<1,.9,.75>*1.5)//<1,.8,.5>/2) 
translate <0,.125,-.25>          
}



blob {
threshold .1
sphere {0,1,1 scale <1.375,.5,1.375> rotate 20*x translate y}
sphere {0,1,-2 scale <1.5,1.5,1.5> translate -y*1.5 rotate 20*x translate y}
sphere {0,1,-2 scale <1.5,.5,1.5> translate -y/2 rotate 20*x translate y}
sphere {0,1,1 scale <1.15,2.5,1.15> rotate 30*x translate y}    
sphere {0,1,1 scale <.65,1,.65> rotate 60*x translate <0,2.5,1>}  
sphere {0,1,1 scale <.55,1,.55> rotate 100*x translate <0,2.5,1.5>}
sphere {0,1,1 scale <.25,1,.25> rotate 100*x translate <0,2.5,1.5>}
rotate -90*y
texture {RobeTex rotate 45*y} 
translate -y
rotate 10*Lids*x 
rotate -12.5*EyeBalance*z
translate y
translate <0,-.06125,.125>
}
translate <0,1.5,-.25>
rotate HeadRotate
translate <0,-1.5,.25>
}
torus {2,2
clipped_by {cylinder {0,y*2,2.5}} 
clipped_by {plane {-z,0 rotate -20*y}}   
clipped_by {plane {-z,0 rotate 20*y}}   
scale <.75,.875,1.25>
rotate -25*x
translate <0,-2.375,.25>   
texture {RobeTex1}
} 
#macro Arm(URot,LRot,FoldRot,Side)
#declare UArmTransform = transform{rotate URot translate <-1.125,-1.5,.25> scale Side*x}      
#declare LArmTransform = transform{rotate LRot translate <0,-2,0> transform UArmTransform}    
cylinder {0,<0,-2,0>,.5,1 texture {RobeTex} transform UArmTransform} 
cylinder {0,<0,-2,0>,.5,1 texture {RobeTex1} transform LArmTransform}
cylinder {y*.25,0,.55,1 scale y*1.5 scale 1.5*z translate -2*y translate .25*z texture {RobeTex1} rotate FoldRot transform LArmTransform} 
cylinder {y*.25,0,.4,-3/4 scale 2*y scale 1.5*z translate -2.25*y translate .25*z texture {RobeTex2} rotate FoldRot transform LArmTransform} 
cylinder {y*.25,0,.3,-1/4 scale 2*y scale 1.5*z translate -2.25*y translate .25*z texture {RobeTex2} rotate FoldRot transform LArmTransform} 
cylinder {0,<0,-2,0>,.3,-3/4 translate -1.5*y texture {RobeTex2} transform LArmTransform}
cylinder {0,<0,-2,0>,.4,-1/4 translate -1.5*y texture {RobeTex2} transform LArmTransform}
cylinder {0,<0,-2,0>,.3,-3/4 scale 1.25*z translate .125*z translate -1.5*y texture {RobeTex2} rotate FoldRot transform LArmTransform}
#end 
#macro Finger(RD,L,R,N,RT,T)
#local L = (1-(abs(R)/360))*L
#declare C=0;
#while (C<L)
sphere {0,1,1/6
scale <1,1,1>
scale RD/4//*(pow((C/(L+.2)),2)*.25+.125)
translate <0,0,-C>
rotate (R*(C/L))*x
rotate RT
translate T
}             
#declare C=C+(L/N) 
#end        
#end 
#macro Finger2(RD,L,R,N,RT,T)
#local L = (1-(abs(R)/360))*L
#declare C=0;
#while (C<L)
sphere {0,1,1/24
scale <1,1,1>
scale RD/4//*(pow((C/(L+.2)),2)*.25+.125)
translate <0,0,-C>
rotate (R*(C/L))*x
rotate RT
translate T
}             
#declare C=C+(L/N) 
#end        
#end 

#macro BWHand(Rot1,Rot2,Rot3,Rot4,URot,LRot,WRot,Side) 
#declare UArmTransform = transform{rotate URot translate <-1.125,-1.5,.25> scale Side*x}      
#declare LArmTransform = transform{rotate LRot translate <0,-2,0> transform UArmTransform}    
blob {threshold .1
#declare AntiRot1 = (Rot1/120) 
#declare AntiRot2 = (Rot2/120) 
#declare AntiRot3 = (Rot3/120) 
Finger(1.125,1.5,Rot2,20,(-10-10*AntiRot2)*y,(.125-.125/2*AntiRot2)*x)
Finger(1.125,1.66,Rot1,20,(10+10*AntiRot1)*y,-(.125-.125/2*AntiRot1)*x) 
Finger(1.125,1.4,Rot3,20,-20*y,<.4,-.125/2,.25>)  
Finger(1.06125,1,Rot4,20,<-15,50,0>,<-.5,-.125,.25>)    
Finger2(1.5,.5,Rot4/2,10,<-15,50,0>,<-.375,0,.175>)  
//Thumb(1,1.33,Rot4,20,<0,30,0>,<-.5,.25,.25>)  
#declare C=0
#while (C<10)
sphere {0,1.5+.1*C,.125/9 translate <0,0,.25> scale <1,1.25,1> scale y/3 translate .25/3*y scale (.5+(.125*C))}  
#declare C=C+1
#end    
sphere {0,1.4,.125 translate <0,0,.25> scale <1,1.25,1> scale y/3 translate -.25/3*y scale .5}  
sphere {0,1.4,.125 translate <0,0,.25> scale y/4 translate -.25*y scale .5}  
cylinder {0,z*3,.425,.25 scale y*2/3 rotate <-WRot.x,-WRot.y,0>} 
texture {
pigment {rgb <1,.8,.6>}
//finish {ambient <.6,.4,.4> diffuse .5 brilliance 0} 
finish {ambient <.6,.4,.4>/2 diffuse 0}}
Lighting(<1,.65,.45>)
rotate WRot
rotate -90*x                                        
scale 2/3 
scale -x
translate <0,-2.5,0>
transform LArmTransform   
}
#end     
blob {
threshold .1     
sphere {0,1,1 scale <1.25,3,1> translate <0,-2.5,.5>}   
sphere {0,1,1 scale <1.25,2.5,1> translate <0,-3.5,0> translate y/15*Breathing(clock)}  
sphere {0,1,1 scale <1,2,1> translate <0,-3.5,.25>}  
cylinder {-x,x,.75,1 translate <0,-1.5,.25> translate y/15*Breathing(clock)} 
Arm(RArmURot,RArmLRot,RArmFRot,1)  
Arm(LArmURot,LArmLRot,LArmFRot,-1)  
texture {RobeTex translate .5*y}
translate <0,0,1/2>
} 
BWHand(RHRot.x,RHRot.y,RHRot.z,RHRot.u,  RArmURot,RArmLRot,RArmWRot,1)
BWHand(LHRot.x,LHRot.y,LHRot.z,LHRot.u,  LArmURot,LArmLRot,LArmWRot,-1)   
}