#version unofficial MegaPov 0.5;   
global_settings {
max_trace_level 40  
post_process { overwrite_file 
find_edges{1,.5,.7,1,2,rgb .05}}   
assumed_gamma 1.25
}
#include "colors.inc"

//camera { location <-10,7.5,-25> direction 1 look_at <0,10,14>}                
//camera { location <-10,15,5> direction 1/2 look_at <0,5,10>}
camera { location <-3,5.75,7> direction 3/4 look_at <-1.5,6.5,13>} 

//Lights to give Hogwire (and all animated objects) his "Catoony" look. 
//These were discontinued in favor of the slope texture.
/*light_source {<-5,6,15>*20    rgb 1.0 groups "Cartoon"}// shadowless}   
light_source {<-5,8,7.5>*20   rgb 1/4 groups "Cartoon" shadowless}   
light_source {<-5,10,-.25>*20 rgb 1/4 groups "Cartoon" shadowless} */

light_source {<-5,0,12.5>*2000 rgb 3 groups "Sun"}           
light_source {<5,0,12.5>*2000 rgb <.2,.25,.5> groups "Sun" shadowless}  
light_source {<-5,6,12.5>*2000 rgb 3 groups "Sun"}// area_light 1000,1000,2,2 orient adaptive 0}           

//Lights that give highlights 
//Sunlight falling on cedars...
light_source {<5,.1,10>*1.5 rgb 3*<.35,.25,.2>/3 fade_distance 12 fade_power 2 shadowless   groups "RoomDetail1"}  
//Bluish light in upper left-hand corner.
light_source {<-17.5,15,0>*1.5 rgb <.2,.25,.5> fade_distance 10 fade_power 2 shadowless  groups "RoomDetail1"}



//#include "Office(closeup).inc"
#include "S4AD.inc"
#include "Hogwire.inc"
object {Hogwire 
scale 1
translate <0,9,15.5> 
no_shadow
} 
union {#include "FrogSandwich.inc" 
scale 1/3 
rotate 0*y
translate <-2.5,5,9>  
}
 

#declare BaseSpline = 
spline {
cubic_spline 
0,<-2,-10,150>,
1/2,<-3,2,10>,
2/3,<-1.75,2,1>,  
.8,<0,0,0>  
}

#if (clock > .3)

//motion_blur {
union {
#declare F=0
#declare NoF=100
#while (F<NoF)   
#declare Rnd1 = rand(seed(F*F*F+1*76876))*2
#declare Rnd2 = rand(seed(F*F*F*F*F*F-30*886))*2   
#declare Rnd3 = rand(seed(F*F*F*F*F+50*334876))*2  
#declare Rnd4 = rand(seed(F*F*F*F*F*F-886))*2   
#declare Rnd5 = rand(seed(F*F*F*F*F+50+4876))*2
#declare Floor = 0
#declare SP1 = vtransform(<0,Rnd1+Rnd3/8,0>,rotate 436546547*Rnd2 rotate -768946547*Rnd1 rotate 768946547*Rnd3)                      
#declare SP2 = vtransform(<0,Rnd2+Rnd1/8,0>,rotate 436546547*Rnd1 rotate -768946547*Rnd2 rotate 768946547*Rnd3)                      
#declare SP3 = vtransform(<0,-Rnd3+Rnd2/8,Rnd1>,rotate 436546547*Rnd3 rotate -768946547*Rnd2 rotate 768946547*Rnd1)                  
#declare SP4 = vtransform(<0,-Rnd1+Rnd3/4,Rnd1>,rotate 436546547*Rnd2 rotate -768946547*Rnd1 rotate 768946547*Rnd1)/2+ 
               <(Rnd4*5-2.5)/20,1/4.75,(Rnd5*4-4+Rnd1*4)/20>*<1,1,1/1.75>+<-1/8,0,-1/8>
#declare SP5 = <(Rnd4*5-2.5)/20,1/4.75,(Rnd5*4-4+Rnd1*4)/20>*<1,1,1/1.75>+<-1/8,0,-1/8>
#declare SP6 = <(Rnd4*5-2.5)/20,1/4.75,(Rnd1*4-4+Rnd2*4)/20>*<1,1,1/1.75>+<-1/8,0,-1/8>
#declare SP7 = <(Rnd5*5-2.5)/20,1/4.75,(Rnd2*4-4+Rnd3*4)/20>*<1,1,1/1.75>+<-1/8,0,-1/8>
#declare SP8 = <(Rnd1*5-2.5)/20,1/4.75,(Rnd3*4-4+Rnd4*4)/20>*<1,1,1/1.75>+<-1/8,0,-1/8>


                  
#if (SP1.y < Floor) #declare SP1 = <SP1.x,.25+Floor+Rnd1/3,SP1.z> #end
#if (SP2.y < Floor) #declare SP2 = <SP2.x,.25+Floor+Rnd2/3,SP2.z> #end
#if (SP3.y < Floor) #declare SP3 = <SP3.x,.25+Floor+Rnd1/3,SP3.z> #end
#if (SP4.y < Floor) #declare SP4 = <SP4.x,.25+Floor+Rnd3/3,SP4.z> #end
#if (SP5.y < Floor) #declare SP5 = <SP5.x,.25+Floor+Rnd1/3,SP5.z> #end 



#declare RandomFlySpline = 
spline {
cubic_spline 
0,   SP1
.25, SP2/5
.5, SP3/4
.625,SP4/3 
.78,  SP5 
.799,  SP5  
.8,  SP5 
.801,  SP5 
.82,  SP5
1,   SP6
1.25,SP7
1.5, SP8
}                                                                                          
#declare point1 = <0,0,0>+RandomFlySpline(clock-.125-.0075+Rnd1/8)*2+BaseSpline(clock-.125      -.0075+Rnd3/8)
   
union {
sphere {0,.125/6 scale y/2 pigment {rgb 0}}
disc {0,z,.125/10 pigment {rgbt 1} scale y*2 rotate 45*z rotate 20*x translate .125/6*y translate -.125/6*x
rotate z*(rand(seed(F*F*clock*100+clock))*90-45)
}
disc {0,z,.125/10 pigment {rgbt 1} scale y*2 rotate -45*z rotate 20*x translate .125/6*y translate .125/6*x
rotate -z*(rand(seed(F*F*clock*100+clock))*90-45)
}   
translate point1+.0001
}
 
#declare F=F+1 
#end     
translate <-2.5,5,9>  
}
#end 


#declare BaseSpline2 = 
spline {
cubic_spline 
0,<2,4,-1>,
1/3,<-1/2,2,0>, 
.49,<0,5/3/4,0>, 
1/2,<0,5/3/4,0>, 
.51,<0,5/3/4,0>, 
.6,<0,5/3/4,1/2>         
.7,<1/4,5/3/4,0>
.8,<-1/4,5/3/4,0>                  
1,<0,1,0> 
1.25,<-1,2,1/2>,    
1.5,<-1,6,1>
} 
#declare point3 = <0,0,0>+BaseSpline2(clock*2+.1)
#declare point4 = <0,0,0>+BaseSpline2(clock*2+.105)
//merge {
union {
sphere {0,.125/6 scale y/2 pigment {rgb 0}}
disc {0,z,.125/10 pigment {rgbt 1} scale y*2 rotate 45*z rotate 20*x translate .125/6*y translate -.125/6*x
rotate z*(rand(seed(clock*100+clock))*90-45)
}
disc {0,z,.125/10 pigment {rgbt 1} scale y*2 rotate -45*z rotate 20*x translate .125/6*y translate .125/6*x
rotate -z*(rand(seed(clock*100+clock))*90-45)
}
scale 1.5   
translate <-2.5,5,9>+point3
}

glow {color -<1/2,1/2,1>/8 type 1 color -<1/2,1/2,1>/8 location <-15,14,0>}      
glow {color <1,.9,.9>      type 1  location <-5,20,32>}      
glow {color <.125,.25,.5>   type 1  location <5,20,32>} 
sphere {0,.000001} 
