#version unofficial MegaPov 0.5;   
global_settings {
max_trace_level 40   
post_process { overwrite_file find_edges{1,.5,.7,1,2,rgb .05}}   
assumed_gamma 1.25
}
background {rgb .5}
/*camera {      
location <-2,0,-3>*4
direction 1
look_at -y
}*/  
camera {location <0,5,-20> direction 1 look_at y*5  
} 
light_source {<-20,40,10>*200 rgb 2}  
light_source {<-20,40,10>*200 rgb 1/2 shadowless} 
light_source {<0,20,0>*200 rgb <.15,.25,.5>*2 shadowless} 
light_source {<20,-40,10>*200 rgb <.1,.25,.1> shadowless} 
light_source {<20,-40,-10>*200 rgb 1/4 shadowless} 


#declare BarkTexture = 
texture {
pigment {rgb <.8,.5,.3>}
normal {granite scale 5*y scale 1/4 bump_size 1.5}
finish {ambient 0 diffuse 1}
}

#declare LeafTexture = 
texture {
pigment {rgb <.1,1,.1>*.75}
normal {granite scale 1 bump_size 2}
finish {ambient 0 diffuse 1}
} 
#declare GroundTexture = 
texture {
pigment {bozo color_map {[.4 rgb <.1,1,.1>*.375][.45 rgb <.8,.4,.2>/2]} scale 6 warp {turbulence 1} scale 1/6 scale 4}
normal {granite scale 5 bump_size 1}
finish {ambient 0 diffuse 1/2}
}  

#macro Tree(Random,MaxAngle)
#declare C=0
#declare N=10
#while (C<N)
#declare Rand = rand(seed(C*C*C+4+Random))
#declare Rand2 = rand(seed(C*C*C*C+6+Random+Random+546546))   
#declare Rand3 = rand(seed(C*C*C*C+3*Random+67657))
#declare Rand4 = rand(seed(C*C*C+2+Random*Random+99))
#declare R0 = (Rand2/2+1/4)/3
#declare R1 = (Rand3/2+1/4)/6         
#declare R2 = (Rand4/4+1/4)/2   
#declare R3 = (Rand/8+1/8 )/2       
#declare R4 = (Rand3/16+1/16)/2
union {
cone {0,R0,y*2+y*Rand4,R1}
sphere {0,R0}  
union {
cone {0,R1,y,R2}
sphere {0,R1}   
        union {
        cone {0,R2,y,R3}  
        sphere {0,R2}  
                union {
                cone {0,R3,y,R4}
                sphere {0,R3}
                
                
                #if (Rand3 > .125)
                union {
                sphere {y*.6,2/3}                 
                /*sphere {x*2/3,1/3 rotate Rand2*56456-Rand4*54667+Rand*2344 translate y*.6}  
                sphere {x*2/3,1/3 rotate Rand*5656-Rand2*54667+Rand2*244 translate y*.6}   
                sphere {x*2/3,1/3 rotate Rand3*56456-Rand*5467+Rand4*344 translate y*.6}  
                sphere {x*2/3,1/3 rotate Rand4*34456-Rand3*22667+Rand2*24 translate y*.6}   */
                texture {
                pigment {rgb <.1+.875*Rand2,1-.75*Rand4,.1>*.75}
                normal {granite scale 1 bump_size 2}
                finish {ambient 0 diffuse 1} 
                scale 2
                } 
                }   
                #end
                
                texture {BarkTexture translate y*5*Rand3}
                rotate <MaxAngle*Rand3-MaxAngle/2,MaxAngle*Rand-MaxAngle/2,MaxAngle*Rand2-MaxAngle/2>
                translate y
                }      
        texture {BarkTexture translate y*5*Rand2}
        rotate <MaxAngle*Rand4-MaxAngle/2,MaxAngle*Rand2-MaxAngle/2,MaxAngle*Rand3-MaxAngle/2>
        translate y
        } 
texture {BarkTexture translate y*5*Rand}
rotate <MaxAngle*Rand4-MaxAngle/2,MaxAngle*Rand2-MaxAngle/2,MaxAngle*Rand-MaxAngle/2>
translate y*2+y*Rand4
}           
texture {BarkTexture}
//rotate <MaxAngle*Rand-MaxAngle/2,MaxAngle*Rand4-MaxAngle/2,MaxAngle*Rand3-MaxAngle/2>
}           
#declare C=C+1
#end 
#end


#declare B=0
#declare T=50
#while (B<T) 
#declare Rand5 = rand(seed(B*B*B+5546))   
#declare Rand6 = rand(seed(B*B+357))
#declare Rand7 = rand(seed(B*B*B*B-99))
#declare Loc = vtransform((Rand5*60+Rand6/2+10)*x, rotate Rand5*6587567*y rotate -Rand6*7567*y rotate Rand7*14567*y)
#if (Loc.z <0)
#declare Loc = <Loc.x,Loc.y,-Loc.z>
#end  
#if (Loc.x <10)
#declare Loc = <Loc.x+20,Loc.y,Loc.z>
#end  
#if (Loc.x >10)
#declare Loc = <Loc.x-20,Loc.y,Loc.z>
#end
union {Tree(B+6,100) scale 2 translate Loc}
#declare B=B+1
#end          

#declare B=0
#declare T=150
#while (B<T) 
#declare Rand5 = rand(seed(B*B*B+546))   
#declare Rand6 = rand(seed(B*B+1357))
#declare Rand7 = rand(seed(B*B*B*B-299))
#declare Loc = vtransform((Rand5*60+Rand6/2+10)*x, rotate Rand5*6587567*y rotate -Rand6*7567*y rotate Rand7*14567*y)
#if (Loc.z <0)
#declare Loc = <Loc.x,Loc.y,-Loc.z>
#end  
#if (Loc.x <10)
#declare Loc = <Loc.x+20,Loc.y,Loc.z>
#end  
#if (Loc.x >10)
#declare Loc = <Loc.x-20,Loc.y,Loc.z>
#end
sphere {y*.375,1/2 
scale 2 translate Loc
texture {
pigment {rgb <.1+.875*Rand5,1-.75*Rand6,.1>*.75}
normal {granite scale 1 bump_size 2}
finish {ambient 0 diffuse 1}
scale 2
}
}
#declare B=B+1
#end  

#declare B=0
#declare T=500
#while (B<T) 
#declare Rand5 = rand(seed(B*B*B+1464))   
#declare Rand6 = rand(seed(B*B+1574))
#declare Rand7 = rand(seed(B*B*B*B-1299))
#declare Loc = vtransform((Rand5*60+Rand6/2+10)*x, rotate Rand5*6587567*y rotate -Rand6*7567*y rotate Rand7*14567*y)
#if (Loc.z <0)
#declare Loc = <Loc.x,Loc.y,-Loc.z>
#end  
#if (Loc.x <10)
#declare Loc = <Loc.x+20,Loc.y,Loc.z>
#end  
#if (Loc.x >10)
#declare Loc = <Loc.x-20,Loc.y,Loc.z>
#end
sphere {y*.15,.25   
scale 2 translate Loc
texture {
pigment {rgb <.1+.875*Rand5,1-.75*Rand6,.1>*.75}
normal {granite scale 1 bump_size 2}
finish {ambient 0 diffuse 1} 
scale 2
} 
}
#declare B=B+1
#end 

sky_sphere {
pigment {
planar 
color_map {
[.75 rgb <.5,.5,.625>]    
[1 rgb <.85,.84,.825>]
}
scale y/2
} 
pigment {
bozo 
pigment_map {[0 bozo color_map {[.4 rgb 1 transmit .125][.6 rgb 1 transmit 1]}scale .125][.5 rgb 1 transmit 1]
}
turbulence 1/2
scale 1/7
scale y/3
}
} 
plane {y,0 texture {GroundTexture}}

fog {fog_type 2 distance 10 rgb <0,.125,0>
fog_offset 0
fog_alt 1
} 

//glow {1 glow_type 1 color <1,1,.9> location <-10,15,0>}      
//glow {2 glow_type 1 color 1 location <5,5,32>}      
