// SWExplode.pov
//  Written by H.E.Day
//  Modified, cleaned up, and properly indented by Mark Wagner

#ifndef(included)
	#include "colors.inc"
	camera {
		location  <0, 0, 16.6>/4
		look_at <0,0,0>
	}
	light_source {0 rgb 1}
#end
#ifndef(Random)
	#declare Random = 125; //Random (any) Number.
#end
#ifndef(Color)
	#declare Color = <1,.625,.25>-(<0,.125,.25>*clock);//Red Green Blue value for the overall 
	//color of the explosion (Change to <1,1,1> to get an Alpha Mask).
#end
#ifndef(Detail)
	#declare Detail = 1;//Amount of "smoothness". change to < .5 for bigger explosions.
#end
#ifndef(Turbulence)
	#declare Turbulence = .5;//Change to vary the amount of "violence".
#end

#ifndef(AnimationAmount)	
	#declare AnimationAmount = 1.5;//How much does the explosion "change" during 
	//the animation? 1 - 1.75 is good for small explosions, .25 - 1 for larger ones.
#end
#ifndef(StreakNumber)
	#declare StreakNumber = 0;//Number of "streaks" flying away.
#end




//Macros and Code follows
//Start Flare and Glow

#macro StartGlow(R,N,S,E,C,RT) 
	#declare GCLock = mod((C-S)/(E-S), 1);
	#if (GCLock > 0) 
		#if (C < E)
			#declare C=0;
			#while (C< N)
				#declare S = seed(C+R); 
				#declare SR = seed(R);
				disc {0,y,1 
					texture { 
						pigment { 
							cylindrical
							color_map {
							[0 rgb <1,.75,.5>*2-((1-EColor)*2*GCLock) transmit 1]
							[1 rgb <1,.75,.5>*2-((1-EColor)*2*GCLock) transmit .75+.25*GCLock]
							}
							turbulence .125
						}
						finish {ambient 1.5 diffuse 0} 
					}
					scale <.3*(rand(SR)*.75+.25),1,1> 
					rotate 345546*y*23346*rand(C)
					rotate 36*y+23346*rand(C)
					rotate y+6*(rand(C)*360) 
					translate (rand(C)*.1)-.05*y
					rotate -RT*y*GCLock
					rotate 90*x
					scale  1.5
				}
				#declare C=C+1;
			#end 
			disc {0,y,1 
				texture { 
					pigment { 
						cylindrical
						pigment_map {
							[0 rgb <1,.75,.5>*2-((1-EColor)*2*GCLock) transmit 1]
							[.125 bozo color_map {[0 rgb 2-((1-EColor)*2*GCLock) transmit .5+.5*GCLock][1 rgb 2-((1-EColor)*2*GCLock) transmit 1]} scale .5 ] 
							[-.5*GCLock+1 rgb <1,.75,.5>*2-((1-EColor)*2*GCLock) transmit 1*GCLock]
						}
						rotate (rand(SR)*360)
						turbulence .25
						scale .75 
						translate -.5*GCLock*y
					}
					finish {ambient 1.25 diffuse 0} 
				}				
				scale 1.25
				translate .05*y
				rotate 90*x
			}			
		#end 
	#end
#end    


//Streak Macro
#macro Streak(SRand,SBright,SLimit,SClock)
	#declare S1=seed(SRand)
	#declare S2=seed(SRand*45)  
	#declare ERandA = (rand(S1)*1)
	#if (SClock > 0)
		disc {0,y,1 hollow on
			texture { 
				pigment {spherical
					pigment_map {
						[0 rgb 0 transmit 1]
						[.75 bozo color_map {[0 rgb EColor*1.5 transmit 0][1 rgb EColor*1.5 transmit .875]}translate -5*y*SClock translate SRand/10 scale .125 scale 1/<.25,1,5> ]
						[1 rgb EColor*1.5]
					} 
					scale <1,1,-2*SClock+4>
					translate <0,0,1.5*SClock>
				}
				finish {ambient (1*(rand(S1)*1))*(2*(1-SClock)) diffuse 0} 
			}
			texture { 
				pigment {spherical
					pigment_map {
						[0 rgb 0 transmit 1] 
						[.5 rgb EColor*1.5 transmit .5]
						[1 rgb <1,.75,.25>*3]
					} 
					scale <1.5,1,.5>/2
					translate <0,0,.85>
				}
				finish {ambient (1.5*(rand(S1)*1))*(2*(1-SClock)) diffuse 0} 
			}
			#if (SClock < .5)
				scale <1,1,1*SClock+.5>
			#else
			#end
			scale <.25*((rand(S2)*1)+.5),1,3*((rand(S2)*.75)+.25)>*((rand(S1)*.5)+1 )
			rotate -90*x			
			translate (((rand(S1)*2.5)-1.5)+((rand(S1)*SLimit/2)+SLimit/2)*SClock)*y
			#declare Seed = seed(SRand)
			rotate (rand(Seed)*2344+(45*SRand*23))*z
			translate ((rand(S1)*.25)-.125)*z 
			scale .125*SClock+.25
		} 
	#end
#end




//The Explosion
#macro Explosion (ETrans,EColor,ES,EAnimate,ERadius,EClocka,EStart,EEnd,EDetail,EShock,ETurb)
#declare EClock = mod((EClocka - EStart)/(EEnd - EStart), 1); 
#declare ESeed = seed(ES)
#declare ERand = rand(ESeed)
#local EIntensity = (1-(EClock/2))*.25; 
#local EIntensity2 = (1-EClock)*.25;
union {
#if (EClock > 0)
union {
sphere {0, 1 hollow on
pigment { rgbt 1}
interior {
media{
intervals 50*EDetail
samples 1,2
variance 1/600
confidence .9999
emission EColor*EIntensity/ERadius
density { spherical
color_map{
[0 rgb 0]
[0.124 rgb 0]
[0.125 rgb 4]
[1 rgb 1]

}
translate (-2*EAnimate)*EClock*y
warp {turbulence .75*ETurb}
translate (2*EAnimate)*EClock*y
rotate ERand+6787
}
density { spherical
color_map{
[0 rgb 0]
[.249 rgb 0]
[0.25 rgb (-5*EClock+6)]
[1.0 rgb 1]
}
translate (1*EAnimate)*EClock*z
warp {turbulence .5*ETurb }
translate (-1*EAnimate)*EClock*z
rotate 323456*ERand+567
}

density { bozo
color_map{
[0 rgb 0]
[0.2*clock+.0001 rgb 0]
[-.2*clock+.0001 rgb 1]
[1.0 rgb 1]}
scale .2
translate (1*EAnimate)*EClock
warp {turbulence .25*ETurb omega .1}
translate (-1*EAnimate)*EClock
rotate 3456*ERand
}

density { bozo
color_map{
[0 rgb 0]            
[0.2*clock+.0001 rgb 0]
[-.2*clock+.0001 rgb 1]
[1.0 rgb 1]
}
scale .1
translate (-1*EAnimate)*EClock
warp {turbulence .25*ETurb omega .125}
translate (1*EAnimate)*EClock
rotate 56*ERand
}


#if (EClock <= .5)
#else
density { bozo
color_map{
[1.5*EClock-1 rgb .75]
[2*EClock-1 rgb 1]
[1.0 rgb 1]
}
scale .25
translate (.2*EAnimate)*EClock*z
warp {turbulence .5*ETurb }
translate (-.2*EAnimate)*EClock*z
rotate 32*ERand+56
}
#end 
#if (EClock <= .5)
#else
density { bozo
color_map{
[1.9*EClock-1 rgb -1*EClock+1]
[2*EClock-1 rgb 1]
[1.0 rgb 1]
}
scale 1
translate (1*EAnimate)*EClock*z
warp {turbulence 1*ETurb }
translate (-1*EAnimate)*EClock*z
rotate 3*ERand+5
}
#end


}

#if (EClock <= .5)
media{
emission <1,1,.5>*2*EIntensity/ERadius
density { spherical
color_map{
[1.5*EClock+0 rgb 0]
[1*EClock+0.5 rgb 5]
[1.0 rgb 15]
}

translate (-2.5*EAnimate)*EClock*x
warp {turbulence (.25*EClock+1)*ETurb }
translate (2.5*EAnimate)*EClock*x
rotate ERand-12
}    
scale 2.5
scale -.5*EClock+.5
}
media{
emission <1,1,.5>*2*EIntensity/ERadius
density { spherical
color_map{
[1.5*EClock+0 rgb 0]
[1*EClock+0.5 rgb 2.5]
[1.0 rgb 7.5]
}

translate (-5*EAnimate)*EClock*x
warp {turbulence (.5*EClock+1)*ETurb omega .875 }
translate (5*EAnimate)*EClock*x
rotate ERand
}    
scale 2
scale -.5*EClock+.5
}
#end
}
scale 1.5*EClock+.5
rotate ERand*25
}
//Glow around the explosion
sphere {0, 1 hollow on
pigment { rgbt 1}
interior {
media{
emission EColor*EIntensity2/ERadius
density { spherical
color_map{
[0 rgb 0] 
[.5*clock+.5 rgb 2]
[1.0 rgb 5]
}
}

#if (EClock <= .5)
#else
density { bozo
color_map{
[1.5*EClock-1 rgb .75]
[2*EClock-1 rgb 1]
[1.0 rgb 2]
}
scale .25
translate (.2*EAnimate)*EClock*z
warp {turbulence .5*ETurb }
translate (-.2*EAnimate)*EClock*z
rotate 323456*ERand+567567
}
#end 
#if (EClock <= .5)
#else
density { bozo
color_map{
[1.5*EClock-1 rgb -1*EClock+1]
[2*EClock-1 rgb 1]
[1.0 rgb 2]
}
scale 1
translate (1*EAnimate)*EClock*z
warp {turbulence 1*ETurb }
translate (-1*EAnimate)*EClock*z
rotate 323456*ERand+567567
}
#end


}
}
scale 1
scale 1*EClock+1
rotate ERand*25
}
#if (EClock <= .5)
#if (EShock = on)
#local EClock = EClock*2 
disc {<0,0,0>, y, 1.5
pigment {
onion
pigment_map {
[0 color rgbt <1,.5,0,1>]
[.15*EClock+0.5 color rgbt <1,.375,0,1>]
[.95 bozo color_map {[0 rgbt <1,1,0,1*EClock>]
[1 rgbt <1,.5,0,1*EClock>]}
turbulence 1 scale .0675 translate <0,.75*EClock,0>]
[1 color rgbt <1,.5,0,1>]
}
translate <0,-.25*EClock,0>
}
finish {
ambient 3
diffuse 0
}
no_shadow hollow
rotate 43567*ERand
scale 15*EClock+.1
}
#end
#end
scale ERadius
translate ETrans 
rotate ERand*25
}
#declare A=0;
#while (A<StreakNumber)
union {Streak(A**34*ERand,1,ERadius*2,EClocka) rotate 45*z scale 1.5 translate -2*z rotate ERand*25*z}
#declare A=A+1;
#end          
#end 
             
union {StartGlow(4566+ERand,100,-.001,.25,EClocka,15) scale 1.25 translate -1.5*z  rotate ERand*-25*z} 
union {StartGlow(5676,100,-.001,.25,EClocka,-15) scale 1.25 translate -1.5*z  rotate ERand*25*z}

rotate 3425*z    
rotate ERand*z
}

#end

//Explosion (EX,EY,EZ,EColor,ERand,EAnimate,ERadius,EClock,EStart,EEnd,EDetail,EShock)

#ifndef(included)
	#declare Clock = pow(clock,1/2);
	
	union {
		Explosion (<0,0,0>,Color, //Position,Color
		70, //Random
		AnimationAmount, //Animate
		1, //Radius
		clock,-.001,1, //Clock,Start,Stop
		Detail, //Detail
		off, //Shockwave
		1
		)
		scale 1 
	}  
	global_settings {max_trace_level 150}
#end