/*
 *	USS Aardvark
 *	Prototype of the Aardvark class of scout ships
 *
 *	Copyright 2000 Mark Wagner
 */

#version unofficial MegaPov 0.5;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "damage.inc"		// H.E.Day's damage textures

#ifndef(included)
	global_settings{assumed_gamma 1} 
	
	#declare cm = 1/2.54;		// 1 pov unit = 1 inch
	#include "units.inc"		// www.geocities.com/rengaw/PovRay.html
	 
	#declare Framework = no;	// Show the design framework?
	#declare Body = yes;		// Show the actual ship?
	
	background{SummerSky}
#else
	#ifndef(Body)
		#declare Body = on;
	#end
	#ifndef(Framework)
		#declare Framework = off;
	#end
#end

#if(Framework)
	// Body
		//Main beams
	cylinder{x*-10*feet, x*15*feet, 1*foot pigment{rgb <1,1,0>} translate z*-4*feet}
	cylinder{x*-10*feet, x*15*feet, 1*foot pigment{rgb <1,1,0>} translate z*4*feet}
		//Crossbeams
	cylinder{z*-4*feet, z*4*feet, 1*foot pigment{rgb <1,1,0>} translate x*-8*feet}
	cylinder{z*-4*feet, z*4*feet, 1*foot pigment{rgb <1,1,0>} translate x*7*feet}
	//Guns
	cylinder{x*-5*feet, x*0*feet, 6*inch pigment{rgb <1,0,0>} translate z*10*feet}
	cylinder{x*-5*feet, x*0*feet, 6*inch pigment{rgb <1,0,0>} translate z*-10*feet}
#end

#if(Body)
	#declare BodyPigment = pigment{rgb 1}			// Basic body color
	#declare BodyFinish = finish{
		specular .2
		roughness .3
	}
	#declare SquadColor = pigment {rgb <-.5,-.5,1>}		// Squadron color
	#declare ShipNumber = 1;						// Ship number
	#declare SquadPigment = pigment{				// Squadron markings
		radial
		pigment_map{
			[0 SquadColor]
			[.25 SquadColor]
			[.25 BodyPigment]
			[.5 BodyPigment]
			[.5 SquadColor]
		}
		frequency 4*ShipNumber
	}
/*	#declare LevelLines = pigment{
		gradient y
		pigment_map{
			[.05 rgb .8]
			[.05 rgbt 1]
		}
		scale foot
		frequency 3
	}*/
/*	#declare LevelLines = pigment{
		crackle
		pigment_map{
			[.05 rgb .8]
			[.05 rgbt 1]
		}
		scale foot
	}*/
	#declare LevelLines = pigment{rgbt 1}
	
	#declare SS_Body = difference{
		box{<15,-1,-10>*feet,<-16,3,10>*feet}	/* Main body */
		intersection{
			quadric{	/* Nose cutout */
				<1, -1,  1>,
				<0,  0,  0>,
				<0,  0,  0>, -3
			}
			box{<-10.01,-2.01,-3.01>,<0.01,6.01,3.01>}
			texture{
				pigment{
					cylindrical
					pigment_map{
						[0 BodyPigment]
						[.645 BodyPigment]
						[.645 SquadColor]
					}
					scale 5
				}
				finish{BodyFinish}
			}
			scale <2.5,.5,1.5>*feet
			translate x*15*feet
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
		}
		union{ /* Nose rounding */
			box{<-16,-1.1,-11>*feet,<11,4,11>*feet}
			intersection{
				box{<4,2,4>,<0,-2,-4>}
				quadric{
					<0,1,0>,
					<0,0,0>,
					<-1,0,0>,0
				}
				scale <-1,.5,1>*feet
				translate x*15*feet
			}
			inverse
			texture{
				pigment{SquadColor}
				finish{BodyFinish}
			}
			texture{Scarring1 scale foot}
		}	
		intersection{
			quadric{	/* Wing cutout */
				<1, -1,  1>,
				<0,  0,  0>,
				<0,  0,  0>, -5
			}
			box{<-10.01,-2.01,-3.66>,<0.01,6.01,0>}
			texture{
				pigment{
					cylindrical
					pigment_map{
						[0 BodyPigment]
						[.55 BodyPigment]
						[.55 SquadPigment]
					}
					scale 5
				}
				finish{BodyFinish}
			}
			scale <7,.75,3>*feet
			translate x*15*feet+z*10.1*feet
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
		}
		intersection{
			quadric{	/* Wing cutout */
				<1, -1,  1>,
				<0,  0,  0>,
				<0,  0,  0>, -5
			}
			box{<-10.01,-2.01,-3.66>,<0.01,6.01,0>}
			texture{
				pigment{
					cylindrical
					pigment_map{
						[0 BodyPigment]
						[.55 BodyPigment]
						[.55 SquadPigment]
					}
					scale 5
				}
				finish{BodyFinish}
			}
			scale <7,.75,-3>*feet
			translate x*15*feet+z*-10.1*feet
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
		}
		intersection{	/* Rear cutout */
			quadric{
				<0,1,0>,
				<0,1,0>,
				<-1,0,0>,1
			}
			box{<0,-2.1,-6>,<8,2,2>}
			texture{
				pigment{BodyPigment}
				finish{BodyFinish}
			}
			scale <5,1,5>*feet
			translate (x*-18+y*1+z*7)*feet
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
			inverse
		}
		intersection{	/* Rear cutout */
			quadric{
				<0,1,0>,
				<0,1,0>,
				<-1,0,0>,1
			}
			box{<0,-2.1,-6>,<8,2,2>}
			texture{
				pigment{BodyPigment}
				finish{BodyFinish}
			}
			scale <5,1,-5>*feet
			translate (x*-18+y*1+z*-7)*feet
			inverse
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
		}
		intersection{	/* Engine cutout */
			quadric{
				<0,1,1>
				<0,0,0>
				<-1,0,0>,0
			}
			box{<0,-20,-20>,20}
			texture{
				pigment{BodyPigment}
				finish{BodyFinish}
			}
			scale <-.25,.25,.25>*feet
			scale <1,1/1.5,1.5>
			translate x*-11.5*feet+y*(2/3)*1.4*feet+z*-2*feet
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
		}
		intersection{	/* Engine cutout */
			quadric{
				<0,1,1>
				<0,0,0>
				<-1,0,0>,0
			}
			box{<0,-20,-20>,20}
			texture{
				pigment{BodyPigment}
				finish{BodyFinish}
			}
			scale <-.25,.25,.25>*feet
			scale <1,(2/3),1.5>
			translate x*-11.5*feet+y*(2/3)*1.4*foot+z*2*feet
			texture{
				pigment{LevelLines}
			}
			texture{Scarring1 scale foot}
		}
	}
	#declare SS_Gun = union{
		difference{
			cylinder{x*-3*feet, x*5.5*feet, 3*inch}
			cylinder{x*-3*feet, x*5.6*feet, 2.5*inch}
		}
		cone{x*-2*feet, 7*inch x*0*feet, 3*inch}
		sphere{0*feet, 7*inch scale <3,1,1> translate x*-2*feet}
/*		difference{
			cone{x*5*feet, 3*inch, x*5.7*feet, 5.5*inch}
			cone{x*5.2*feet, 2.5*inch, x*5.71*feet, 5.0*inch}
			texture{T_Brass_3A}
		}*/
		cylinder{x*54*inch, x*55*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*52*inch, x*53*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*50*inch, x*51*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*48*inch, x*49*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*46*inch, x*47*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*44*inch, x*45*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*42*inch, x*43*inch, 4.5*inch texture{T_Brass_4E}}
		cylinder{x*40*inch, x*41*inch, 4.5*inch texture{T_Brass_4E}}
		texture{
			gradient x
			texture_map{
				[0 T_Copper_4A]
				[1 T_Brass_4E]
			}
			scale 10*feet
			translate x*-4*feet
		}
	}
	#declare SS_Engine = union{
		difference{
			intersection{
				quadric{
					<0,1,1>
					<0,0,0>
					<-1,0,0>,0
				}
				box{<0,-20,-20>,20}
				scale <-.25,.25,.25>*feet
			}
			intersection{
				quadric{
					<0,1,1>
					<0,0,0>
					<-1,0,0>,0
				}
				box{<0,-20,-20>,20}
				scale <-.25,.25,.25>*feet
				translate x*-3*inch
			}
		}
		sphere{
			<-5,0,0>*feet,1*feet
			pigment{rgbt 1}
			hollow
			interior{
				media{
					//density{}
					emission .5*<0,0,.125>*(1/inch)
					absorption .5*<.0625,.0625,0>*(1/inch)
				}
			}
		}
		scale <1,1,1.5>
		texture{T_Copper_4A}
		texture{Scarring1 scale .25*foot}
	}
	#declare SS_Cockpit = union{
		cylinder{x*-2*feet, x*0*feet, 1.5*feet}
		sphere{0, 1.5*feet scale <3,1,1> translate x*0*feet}
		sphere{0, 1.5*feet scale <4,1,1> translate x*-2*feet}
		torus{
			1.4*feet, 2*inch 
			scale <1,2,1> 
			rotate z*90
			translate x*.5*feet
			texture{New_Brass}
			sturm
		}
		torus{
			1.4*feet, 2*inch 
			scale <1,2,1> 
			rotate z*90
			translate x*-4*feet
			texture{New_Brass}
			sturm
		}
		pigment{rgb .01}
		finish{
			specular 1
			roughness .005
		}
	}
	#declare AardvarkSS = union{
		object{SS_Body 
			texture{
				pigment{BodyPigment}
				finish{BodyFinish}
			}
			scale <1,1.5,1>
			texture{Scarring1 scale foot}
		}
		object{SS_Cockpit translate y*3*feet}
		object{SS_Gun translate z* 9*feet+y*.75*feet}
		object{SS_Gun translate z*-9*feet+y*.75*feet}
		object{SS_Engine translate x*-11.5*feet+y*1.4*feet+z*-2*feet}
		object{SS_Engine translate x*-11.5*feet+y*1.4*feet+z* 2*feet}
	}
	#ifndef(included)
		object{AardvarkSS}
	#end
#end

#ifndef(included)
#declare Cam1 = camera{
	location <50,25,50>*feet
	look_at 0*feet
	angle 23
}
#declare Cam2 = camera{
	location vnormalize(<1,1,1>)*.125*mile
	look_at 0
	angle 3
}

#declare Top = camera{
	location y*.125*mile
	look_at 0
	angle 3
	translate .1*inch
}
#declare Front = camera{
	location x*.125*mile
	look_at 0
	angle 3
}
#declare Rear = camera{
	location x*-.125*mile
	look_at 0
	angle 3
}
#declare Right = camera{
	location z*-.125*mile
	look_at 0
	angle 3
}
#declare Left = camera{
	location z*.125*mile
	look_at 0
	angle 3
}


camera{Top}
light_source{<1000,1000,1000>*feet 1}
light_source{y*-4*feet .5 shadowless}

#declare GraphPaper = texture{
	pigment{
		gradient x
		color_map{
			[.1 rgb <0,.7,1>]
			[.1 rgb 1]
		}
	}
	finish{
		ambient 1
		diffuse 0
	}
}
texture{
	pigment{
		gradient z
		color_map{
			[.1 rgb <0,.7,1>]
			[.1 rgbt 1]
		}
	}
	finish{
		ambient 1
		diffuse 0
	}
}

plane{
	y, -5.1*feet
	texture{GraphPaper scale feet} 
}
/*plane{
	y, -20.1*feet 
	texture{GraphPaper scale feet} 
	rotate z*-90
}
plane{
	y, -15.1*feet 
	texture{GraphPaper scale feet} 
	rotate x*90
}*/
#end