// IRTC Animation Entry
// Topic: "Alien Invasion"
// Copyright 2000 by Mark Wagner

// Galaxian.pov
//  A rendering of a "Galaxian" style game

#declare cm = 2.54/12;	// One POV unit = 1/12 of a cm
#include "units.inc"	// www.geocities.com/Rengaw03/POV-Ray.html
#declare included = true;

#version unofficial MegaPOV 0.5;
global_settings{assumed_gamma 1}

// The ship graphics
#declare Ships = array[4][13]
#declare Missile = array[4]

// The USS Aardvark, used as the player ship
#include "aardvark.pov"
// Assorted alien ships
#include "alien.pov"

#declare Missile[0] = cylinder{0, z*10*feet, 2*feet pigment{rgb 1}}
#declare Missile[1] = cylinder{0, z*10*feet, 2*feet pigment{rgb <0,0,2>}}
#declare Missile[2] = cylinder{0, z*10*feet, 2*feet pigment{rgb 1}}
#declare Missile[3] = cylinder{0, z*10*feet, 2*feet pigment{rgb <1,0,0>}}

/*
#declare count1 = 0;
#while(count1 < 13)
	#declare Ships[1][count1] = box{0, 24*feet pigment{rgb <1,0,0>}}
	#declare Ships[2][count1] = box{0, 24*feet pigment{rgb <1,1,0>}}
	#declare Ships[3][count1] = box{0, 24*feet pigment{rgb <0,1,0>}}
	#declare count1 = count1 + 1;
#end
*/

#declare Ships[0][1] = object{AardvarkSS translate z*16*feet rotate y*90}
#declare Ships[0][8] =  sphere{z*0*feet+x*16*feet, 15*feet    pigment{rgbt <1,0,0,0>}}
#declare Ships[0][9] =  sphere{z*0*feet+x*16*feet, 11.25*feet pigment{rgbt <1,0,0,.25>}}
#declare Ships[0][10] = sphere{z*0*feet+x*16*feet, 7.5*feet   pigment{rgbt <1,0,0,.5>}}
#declare Ships[0][11] = sphere{z*0*feet+x*16*feet, 3.25*feet  pigment{rgbt <1,0,0,.75>}}
#declare Ships[0][12] = sphere{z*0*feet+x*16*feet, .005*feet  pigment{rgbt <1,0,0,1>}}

/* The biggest switch/case statement you've ever seen */
#switch(clock)
	#include "status.inc"
#end


/* I forgot to save the number of lives in status.inc, so it is declared here.
 * This has the side benefit of speeding up parsing */
#switch(clock)
	#range(0,61)
		#declare Lives = 3;
	#break
	#range(62,3341)
		#declare Lives = 2;
	#break
	#range(3341,4574)
		#declare Lives = 1;
	#break
	#range(4574,5368)
		#declare Lives = 0;
	#break
	#range(5368,5978)
		#declare Lives = -1;
	#break
	#range(5368,6531)
		#declare Lives = -2;
	#break
#end

#declare count1 = 0;
#while(count1 < Lives)
	object{Ships[0][1] translate x*count1*32*feet+z*220*feet+y*5*feet}
	#declare count1 = count1 + 1;
#end

#declare ScoreTxt = text{ 
	ttf "c:\windows\fonts\lucon.ttf" str(Score,0,0) 1*foot, 0
	rotate x*-90
	scale <20*feet,1,20*feet> 
	pigment{rgb 1}
}

#if(Score > HighScore)
	#declare HighScore = Score;
#end

#declare HighScoreTxt = text{ 
	ttf "c:\windows\fonts\lucon.ttf" str(HighScore,0,0) 1*foot, 0
	rotate x*-90
	scale <20*feet,1,20*feet> 
//	translate x*150*feet+z*220*feet+y*5*feet
	pigment{rgb 1}
}

object{HighScoreTxt translate <160*feet-((max_extent(HighScoreTxt).x-min_extent(HighScoreTxt).x)/2),5*feet,230*feet>}
object{ScoreTxt translate <310*feet-((max_extent(ScoreTxt).x-min_extent(ScoreTxt).x)),5*feet,230*feet>}

box{<0,0,202>*feet, <320,1,200>*feet pigment{rgb <1,1,1>}}
box{<0,2,240>*feet, <320,3,202>*feet pigment{rgb 0}}

light_source{y*1000*feet, 1}

camera{
	orthographic
	location <160,10000,120>*feet
	direction -y
	up -240*z*feet
	right 320*x*feet
}
