// IRTC Animation Entry
// Topic: "Alien Invasion"
// Copyright 2000 by Mark Wagner

// splashscreen.pov
//  The movie poster

global_settings{assumed_gamma 1.0}
background{rgb 0}

#declare included = true;

#declare cm = 1/(2.54*12);	// 1 foot = 1 POV unit
#include "units.inc"		// Same place as always

#include "aardvark.pov"
#include "SWExplode.pov"

union{
	object{AardvarkSS}
	merge{
		cylinder{x*6*feet, x*200*feet, 1*feet}
		sphere{  x*6*feet, 1*foot}
		pigment{rgbt 1}
		hollow
		interior{
			media{
				emission <0,0,1>
				absorption <1,1,0>
				density{
					cylindrical
					density_map{
						[0 rgb 0]
						[.84 rgb .4]
						[1 rgb 100]
					}
					rotate z*90
				}
			}
		}
		translate y*9*inch+z*9*feet
	}
	merge{
		cylinder{x*6*feet, x*200*feet, 1*feet}
		sphere{  x*6*feet, 1*foot}
		pigment{rgbt 1}
		hollow
		interior{
			media{
				emission <0,0,1>
				absorption <1,1,0>
				density{
					cylindrical
					density_map{
						[0 rgb 0]
						[.84 rgb .4]
						[1 rgb 100]
					}
					rotate z*90
				}
			}
		}
		translate y*9*inch+z*-9*feet
	}
	object{Explosion(<-200,30,-50>*feet,<1,.625,.25>,70,1,50*feet,clock,0,1,1,off,1)}
	rotate z*-10
	translate y*-10*feet
}


camera{
	location <-30,20,20>*feet
	look_at <0,0,5>*feet
//	location y*1000*feet
//	look_at 0
}

light_source{Parsec, 1}



