/*
 *  This program copyright 2000 Mark Wagner
 */

struct HUMAN_PLAYER
{
        int x;
        int y;
        int status;
        int lives;
        int next_life_score;
};
struct COMP_SHIP
{
        int x;
        int y;
        int type;
        int status;
};
struct MISSILE
{
        int x;
        int y;
        int dir; //Owner is indicated by direction: +1 = comp, -1 = player
};
struct GAME
{
        int score;
        int level;
        int status;
        int stat_time; // Time remaining until next status change
        int total_time; // The total number of clock ticks elapsed since start
        struct HUMAN_PLAYER player;
        int num_ships;
        int move_direction;
        struct COMP_SHIP cships[40];
        int num_missiles;
        struct MISSILE missiles[41];
};

// Game status
#define PLAYING   1
#define DYING     2
#define NEXTLEVEL 3
#define GAMEOVER  4

// Misc. constants
#define SHIP_WIDTH 24
#define SHIP_HEIGHT 24
#define MISSILE_WIDTH 1
#define MISSILE_HEIGHT 5

#define BOARD_HEIGHT 200
#define BOARD_WIDTH 320

#define PLAYER_MOVE_SPEED 5
#define MISSILE_MOVE_SPEED 8
#define COMP_MOVE_SPEED 2

extern struct GAME TheGame;
extern int HighScore;
/* Key states */
extern bool left_down;
extern bool right_down;

/* Win API Data */
extern TForm1 *Form1;
extern HINSTANCE AppInst;

