/*
 *  This program copyright 2000 Mark Wagner
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "gal_main.h"
#include "globals.h"
#include "internal.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
bool left_down;
bool right_down;

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
        static Icons_Inited = false;
        /* If control key, flag */
        if(Key == 188 /* < */)
                left_down = true;
        if(Key == 190 /* > */)
                right_down = true;

        /* If space and in game, fire missile */
        if(Form1->Timer1->Enabled == true && Key == ' ')
                Human_Fire();
        /* If F1 and not in game, start game */
        if(Form1->Timer1->Enabled == false && Key == '1')
        {
                if(!Icons_Inited)
                {
                        if(!InitIcons(GetDC(Form1->Handle)))
                        {
                                Application->Terminate();
                        }
                        Icons_Inited = true;
                }
                Init_Game();
        }
        /* Quit game */
        if(Form1->Timer1->Enabled == true && (Key == 'q' || Key == 'Q'))
        {
                TheGame.status = GAMEOVER;
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
        /* If control key, flag */
        if(Key == 188/* Left arrow */)
                left_down = false;
        if(Key == 190/* Right arrow */)
                right_down = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
        /* The guts of the program */
        /* Save game state */
        WriteStatus("status.inc");
        /* Update overall status */
        Update_Status();

        /* Update missiles */
        Update_Missiles();
        /* Update player */
        Update_Player();
        /* Update computer */
        Update_Computer();
        /* Redraw screen */
        DrawGame(GetDC(Form1->Handle));

        Form1->ScoreLbl->Caption = TheGame.score;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
        DeleteIcons();        
}
//---------------------------------------------------------------------------

