//////////////////////////
//
// Glueslug.inc
//
// This file has been heavily stripped from the original, for source code submission to the 
// IRTC contest, "Alien Invasion". Forgive me, but I cannot bring myself to
// make the real slug object public at this time. 
//
// The object presented in this file isn't much more than a simple sphere (unlike the original slug).
//
// Copyright Collins Mark 2000
//
////////////////////////// 

// Cut Here and Place in main file.
/*
#include "colors.inc"        // if not previously included
#include "Textures.inc"      // if not previously included
#include "Stones.inc"        // if not previously included
#include "frame_clock.inc" // declares a variable "Frame_Clock" that stores the current frame number.
                              // This statement must remain near the top.

   #declare slug_Stretch = 1.0;      // Strech along glueslug axis. 1 is relaxed. 
   #declare slug_PupilSize = 1.00;    // Size of pupil. 1 is normal
   #declare slug_LookAt = <0.0, 0.0, -2.0>; // Position the eyes focus on, relative to bottom of head.
   #declare slug_LeftEye = <0.2, 0.3, -0.2>;  // Really the Right eye position (Left and right eye got swapped somehow), 
                                              // relative to bottom of head. <0.2, 0.3, 0> is relaxed (at normal scale).
   #declare slug_RightEye = <-0.2, 0.3, -0.2>; // Really the Left eye position (Left and right eye got swapped somehow), 
                                               // relative to bottom of head. <-0.2, 0.3, 0> is relaxed (at normal scale).
   #declare slug_AutoEyeMovement_En = 1; // Enables random movement of eyestructure position. If set (1), slug_AutoEyeMovementStrength must be defined.
   #declare    slug_AutoEyeMovementStrength = 0.1; // (default 0.1) Zero values cause the eyes to not move at all, 1 moves the eyes around pretty good.
   #declare    slug_AutoEyeMoveCorrectionFactor = 0.05; // (default 0.05) Determines, in part, random distance from specified eye postion. The larger the value, the larger
                                                      // the tendency to drift back to the specified postion. 0.0 causes no tendency to drift back
                                                      // Values greater than 1 are unstable.
   #declare    slug_AutoEyeMoveViscosity = 0.1; // (default 0.1) Adds viscosity to the eye movement. Tendency to move in the opposity direction of 
                                                // the velocity. Proportional to velocity sqared. 0 is no viscosity, and 1 is very viscous.
   #declare    slug_AutoEyeMoveDryFriction = 0.0001;// (default 0.0001) Adds dry friction to the movement. Constant tendency to move in the opposite
                                                 // direction of velocity.    
   #declare    slug_InitialAutoEyeMove = 0; // Initializes auto eye position movement. Initialization performed automatically when clock = 0;
   #declare slug_Eyelids = 1.0; // Eyelids open. 1 corresponds to normal open. 0 completely closed.   
   #declare slug_AutoBlink_En = 1; // Set (1) to enable autoblink. If set, slug_AutoBlinkPeriod must be defined.
   #declare   slug_AutoBlinkPeriod = 45; //approximate number of frames until next blink, assumming slug_AutoBlink_En is set (1). 
   #declare slug_Mouth = 0.2; // Mouth open. 1 is very open, 0 is completey closed.
   #declare slug_MoveMouth = <0,0>; // Move mouth by x and y. z is always be 0. This parameter is not effected by slug scaling, only mouth scaling.
   #declare slug_ScaleMouth = <1,1>; // Scales the x and y of mouth, after opening. <1,1> is normal.  
   #declare slug_ForceEyelidsStraight = 0; // If set (1) eyelids will not wander with inner eye. Clear (0) for normal operation.
   #declare slug_Breath = 1.0; // Multiplies size of middle ball times value. 1.0 is relaxed.
   #declare slug_AutoBreath_En =1; // Takes care of breathing for you.
   #declare    slug_AutoBreathPeriod = 3; // units in seconds (30 frame periods) of breath cycle.
   #declare    slug_AutoBreathAmplitude = 0.1; // Fraction of slug's throax of peak expansion and peak compression. 
   #declare slug_MoveHead = <0,0.0,-0.0>; // Head movement after stretching. 
   #declare slug_MoveThorax = <0,0,0>; // Middle movement after stretching.
   #declare slug_MoveButt = <0,0,0>; // Buttocks movement after stretching.
   #declare slug_MoveTail = <0,0,0>; // Tail Movement after stretching (wagging).
   #declare slug_TailAutoWag_En = 1; // Enables automatic wagging of tail.
   #declare    slug_TailAutoWagPeriod = 7.56; // units in seconds (30 frame periods) of wag cycle.
   #declare slug_Scale = 1.0; // Scaling of entire slug. 
   #include "glueslug.inc"
   object {GlueSlug} 
*/
// End cut here. Place above cut in main file.
   
   #declare gs_Stretch = slug_Stretch;      // Strech along glueslug axis. 1 is relaxed. 
   #declare gs_PupilSize = slug_PupilSize;    // Size of pupil. 1 is normal
   #declare gs_LookAt = slug_LookAt/slug_Scale; // Position the eyes focus on, relative to bottom of head.
   #declare gs_Mouth = slug_Mouth; // Mouth open. 1 is very open, 0 is completey closed.
   #declare gs_MoveMouth = slug_MoveMouth; // Move mouth by x and y. z is always be 0. This parameter is not effected by slug scaling, only mouth scaling.
   #declare gs_ScaleMouth = slug_ScaleMouth; // Scales the x and y of mouth, after opening. <1,1> is normal.  
   #declare gs_ForceEyelidsStraight = slug_ForceEyelidsStraight; // If set (1) eyelids will not wander with inner eye. Clear (0) for normal operation.
   #declare gs_MoveHead = slug_MoveHead/slug_Scale; // Head movement after stretching. 
   #declare gs_MoveThorax = slug_MoveThorax/slug_Scale; // Middle movement after stretching.
   #declare gs_MoveButt = slug_MoveButt/slug_Scale; // Buttocks movement after stretching.
   #declare gs_MoveTail = slug_MoveTail/slug_Scale; // Tail Movement after stretching (wagging).      
   

   #declare gs_Eyelids = slug_Eyelids;
   
   #declare gs_LeftEye = slug_LeftEye/slug_Scale; 
   #declare gs_RightEye = slug_RightEye/slug_Scale;

   #declare gs_Breath = slug_Breath;

   #declare gs_MoveTail = slug_MoveTail/slug_Scale;
   
    
   /////////////////////
   // Glueslug body
   /////////////////////                            
   #declare gs_Body = blob  
   {
      threshold 0.7
      
      sphere { <0,0,0>, 0.25, 1.2 translate (<0,0,0.0*gs_Stretch>+gs_MoveHead)}          
      translate <0,0.07,0>
   }
   
   
   //////////////////////////////////////////////////////////
   // Most of glueslug -- anything that has the main texture
   //////////////////////////////////////////////////////////
   #declare gs_GlueSlug_Basic = difference
   {
      union
      {
         object {gs_Body}                      
         texture {T_Stone24 }                  // Change body texture here
      }
      superellipsoid {<0.80, 0.1>                       ////// Mouth
                      scale <0.02*gs_Mouth+0.05, 0.03*gs_Mouth, 0.2>
                      scale <gs_ScaleMouth.x, gs_ScaleMouth.y, 1> 
                      translate <0,0.06,0>
                      translate gs_MoveHead
                      translate <gs_MoveMouth.x, gs_MoveMouth.y, 0> 
                      pigment {color <0.6, 0.5, 0.55>*0.2}
                      }  
   }  
   
   /////////////////////////
   // Final say in glueslug object.
   /////////////////////////
   #declare GlueSlug = union
   {
      object {gs_GlueSlug_Basic}            
      box {<-0.017,0,-0.007>, <0.017, 0.038,0.007>      // Tooth
           translate <-0.018,0.015,-0.09> 
           translate gs_MoveHead
           pigment {color <1,1,0.9>}}                   // Tooth
      scale slug_Scale 
   }
   
   