   //////////////////////
   // baseball.inc
   //
   // declares a baseball diamond object
   //
   // Created for the IRTC competition, "Alien Invasion".
   // Deadline for entry Oct. 15, 2000
   //
   // 
   // Copyright 2000, Collins Mark 
   //
   //////////////////////////////////////
   //#include "metals.inc" //if not included already
   
   ///////////////////////////////////
   // diamond; this is the dirt field 
   ///////////////////////////////////
   #declare base_StretchSize = 50;
   #declare diamond = difference
   {
      /*union
      {
         cylinder {<0,0,0>, <0,0.1,0> 80}
         box {<-15,0,0>, <0,0.1,80> rotate -45*y}
         box {<15,0,0>, <0,0.1,80> rotate 45*y}
      } */ 
      union
      {
         cylinder {<0,0,0>, <0,0.1,0> 50}
         box {<-45,0,0>, <0,0.1,50> rotate -45*y}
         box {<45,0,0>, <0,0.1,50> rotate 45*y}
         translate <0,0,30>
      }
      box {<-100,-0.1,-100>, <-15,0.2,100> rotate -45*y} 
      box {<100,-0.1,-100>, <15,0.2,100> rotate 45*y} 
      box {<-100, -0.1, -100>, <100, 0.2, -15>}
      difference              // plant grass for infield
      {
         box {<0,-0.2,0>, <base_StretchSize, 0.2, base_StretchSize> }
         cylinder {<base_StretchSize, -0.2, 0>, <base_StretchSize, 0.2, 0> base_StretchSize*0.2} // first
         cylinder {<0, -0.2, base_StretchSize>, <0, 0.2, base_StretchSize>, base_StretchSize*0.2} // third
         cylinder {<base_StretchSize, -0.2, base_StretchSize>, <base_StretchSize, 0.2, base_StretchSize>, base_StretchSize*0.2} // second
         cylinder {<base_StretchSize/2.5, -0.2, base_StretchSize/2.5>, <base_StretchSize/2.5, 0.2, base_StretchSize/2.5>, base_StretchSize*0.15} // mound 
         box {<-0.1, -0.02, -20>, <base_StretchSize*0.15, 0.02, 20> rotate -45*y} // home
         rotate -45*y
      }
    
      texture 
      { 
         //pigment {color White}
          pigment
          {
              marble
              turbulence <6,6,6>
              color_map 
              {
                  [0.0, 0.1   color <0.45,0.3,0.3> color Black]
                  [0.1, 0.2   color Black color <0.45,0.3,0.3>]
                  [0.2, 0.3   color <0.45,0.3,0.3> color <0.45,0.3,0.3>]
                  [0.3, 0.4   color <0.2,0.5,0.3> color <0.45,0.3,0.3>]
                  [0.5, 0.5   color <0.45,0.3,0.3> color Black]
                  [0.5, 0.6   color <0.45,0.3,0.3> color Black]
                  [0.6, 0.7   color <0.45,0.3,0.3> color Black]
                  [0.7, 0.8   color <0.45,0.3,0.3> color <0.45,0.3,0.3>]
                  [0.8, 0.9   color Black color <0.45,0.3,0.3>] 
                  [0.9, 1.001   color Black color <0.45,0.3,0.3>]
               }
           }  
           scale 0.5
        }
        //pigment {color <0.45,0.3,0.3>}
     }
     
     
     ///////////////////////////////////////////////
     // Fence; this is the fence around the infield.
     ///////////////////////////////////////////////
     #declare BaseballWireRad = 0.04;
     #declare BaseballPollRad = 0.2;
     
     ////////////////////////////////// 
     // Cage for grandstand protection.
     //////////////////////////////////
     #declare GrandFence = union
     {  
        #declare i=0;
        #while (i<24) // 24 horizontal wires in a 6 foot fence.
           cylinder {<-6.2132, i/4, -0>, <6.2132, i/4, -0>, BaseballWireRad texture {T_Chrome_4B}}
           #declare i=i+1;
        #end 
        
        #declare i= -6.2;
        #while (i<6.2)
           cylinder {<i, 0, -0>, <i, 6, -0>, BaseballWireRad texture {T_Chrome_4B}}
           #declare i=i+0.25;
        #end
        cylinder {<-6.2132, 6, -0>, <6.2132, 6, -0>, BaseballPollRad texture {T_Chrome_4B}}
        cylinder {<-6.2132, 0, -0>, <-6.2132, 6, -0>, BaseballPollRad texture {T_Chrome_4B}}
        cylinder {<6.2132, 0, -0>, <6.2132, 6, -0>, BaseballPollRad texture {T_Chrome_4B}}   
     } 
     
     //////////////////////////
     // Fences for players
     //////////////////////////
     #declare PlayerFence = union
     {
        #declare i=0;
        #while (i<24) // 24 horizontal wires in a 6 foot fence.
           cylinder {<-30, i/4, -0>, <30, i/4, -0>, BaseballWireRad texture {T_Chrome_4B}}
           #declare i=i+1;
        #end 
        
        #declare i= -30;
        #while (i<30)
           cylinder {<i, 0, -0>, <i, 6, -0>, BaseballWireRad texture {T_Chrome_4B}}
           #declare i=i+0.25;
        #end
        cylinder {<-30, 6, -0>, <30, 6, -0>, BaseballPollRad texture {T_Chrome_4B}}   
     } 
     
     #declare Fence = union
     {
        object {GrandFence translate <0,0,-15>}
        object {GrandFence rotate 45*x translate <0,6,-15>}
        object {PlayerFence translate <-30+6.2132,0,-15> rotate 45*y}
        object {PlayerFence translate <30-6.2132,0,-15> rotate -45*y}
        cylinder {<-60+6.2132, 0, -15>, <-60+6.2132, 6, -15>, BaseballPollRad rotate 45*y texture {T_Chrome_4B}} //poll
        cylinder {<60-6.2132, 0, -15>, <60-6.2132, 6, -15>, BaseballPollRad rotate -45*y texture {T_Chrome_4B}}  //poll
        cylinder {<-30+6.2132, 0, -15>, <-30+6.2132, 6, -15>, BaseballPollRad rotate 45*y texture {T_Chrome_4B}} //poll
        cylinder {<30-6.2132, 0, -15>, <30-6.2132, 6, -15>, BaseballPollRad rotate -45*y texture {T_Chrome_4B}}  //poll         
     }
     
     
     
     ////////////
     // Bench
     ////////////
     #declare BaseBench = object { box {<-6.2132, 0, -0.5>, <6.2132, 0.2, 0.5> }}
        
     /////////////////////////////////
     // Bleachers
     /////////////////////////////////
     #declare BleacherPollRad = 0.1;
     #declare Bleachers = union
     {
        object {BaseBench translate <0,1.5,0>}  //  lower seat
        cylinder {<-6,0,0>, <-6,1.5,0>, BleacherPollRad}                       //poll
        cylinder {<6,0,0>, <6,1.5,0>, BleacherPollRad}                       //poll
        object {BaseBench translate <0,1.0,-1>} // foot rest of second seat 
        cylinder {<-6,0,-1>, <-6,1.0,-1>, BleacherPollRad}                       //poll
        cylinder {<6,0,-1>, <6,1.0,-1>, BleacherPollRad}                       //poll
        object {BaseBench translate <0,2.5,-2>} // second seat
        cylinder {<-6,0,-2>, <-6,2.5,-2>, BleacherPollRad}                       //poll
        cylinder {<6,0,-2>, <6,2.5,-2>, BleacherPollRad}                       //poll
        object {BaseBench translate <0,2.0,-3>} // foot rest of third seat
        cylinder {<-6,0,-3>, <-6,2.0,-3>, BleacherPollRad}                       //poll
        cylinder {<6,0,-3>, <6,2.0,-3>, BleacherPollRad}                       //poll
        object {BaseBench translate <0,3.5,-4>} // third seat 
        cylinder {<-6,0,-4>, <-6,3.5,-4>, BleacherPollRad}                       //poll
        cylinder {<6,0,-4>, <6,3.5,-4>, BleacherPollRad}                       //poll             
        object {BaseBench translate <0,3.0,-5>} // foot rest of fourth seat
        cylinder {<-6,0,-5>, <-6,3.0,-5>, BleacherPollRad}                       //poll
        cylinder {<6,0,-5>, <6,3.0,-5>, BleacherPollRad}                       //poll
        object {BaseBench translate <0,4.5,-6>} // fourth seat 
        cylinder {<-6,0,-6>, <-6,4.5,-6>, BleacherPollRad}                       //poll
        cylinder {<6,0,-6>, <6,4.5,-6>, BleacherPollRad}                       //poll             
        object {BaseBench translate <0,4.0,-7>} // foot rest of fifth seat 
        cylinder {<-6,0,-7>, <-6,4.0,-7>, BleacherPollRad}                       //poll
        cylinder {<6,0,-7>, <6,4.0,-7>, BleacherPollRad}                       //poll
        object {BaseBench translate <0,5.5,-8>} // fifith seat
        cylinder {<-6,0,-8>, <-6,5.5,-8>, BleacherPollRad}                       //poll
        cylinder {<6,0,-8>, <6,5.5,-8>, BleacherPollRad}                       //poll 
        cylinder {<-6,0,-8>, <6,5.5,-8>, BleacherPollRad}                       // cross poll
        cylinder {<6,0,-8>, <-6,5.5,-8>, BleacherPollRad}                       // cross poll
        
        //texture {T_Chrome_4B}
        //pigment {color <0.4,0.5,0.7>}
        pigment {color <0.4,0.3,0.5>} 
     }
     
     //////////////////////
     // Dugout bench
     //////////////////////     
     #declare DugBench = union
     {
        box {<-8.1, 0, -0.5>, <8.1, 0.2, 0.5> }
        cylinder {<-8,0,0> <-8,0,1.5> 0.5}
        cylinder {<-8,0,0> <-8,0,1.5> 0.5}
        pigment {color <0.4,0.3,0.5>}
     }  
     
     ////////////////////
     // Home Plate
     ////////////////////
     #declare HomePlate = difference
     {
        box {<-0.75, -0.1, -0.75>, <0.75, 0.2, 1.2>}
        box {<-2,-0.2, 0>, <2, 0.3, 1.3> rotate 35*y translate <0.75,0,0.75>} 
        box {<-2,-0.2, 0>, <2, 0.3, 1.3> rotate -35*y translate <-0.75,0,0.75>}
        pigment {color <0.8,0.8,0.8>}
     } 
     
     ///////////////////////////
     // BaseballDiamond
     //
     // Last say in Baseball diamond
     ////////////////////////////////
     #declare BaseballDiamond = union
     {
        object {diamond}
        object {Fence}
        object {Bleachers translate <0,0,-18>}
        object {DugBench translate <40,0,-17> rotate -45*y}
        object {DugBench translate <-40,0,-17> rotate 45*y}
        object {HomePlate}
     }   