   ///////////////////
   //  launchpad.inc
   // defines the lauch pad object
   //
   // Top of lauch rod stands 5 units above ground. 
   // Top of blast plate stands 0.7 units above ground.
   //
   // Created for the IRTC competition, "Alien Invasion".
   // Deadline for entry Oct. 15, 2000
   //
   // 
   // Copyright 2000, Collins Mark 
   //
   ////////////////////////////////////////////////////
   
   //#include "metals.inc" //if not included already.
   
   #declare padleg = union         // Each individual leg of laucher
   {
      difference        //side slab (with holes) of each leg
      {
         prism
         {
            linear_sweep
            linear_spline 
            0,
            0.01, //Thickness
            5, //number of points making up the shape
            <0.60, -0.07>,
            <0.4, -0.07>,
            <0,-1.1>,
            <0,-1.3>,
            <0.60, -0.07> 
         }
         cylinder { <0.44, -0.1, -0.2>, <0.44, 0.1, -0.2>, 0.06} 
         cylinder { <0.35, -0.1, -0.4>, <0.35, 0.1, -0.4>, 0.05}
         cylinder { <0.26, -0.1, -0.6>, <0.26, 0.1, -0.6>, 0.04}
         cylinder { <0.17, -0.1, -0.8>, <0.17, 0.1, -0.8>, 0.03}
         cylinder { <0.08, -0.1, -1.0>, <0.08, 0.1, -1.0>, 0.02} 
      }
      prism            // bottom, sloping slab of each leg
      {
         linear_sweep
         linear_spline 
         -0.025,
         0.025, //Thickness
         5, //number of points making up the shape
         <0.4, -0.07>,
         <0.41,-0.07>,
         <0.01,-1.1>,
         <0, -1.1>,
         <0.4, -0.07>  
      }
      prism            // very bottom of each leg
      {
         linear_sweep
         linear_spline 
         -0.025,
         0.025, //Thickness
         5, //number of points making up the shape
         <0, -1.1>,
         <0.01, -1.1>,
         <0.01,-1.3>,
         <0, -1.3>,
         <0, -1.1>  
      } 
      prism            // top of each leg
      {
         linear_sweep
         linear_spline 
         -0.025,
         0.025, //Thickness
         5, //number of points making up the shape
         <0, -1.3>,
         <0.01, -1.3>,
         <0.61,-0.07>,
         <0.60, -0.07>,
         <0, -1.3>  
      }
      
      rotate 90*z
   }
         
                    
   #declare padlegs = union     // everything colored orange
   {
      cylinder {<0, 0.4 0>, <0, 0.60, 0> 0.07}     // Main cylinder
      object {padleg}                              // leg
      object {padleg rotate 120*y}                 // leg
      object {padleg rotate -120*y}                // leg
      cylinder {<0,0.60, 0>, <0,0.65, 0> 0.04}    // gooseneck
      
      pigment {color Orange}
      
      rotate 20*y
   }  
   
   #declare lauchpad = union   // Last say in laucher
   {
      object {padlegs}
      cylinder {<0.0, 0.65, 0>, <0, 0.80, 0>, 0.01 texture {T_Chrome_4B}} //slider cylinder for blast plate
      cylinder {<0.0, 0.69, 0>, <0, 0.70, 0>, 0.27 texture {T_Chrome_4B}} //Blast plate 
      cylinder {<0.0, 0.80, 0>, <0, 5.00, 0>, 0.008 texture {T_Chrome_3B}} // lauch rod
   }