   //////////////////////
   // rocket.inc
   //
   // defines the rocket and its parts 
   //
   // Created for the IRTC competition, "Alien Invasion".
   // Deadline for entry Oct. 15, 2000
   //
   // 
   // Copyright 2000, Collins Mark 
   //
   /////////////////////////////////////////////////////////////////
   
   ////////////////////////////////////
   //#include "glass.inc" // if not included before
   
   #declare rocket_Fin = prism                     // Fins of rocket
   {
      linear_sweep
      linear_spline 
      -0.01,
      0.01, //Thickness
      6, //number of points making up the shape
      <0.5, -0.05>
      <0.9, -0.05>
      <0.3, -0.4>
      <0.0, -0.4>
      <0.0, -0.3>
      <0.5, -0.05>
      pigment 
      {  
         wood
         turbulence 0.05
         scale 0.125
         color_map
         {  
            [ 0.2 Maroon]
            [ 0.21 Maroon*0.7]
            [ 0.3 Black]
            [ 0.31 Maroon*0.7] 
            [ 0.4 Maroon] 
            [ 0.5 Maroon]
            [ 0.6 Maroon*0.7]
            [ 0.7 Maroon]
            [ 0.8 Maroon]
            [ 0.9 Maroon]
            [ 1.00 Maroon]    
         }
         rotate 90
         //finish {phong 0.5 phong_size 0.5 }
      }
      rotate z*90
   }
   
   #declare rocket_Bottom = union                       // Bottom of rocket
   {
      cylinder {<0, 0.5, 0>, <0, 1.5, 0> 0.05 pigment {color Maroon} finish {phong 0.5 phong_size 0.5 }} 
      object {rocket_Fin rotate y*60} 
      object {rocket_Fin rotate -y*60}
      object {rocket_Fin rotate -y*180}
      difference
      {
          text { ttf "TIMESBD.ttf" "Alien Invader" 1, 0          // Alien Invader                                            
               rotate -z*90                               
               scale 0.10
               scale <1,1, 0.5>                                                 
               translate <-0.03, 1.45, -.06> 
              }
         difference
         {  
            cylinder {<0, 0.5, 0>, <0, 1.5, 0>, 0.5}
            cylinder {<0, 0.5, 0>, <0, 1.5, 0>, 0.0501}
         }
         pigment { color Yellow } finish {phong 0.5 phong_size 0.5 } 
      }   
      rotate -15*y      
   }
   
   #declare rocket_Top = union                  // Top of rocket, less nose cone
   {
      lathe
      {
         linear_spline
         9
         <0.000, -0.25>
         <0.047, -0.25>
         <0.047, -0.20>
         <0.050, -0.20>
         <0.075, -0.05>
         <0.075, -0.025>
         <0.071, -0.025>
         <0.071, 0.000>
         <0.000, 0.000>
         pigment 
         {  
            wood
            turbulence 0.05
            scale 0.125
            color_map
            {  
               [ 0.2 Maroon]
               [ 0.21 Maroon*0.7]
               [ 0.3 Black]
               [ 0.31 Maroon*0.7] 
               [ 0.4 Maroon] 
               [ 0.5 Maroon]
               [ 0.6 Maroon*0.7]
               [ 0.7 Maroon]
               [ 0.8 Maroon]
               [ 0.9 Maroon]
               [ 1.00 Maroon]    
            }
            rotate 90*x
            //finish {phong 0.5 phong_size 0.5 }
         }
      }
      union
      {
         difference  ////// Clear payload window
         {
            cylinder {<0, -0.025, 0>, <0, 0.25, 0>, 0.075} 
            cylinder {<0, -0.026, 0>, <0, 0.251, 0>, 0.07301}
            texture 
            {
               pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
               finish 
               {
                  ambient 0.2//0.1
                  diffuse 0.2//0.1
                  reflection 0.15//0.25
                  specular 1
                  roughness 0.001
               }
            }
         }
         difference
         {
            cylinder {<0, 0.24, 0>, <0, 0.25, 0>, 0.0751} 
            cylinder {<0, 0.23, 0>, <0, 0.251, 0>, 0.073011}
            pigment {color Maroon}
         }
      }
      union                                    // Eye hook for chute
      {
         torus{0.021, 0.005 rotate x*90 translate <0, -0.28, 0>}
         cylinder {<0,-0.24, 0>, <0,-0.26, 0>, 0.005}
         texture {T_Chrome_5B}   
      }  
      sphere              // Chute line knot
      {
         <0,0, 0>, 0.01
         pigment
         {
            wood
            turbulence 0.05
            scale 0.0125
            color_map
            {  
               [ 0.2 White]
               [ 0.21 White*0.7]
               [ 0.3 Black]
               [ 0.31 White*0.7] 
               [ 0.4 White] 
               [ 0.5 White]
               [ 0.6 White*0.7]
               [ 0.7 White*0.1]
               [ 0.8 White*0.7]
               [ 0.9 White]
               [ 1.00 White]    
            }
         }
         rotate z*90
         rotate x*90
         translate <0,-0.3,0>
      }
   }
   
   #declare rocket_NoseCone =  lathe
   {
      linear_spline
      11
      <0.000, -0.05>
      <0.072, -0.05>
      <0.072, -0.00>
      <0.075, -0.00>
      //<0.075, 0.05>
      <0.065, 0.1 +0.3*(49 - 49)/49>
      <0.055, 0.1 +0.3*(49 - 36)/49>
      <0.045, 0.1 +0.3*(49 - 25)/49>
      <0.035, 0.1 +0.3*(49 - 16)/49>
      <0.025, 0.1 +0.3*(49 - 9)/49>
      <0.015, 0.1 +0.3*(49 - 4)/49>
      <0.005, 0.1 +0.3*(49 - 2)/49>
      pigment 
      {  
         wood
         turbulence 0.05
         scale 0.125
         color_map
         {  
            [ 0.2 Maroon]
            [ 0.21 Maroon*0.7]
            [ 0.3 Black]
            [ 0.31 Maroon*0.7] 
            [ 0.4 Maroon] 
            [ 0.5 Maroon]
            [ 0.6 Maroon*0.7]
            [ 0.7 Maroon]
            [ 0.8 Maroon]
            [ 0.9 Maroon]
            [ 1.00 Maroon]    
         }
         rotate 90*x
         //finish {phong 0.5 phong_size 0.5 }
      }
   }
   
   #declare rocket = union
   {
      object {rocket_Bottom}
      object {rocket_Top translate <0, 1.5+0.15, 0>} 
   }
   
   
   #declare rocket_ChuteSquare = bicubic_patch 
   {
      type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.5, 0.5, -0.4>,  <-0.25, 0.5, 0.0>, <0.25, 0.5, 0.0>,  <0.5, 0.5, -0.4>,
      <-0.5, 0.25, 0.0>,    <0.0, 0.0, 0.2>, <0.0, 0.0, 0.2>, <0.5, 0.25, 0.0>,
      <-0.5, -0.25, 0.0>,   <0.0, 0.0, 0.2>, <0.0, 0.0, 0.2>, <0.5, -0.25, 0.0>,
      <-0.5, -0.5, -0.4>, <-0.25, -0.5, 0.0>,<0.25, -0.5, 0.0>, <0.5, -0.5, -0.4>
      rotate -90*x  // to orient the object to LHC
      //rotate 25*y   // to see the four "legs" better
      translate <0,1.4,0>
   }    
   #declare rocket_ChuteLines = union
   {
      cylinder {<0,0,0>, <0.5,1,0.5> 0.01} 
      cylinder {<0,0,0>, <0.5,1,-0.5> 0.01}
      cylinder {<0,0,0>, <-0.5,1,0.5> 0.01}
      cylinder {<0,0,0>, <-0.5,1,-0.5> 0.01}
      pigment
      {
         wood
         turbulence 0.05
         scale 0.0125
         color_map
         {  
            [ 0.2 White]
            [ 0.21 White*0.9]
            [ 0.3 White*0.6]
            [ 0.31 White] 
            [ 0.4 White] 
            [ 0.5 White]
            [ 0.6 White*0.9]
            [ 0.7 White*0.4]
            [ 0.8 White]
            [ 0.9 White]
            [ 1.00 White]    
         }
      }
   }
   #declare rocket_Chute = union
   {
      union
      { 
         object {rocket_ChuteSquare}         
         object {rocket_ChuteSquare rotate 45*y}      
         pigment {checker White*0.8, Red*0.8 scale 0.2}
      }
      object {rocket_ChuteLines}
      object {rocket_ChuteLines rotate 45*y} 
   }
      
   #declare rocket_ChuteClosed = union      // Creates a rolled-up parachute
   {
      union
      {
         cylinder {<-0.2, 0, 0>, <0.2, 0, 0> 0.05}
         cone {<-0.2, 0, 0>, 0.07, <-0.05, 0, 0> 0.05}
         cone {<0.2, 0, 0>, 0.07, <0.05, 0, 0> 0.05}
         pigment {checker White*0.8, Red*0.8 scale 0.1}
      }
      union
      {
         torus {0.06, 0.01 rotate 90*z rotate 009*x translate <-0.06, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 158*x translate <-0.05, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 097*x translate <-0.04, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 206*x translate <-0.01, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 055*x translate <0.00, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 194*x translate <0.02, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 203*x translate <0.04, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 052*x translate <0.05, 0, 0>}
         torus {0.06, 0.01 rotate 90*z rotate 191*x translate <0.06, 0, 0>}
         pigment
         {
            wood
            turbulence 0.05
            scale 0.0125
            color_map
            {  
               [ 0.2 White]
               [ 0.21 White*0.9]
               [ 0.3 White*0.6]
               [ 0.31 White] 
               [ 0.4 White] 
               [ 0.5 White]
               [ 0.6 White*0.9]
               [ 0.7 White*0.4]
               [ 0.8 White]
               [ 0.9 White]
               [ 1.00 White]    
            }
         }
      }
   } 
   
   #declare rocket_ChuteClosedLines = union
   {
      cylinder {<-0.3,0.03,0>, <0,0,0> 0.01}
      cylinder {<-0.3,0.035,0>, <0,0,0> 0.01}
      cylinder {<-0.3,0.036,0>, <0,0,0> 0.01}
      cylinder {<-0.3,0,0>, <0,0,0> 0.01}
      cylinder {<-0.3,-0.01,0>, <0,0,0> 0.01}
      cylinder {<-0.3,-0.015,0>, <0,0,0> 0.01}
      cylinder {<-0.3,-0.035,0>, <0,0,0> 0.01}
      pigment
      {
         wood
         turbulence 0.05
         scale 0.0125
         color_map
         {  
            [ 0.2 White]
            [ 0.21 White*0.9]
            [ 0.3 White*0.6]
            [ 0.31 White] 
            [ 0.4 White] 
            [ 0.5 White]
            [ 0.6 White*0.9]
            [ 0.7 White*0.4]
            [ 0.8 White]
            [ 0.9 White]
            [ 1.00 White]    
         }
      }
   }
   
   #declare SmokeBall = object
   {
      sphere {<0,0,0>, 1}
      pigment
      {
         bozo
         turbulence 0.05
         scale 0.25
         color_map
         {  
            [ 0.2 rgbf <0.9,0.9,0.9, 0.8>]
            [ 0.3 rgbf <0.9,0.9,0.9, 0.7>] 
            [ 0.4 rgbf <1.0,1.0,1.0, 0.6>] 
            [ 0.5 rgbf <0.9,0.9,0.9, 0.5>]
            [ 0.6 rgbf <1.0,1.0,1.0, 0.4>]
            [ 0.7 rgbf <0.9,0.9,0.9, 0.5>]
            [ 0.8 rgbf <1.0,1.0,1.0, 0.6>]
            [ 0.9 rgbf <0.9,0.9,0.9, 0.7>]
            [ 1.00 rgbf <1.0,1.0,1.0, 0.8>]    
         }
      }
   }
   
   #declare SmokeBallBlast = object
   {
      sphere {<0,0,0>, 1}
      pigment
      {
         bozo
         turbulence 0.05
         scale 0.25
         color_map
         {  
            [ 0.2 rgbf <0.9,0.9,0.9, 0.9>]
            [ 0.3 rgbf <0.9,0.9,0.9, 0.9>] 
            [ 0.4 rgbf <1.0,1.0,1.0, 0.8>] 
            [ 0.5 rgbf <0.9,0.9,0.9, 0.7>]
            [ 0.6 rgbf <1.0,1.0,1.0, 0.6>]
            [ 0.7 rgbf <0.9,0.9,0.9, 0.5>]
            [ 0.8 rgbf <1.0,1.0,1.0, 0.6>]
            [ 0.9 rgbf <0.9,0.9,0.9, 0.7>]
            [ 1.00 rgbf <1.0,1.0,1.0, 0.8>]    
         }
      }
   }          