#declare time = 20;
#include "ships.inc"

#declare Ocean = texture {
  pigment {
    bozo
    turbulence 0.5
    colour_map {
      [0.00 colour rgb <0,0,1>]
      [0.20 colour rgb <0,0,1>]
      [0.20 colour rgbt <1,1,1,1>]
      [0.80 colour rgbt <1,1,1,1>]
      [0.80 colour rgb <0,0,1>]
      [1.00 colour rgb <0,0,1>]
    }
  }
}

#declare Land = texture {
  pigment {
    agate
    turbulence 0.5
    colour_map {
      [0.00 colour rgb <.5, .4, .1>]
      [0.30 colour rgb <.3, .5, .4>]
      [0.70 colour rgb <.3, .5, .4>]
      [1.00 colour rgb <.5, .4, .1>]
    }
  }
  normal {
    bozo
    turbulence 0.5
    normal_map {  
      [0.2 wrinkles .15 scale .01]
      [0.8 granite turbulence 1]
      [1.0 wrinkles .15 scale .01]
    }
  }
}

#declare Clouds1 = pigment {
  bozo
  turbulence 1
  colour_map {
    [0.0 colour rgbt <1,1,1,1>]
    [0.5 colour rgb <1,1,1>]
    [1.0 colour rgbt <1,1,1,1>]
  }
  scale 0.25
}

#declare Clouds2 = pigment {
  bozo
  turbulence 0.5
  colour_map {
    [0.0 colour rgb <1,1,1>]
    [0.15 colour rgb <1,1,1>]
    [0.3 colour rgbt <1,1,1,1>]
    [0.7 colour rgbt <1,1,1,1>]
    [0.85 colour rgb <1,1,1>]
    [1.0 colour rgb <1,1,1>]
  }
}
  
#declare CloudCover = texture {
  pigment {
    bozo
    turbulence 0.5
    pigment_map {
      [0.00 Clouds1]
      [0.10 Clouds1]
      [0.35 Clouds2]
      [0.65 Clouds2]
      [0.90 Clouds1]
      [1.00 Clouds1]
    }
  }
}

camera {
  location <0, 7.5, -144.3-500*clock>
  look_at <0, 7.5, -150-500*clock>
}

light_source {
  <-2500, 1500, 1500>
  colour rgb <1,1,1>
}

sphere { <0,0,0>, 2
  texture { Land }
  texture { Ocean }
  texture { CloudCover }
  scale 150
  rotate y*170
  translate <15, 120, -1000>
}

AlienCarrier (<0,0,0>, <0,0,-75*clock>, 1)

object { AlienFighter
  texture { Organic }
  translate <0, 0, -170-500*clock>
}

object { AlienFighter
  texture { Organic }
  translate <-7.5, 0, -140-500*clock>
}

object { AlienFighter
  texture { Organic }
  translate <7.5, 0, -140-500*clock>
}

object { AlienFighter
  texture { Organic }
  translate <0, 7.5, -140-500*clock>
}

union { 
  box { <100, 100, 1.5>, <-100, -100, -1.5>
    hollow
    pigment { colour rgbt <1,1,1,1> }
    interior {
      media {
        emission 1.0
        intervals 10
        density {
          bozo
          phase clock
          turbulence 1.0
          colour_map {
            [0.00 colour rgb <0.9, 0.7, 0>*(clock-0.93)*(clock>0.93)*14.3]
            [0.25 colour rgb <0.6, 0.3, 0>*(clock-0.93)*(clock>0.93)*14.3]
            [0.50 colour rgb <0.5, 0.2, 0>*(clock-0.93)*(clock>0.93)*14.3]
            [0.75 colour rgb <0.6, 0.3, 0>*(clock-0.93)*(clock>0.93)*14.3]
            [1.00 colour rgb <0.9, 0.7, 0>*(clock-0.93)*(clock>0.93)*14.3]
          }
        }
      }
    }
  }
  box { <100, 100, -1.5>, <-100, -100, -1.6>
    hollow
    pigment { colour rgbt <0, 0, 0, 0+min(14.3*clock, 1)> }
  }
  translate < 0, 0, 10000*(clock < 0.93 )-(610+500*(clock-0.93))*(clock>0.93)>
}

object { AlienFighter
  texture { Organic }
  translate <0, -7.5, -140-500*clock>
}

object { AlienEscort
  texture { Organic }
  rotate <10, 0, -10>
  translate <-20, -10, -400-125*clock>
}

AlienCarrier (<-10,0,0>, <80, 50, -350-75*clock>, 1)

object { AlienEscort
  texture { Organic }
  translate <160, -25, -250-125*clock>
}

object { AlienEscort
  texture { Organic }
  translate <100, 30, -175-125*clock>
}

object { AlienEscort
  texture { Organic }
  translate <350, 80, -275-125*clock>
}

object { AlienEscort
  texture { Organic }
  translate <200, -50, -150-125*clock>
}

object { AlienEscort
  texture { Organic }
  translate <120, -75, -75-125*clock>
}

AlienCarrier (<0,0,0>, <225, -35, -210-75*clock>, 1)

Stars ()