#declare time=20;
#include "ships.inc"

#declare MissileBody = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.098735, 0.501478, -0.000100>, <-0.098735, 0.501432, -0.132239>, <0.098735, 0.501432, -0.132239>, <0.098735, 0.501478, -0.000100>, 
      <-0.098735, -0.123779, -0.000045>, <-0.098735, -0.123825, -0.132184>, <0.098735, -0.123825, -0.132184>, <0.098735, -0.123779, -0.000045>, 
      <-0.098735, -0.373058, 0.000010>, <-0.098735, -0.373104, -0.132129>, <0.098735, -0.373104, -0.132129>, <0.098735, -0.373058, 0.000010>, 
      <-0.000000, -0.500444, 0.000003>, <-0.000000, -0.500444, 0.000003>, <0.000000, -0.500444, 0.000003>, <0.000000, -0.500444, 0.000003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.098735, 0.501478, -0.000100>, <0.098735, 0.501525, 0.132039>, <-0.098735, 0.501525, 0.132039>, <-0.098735, 0.501478, -0.000100>, 
      <0.098735, -0.123779, -0.000045>, <0.098735, -0.123732, 0.132094>, <-0.098735, -0.123732, 0.132094>, <-0.098735, -0.123779, -0.000045>, 
      <0.098735, -0.373058, 0.000010>, <0.098735, -0.373012, 0.132149>, <-0.098735, -0.373012, 0.132149>, <-0.098735, -0.373058, 0.000010>, 
      <0.000000, -0.500444, 0.000003>, <0.000000, -0.500444, 0.000003>, <-0.000000, -0.500444, 0.000003>, <-0.000000, -0.500444, 0.000003>
    }
  }
  rotate x*-270
}

#declare fins = prism {
  linear_sweep
  linear_spline
  -0.005,
  0.005,
  11,
  <-0.124, 0.45>, <-0.124, 0.25>, <-0.09, 0.198038>, <0.09, 0.198038>, <0.124, 0.25>, <0.124, 0.45>, <0.09, 0.398038>, <0.09, 0.25>, <-0.09, 0.25>,
  <-0.09, 0.398038>, <-0.124, 0.45>
  pigment { colour Red }
  finish { Metal }
}

#macro Missile (rotation, translation, engine)
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
      colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
    HumanEngine (0.1, 0.1, 0.1, <0, 0, 0.5>, engine)
    rotate rotation
    translate translation
  }
#end

#declare Camoflage = texture {
  pigment {
    bozo
    colour_map {
      [0.0 colour rgb <.45, .75, .6>]
      [0.25 colour rgb <.45, .75, .6>]
      [0.75 colour rgb <.45, .75, .15>]
      [1.0 colour rgb <.45, .75, .15>]
    }
  }
  finish { metallic }
  scale 0.5
}

#macro AAturret (rotation, translation, turretrotate, gunrotate, M1, M2, M2yt, M2zt, M3, M4, M5, M6 )
  union {
    difference {
      superellipsoid { <0.25, 0.25> }
      box { <2, 0, 2>, <-2, -2, -2> }
      cylinder { <0, 1, 0>, <0, .8, 0>, 0.55 }
    }
    cylinder { <0, .79, 0>, <0, 1.21, 0>, 0.45
      pigment { colour Gray75 }
      finish { Metal ambient 0.7}
      rotate y*turretrotate
    }
    union { 
      box { <0.465, 1.2, 0.65>, <-0.465, 1.5, -0.75> }
      cylinder { <0.4, 1.52, 0.54>, <-0.4, 1.52, 0.54>, 0.10
        pigment { colour Gray75 }
        finish { Metal ambient 0.7 }
      }
      rotate y*turretrotate
      texture { Camoflage rotate y*turretrotate }
    }
    union {
      box { <0.4, 1.5, 0.4>, <-0.4, 1.54, -0.7>}
      difference {
        box { <0.465, 1.54, 0.65>, <-0.465, 2.2, -0.75> }
        box { <0.415, 1.59, -0.72>, <-0.415, 2.15, -0.76> }
        cylinder { <0, 1.735, 0.3>, <0, 1.735, -0.76>, 0.125 }
        cylinder { <0, 2.005, 0.3>, <0, 2.005, -0.76>, 0.125 }
        cylinder { <0.27, 1.735, 0.3>, <0.27, 1.735, -0.76>, 0.125 }
        cylinder { <0.27, 2.005, 0.3>, <0.27, 2.005, -0.76>, 0.125 }
        cylinder { <-0.27, 1.735, 0.3>, <-0.27, 1.735, -0.76>, 0.125 }
        cylinder { <-0.27, 2.005, 0.3>, <-0.27, 2.005, -0.76>, 0.125 }
      }
      rotate <gunrotate, turretrotate, 0>
      texture { Camoflage rotate <gunrotate, turretrotate, 0> }
    }
    Missile (<gunrotate, 0,  0>, <0, 1.735, -0.2>, M5)
    Missile (<gunrotate, 0,  0>, <0, 2.005+M2yt, -0.2+M2zt>, M2)
    Missile (<gunrotate, 0,  0>, <0.27, 1.735, -0.2>, M6)
    Missile (<gunrotate, 0,  0>, <0.27, 2.005, -0.2>, M3)
    Missile (<gunrotate, 0,  0>, <-0.27, 1.735, -0.2>, M4)
    Missile (<gunrotate, 0,  0>, <-0.27, 2.005, -0.2>, M1)
    texture { Camoflage }
    rotate rotation
    translate translation
  }
#end

camera {
  //location <0, 6.8, 10>
  location <0, 29.2-22.4*clock, -130+140*clock>
  look_at <0, 5.605, 29.8>
  angle 30
}

union {
  box { <100, 100, 1.5>, <-100, -100, -1.5>
    hollow
    pigment { colour rgbt <1,1,1,1> }
    interior {
      media {
        emission 1.0
        intervals 10
        density {
          bozo
          phase 1+clock
          turbulence 1.0
          colour_map {
            [0.00 colour rgb <0.9, 0.7, 0>*(0.07-clock)*(clock<0.07)*14.3]
            [0.25 colour rgb <0.6, 0.3, 0>*(0.07-clock)*(clock<0.07)*14.3]
            [0.50 colour rgb <0.5, 0.2, 0>*(0.07-clock)*(clock<0.07)*14.3]
            [0.75 colour rgb <0.6, 0.3, 0>*(0.07-clock)*(clock<0.07)*14.3]
            [1.00 colour rgb <0.9, 0.7, 0>*(0.07-clock)*(clock<0.07)*14.3]
          }
        }
      }
    }
  }
  box { <100, 100, -1.5>, <-100, -100, -1.6>
    hollow
    pigment { colour rgbt <0, 0, 0, 0+min(14.3*clock, 1)> }
  }
  rotate y*180
  translate < 0, 0, -125+140*clock*(clock<0.07)>
}

object { AlienFighter
  texture { Organic }
  rotate <9, 180, 0>
  translate <0, 29.873-22.4*clock, -134.25+140*clock>
}

object { AlienFighter
  texture { Organic }
  rotate <0, 180+90*pow(clock, .75)*(clock>0.07), 0>
  translate <0+100*pow(clock, 1.5)*(clock>0.07), 22.373-22.4*clock, -105.793+140*clock>
}

light_source { <1000, 1000, -1000> White }



height_field {
  tga "e:\pc'sjunk\pov\misc\heigtfield.tga"
  smooth
  pigment {
    gradient y
    turbulence 0.4
    colour_map {
      [0.00 colour rgb <.45, .75, .6>]
      [0.19 colour rgb <.45, .75, .6>]
      [0.193 colour rgb <.75, .45, .3>]
      [0.196 colour rgb <.6, .75, .23>]
      [0.20 colour rgb <.45, .75, .6>]
      [0.40 colour rgb <.45, .75, .6>]
      [0.404 colour rgb <.6, .75, .23>]
      [0.407 colour rgb <.75, .45, .3>]
      [0.41 colour rgb <.45, .6, .15>]
      [0.60 colour rgb <.45, .75, .6>]
      [0.603 colour rgb <.75, .6, .23>]
      [0.607 colour rgb <.45, .75, .3>]
      [0.61 colour rgb <.45, .75, .6>]
      [1.00 colour rgb <.45, .75, .6>]
    }
  }
  translate <-.5, -.5, -.5>
  scale <160, 20, 160>
}

AAturret (<0, 0, 0>, <0,3.6,30>, 0, 0+min(30*(clock-0.5)*(clock>0.5),9), 0, (clock > 0.8), 5.2*(clock-0.8)*(clock>0.8),
  -94*(clock-0.8)*(clock>0.8), 0, 0, 0, 0)

AAturret (<0, 0, 0>, <-18, 3, 40>, 10, 15, 0, 0, 0, 0, 0, 0, 0, 0)

AAturret (<0, 0, 0>, <20, 2.8, 75>, -10, 5, 0, 0, 0, 0, 0, 0, 0, 0)

AAturret (<0, 0, 0>, <0, 2, 69>, -15, 20, 0, 0, 0, 0, 0, 0, 0, 0)

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.0 colour SkyBlue ]
      [ 0.5 color SkyBlue ]
      [ 1.0 color MidnightBlue ]
    }
    scale 2
    translate -1
  }
}