#declare time = 4;
#include "ships.inc"

#declare Explosion = sphere { <0, 0, 0>, 3
  hollow
  pigment { colour rgbt <1,1,1,1> }
  interior {
    media {
      emission 1
      intervals 20
      density {
        spherical
        density_map {
          [0.00 colour Black]
          [0.20-(0.19-clock*0.19)
                bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.90 colour Orange*(.25-(clock*clock*.25))]
                  [0.95 colour Orange*(.5-(clock*clock*.5))]
                  [1.00 colour Yellow*(.5-(clock*clock*.5))]
                }
                scale .6
                turbulence 1.0
                phase clock*.5
          ]
          [0.60-(0.58-clock*0.58)
                bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*(.35-((0.23+clock)*(0.23+clock)*.25))]
                  [0.90 colour Orange*(.7-((0.23+clock)*(0.23+clock)*.5))]
                  [0.95 colour Yellow*(.7-((0.23+clock)*(0.23+clock)*.5))]
                  [1.00 colour Yellow*(1.4-((0.23+clock)*(0.23+clock)))]
                }
                scale .5
                turbulence 1.0
                phase clock*.5
          ]
          [0.80-(0.77-clock*0.77)
                bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40 colour Black]
                  [0.80 colour Orange*(.65-((0.24+clock)*(0.24+clock)*0.5))]
                  [0.90 colour Orange*(1.3-((0.24+clock)*(0.24+clock)))]
                  [0.95 colour Yellow*(1.3-((0.24+clock)*(0.24+clock)))]
                  [1.00 colour Yellow*(2.6-((0.24+clock)*(0.24+clock)*2))]
                }
                scale .4
                turbulence 1.0
                phase clock*.5
          ]
          [0.90-(0.76-clock*0.76)
                bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40-(0.20-clock*0.20) colour Black]
                  [0.80-(0.40-clock*0.40) colour Orange*(1.1-((0.20+clock)*(0.20+clock)))]
                  [0.90-(0.40-clock*0.40) colour Orange*(2.2-((0.20+clock)*(0.20+clock)*2))]
                  [0.95-(0.20-clock*0.20) colour Yellow*(2.2-((0.20+clock)*(0.20+clock)*2))]
                  [1.00 colour Yellow*(3.3-((0.20+clock)*(0.20+clock*3)))]
                }
                scale .4
                turbulence 1.0
                phase clock*.5
          ]
          [1.00 bozo
                colour_map {
                  [0.00 colour Black]
                  [0.40-(0.30-clock*0.20) colour Black]
                  [0.80-(0.40-clock*0.40) colour Orange*(1.15-((clock+0.27)*(clock+0.27)))]
                  [0.90-(0.40-clock*0.40) colour Orange*(2.3-((0.27+clock)*(0.27+clock)*2))]
                  [0.95-(0.20-clock*0.20) colour Yellow*(2.3-((0.27+clock)*(0.27+clock)*2))]
                  [1.00 colour Yellow*(4.6-((clock+0.27)*(0.27+clock)*4))]
                }
                scale .4
                turbulence 1.0
                phase clock*.5
          ]
        }
        scale 2.8-(2.7-clock*2.7)
        turbulence 0.2+(0.4-clock*0.4)
      }
    }
  }
}

#declare MissileBody = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.098735, 0.501478, -0.000100>, <-0.098735, 0.501432, -0.132239>, <0.098735, 0.501432, -0.132239>, <0.098735, 0.501478, -0.000100>, 
      <-0.098735, -0.123779, -0.000045>, <-0.098735, -0.123825, -0.132184>, <0.098735, -0.123825, -0.132184>, <0.098735, -0.123779, -0.000045>, 
      <-0.098735, -0.373058, 0.000010>, <-0.098735, -0.373104, -0.132129>, <0.098735, -0.373104, -0.132129>, <0.098735, -0.373058, 0.000010>, 
      <-0.000000, -0.500444, 0.000003>, <-0.000000, -0.500444, 0.000003>, <0.000000, -0.500444, 0.000003>, <0.000000, -0.500444, 0.000003>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.098735, 0.501478, -0.000100>, <0.098735, 0.501525, 0.132039>, <-0.098735, 0.501525, 0.132039>, <-0.098735, 0.501478, -0.000100>, 
      <0.098735, -0.123779, -0.000045>, <0.098735, -0.123732, 0.132094>, <-0.098735, -0.123732, 0.132094>, <-0.098735, -0.123779, -0.000045>, 
      <0.098735, -0.373058, 0.000010>, <0.098735, -0.373012, 0.132149>, <-0.098735, -0.373012, 0.132149>, <-0.098735, -0.373058, 0.000010>, 
      <0.000000, -0.500444, 0.000003>, <0.000000, -0.500444, 0.000003>, <-0.000000, -0.500444, 0.000003>, <-0.000000, -0.500444, 0.000003>
    }
  }
  rotate x*-270
}

#declare fins = prism {
  linear_sweep
  linear_spline
  -0.005,
  0.005,
  11,
  <-0.124, 0.45>, <-0.124, 0.25>, <-0.09, 0.198038>, <0.09, 0.198038>, <0.124, 0.25>, <0.124, 0.45>, <0.09, 0.398038>, <0.09, 0.25>, <-0.09, 0.25>,
  <-0.09, 0.398038>, <-0.124, 0.45>
  pigment { colour Red }
  finish { Metal }
}

#macro Missile (rotation, translation, engine)
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
      colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
    HumanEngine (0.1, 0.1, 0.1, <0, 0, 0.5>, engine)
    rotate rotation
    translate translation
  }
#end

#declare ME1 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, 0.3
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME2 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { -y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, 0.3
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME3 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, 0.3
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME4 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { -y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, 0.3
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME5 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { z, 0.3
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, 0.1
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME6 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { -y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { z, 0.1
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, -0.1
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME7 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { z, -0.1
    pigment { colour rgb <0,0,0> }
  }
  plane { -z, -0.3
    pigment { colour rgb <0,0,0> }
  }
}

#declare ME8 = difference { 
  union {
    object { fins }
    object { fins
      rotate z*90
    }
    object { MissileBody
      pigment {
        gradient z
        colour_map {
          [0.0 Red]
          [0.1 Red]
          [0.1 White]
          [1.0 White]
        }
        translate z*-0.4
      }
      finish { Metal }
    }
  }
  plane { -y, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { -x, 0
    pigment { colour rgb <0,0,0> }
  }
  plane { z, -0.3
    pigment { colour rgb <0,0,0> }
  }
}

#declare Mexplode = union {
  object { ME1
    rotate <-21.6*(clock-0.1)*(clock>0.1), -469.44*(clock-0.1)*(clock>0.1), -719.981*(clock-0.1)*(clock>0.1)>
    translate <-2.0*(clock-0.1)*(clock>0.1), -2.65*(clock-0.1)*(clock>0.1), 1.11*(clock-0.1)*(clock>0.1)>
  }
  object { ME2
    rotate <-33.12*(clock-0.1)*(clock>0.1), 682.56*(clock-0.1)*(clock>0.1), -126.72*(clock-0.1)*(clock>0.1)>
    translate <-1.82*(clock-0.1)*(clock>0.1), 1.65*(clock-0.1)*(clock>0.1), 1.69*(clock-0.1)*(clock>0.1)>
  }
  object { ME3
    rotate <-15.84*(clock-0.1)*(clock>0.1), -339.84*(clock-0.1)*(clock>0.1), -590.4*(clock-0.1)*(clock>0.1)>
    translate <1.91*(clock-0.1)*(clock>0.1), -1.93*(clock-0.1)*(clock>0.1), 2.31*(clock-0.1)*(clock>0.1)>
  }
  object { ME4
    rotate <-604.8*(clock-0.1)*(clock>0.1), 505.44*(clock-0.1)*(clock>0.1), 126.72*(clock-0.1)*(clock>0.1)>
    translate <1.70*(clock-0.1)*(clock>0.1), 2.68*(clock-0.1)*(clock>0.1), 1.53*(clock-0.1)*(clock>0.1)>
  }
  object { ME5
    rotate <299.52*(clock-0.1)*(clock>0.1), -285.12*(clock-0.1)*(clock>0.1), 650.88*(clock-0.1)*(clock>0.1)>
    translate <-1.466*(clock-0.1)*(clock>0.1), -.739*(clock-0.1)*(clock>0.1), 1.03*(clock-0.1)*(clock>0.1)>
  }
  object { ME6
    rotate <507.24*(clock-0.1)*(clock>0.1), 182.88*(clock-0.1)*(clock>0.1), -99.36*(clock-0.1)*(clock>0.1)>
    translate <-1.088*(clock-0.1)*(clock>0.1), 1.044*(clock-0.1)*(clock>0.1), 1.023*(clock-0.1)*(clock>0.1)>
  }
  object { ME7
    rotate <626.4*(clock-0.1)*(clock>0.1), 36*(clock-0.1)*(clock>0.1), -610.56*(clock-0.1)*(clock>0.1)>
    translate <0.535*(clock-0.1)*(clock>0.1), -1.31*(clock-0.1)*(clock>0.1), 1.131*(clock-0.1)*(clock>0.1)>
  }
  object { ME8
    rotate <380.16*(clock-0.1)*(clock>0.1), 122.4*(clock-0.1)*(clock>0.1), -34.56*(clock-0.1)*(clock>0.1)>
    translate <1.031*(clock-0.1)*(clock>0.1), 0.729*(clock-0.1)*(clock>0.1), 0.781*(clock-0.1)*(clock>0.1)>
  }
}

#declare Camoflage = texture {
  pigment {
    bozo
    colour_map {
      [0.0 colour rgb <.45, .75, .6>]
      [0.25 colour rgb <.45, .75, .6>]
      [0.75 colour rgb <.45, .75, .15>]
      [1.0 colour rgb <.45, .75, .15>]
    }
  }
  finish { metallic }
  scale 0.5
}

#macro AAturret (rotation, translation, turretrotate, gunrotate, M1, M2, M2yt, M2zt, M3, M4, M5, M6 )
  union {
    difference {
      superellipsoid { <0.25, 0.25> }
      box { <2, 0, 2>, <-2, -2, -2> }
      cylinder { <0, 1, 0>, <0, .8, 0>, 0.55 }
    }
    cylinder { <0, .79, 0>, <0, 1.21, 0>, 0.45
      pigment { colour Gray75 }
      finish { Metal ambient 0.7}
      rotate y*turretrotate
    }
    union { 
      box { <0.465, 1.2, 0.65>, <-0.465, 1.5, -0.75> }
      cylinder { <0.4, 1.52, 0.54>, <-0.4, 1.52, 0.54>, 0.10
        pigment { colour Gray75 }
        finish { Metal ambient 0.7 }
      }
      rotate y*turretrotate
      texture { Camoflage rotate y*turretrotate }
    }
    union {
      box { <0.4, 1.5, 0.4>, <-0.4, 1.54, -0.7>}
      difference {
        box { <0.465, 1.54, 0.65>, <-0.465, 2.2, -0.75> }
        box { <0.415, 1.59, -0.72>, <-0.415, 2.15, -0.76> }
        cylinder { <0, 1.735, 0.3>, <0, 1.735, -0.76>, 0.125 }
        cylinder { <0, 2.005, 0.3>, <0, 2.005, -0.76>, 0.125 }
        cylinder { <0.27, 1.735, 0.3>, <0.27, 1.735, -0.76>, 0.125 }
        cylinder { <0.27, 2.005, 0.3>, <0.27, 2.005, -0.76>, 0.125 }
        cylinder { <-0.27, 1.735, 0.3>, <-0.27, 1.735, -0.76>, 0.125 }
        cylinder { <-0.27, 2.005, 0.3>, <-0.27, 2.005, -0.76>, 0.125 }
      }
      rotate <gunrotate, turretrotate, 0>
      texture { Camoflage rotate <gunrotate, turretrotate, 0> }
    }
    Missile (<gunrotate, 0,  0>, <0, 1.735, -0.2>, M5)
    Missile (<gunrotate, 0,  0>, <0, 2.005+M2yt, -0.2+M2zt>, M2)
    Missile (<gunrotate, 0,  0>, <0.27, 1.735, -0.2>, M6)
    Missile (<gunrotate, 0,  0>, <0.27, 2.005, -0.2>, M3)
    Missile (<gunrotate, 0,  0>, <-0.27, 1.735, -0.2>, M4)
    Missile (<gunrotate, 0,  0>, <-0.27, 2.005, -0.2>, M1)
    texture { Camoflage }
    rotate rotation
    translate translation
  }
#end

camera {
  location <0, 6.8, 10>
  look_at <0, 5.605, 29.8>
  angle 30
}

box { <100, 100, 1.5>, <-100, -100, -1.5>
  hollow
  pigment { colour rgbt  <1-2*(clock-0.5)*(clock>0.5), 1-2*(clock-0.5)*(clock>0.5), 1-2*(clock-0.5)*(clock>0.5), 1-min(2*clock,1)>}
  finish { ambient 1.0 }
  translate <0, 0, 11.50001>
}

object { AlienFighter
  texture { Organic }
  rotate <9, 180, 0>
  translate <0, 7.473, 5.75>
}

light_source { <1000, 1000, -1000> White }

height_field {
  tga "e:\pc'sjunk\pov\misc\heigtfield.tga"
  smooth
  pigment {
    gradient y
    turbulence 0.4
    colour_map {
      [0.00 colour rgb <.45, .75, .6>]
      [0.19 colour rgb <.45, .75, .6>]
      [0.193 colour rgb <.75, .45, .3>]
      [0.196 colour rgb <.6, .75, .23>]
      [0.20 colour rgb <.45, .75, .6>]
      [0.40 colour rgb <.45, .75, .6>]
      [0.404 colour rgb <.6, .75, .23>]
      [0.407 colour rgb <.75, .45, .3>]
      [0.41 colour rgb <.45, .6, .15>]
      [0.60 colour rgb <.45, .75, .6>]
      [0.603 colour rgb <.75, .6, .23>]
      [0.607 colour rgb <.45, .75, .3>]
      [0.61 colour rgb <.45, .75, .6>]
      [1.00 colour rgb <.45, .75, .6>]
    }
  }
  translate <-.5, -.5, -.5>
  scale <160, 20, 160>
}

AAturret (<0, 0, 0>, <0,3.6,30>, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0)

AAturret (<0, 0, 0>, <-18, 3, 40>, 10, 15, 0, 0, 0, 0, 0, 0, 0, 0)

AAturret (<0, 0, 0>, <20, 2.8, 75>, -10, 5, 0, 0, 0, 0, 0, 0, 0, 0)

AAturret (<0, 0, 0>, <0, 2, 69>, -15, 20, 0, 0, 0, 0, 0, 0, 0, 0)

object { Explosion
  translate <0, 6.645, 11-1000*(clock>0.5)>
}

object { Mexplode
  rotate x*9
  translate <0, 6.645, 11>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.0 colour SkyBlue ]
      [ 0.5 color SkyBlue ]
      [ 1.0 color MidnightBlue ]
    }
    scale 2
    translate -1
  }
}