#declare time=20;
#include "ships.inc"

#declare Ocean = texture {
  pigment {
    bozo
    turbulence 0.5
    colour_map {
      [0.00 colour rgb <0,0,1>]
      [0.20 colour rgb <0,0,1>]
      [0.20 colour rgbt <1,1,1,1>]
      [0.80 colour rgbt <1,1,1,1>]
      [0.80 colour rgb <0,0,1>]
      [1.00 colour rgb <0,0,1>]
    }
  }
}

#declare Land = texture {
  pigment {
    agate
    turbulence 0.5
    colour_map {
      [0.00 colour rgb <.5, .4, .1>]
      [0.30 colour rgb <.3, .5, .4>]
      [0.70 colour rgb <.3, .5, .4>]
      [1.00 colour rgb <.5, .4, .1>]
    }
  }
  normal {
    bozo
    turbulence 0.5
    normal_map {  
      [0.2 wrinkles .15 scale .01]
      [0.8 granite turbulence 1]
      [1.0 wrinkles .15 scale .01]
    }
  }
}

#declare Clouds1 = pigment {
  bozo
  turbulence 1
  colour_map {
    [0.0 colour rgbt <1,1,1,1>]
    [0.5 colour rgb <1,1,1>]
    [1.0 colour rgbt <1,1,1,1>]
  }
  scale 0.25
}

#declare Clouds2 = pigment {
  bozo
  turbulence 0.5
  colour_map {
    [0.0 colour rgb <1,1,1>]
    [0.15 colour rgb <1,1,1>]
    [0.3 colour rgbt <1,1,1,1>]
    [0.7 colour rgbt <1,1,1,1>]
    [0.85 colour rgb <1,1,1>]
    [1.0 colour rgb <1,1,1>]
  }
}
  
#declare CloudCover = texture {
  pigment {
    bozo
    turbulence 0.5
    pigment_map {
      [0.00 Clouds1]
      [0.10 Clouds1]
      [0.35 Clouds2]
      [0.65 Clouds2]
      [0.90 Clouds1]
      [1.00 Clouds1]
    }
  }
}

camera {
  location <-162, 70, -90>
  look_at <15-18.75*max(clock-0.2,0), 120-140.625*max(clock-0.2,0), -1000+1250*max(clock-0.2,0)>
}

light_source {
  <-2500, 1500, 1500>
  colour rgb <1,1,1>
}

plane {z, -91
  hollow  
  pigment { colour rgbt <0,0,0,0+min(5*clock,1)> }
}

sphere { <0,0,0>, 2
  texture { Land }
  texture { Ocean }
  texture { CloudCover }
  scale 150
  rotate y*170
  translate <15, 120, -1000>
}

AlienCarrier (<0,0,0>, <0,0,0>, 0)

object { AlienEscort
  texture { Organic }
  rotate <10, 0, -10>
  translate <-20, -10, -400>
}

AlienCarrier (<-10,0,0>, <80, 50, -300>, 0)

object { AlienEscort
  texture { Organic }
  translate <160, -25, -250>
}

object { AlienEscort
  texture { Organic }
  translate <100, 30, -175>
}

object { AlienEscort
  texture { Organic }
  translate <350, 80, -275>
}

object { AlienEscort
  texture { Organic }
  translate <200, -50, -150>
}

object { AlienEscort
  texture { Organic }
  translate <120, -75, -75>
}

AlienCarrier (<0,0,0>, <225, -35, -210>, 0)

Stars ()