#include "ship_parts.inc"

#declare AlienCarrierHull = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.002027, -1.529642, -0.006338>, <-0.002027, -1.529645, -0.005223>, <-0.001115, -1.529649, -0.004311>, <0.000000, -1.529649, -0.004311>, 
      <-1.000000, -1.412387, -0.014746>, <-1.000000, -1.414291, 0.535251>, <-0.550000, -1.415849, 0.985248>, <0.000000, -1.415849, 0.985248>, 
      <-1.000000, -1.554940, -0.006667>, <-1.000000, -1.556845, 0.543330>, <-0.550000, -1.558403, 0.993327>, <0.000000, -1.558403, 0.993327>, 
      <-1.000000, -0.776671, -0.004862>, <-1.000000, -0.601779, 0.544883>, <-0.550000, -0.598938, 1.006787>, <0.000000, -0.596879, 1.006055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -1.529649, -0.004311>, <0.001115, -1.529649, -0.004311>, <0.002027, -1.529645, -0.005223>, <0.002027, -1.529642, -0.006338>, 
      <0.000000, -1.415849, 0.985248>, <0.550000, -1.415849, 0.985248>, <1.000000, -1.414291, 0.535251>, <1.000000, -1.412387, -0.014746>, 
      <0.000000, -1.558403, 0.993327>, <0.550000, -1.558403, 0.993327>, <1.000000, -1.556845, 0.543330>, <1.000000, -1.554940, -0.006667>, 
      <0.000000, -0.596879, 1.006055>, <0.550000, -0.598938, 1.006787>, <1.000000, -0.601779, 0.544883>, <1.000000, -0.776671, -0.004862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.002027, -1.529642, -0.006338>, <0.002027, -1.529638, -0.007453>, <0.001115, -1.529634, -0.008383>, <0.000000, -1.529634, -0.008383>, 
      <1.000000, -1.412387, -0.014746>, <1.000000, -1.410482, -0.564742>, <1.167313, -1.408892, -1.024535>, <0.000000, -1.408892, -1.024535>, 
      <1.000000, -1.554940, -0.006667>, <1.000000, -1.553036, -0.556664>, <1.167313, -1.551445, -1.016455>, <0.000000, -1.551445, -1.016455>, 
      <1.000000, -0.776671, -0.004862>, <1.000000, -0.951550, -0.554601>, <1.167313, -0.949960, -1.014392>, <0.000000, -0.952002, -1.013684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -1.529634, -0.008383>, <-0.001115, -1.529634, -0.008383>, <-0.002027, -1.529638, -0.007453>, <-0.002027, -1.529642, -0.006338>, 
      <0.000000, -1.408892, -1.024535>, <-1.167313, -1.408892, -1.024535>, <-1.000000, -1.410482, -0.564742>, <-1.000000, -1.412387, -0.014746>, 
      <0.000000, -1.551445, -1.016455>, <-1.167313, -1.551445, -1.016455>, <-1.000000, -1.553036, -0.556664>, <-1.000000, -1.554940, -0.006667>, 
      <0.000000, -0.952002, -1.013684>, <-1.167313, -0.949960, -1.014392>, <-1.000000, -0.951550, -0.554601>, <-1.000000, -0.776671, -0.004862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-1.000000, -0.776671, -0.004862>, <-1.000000, -0.601779, 0.544883>, <-0.550000, -0.598938, 1.006787>, <0.000000, -0.596879, 1.006055>, 
      <-1.000000, 0.001611, -0.003051>, <-1.000000, 0.353286, 0.546436>, <-0.550000, 0.360528, 1.020248>, <0.000000, 0.360528, 1.020248>, 
      <-1.186499, 0.148029, -0.000810>, <-1.372998, 0.146124, 0.549187>, <-0.550000, -0.451151, 1.743960>, <0.000000, -0.451151, 1.743960>, 
      <-1.093249, 0.279763, -0.001112>, <-1.186499, 0.277859, 0.549716>, <-0.550000, -0.021557, 1.372101>, <0.000000, -0.019539, 1.371273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.596879, 1.006055>, <0.550000, -0.598938, 1.006787>, <1.000000, -0.601779, 0.544883>, <1.000000, -0.776671, -0.004862>, 
      <0.000000, 0.360528, 1.020248>, <0.550000, 0.360528, 1.020248>, <1.000000, 0.353286, 0.546436>, <1.000000, 0.001611, -0.003051>, 
      <0.000000, -0.451151, 1.743960>, <0.550000, -0.451151, 1.743960>, <1.372998, 0.146124, 0.549187>, <1.186499, 0.148029, -0.000810>, 
      <0.000000, -0.019539, 1.371273>, <0.550000, -0.021557, 1.372101>, <1.186499, 0.277859, 0.549716>, <1.093249, 0.279763, -0.001112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <1.000000, -0.776671, -0.004862>, <1.000000, -0.951550, -0.554601>, <1.167313, -0.949960, -1.014392>, <0.000000, -0.952002, -1.013684>, 
      <1.000000, 0.001611, -0.003051>, <1.000000, -0.350064, -0.552538>, <1.167313, -0.348474, -1.012328>, <0.000000, -0.348474, -1.012328>, 
      <1.186499, 0.148029, -0.000810>, <1.000000, 0.149933, -0.550807>, <1.167313, 0.151523, -1.010596>, <0.000000, 0.151523, -1.010596>, 
      <1.093249, 0.279763, -0.001112>, <1.000000, 0.281669, -0.550278>, <1.167313, 0.283259, -1.010066>, <0.000000, 0.281219, -1.010899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.952002, -1.013684>, <-1.167313, -0.949960, -1.014392>, <-1.000000, -0.951550, -0.554601>, <-1.000000, -0.776671, -0.004862>, 
      <0.000000, -0.348474, -1.012328>, <-1.167313, -0.348474, -1.012328>, <-1.000000, -0.350064, -0.552538>, <-1.000000, 0.001611, -0.003051>, 
      <0.000000, 0.151523, -1.010596>, <-1.167313, 0.151523, -1.010596>, <-1.000000, 0.149933, -0.550807>, <-1.186499, 0.148029, -0.000810>, 
      <0.000000, 0.281219, -1.010899>, <-1.167313, 0.283259, -1.010066>, <-1.000000, 0.281669, -0.550278>, <-1.093249, 0.279763, -0.001112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-1.093249, 0.279763, -0.001112>, <-1.186499, 0.277859, 0.549716>, <-0.550000, -0.021557, 1.372101>, <0.000000, -0.019539, 1.371273>, 
      <-1.000000, 0.411500, 0.000248>, <-1.000000, 0.409595, 0.550245>, <-0.550000, 0.408037, 1.000242>, <0.000000, 0.408037, 1.000242>, 
      <-0.502589, 2.985504, 0.004998>, <-0.502589, 2.984815, 0.191042>, <-0.276424, 2.984251, 0.343259>, <0.000000, 2.984251, 0.343259>, 
      <-0.197771, 0.282483, 0.001197>, <-0.197771, 0.282107, 0.109970>, <-0.108774, 0.281798, 0.198966>, <0.000000, 0.281798, 0.198966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.019539, 1.371273>, <0.550000, -0.021557, 1.372101>, <1.186499, 0.277859, 0.549716>, <1.093249, 0.279763, -0.001112>, 
      <0.000000, 0.408037, 1.000242>, <0.550000, 0.408037, 1.000242>, <1.000000, 0.409595, 0.550245>, <1.000000, 0.411500, 0.000248>, 
      <0.000000, 2.984251, 0.343259>, <0.276424, 2.984251, 0.343259>, <0.502589, 2.984815, 0.191042>, <0.502589, 2.985504, 0.004998>, 
      <0.000000, 0.281798, 0.198966>, <0.108774, 0.281798, 0.198966>, <0.197771, 0.282107, 0.109970>, <0.197771, 0.282483, 0.001197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <1.093249, 0.279763, -0.001112>, <1.000000, 0.281669, -0.550278>, <1.167313, 0.283259, -1.010066>, <0.000000, 0.281219, -1.010899>, 
      <1.000000, 0.411500, 0.000248>, <1.000000, 0.413404, -0.549749>, <1.167313, 0.414994, -1.009535>, <0.000000, 0.414994, -1.009535>, 
      <0.502589, 2.985504, 0.004998>, <0.502589, 2.986193, -0.181045>, <0.276424, 2.986756, -0.333262>, <0.000000, 2.986756, -0.333262>, 
      <0.197771, 0.282483, 0.001197>, <0.197771, 0.282860, -0.107576>, <0.108774, 0.283168, -0.196573>, <0.000000, 0.283168, -0.196573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, 0.281219, -1.010899>, <-1.167313, 0.283259, -1.010066>, <-1.000000, 0.281669, -0.550278>, <-1.093249, 0.279763, -0.001112>, 
      <0.000000, 0.414994, -1.009535>, <-1.167313, 0.414994, -1.009535>, <-1.000000, 0.413404, -0.549749>, <-1.000000, 0.411500, 0.000248>, 
      <0.000000, 2.986756, -0.333262>, <-0.276424, 2.986756, -0.333262>, <-0.502589, 2.986193, -0.181045>, <-0.502589, 2.985504, 0.004998>, 
      <0.000000, 0.283168, -0.196573>, <-0.108774, 0.283168, -0.196573>, <-0.197771, 0.282860, -0.107576>, <-0.197771, 0.282483, 0.001197>
    }
  }
  rotate x*-90
}

#macro CarrierFangs (times, opening)
  #local counter = 0;
  #while (counter<times)
  object { Fang
    scale <3.333333, 6, 3.333333>
    rotate x*opening
    translate <0, 9, -28.4>
    rotate z*(360/times)*counter
  }
  #local counter = counter+1;
  #end
#end

#declare FighterBay = union {
  cylinder { <0, 0, -1.5>, <0, 0, 1.25>, 1
    open
    hollow
  }
  difference {
    union {
      difference {
        sphere { <0, 0, 2.25>, 1.414214
          hollow
        }
        cylinder { <0, 0, 0.8>, <0, 0, 1.5>, 0.999 }
      }
      box { <2, 1.0, 0>, <-2, 3.75, 5>
        hollow
      }
    }    
    cylinder { <0, 0, 2.25>, <0, 2, 2.25>, 0.999 }
  }
  texture { Organic }
}

#macro AlienCarrier (rotation, translation, fangs)
  union {
    object { AlienCarrierHull
      scale 20
    }
    AlienEngine (5, 5, 3.5,<0, 7.07068, 30.2>, 0.2)
    AlienEngine (5, 5, 3.5,<0, -7.07068, 30.2>, 0.2)
    AlienEngine (5, 5, 3.5,<7.07068, 0, 30.2>, 0.2)
    AlienEngine (5, 5, 3.5,<-7.07068, 0, 30.2>, 0.2)
    CarrierFangs (12, fangs)
    object { FighterBay }
    object { AlienTurret
      rotate x*-20
      scale 3
      translate <0, 18.6, -15>
    }
    object { AlienTurret
      rotate x*-20
      scale 2
      translate <-6, 18.4, -13>
    }
    object { AlienTurret
      rotate x*-20
      scale 2
      translate <6, 18.4, -13>
    }
    object { AlienTurret
      rotate y*180
      scale 3
      translate <0, 19.4, 15>
    }
    object { AlienTurret
      rotate y*180
      scale 2
      translate <-6, 19.2, 13>
    }
    object { AlienTurret
      rotate y*180
      scale 2
      translate <6, 19.2, 13>
    }
    object { AlienTurret
      rotate <0, 0, 180>
      scale 2
      translate <0, -20, -6>
    }
    object { AlienTurret
      rotate <0, 180, 180>
      scale 2
      translate <0, -20, 6>
    }
    object { AlienTurret
      rotate <0, 90, 180>
      scale 2
      translate <6, -20, 0>
    }
    object { AlienTurret
      rotate <0, -90, 180>
      scale 2
      translate <-6, -20, 0>
    }
    object { AlienTurret
      rotate z*-90
      rotate y*20
      scale 2
      translate <18.6, 3, -13>
    }
    object { AlienTurret
      rotate z*-90
      rotate y*20
      scale 2
      translate <18.6, -3, -13>
    }
    object { AlienTurret
      rotate z*90
      rotate y*-20
      scale 2
      translate <-18.6, 3, -13>
    }
    object { AlienTurret
      rotate z*90
      rotate y*-20
      scale 2
      translate <-18.6, -3, -13>
    }
    object { AlienTurret
      rotate <0, 180, -90>
      scale 2
      translate <20, 3, 13>
    }
    object { AlienTurret
      rotate <0, 180, -90>
      scale 2
      translate <20, -3, 13>
    }
    object { AlienTurret
      rotate <0, 180, 90>
      scale 2
      translate <-20, 3, 13>
    }
    object { AlienTurret
      rotate<0, 180, 90>
      scale 2
      translate <-20, -3, 13>
    }
    texture { Organic }
    rotate rotation
    translate translation
  }
#end
  
#declare AlienEscortHull = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.017307, -2.096249, -0.319369>, <0.017307, -2.096301, -0.296292>, <-0.017307, -2.096301, -0.296292>, <-0.017307, -2.096249, -0.319369>, 
      <-1.000000, -2.084221, 0.219058>, <-1.000000, -2.081222, -0.890712>, <1.000000, -2.081222, -0.890712>, <1.000000, -2.084221, 0.219059>, 
      <-1.000000, -6.147764, 0.214559>, <-1.000000, -6.144765, -0.895211>, <1.000000, -6.144765, -0.895211>, <1.000000, -6.147764, 0.214561>, 
      <-2.874801, -7.027995, 0.112392>, <-2.863513, -7.024996, -0.841059>, <2.871610, -7.028760, -0.841059>, <2.860322, -7.031759, 0.112394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.017307, -2.096249, -0.319369>, <-0.017307, -2.096198, -0.342445>, <0.017307, -2.096198, -0.342445>, <0.017307, -2.096249, -0.319369>, 
      <1.000000, -2.084221, 0.219059>, <1.000000, -2.087220, 1.328831>, <-1.000000, -2.087220, 1.328828>, <-1.000000, -2.084221, 0.219058>, 
      <1.000000, -6.147764, 0.214561>, <1.000000, -6.150763, 1.324333>, <-1.000000, -6.150763, 1.324330>, <-1.000000, -6.147764, 0.214559>, 
      <2.860322, -7.031759, 0.112394>, <2.849033, -7.034758, 1.065847>, <-2.886090, -7.030994, 1.065844>, <-2.874801, -7.027995, 0.112392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-2.874801, -7.027995, 0.112392>, <-2.863513, -7.024996, -0.841059>, <2.871610, -7.028760, -0.841059>, <2.860322, -7.031759, 0.112394>, 
      <-4.749602, -7.908227, 0.010225>, <-4.727026, -7.905228, -0.786908>, <4.743220, -7.912754, -0.786908>, <4.720643, -7.915753, 0.010227>, 
      <-3.996481, -12.000635, 0.005727>, <-3.973904, -11.997636, -0.791406>, <3.999919, -12.082684, -0.791406>, <3.977342, -12.085683, 0.005728>, 
      <-1.011288, -12.084196, 0.001228>, <-0.988712, -12.081197, -0.795905>, <1.011288, -12.081197, -0.795905>, <0.988712, -12.084196, 0.001230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <2.860322, -7.031759, 0.112394>, <2.849033, -7.034758, 1.065847>, <-2.886090, -7.030994, 1.065844>, <-2.874801, -7.027995, 0.112392>, 
      <4.720643, -7.915753, 0.010227>, <4.698066, -7.918752, 0.807361>, <-4.772179, -7.911226, 0.807358>, <-4.749602, -7.908227, 0.010225>, 
      <3.977342, -12.085683, 0.005728>, <3.954765, -12.088682, 0.802862>, <-4.019058, -12.003634, 0.802859>, <-3.996481, -12.000635, 0.005727>, 
      <0.988712, -12.084196, 0.001230>, <0.966135, -12.087195, 0.798364>, <-1.033865, -12.087195, 0.798361>, <-1.011288, -12.084196, 0.001228>
    }
  }
  translate  7.0*y
  rotate x*-90
}

#declare AlienEscort = union {
  object { AlienEscortHull
  scale 3
  }
  object { AlienTurret
    scale 1.5
    translate <4.5, 1.5, 4.5>
  }
  object { AlienTurret
    scale 1.5
    translate <-4.5, 1.5, 4.5>
  }
  object { AlienTurret
    scale 1.5
    rotate y*180
    translate <-3, 1.38, 10.5>
  }
  object { AlienTurret
    scale 1.5
    rotate y*180
    translate <3, 1.38, 10.5>
  }
  AlienEngine (3.0, 1.8, 3.0, <0, 0, 15>, 0.4)
}

#declare AlienFighterHull = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.747790, -4.523549, 0.015826>, <0.746187, -4.520350, 1.427399>, <2.770604, -4.520350, 1.299176>, <2.770604, -4.523549, -0.048287>, 
      <-4.027591, -2.556063, -0.039738>, <-4.027591, -2.554740, 1.959991>, <2.741528, -2.455842, 1.959991>, <2.741528, -2.457165, -0.039740>, 
      <2.999116, 6.994215, -0.011703>, <2.993462, 6.990692, -0.015325>, <2.741528, -0.542364, 1.450575>, <2.730322, -0.538004, -0.017324>, 
      <0.487796, 2.524135, -0.016142>, <0.482168, 2.514306, 0.242407>, <2.117007, 3.508441, 0.712681>, <2.114205, 3.507877, -0.021196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <2.770604, -4.523549, -0.048287>, <2.770604, -4.526749, -1.395750>, <0.749392, -4.526749, -1.395747>, <0.747790, -4.523549, 0.015826>, 
      <2.741528, -2.457165, -0.039740>, <2.741528, -2.458487, -2.039470>, <-4.027591, -2.557386, -2.039467>, <-4.027591, -2.556063, -0.039738>, 
      <2.730322, -0.538004, -0.017324>, <2.719117, -0.533644, -1.485222>, <3.004770, 6.997738, -0.008082>, <2.999116, 6.994215, -0.011703>, 
      <2.114205, 3.507877, -0.021196>, <2.111404, 3.507313, -0.755072>, <0.493424, 2.533964, -0.274692>, <0.487796, 2.524135, -0.016142>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.487796, 2.524135, -0.016142>, <0.482168, 2.514306, 0.242407>, <2.117007, 3.508441, 0.712681>, <2.114205, 3.507877, -0.021196>, 
      <-2.023524, -1.945945, -0.020581>, <-2.029127, -1.962080, 0.500140>, <1.492485, 7.559246, -0.025213>, <1.498088, 7.553758, -0.025067>, 
      <-1.501287, 7.543185, -0.033298>, <-1.497887, 7.548672, -0.033445>, <1.969239, -1.963530, 0.499852>, <1.974838, -1.945919, -0.021388>, 
      <-2.116565, 3.501068, -0.024349>, <-2.109470, 3.501330, 0.708625>, <-0.514583, 2.520090, 0.242520>, <-0.508995, 2.530657, -0.016502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <2.114205, 3.507877, -0.021196>, <2.111404, 3.507313, -0.755072>, <0.493424, 2.533964, -0.274692>, <0.487796, 2.524135, -0.016142>, 
      <1.498088, 7.553758, -0.025067>, <1.503691, 7.548270, -0.024921>, <-2.017921, -1.929811, -0.541301>, <-2.023524, -1.945945, -0.020581>, 
      <1.974838, -1.945919, -0.021388>, <1.980437, -1.928307, -0.542628>, <-1.504687, 7.537697, -0.033150>, <-1.501287, 7.543185, -0.033298>, 
      <-0.508995, 2.530657, -0.016502>, <-0.503406, 2.541224, -0.275523>, <-2.123660, 3.500807, -0.757323>, <-2.116565, 3.501068, -0.024349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-2.116565, 3.501068, -0.024349>, <-2.109470, 3.501330, 0.708625>, <-0.514583, 2.520090, 0.242520>, <-0.508995, 2.530657, -0.016502>, 
      <-2.731843, -0.541048, -0.015400>, <-2.721054, -0.546013, 1.450694>, <-2.998406, 7.003710, -0.014813>, <-2.992828, 7.007233, -0.011616>, 
      <-2.724815, -2.467441, -0.030036>, <-2.724812, -2.466118, 1.969693>, <3.945694, -2.467425, 1.969693>, <3.945690, -2.468747, -0.030038>, 
      <-2.752393, -4.512120, -0.050426>, <-2.752390, -4.500121, 1.292342>, <-0.734384, -4.501441, 1.420566>, <-0.732785, -4.513440, 0.013685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.508995, 2.530657, -0.016502>, <-0.503406, 2.541224, -0.275523>, <-2.123660, 3.500807, -0.757323>, <-2.116565, 3.501068, -0.024349>, 
      <-2.992828, 7.007233, -0.011616>, <-2.987250, 7.010756, -0.008418>, <-2.742633, -0.536083, -1.481495>, <-2.731843, -0.541048, -0.015400>, 
      <3.945690, -2.468747, -0.030038>, <3.945686, -2.470070, -2.029768>, <-2.724819, -2.468764, -2.029765>, <-2.724815, -2.467441, -0.030036>, 
      <-0.732785, -4.513440, 0.013685>, <-0.731186, -4.525440, -1.393197>, <-2.752397, -4.524119, -1.393194>, <-2.752393, -4.512120, -0.050426>
    }
  }
  rotate x*-90
}

#declare AFCockpit = sphere { <0, 0, 0>, 1
    texture {
      gradient z
      texture_map {
        [ 0.0 Organic ]
        [ 0.2 Organic ]
        [ 0.85 CPGlass ]
        [ 1.0 CPGlass ]
      }
    }
    translate <0, -.05, -2.75>
    scale <1.1, .26, 1.1>
}

#declare AlienFighter = union {
  object { AlienFighterHull
    no_shadow
  }
  object { AFCockpit }
  object { HAlienGun
    scale 0.75
    translate <1.5, -.05, -3.5>
  }
  object { HAlienGun
    scale 0.75
    translate <-1.5, -.05, -3.5>
  }
  object { VAlienGun
    translate <0, 0.85, -1.5>
  }
  object { VAlienGun
    rotate <180, 180, 0>
    translate <0, -0.95, -1.5>
  }
  AlienEngine (1,1,1,<1.7, -.05, 4.5>, 1)
  AlienEngine (1,1,1,<-1.7, -.05, 4.5>, 1)
}
