#include "colors.inc"
#include "metals.inc"
#include "golds.inc"                                                            
#include "txttree.inc"

//
// position finale : <0,0,0> RY=-90, Alpha*=60, Tilt=60



global_settings { 
max_trace_level 50
 }                                          
//=========================================
// Camera & light
//-----------------------------------------

#switch(clock)
#range(6,8)
#declare PdV=<0, 5.6 , 0>+<-sin((clock-6)*pi/2),0,-cos((clock-6)*pi/2)>;
#declare PdA=<-4*sin((clock-6)*pi/2),5.2,-4*cos((clock-6)*pi/2)>;
#declare foca=1.7;
#break
#range(3,6)
#declare PdV=<3, 10 , 13>;
#declare PdA=<0,4,0>;
#declare foca=1+(clock-3);
#break
#range(0,3)
#declare PdV=<3, 10 , 13>;
#declare PdA=<0,4,10*(3-clock)/3>;
#declare foca=1;
#break
#end



#debug concat("Clock : ",str(clock,1,2),"\n")
#debug concat("PdV : ",str(PdV.x,1,2)," , ",str(PdV.y,1,2)," , ",str(PdV.z,1,2),"\n")
#debug concat("PdA : ",str(PdA.x,1,2)," , ",str(PdA.y,1,2)," , ",str(PdA.z,1,2),"\n")

camera {location  PdV direction <0.0 , 0.0 , foca > up y  right 4*x/3 look_at   PdA}
//-----------------------------------------
light_source{PdV color White*0.5  shadowless}
light_source{<-2000,40000,-5000> color White*1.9}

sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.5  color CornflowerBlue ]
        [ 1.0  color MidnightBlue ]
      }
      scale 2
      translate -1
    }
}                       

#declare Sandstone = texture {
  pigment { agate frequency 10 pigment_map {
      [ 0 rgb <.6,.5,.4> ]
      [.1 rgb <.65,.6,.55> ]
      [.9 rgb <.65,.6,.55> ]
      [1  rgb <.7,.6,.5> ]
  }
  //scale <20,1,20>
  }
  normal { granite scale 10 }
}
 
difference {                    
plane{y,0 }
box { <-2,-0.5,-20000>,<2,1,20000> }
 texture { Sandstone} 
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <-1400,-5000,1500>
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <1400,-5000,1500>
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <-1400,-5000,-1500>
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <1400,-5000,-1500>
}

box { <-2,0,-20000>,<2,-0.5,20000>
 pigment{ Gray30}
}
 
#declare txtTree=texture{txtTree_6} // Bark texture                             
#declare txtLeaf=texture{txtLeaf_4} // Leaf texture                             
#declare Leaf    =object{#include "gtleaf.inc" }
#declare Treea   =object{#include "gttreea.inc" }
#declare Foliagea=object{#include "gtfoliagea.inc" texture{txtLeaf} }

#declare Treeb   =object{#include "gttreeb.inc" }
#declare Foliageb=object{#include "gtfoliageb.inc" texture{txtLeaf} }           

#declare Treec   =object{#include "gttreec.inc" }
#declare Foliagec=object{#include "gtfoliagec.inc" texture{txtLeaf} }           

#declare Treed   =object{#include "gttreed.inc" }
#declare Foliaged=object{#include "gtfoliaged.inc" texture{txtLeaf} }           

#declare Treem   =object{#include "gttreem.inc" }
#declare Foliagem=object{#include "gtfoliagem.inc" texture{txtLeaf} }           

#declare Trees   =object{#include "gttrees.inc" }
#declare Foliages=object{#include "gtfoliages.inc" texture{txtLeaf} }           


#declare rayo=9.0;

union {
  object{Treea}
  object{Foliagea}
  scale 1/10
  translate <rayo,0,0>
  // rotate <0,60,0>
}
union {
  object{Treeb}
  object{Foliageb}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,120,0>
}
union {
  object{Treec}
  object{Foliagec}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,-120,0>
}
union {
  object{Treed}
  object{Foliaged}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,60,0>
}
union {
  object{Treem}
  object{Foliagem}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,180,0>
}
union {
  object{Trees}
  object{Foliages}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,-60,0>
}
 
#declare murpig=
 pigment{ brick pigment{White},pigment{Red}
 brick_size <0.4,0.1,0.2>
 mortar 0.03
 }
#declare loop=-200;
#while (loop<200)
#declare murpos=<0,0,13>+loop*<0,0,1000>;
#declare loop=loop+1;
box { <-20000,0,0>,<-2,5,1>
 pigment{murpig}
 translate murpos
}
box { <2,0,0>,<20000,5,1>
 pigment{murpig}
 translate murpos
}

difference { 
cylinder { <0,0,0>,<0,0,1>,3 }
cylinder { <0,0,-1>,<0,0,2>,2 }
plane { y , 0 }
 pigment{murpig
 rotate <90,0,0>
 warp { cylinder <0,0,0>,<1,1,6.11> }
 rotate <90,0,0>
 }
translate <0,5,0>+murpos
}
#end

#declare T_Robot =
   texture { T_Gold_4D
   finish { ambient .1 diffuse .1 specular 1 roughness .01
   reflection .5 brilliance 4 metallic on }
 
}
 
#declare T_Chenille =
   texture { T_Chrome_4D
   finish { ambient .1 diffuse .1 specular 1 roughness .01
   reflection .5 brilliance 4 metallic on }
}                                                                               


#declare TX=0.0; // translation x
#declare TY=0.0; // translation y
#switch(clock)
#range(6,8)
#declare TZ=0; // translation z
#declare RY=90.0*(7-clock); //clock*180.0; // orientation chenilles
#declare ChenilleD=0;// phase de la chenille droite
#declare ChenilleG=0;// phase de la chenille gauche                      
#declare Tilt=60.0; // inclinaison du tronc  0-90/180
#declare AlphaG=60; // rotation gauche 0-360
#declare AlphaD=60; // rotation gauche 0-360
#break
#range(3,6)
#declare RY=90;
#declare TZ=0;
#declare ChenilleD=0;
#declare ChenilleG=0;
#declare Tilt=30.0+30*(clock-3)/3; // inclinaison du tronc  0-90/180
#declare AlphaD=60*(clock-3)/3; // rotation gauche 0-360
#declare AlphaG=60*(clock-3)/3; // rotation gauche 0-360

#break
#range(0,3)
#declare TZ=(3-clock)/3*13;
#declare RY=90;
#declare ChenilleD=-(3-clock)/3*13;
#declare ChenilleG=-(3-clock)/3*13;
#declare Tilt=30.0+30*sin(clock*pi*2/3); // inclinaison du tronc  0-90/180
#declare AlphaD=0; // rotation gauche 0-360
#declare AlphaG=0; // rotation gauche 0-360

#break
#end
 

#include "robot.inc"
