#include "colors.inc"
#include "metals.inc"
#include "golds.inc"                                                            


// deux scenes: clock 0-1 / 1-2
// ouverture 0: plongee sur les arbres avec le robot arrivant
// --> 1 : le robot est  mi-chemin de la porte, plan en pied du robot
// 1-->2 vue normal, prise derriere l'epaule du robot
// -->2 le robot est sous l'arche de la porte, plan en pied large
// 
//
// vitesse du robot : dans les 60 km/h <--> 16  17 metre/s
// duree prevue a 25 fps, 0->1 : 3s 1->2 : 3s ( 800 k pour cette phase )
//



global_settings { 
max_trace_level 50
 }                                          
//=========================================
// Camera & light
//-----------------------------------------


#declare PdV=<-400,0,-6000>;




#declare PdA=<-1100,0,0>;

camera {location  PdV direction <0.0 , 0.0 , 3 > up y  right 4*x/3 look_at   PdA}
//-----------------------------------------
light_source{PdV color White*0.5  shadowless}
light_source{<-200,0,-50000> color White*1.9}



sphere
  { 0,1000
    pigment
    { image_map { gif "Earth.gif" map_type 1 interpolate 2 } 
    }
    rotate <0,-150-clock*70,0>
    rotate <180,0,0>
    rotate <+23,0,0>
    
}

union{
cone { <0,90,0>,300,<0,150,0>,100 }
cone { <0,-90,0>,300,<0,-150,0>,100 }
#declare loop=0;
#while (loop<5)
sphere { <300,0,0>,95 rotate <0,loop*72,0> 
pigment { rgb <.4,.4+loop/50,.4+loop/50> } finish { specular .2 }
}
#declare loop=loop+1;
#end
torus{ 300,90 }
         pigment { rgb <.4,.4,.4> } finish { specular .2 }
      normal { granite 100 scale 150 }
      rotate <0,clock*270,0>
      rotate <10,0,0>
      translate <-1500,0,-100>
}


union{
cone { <0,90,0>,300,<0,150,0>,100 }
cone { <0,-90,0>,300,<0,-150,0>,100 }
#declare loop=0;
#while (loop<5)
sphere { <300,0,0>,95 rotate <0,loop*72,0> 
pigment { rgb <.4,.4+loop/50,.4+loop/50> } finish { specular .2 }
}
#declare loop=loop+1;
#end
torus{ 300,90 }
         pigment { rgb <.4,.4,.4> } finish { specular .2 }
      normal { granite 100 scale 150 }
      rotate <0,clock*270,0>
      rotate <10,0,0>
      translate <-1500,0,-100>
      rotate <0,-80,0>
}


