#include "colors.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"
#include "finish.inc"
#include "txttree.inc"

// deux scenes: clock 0-1 / 1-2
// ouverture 0: teleportation (arrive) des 6
// --> 1: fin de la teleportation
// 1-->2 : travelling/rotation vers la zone de commande (decouverte des autres)
// 
// 
//



global_settings { 
max_trace_level 50
 }                                          
//=========================================
// Camera & light
//-----------------------------------------

#switch(clock)
#range(1,2)
#declare PdV=<19, 8 , 20>*(1-(clock-1))+<19,4,10>*(clock-1);
#break
#range(0,1)
#declare PdV=<19, 8 , 20>;
#break
#end



#switch(clock)
#range(1,2)
#declare PdA=<0,4,0>*(1-(clock-1))+<00,4,25>*(clock-1);
#break
#range(0,1)
#declare PdA=<0,4,0>;
#break
#end

#debug concat("Clock : ",str(clock,1,2),"\n")
#debug concat("PdV : ",str(PdV.x,1,2)," , ",str(PdV.y,1,2)," , ",str(PdV.z,1,2),"\n")
#debug concat("PdA : ",str(PdA.x,1,2)," , ",str(PdA.y,1,2)," , ",str(PdA.z,1,2),"\n")

camera {location  PdV direction <0.0 , 0.0 , 1 > up y  right 4*x/3 look_at   PdA}
//-----------------------------------------
light_source{PdV color White*0.5  shadowless}
light_source{<0,15,0> color White shadowless // area_light 15*x,15*z,10,10
}
light_source{<0,15,20> color White shadowless // area_light 20*x,20*z,10,10
}

cylinder{ <0,-2.5,0>,<0,0,0>, 14 
texture {hexagon

texture {
    pigment { color rgbf<1.0, 0.2, 0.2, 0.5> }
    finish  { F_Glass2 }
},
texture {
    pigment { color rgbf<0.2, 0.2, 1.0, 0.5> }
    finish  { F_Glass2 }
},
texture {
    pigment { color rgbf<1.0, 1.0, 0.2, 0.5> }
    finish  { F_Glass2 }
} }
interior { ior 1.5 }
} 

cylinder{ <0,17,0>,<0,12,0>, 14 
texture {hexagon

texture {
    pigment { color rgbf<1.0, 0.2, 0.2, 0.5> }
    finish  { F_Glass2 }
},
texture {
    pigment { color rgbf<0.2, 0.2, 1.0, 0.5> }
    finish  { F_Glass2 }
},
texture {
    pigment { color rgbf<1.0, 1.0, 0.2, 0.5> }
    finish  { F_Glass2 }
}}

interior { ior 1.5 }
} 


box { <-20,-2,-20>,<20,16,30> inverse hollow
       texture {  pigment { rgb <.6,.6,.6> } finish { Dull } 
       }
}

torus { 8,0.8 rotate <0,0,90> translate <-20,-2,15> scale <1,1.5,1>
       texture {  pigment { rgb <.5,.5,.5> } finish { Glossy } 
       }
}


box { <-10,-4,20.4>,<10,1,21.5>
       texture {  pigment { rgb <.6,.6,.9> } finish { Dull } 
       }
}
 
#declare txtTree=texture{txtTree_6} // Bark texture                             
#declare txtLeaf=texture{txtLeaf_4} // Leaf texture                             
#declare Leaf    =object{#include "gtleaf.inc" }
#declare Treea   =object{#include "gttreea.inc" }
#declare Foliagea=object{#include "gtfoliagea.inc" texture{txtLeaf} }

#declare Treeb   =object{#include "gttreeb.inc" }
#declare Foliageb=object{#include "gtfoliageb.inc" texture{txtLeaf} }           

#declare Treec   =object{#include "gttreec.inc" }
#declare Foliagec=object{#include "gtfoliagec.inc" texture{txtLeaf} }           

#declare Treed   =object{#include "gttreed.inc" }
#declare Foliaged=object{#include "gtfoliaged.inc" texture{txtLeaf} }           

#declare Treem   =object{#include "gttreem.inc" }
#declare Foliagem=object{#include "gtfoliagem.inc" texture{txtLeaf} }           

#declare Trees   =object{#include "gttrees.inc" }
#declare Foliages=object{#include "gtfoliages.inc" texture{txtLeaf} }           


#declare rayo=9.0;

union {
  object{Treea}
  object{Foliagea}
  scale 1/10
  translate <rayo,0,0>
  // rotate <0,60,0>
}
union {
  object{Treeb}
  object{Foliageb}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,120,0>
}
union {
  object{Treec}
  object{Foliagec}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,-120,0>
}
union {
  object{Treed}
  object{Foliaged}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,60,0>
}
union {
  object{Treem}
  object{Foliagem}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,180,0>
}
union {
  object{Trees}
  object{Foliages}
  scale 1/10
  translate <rayo,0,0>
  rotate <0,-60,0>
}
#if (clock<1)
#declare teleText=texture{
spiral1 5
texture_map{
[0 pigment{ color Clear} ]
[(clock-int(clock)) pigment{ color Clear} ]
[(4*(clock-int(clock))+1)/5 pigment{ color White} finish{ ambient 1}]
[1 pigment{ color White} finish {ambient 1} ]
}
rotate <90,0,0>
}

#declare loo=1;
#while (loo<=6)
cylinder{ <0,0,0>, <0,10,0>, 4 texture { teleText } no_shadow 
translate <rayo,0,0>
rotate <0,60*loo,0>
 }                 
#declare loo=loo+1;
#end 
#end 

union {
  object{Treea}
  object{Foliagea}
  scale 1/10
  rotate <0,60,0>
  translate <0,-2,25>
}
union {
  object{Treeb}
  object{Foliageb}
  scale 1/10
  rotate <0,60,0>
  translate <-8,-2,25>
}
