   /******************************************
   * Include file                           *
  * by tek                                 *
 * defining macros & objects for a scene. *
******************************************/

#declare sub_image = true;

#ifndef ( __fire_inc )
	#include "fire.inc"
#end

#declare texture_render = false;
#declare lighting = true;

 /*************
 * Constants *
*************/

/*        ___  __
         /\  a  |
        /  \_   |
       /   / a  |
      /   /__   |
     /    \ _b  |
    /      | c  2
    \      |_   |
     \    /__b  |
      \   \  a  |
       \   \_   |
        \  / a  |
         \/__  __
   |     | |
      1   a

*/

#declare p2_a = 3;
#declare p2_b = 1;
#declare p2_c = 3;

#declare temp = 4*p2_a+2*p2_b+p2_c;

#declare p2_a = 2*p2_a/temp;
#declare p2_b = 2*p2_b/temp;
#declare p2_c = 2*p2_c/temp;

#declare wing_thick_angle = 10;

#declare p2_fin_height = 0.008;

 /************
 * Textures *
************/

#declare p2_top_texture =
	texture {
		pigment {
			image_map {
				gif "p2_tex.gif"
				once
			}
			rotate <90,0,0>
			translate <-0.5, 0, -0.5>
			scale <2.0, 1.0, 1.4>
			translate <0,0,-p2_a/2>
		}
		#if ( lighting )
			finish {
				diffuse 0.7
				ambient 0.3
				specular 1.0 roughness 0.01
			}
		#else
			finish {
				diffuse 0.0
				ambient 1.0
				specular 0.0
			}
		#end
	}
		

#declare p2_bottom_texture =
	texture {
		pigment { rgb <0.5,0.5,0.5> }
		#if ( lighting )
			finish {
				diffuse 0.7
				ambient 0.3
				specular 0.5 roughness 0.01
			}
		#else
			finish {
				diffuse 0.0
				ambient 1.0
				specular 0.0
			}
		#end
	}


#declare p2_glass =
	texture {
		pigment { rgb <0.05, 0.06, 0.15> }
		#if ( lighting )
			finish {
				ambient 0.5
				diffuse 0.5
				reflection 0.7
				specular 1.0 roughness 0.001
			}
		#else
			finish {
				diffuse 0.0
				ambient 1.0
				specular 0.0
			}
		#end
	}	                   	

#declare p2_red_glass =
	texture {
		pigment { rgbft <1,0,0,0.5,0.5> }
		finish {
			ambient 0.4
			diffuse 0.4
			specular 1.0 roughness 0.004
			reflection 0.2
		}
	}

#declare p2_blue_glass =
	texture {
		pigment { rgbft <0,0,1,0.5,0.5> }
		finish {
			ambient 0.4
			diffuse 0.4
			specular 1.0 roughness 0.004
			reflection 0.2
		}
	}

#declare p2_metal =
	texture {
		pigment { rgb 1 }
		finish {
			metallic
			ambient 0.1
			diffuse 0.2
			reflection 0.7
			specular 1.0 roughness 0.05
		}
	}


 /***********
 * Objects *
***********/

#declare p2_wing_half =
	intersection {
		plane {
			y, 0
			rotate <wing_thick_angle, 45, 0>
			translate <0,0,0.5>
		}
		plane {
			y, 0
			rotate <-wing_thick_angle, 45, 0>
			translate <-2*p2_a,0,0.5>
		}
		plane {
			y, 0
			rotate <wing_thick_angle, 135, 0>
			translate <1,0,-0.5>
		}
		plane {
			-x, 0
		}
	}

#declare p2_fuselage_top =
	intersection {
		plane {
			y, 0
			translate <0,p2_b,0>
		}
		plane {
			y, 0
			rotate <0,0,45>
			translate <-p2_c/2,p2_b,0>
		}
		plane {
			y, 0
			rotate <0,0,-45>
			translate <p2_c/2,p2_b,0>
		}
	}

#declare p2_fuselage_bottom =
	intersection {
		plane {
			-y, 0
			translate <0,-p2_b,0>
		}
		plane {
			-y, 0
			rotate <0,0,45>
			translate <p2_c/2,-p2_b,0>
		}
		plane {
			-y, 0
			rotate <0,0,-45>
			translate <-p2_c/2,-p2_b,0>
		}
		plane {
			-z, 0
			rotate <-45,0,0>
			translate <0,0,-0.5 - p2_b>
		}
		plane {
			-z, 0
			rotate <-35.2643896827546543153770003300188,45,0>
			translate <-p2_c/2,0,-0.5 - p2_b>
		}
		plane {
			-z, 0
			rotate <-35.2643896827546543153770003300188,-45,0>
			translate <p2_c/2,0,-0.5 - p2_b>
		}
		plane {
			-z, 0
			translate <0,0,-0.5 - p2_b>
		}
		plane {
			-z, 0
			rotate <0,45,0>
			translate <-p2_c/2,0,-0.5 - p2_b>
		}
		plane {
			-z, 0
			rotate <0,-45,0>
			translate <p2_c/2,0,-0.5 - p2_b>
		}

		scale <1,p2_a*tan(radians(wing_thick_angle))/(p2_b*sqrt(2)),1>
	}


#declare p2_cockpit = 
	intersection {
		plane { <0,0,1>, 1.9 rotate <0,-67.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
		plane { <0,0,1>, 1.9 rotate <0,-22.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
		plane { <0,0,1>, 1.9 rotate <0,22.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
		plane { <0,0,1>, 1.9 rotate <0,67.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }

		rotate <3,0,0>
		scale 1/10
		translate <0,0,0.1> //<0,0,1.8>
	}                 


#declare p2_light_base =
	union {
		box { <-p2_c*0.4, p2_b, -0.15>, <p2_c*0.4, p2_b+0.02, -0.05> }
		box { <-0.03, p2_b+0.02, -0.145>, <0.03, p2_b+0.05, -0.055> }
	}

#declare p2_light_pos = (<0.03, p2_b+0.02, -0.14> + <p2_c*0.4-0.005, p2_b+0.045, -0.06>)/2;

#declare p2_light =
	box { <0.03, p2_b+0.02, -0.14>, <p2_c*0.4-0.005, p2_b+0.045, -0.06> }


#declare p2_fin =
	polygon {
		4, <0,0,0.2>, <0,p2_fin_height,0.15>, <0,p2_fin_height,0>, <0,0,0>
		rotate <0,0,-45>
		translate <p2_c/2, p2_b, -0.5 - p2_b>
	}


#declare P2 =
	union {
		//body
		intersection {
			object {
				p2_cockpit
				texture { p2_glass }
			}
			object {
				p2_fuselage_top
				texture { p2_top_texture }
			}
			object {
				p2_fuselage_bottom
				texture { p2_bottom_texture }
			}
		}
		//right wing
		intersection {
			object {
				p2_wing_half
				texture { p2_top_texture }
			}
			object {
				p2_wing_half
				scale <1,-1,1>
				texture { p2_bottom_texture }
			}
		}
		//left wing
		intersection {
			object {
				p2_wing_half
				scale <-1,1,1>
				texture { p2_top_texture }
			}
			object {
				p2_wing_half
				scale <-1,-1,1>
				texture { p2_bottom_texture }
			}
		}
		//fin2
		object {
			p2_fin
		}
		object {
			p2_fin
			scale <-1,1,1>
		}
		//lights on top
		object {
			p2_light_base
			texture { p2_metal }
		}
		//right light
		object {
			p2_light
			texture { p2_red_glass }
		}
		#ifdef (right_light_on)
			light_source {
				p2_light_pos + <0,0.05,0>
				rgb <1,0,0>
				fade_distance 0.3 //dist to intensity of 1
				fade_power 2.0
				looks_like {
					sphere {
						<0,0,0>, 0.03
						texture {
							pigment { rgb 1 }
							finish { ambient 1 diffuse 0 }
						}
						scale <1,0.1,1>
						translate <0,-0.05,0>
					}
				}
			}
		#end
		//left light
		object {
			p2_light
			scale <-1,1,1>
			texture { p2_blue_glass }
		}
		#ifdef (left_light_on)
			light_source {
				p2_light_pos + <0,0.05,0>
				rgb <0,0,1>
				fade_distance 0.3
				fade_power 2.0
				looks_like {
					sphere {
						<0,0,0>, 0.03
						texture {
							pigment { rgb 1 }
							finish { ambient 1 diffuse 0 }
						}
						scale <1,0.1,1>
						translate <0,-0.05,0>
					}
				}
				scale <-1,1,1>
			}
		#end

		object {
			fire //yeah! yeah! fire!
			scale p2_b*<1,1,-3>
			translate < p2_c/2 + p2_b/2, p2_b/2, -0.5 - p2_b/2 >
		}
		object {
			fire
			scale p2_b*<1,1,-3>
			translate < -p2_c/2 - p2_b/2, p2_b/2, -0.5 - p2_b/2 >
		}

		translate <0,0,p2_a/2>
	}

/*
#declare P2 =
	triangle {
		<0,0,1>, <1,0,-1>, <-1,0,-1>
		pigment {
			rgb 0.1
		}
		finish {
			diffuse 0.7
			ambient 0.3
			specular 1.0 roughness 0.01
		}
	}
*/

#ifndef ( final_image )
	//do a test render
	
	#if ( texture_render )
		//position objects and camera to exactly align to the texture we map onto the ship
		camera {
			orthographic

			right x*2.0
			up z*(1.4)
			direction -y
			
			location <0,1000,0>
		}

		light_source {
			<1000,1000,1000>
			rgb 1
		}

		object {
			P2
		}

	#else
	
		#declare group_rotate = <20,-45,0>;
	
		camera {
			right x*5/4
			up z
			direction -y*2/4
			
			location <0.0,1.0,0.0>*2
			look_at <0,0,0>
			rotate group_rotate
		}
	
	
		#declare final_image = true;
	
		#include "environment.inc"
		
		object { lights }
		
		sky_sphere { skydome }
	/*
		#include "ground.inc"
	  
		object { ground }
	*/
		
		object { P2 translate <-1.1,0,-0.6> rotate group_rotate }
		object { P2 rotate <90,0,0> translate <-1.1,0,0.6> rotate group_rotate }
		object { P2 rotate <90,0,90> translate <1.1,0,0.6> rotate group_rotate }
		object { P2 rotate <120,0,225> translate <1.1,0.1,-0.6> rotate group_rotate }
		
	#end

#end
