/*do this:

define a bunch of buildings
create two arrays: tall_buildings[] and short_buildings[]
randomly pick an item out of the appropriate one for each grid square
	(items can be repeated to increase probability)
choose which array to use based on distance from the gold building:
	#if ( rand(brs) < dist/max_dist )
		tall_buildings[int(rand(rs)*num_tall_buildings)]
	#else
		short_buildings[int(rand(rs)*num_short_buildings)]
	#end

wide buildings:
can sit over adjacent buildings
must stretch part way into crack (short buildings must not)
can get away with a lot if only use for distant buildings*/
/*Note to me: bounding of intersections is vital. (unions unecessary)
VASTLY improves trace time (just did moebius!)*/

   /******************************************
   * Include file                           *
  * by tek                                 *
 * defining macros & objects for a scene. *
******************************************/


 /*************
 * Constants *
*************/

#declare block_x = 30;
#declare block_z = 40;
#declare the_gap = 10;
#declare half_x = (block_x - the_gap)/2;
#declare half_z = (block_z - the_gap)/2;

 /************
 * Textures *
************/

#declare null_texture =
	texture {
		pigment { rgbt 1.0 }
		finish { ambient 0 diffuse 0 reflection 0 specular 0 }
	}

#declare white_paint =
	texture {
		pigment { rgb 1 }
		finish {
			ambient 0.5
			diffuse 0.5
			specular 1.0 roughness 0.01
		}
	}

#declare black_paint =
	texture {
		pigment { rgb 0.1 }
		finish {
			ambient 0.3
			diffuse 0.7
			specular 0.75 roughness 0.01
		}
	}


#declare very_black =
	texture {
		pigment { rgb 0.0 }
		finish {
			ambient 0.0
			diffuse 0.0
		}
	}


#declare glass_layer2 =
	texture {
		pigment {
			rgbt <0.0,0.0,0.0,1.0>
		}
		finish {
			ambient 0.0
			diffuse 0.0
			specular 0.8 roughness 0.01
			reflection 0.3
		}
	}

#declare magenta_glass =
	texture {
		pigment {
			rgb <0.3,0.0,1.0>
		}
		finish {
			ambient 0.5
			diffuse 0.0
			metallic
			specular 4.0 roughness 0.2 //deliberately peak it out so the highlight turns magenta.
		}
	}

#declare blue_glass =
	texture {
		pigment {
			rgb <0.0,0.0,1.0>
		}
		finish {
			ambient 0.3
			diffuse 0.2
			specular 0.5 roughness 0.2
			metallic
		}
	}


#declare white_plastic =
	texture {
		pigment {
			rgb 1
		}
		finish {
			ambient 0.7
			diffuse 0.3
			specular 1.0 roughness 0.02
		}
	}
	
#declare black_plastic =
	texture {
		pigment {
			rgb 0.1
		}
		finish {
			ambient 0.3
			diffuse 0.7
			specular 1.0 roughness 0.004
		}
	}


#declare tinted_glass =
	texture {
		pigment { rgb <0.1,0.2,0.3> }
		finish {
			//metallic
			ambient 0.0
			diffuse 0.7
			reflection 0.3
			specular 1.2 roughness 0.01
		}
	}


#declare tinted_windows =
	texture {
		brick
		texture { black_plastic }, texture { tinted_glass }
		brick_size <2-0.2,1000,4-0.2>
		mortar 0.2
		translate <0.4,500,0>
		rotate <90,90,0>
	}

#declare clear_windows =
	texture {
		brick
		texture { white_plastic }, texture { null_texture }
		brick_size <4-0.2,1000,4-0.2>
		mortar 0.2
		translate <0.4,500,0>
		rotate <90,90,0>
	}



 /***********
 * Objects *
***********/

#declare slicey =
	intersection {
		plane { y, 0.1 }
		plane { -y, 0.1 }
	}

#declare slicez =
	intersection {
		plane { z, 0.1 }
		plane { -z, 0.1 }
	}


//blue buildings

#declare bb_shell =
	union {
		box { <half_x,0,-half_z>, <0,20,half_z> }
		box { <0,0,-half_z>, <-half_x+0.2,10,half_z> }
		box { <0,0,-half_z>, <-half_x/2,14.8,half_z> }
		cylinder { <-half_x/2,10,-half_z>, <-half_x/2,10,half_z>, 4.8 }
	}

#declare bb_glass =
	union {
		box { <0,0,-half_z+0.1>, <-half_x/2,19.9,half_z-0.1> }
		box { <0,0,-half_z+0.1>, <-half_x+0.1,15,half_z-0.1> }
		cylinder { <-half_x/2,15,-half_z+0.1>, <-half_x/2,15,half_z-0.1>, 4.9 }
	}

#declare bb_frames =
	intersection {
		union {
			box { <0,0,-half_z>, <-half_x/2,20,half_z> }
			box { <0,0,-half_z>, <-half_x,15,half_z> }
			cylinder { <-half_x/2,15,-half_z>, <-half_x/2,15,half_z>, 5 }
		}
		union {
			object { slicez translate <0,0,-12.5> }
			object { slicez translate <0,0,-7.5> }
			object { slicez translate <0,0,-2.5> }
			object { slicez translate <0,0,2.5> }
			object { slicez translate <0,0,7.5> }
			object { slicez translate <0,0,12.5> }
			object { slicey translate <0,0,0> }
			object { slicey translate <0,4,0> }
			object { slicey translate <0,8,0> }
			object { slicey translate <0,12,0> }
		}
	}

#declare blue_building_mid =
	union {
		object {
			bb_shell
			texture { white_plastic }
		}
		object {
			bb_glass
			texture { blue_glass }
			texture { glass_layer2 }
		}
		/*object {
			bb_frames
			texture { white_plastic }
		}*/
		object {
			bb_glass
			texture { clear_windows }
			scale <1.001,1.001,1.001>
		}
	}

#declare blue_building_tall =
	union {
		object {
			blue_building_mid
			translate <0,4,0>
		}
		intersection {
			object { blue_building_mid }
			plane { y, 4 texture { white_plastic } }
		}
	}

#declare blue_building_short =
	intersection {
		object {
			blue_building_mid
			translate <0,-4,0>
		}
		plane { -y, 0 texture { white_plastic } }
	}


#declare space_needle =
	union {
		//the top
		sphere {
			<0,0,0>, 1
			
			texture {
				gradient y
				texture_map {
					[0.45 white_plastic]
					[0.45 magenta_glass]
					[0.53 magenta_glass]
					[0.53 very_black]
					[0.55 very_black]
					[0.55 white_plastic]
				}
				translate <0,-0.5,0>
				scale 2
			}
			
			scale <30,10,30>
			translate <0,80,0>
		}
		//the base
		difference {
			cylinder { 0, y, 1 }
			torus { 1, 0.5 translate <0,0.5,0> }
			bounded_by {
				cylinder { -0.1*y, 1.1*y, 1.1 }
			}
			
			texture {
				pigment {
					rgb <0.6,0.6,0.6>
				}
				finish {
					diffuse 0.7
					ambient 0.3
				}			
			}
			
			scale <min(half_x,half_z),70,min(half_x,half_z)>
		}
	}

/*				image_map {
					tga "window.tga"
				}
				scale <2/sqrt(2),3,2/sqrt(2)>/2
				rotate y*45*/

	
#declare moebius_building =
	intersection {
		intersection {
			difference {
				plane { -x, half_x }
				cylinder{ <-2*block_x/3,40,-1000>, <-2*block_x/3,40,1000>, 15 }
			}
			plane{ x, half_x}
			plane{ y, 0 rotate <0,0,20> translate <-block_x/6,60,0> }
			plane{ y, 0 rotate <0,0,-20> translate <-block_x/6,60,0> }
			plane{ -y, 0 }

			texture { tinted_windows }
		}
		intersection {
			plane{ z, half_z }
			plane{ -z, half_z }

			texture { tinted_windows rotate <0,90,0> }
		}
		bounded_by {
			box { <-half_x-1,0,-half_z-1>, <half_x+1,61,half_z+1> }
		}
	}

#declare no_building =
	sphere {
		<0,-10,0>, 1
		texture { null_texture }
	}
	

//the arrays
#declare num_tall_buildings = 15; 
#declare num_short_buildings = 4; 

#declare tall_buildings = array[num_tall_buildings]
	{ space_needle, moebius_building, moebius_building,
		no_building, no_building, no_building,
		no_building, no_building, no_building,
		no_building, no_building, no_building,
		no_building, no_building, no_building,
	 } //repeat to weight probability
#declare short_buildings = array[num_short_buildings]
	{ blue_building_short, blue_building_mid, blue_building_tall, no_building }


 /***************
 * Test Render *
***************/

#ifndef ( sub_image )
	//do a test render
	#declare height = 60;
	
	camera {
		right x*4/3
		up y
		direction z*1.2
		
		location <-0.8,0.01,0.6>*(30+height/2)*1.3333
		look_at <0,height*1.3333/2,0>
	}

	#declare final_image = true;

	#include "environment.inc"
	
	object { lights }
	
	sky_sphere { skydome }

	union {
		plane {
			y, -0.01
		}
		height_field {
			png "hf.png"
			smooth
			translate <-0.5, 0, -0.5>
			rotate y*180
			scale <block_x*40*4, 300, block_z*40*4>
		}
		
		pigment {
			bozo
			turbulence 4.0
			colour_map {
				[0.3 rgb <0.6, 0.3, 0.2>*1.15 ]
				[0.7 rgb <0.6, 0.3, 0.2>*0.85 ]
			}
			scale 5
		}
		finish {
			diffuse 1.0
			ambient 0.0
			specular 0.2 roughness 0.1
		}
	}
	
	object {
//		short_buildings[1]
		tall_buildings[1]
	}
#end
	