     /******************************************
     * Rocket exhaust flame                   *
    * by Tek                                 *
   * defines a flame in a cylinder pointing *
  * along z with dimensions 1x1x1, centred *
 * on base of fire.                       *
******************************************/

#declare __fire_inc = true;

 /*************
 * Constants *
*************/

#declare cocentric_rings = 3;

 /************
 * Textures *
************/



 /***********
 * Objects *
***********/

#declare fire =
	cylinder {
		<0,0,0>, <0,0,1>, 0.5

    pigment { rgbf 1.0 }

    hollow on

    interior {
      media{
		    /*scattering {
		      5, rgb <1.0,1.0,1.0>
		      eccentricity -0.3
		      extinction 0.0
		    }*/
				emission 16.0
		    absorption 2.0

#ifdef ( high_quality_gases )
//high quality (slow)
		    intervals 10
		    samples 2, 8
		    confidence 0.9999
		    variance 1/1000
		    ratio 0.9
#else
//low quality (fast)
		    intervals 4
		    samples 1, 1
		    confidence 0.999
		    variance 1/1000
		    ratio 0.9
#end

		    density {
		    	gradient z
		    	poly_wave 0.5
		    	density_map {
		    		[0.0
		    			wood
		    			sine_wave
		    			//poly_wave 1.0
		    			scale 0.5
		    			phase -0.25
		    			scale 1/cocentric_rings
		    			density_map {
		    				[0.0 //rgb 0]
		    					cylindrical
		    					poly_wave 2
		    					rotate <90,0,0>
				    			scale cocentric_rings
		    					colour_map {
		    						[0.0 rgb 0.2*<0.0, 0.0, 0.2>] //dark (i.e. pale) blue
		    						[1.0 rgb 0.2*<2.0, 1.0, 0.5>] //bright orange
		    					}
		    				]
		    				[1.0 //rgb 1]
		    					cylindrical
		    					poly_wave 2
		    					rotate <90,0,0>
				    			scale cocentric_rings
		    					colour_map {
		    						[0.0 rgb <0.0, 0.0, 0.2>] //dark (i.e. pale) blue
		    						[1.0 rgb <2.0, 1.0, 0.5>] //bright orange
		    					}
		    				]
		    			}
		    		]
		    		[1.0 rgb 0]
		    	}
		   	}

/*
		    density {
	      	bozo
          colour_map {
            [0.4 rgb 0]
            [0.6 rgb 4/_treescale] //rgb greater than 1, because I want a more "solid" density
          }
          scale 0.03
		    }*/
      }
    }
	}




#ifndef ( sub_image )
	//do a test render
	
	#declare group_rotate = <50,-45,0>;
	
	#declare cam_dist = 1;//10;

	camera {
		right x*4/3
		up z
		direction -y*cam_dist/4 //hey, if you varied cam_dist with time you'd get the Jaws zoom effect. cool. but cheesy.
		
		location <0.0,1.0,0.0>*cam_dist
		look_at <0,0,0>
		rotate group_rotate
	}


	#declare final_image = true;

	#include "environment.inc"
	
	object { lights }
	
	sky_sphere { skydome }
/*
	#include "ground.inc"
  
	object { ground }
*/
	
	object { fire translate <0,0,-0.5> scale -0.4*<1,1,3> translate <-1.1,0,-0.6> rotate group_rotate }
	object { fire translate <0,0,-0.5> scale -0.4*<1,1,3> rotate <90,0,0> translate <-1.1,0,0.6> rotate group_rotate }
	object { fire translate <0,0,-0.5> scale -0.4*<1,1,3> rotate <90,0,90> translate <1.1,0,0.6> rotate group_rotate }
	object { fire translate <0,0,-0.5> scale 0.4*<1,1,3> rotate <120,0,225> translate <1.1,0.1,-0.6> rotate group_rotate }

#end
