   /******************************************
   * Include file                           *
  * by tek                                 *
 * defining macros & objects for a scene. *
******************************************/

#declare sub_image = true;

#include "road segments"
#include "buildings"


 /*************
 * Constants *
*************/


#declare blocks_x = 40;
#declare blocks_z = 40;
#declare block_x = 30;
#declare block_z = 40;

#declare grs = seed(141);


 /************
 * Textures *
************/



 /***********
 * Objects *
***********/

/*
Road map:                                                                   
  +---> z
	| [][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
 \|/[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
x ' [][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][]                              
		[][][][][][]  [][][][][][][][][]  [][][][][][][][]  [][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][]  [][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][]  [][][][][][][][][][][][][][]
		[][][][][][]  [][][][][][][][][]  [][][][][][][][]  [][][][][][][][][][][][][][]
		[][][][][][]  [][][][][]                                                        
		[][][][][][]  [][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][]  [][][][][]  [][][][][][]    []  [][][][][][][][][][][][][][][][][]
		[][][][][][]              [][][][][][]|][|[]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][]    []  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]  [][][][][][][][][]  [][][][][][][][][][][][][][][][][]
		[][][][][][][][][][][][]                                    [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
		[][][][][][][][][][][][][][][][][]  [][][][][][][][][][][]  [][][][][][][][][][]
offset by half 1 block in z and x
*/

#declare roads =
	union {
		object { road_corner scale<-1,1,-1> translate <block_x*(-3),0,block_z*(-7)> }

		#declare loop = -6;
		#while ( loop <= -4 )
			object { road_straight_z translate <block_x*(-3),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_junction_x translate <block_x*(-3),0,block_z*(-3)> }

		#declare loop = -2;
		#while ( loop <= 2 )
			object { road_straight_z translate <block_x*(-3),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_junction_x scale<-1,1,-1> translate <block_x*(-3),0,block_z*(3)> }

		#declare loop = 4;
		#while ( loop <= 5 )
			object { road_straight_z translate <block_x*(-3),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_junction_x translate <block_x*(-3),0,block_z*(6)> }

		#declare loop = 7;
		#while ( loop <= 20 )
			object { road_straight_z translate <block_x*(-3),0,block_z*loop> }
			#declare loop = loop + 1;
		#end


		#declare loop = -7;
		#while ( loop <= -4 )
			object { road_straight_x translate <block_x*loop,0,block_z*(6)> }
			#declare loop = loop + 1;
		#end

		object { road_corner scale <-1,1,-1> translate <block_x*(-8),0,block_z*(6)> }

		#declare loop = 7;
		#while ( loop <= 20 )
			object { road_straight_z translate <block_x*(-8),0,block_z*loop> }
			#declare loop = loop + 1;
		#end


		#declare loop = -2;
		#while ( loop <= -1 )
			object { road_straight_x translate <block_x*loop,0,block_z*(-7)> }
			#declare loop = loop + 1;
		#end

		object { road_junction_z translate <block_x*(0),0,block_z*(-7)> }

		#declare loop = 1;
		#while ( loop <= 12 )
			object { road_straight_x translate <block_x*loop,0,block_z*(-7)> }
			#declare loop = loop + 1;
		#end

		object { road_corner scale <1,1,-1> translate <block_x*(13),0,block_z*(-7)> }


		#declare loop = -12;
		#while ( loop <= -8 )
			object { road_straight_z translate <block_x*(0),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_corner scale<1,1,-1> translate <block_x*(0),0,block_z*(-13)> }

		#declare loop = -20;
		#while ( loop <= -1 )
			object { road_straight_x translate <block_x*loop,0,block_z*(-13)> }
			#declare loop = loop + 1;
		#end


		#declare loop = -6;
		#while ( loop <= -3 )
			object { road_straight_z translate <block_x*(13),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_junction_x scale <-1,1,-1> translate <block_x*(13),0,block_z*(-2)> }

		#declare loop = -1;
		#while ( loop <= 2 )
			object { road_straight_z translate <block_x*(13),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_junction_x translate <block_x*(13),0,block_z*(3)> }

		#declare loop = 4;
		#while ( loop <= 9 )
			object { road_straight_z translate <block_x*(13),0,block_z*loop> }
			#declare loop = loop + 1;
		#end

		object { road_corner scale <-1,1,1> translate <block_x*(13),0,block_z*(10)> }


		#declare loop = -2;
		#while ( loop <= 12 )
			object { road_straight_x translate <block_x*loop,0,block_z*(3)> }
			#declare loop = loop + 1;
		#end


		#declare loop = -20;
		#while ( loop <= -4 )
			object { road_straight_x translate <block_x*loop,0,block_z*(-3)> }
			#declare loop = loop + 1;
		#end


		#declare loop = 14;
		#while ( loop <= 20 )
			object { road_straight_x translate <block_x*loop,0,block_z*(-2)> }
			#declare loop = loop + 1;
		#end


		#declare loop = 14;
		#while ( loop <= 20 )
			object { road_straight_x translate <block_x*loop,0,block_z*(10)> }
			#declare loop = loop + 1;
		#end


		translate <block_x*(1/2/*-3*/),45,0>
	}


#declare ground =
	union {
		#declare gz = -blocks_z/2;
		#while ( gz < blocks_z/2 )

			#declare gx = -blocks_x/2;
			#while ( gx < blocks_x/2 )
			
				#if ( gx > 1 | gz > 0 | gx < -1 | gz < -1 )
					object {
						#if ( rand(grs) > (gx*gx+gz*gz)/(blocks_x*blocks_x+blocks_z*blocks_z) )
							short_buildings[int(rand(grs)*num_short_buildings)]
						#else
							tall_buildings[int(rand(grs)*num_tall_buildings)]
						#end

						#if ( rand(grs) < 0.5 )
							scale <-1,1,1>
						#end						
						#if ( rand(grs) < 0.5 )
							scale <1,1,-1>
						#end						
						translate <gx*block_x,0,gz*block_z> + <0,0,block_z/2>
					}
				#end
			
				#declare gx = gx + 1;
			#end

			#declare gz = gz + 1;
		#end

		object { roads }
		
		union {
			plane {
				y, -0.01
			}
			height_field {
				png "hf.png"
				smooth
				translate <-0.5, 0, -0.5>
				rotate y*180
				scale <blocks_x*30*4, 300, blocks_z*40*4>
			}
			
			pigment {
				bozo
				turbulence 4.0
				colour_map {
					[0.3 rgb <0.6, 0.3, 0.2>*1.15 ]
					[0.7 rgb <0.6, 0.3, 0.2>*0.85 ]
				}
				scale 5
			}
			finish {
				diffuse 1.0
				ambient 0.0
//				diffuse 0.8
//				ambient 0.2
				specular 0.2 roughness 0.1
			}
		}
		
		scale 1/4 		
		translate <42,-15/4,51>
	}

/*
#declare ground =
	plane {
		y, 0
		pigment {
			checker
			rgb 0.6, rgb 0.4
			translate <0,0.5,0>
			scale 2
		}
		finish {
			diffuse 0.7
			ambient 0.3
			specular 1.0 roughness 0.01
		}
	}
*/


#ifndef ( final_image )
	//do a test render
	camera {
/*		right -z*4/3
		up x
		direction -y*2 //16//1.6
		
		location <42,0,51>+<0.0,1.0,0.0>*1000
		look_at <42,0,51>*/

		right x*4/3
		up y
		direction z*0.5

		location <42,0,51>+<-1.0,0.05,0.3>*60
		look_at <42,0,51>
	}

	#declare final_image = true;

	#include "environment.inc"
	
	object { lights }
	
	sky_sphere { skydome }

	#include "canyon.inc"

	object { canyon }
  
  
	object { ground }
#end

