#declare clockl = clock;
//#declare clockl = (75/125)*5;
/*
SCENE 1 - FIRST CHASE SHOT.

P1 flying innocently along, sinister P2 slides into shot.
*/


 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.02
  max_trace_level 80
}
//random seed
#declare rs = seed(132);//116,124,132 //seed(113);

#declare final_image = true; //for include files to turn off test render stuff

//#declare high_quality_gases = true; //set detail of gaseous fx.

#if ( mod( clockl*2, 2 ) < 1 )
	#declare left_light_on = true;
#else
	#declare right_light_on = true;
#end

 /************
 * Includes *
************/

#include "P1.inc"
#include "P2.inc"
#include "ground.inc"
#include "canyon.inc"
#include "environment.inc"

 /******************
 * scene switches *
******************/


//camera type
#declare CAM_FINAL = 0;

#declare camera_type = CAM_FINAL;


 /********************
 * object positions *
********************/

#declare P1_vel = <0,0,5>;
#declare P1_start_pos = <9,2.8,0> - P1_vel*1;
#declare P2_vel = <0,0,5.25>;
#declare P2_start_pos = <9-0.9,7.3,-1.5> - P1_vel*1;

#declare P1_pos = clockl*P1_vel + P1_start_pos;
#declare P1_rot = <0,0,0>;
#declare P2_pos = clockl*P2_vel + P2_start_pos;
#declare P2_rot = <0,0,0>;

//camera position and orientation
#declare cam_loc = P1_pos+<-1,6,-0.2>;
#declare lookat = P1_pos+<-1,0,0>;
//#declare cam_angle = 90;
#declare sky_vect = y;

#declare rock = 5*sin(clockl*pi/3)+5*sin(clockl*pi/5);
#declare bob = <0.7*sin(clockl*pi/4.3), 0.2*sin((clockl+0.3)*pi/6), 1*sin((clockl+0.5)*pi/7)+0.25*sin((clockl+0.7)*pi/3)>;
#declare P1_pos = P1_pos + bob/3;
#declare P1_rot = P1_rot + <0,0,rock>;



 /********************************************************************************************************************
 * CAMERA *
**********/


camera {         
	right x*4/3
	up y
	direction z*1.5 //I prefer this to the "angle" command, it gives me more control.
             
  #switch (camera_type)
  
	  #case (CAM_FINAL)
			location cam_loc-7*x
			look_at lookat-7*x
			rotate <0,0,-4>
			translate 7*x
		#break
		
	#end //switch(camera_type)
}

          
 /********************************************************************************************************************
 * LIGHTS AND ATMOSPHERE *
*************************/

object { lights }

#declare flare_type = "35mm"
#declare flare_size = 4;//1.8;
#declare flare_brightness = 0.2;
#include "nkflare.inc"


sky_sphere { skydome }


 /*****************************************************************************************************************
 * SCENERY *
***********/

union {
	object { ground }
	object { canyon }
}


 /*****************************************************************************************************************
 * FLYING THINGS *
*****************/

object {
	P1
	rotate P1_rot
	translate P1_pos
}

object {
	P2
	rotate P2_rot
	translate P2_pos
}




