#declare clockl = clock;
//#declare clockl = (17/225)*9;
/*
SCENE 3

P1 does the old canyon gag and P2 is forced to abort the chase.
*/


 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.02
  max_trace_level 10
}
//random seed
#declare rs = seed(132);//116,124,132 //seed(113);

#declare final_image = true; //for include files to turn off test render stuff

//#declare high_quality_gases = true; //set detail of gaseous fx.

#if ( mod( clockl*2, 2 ) < 1 )
	#declare left_light_on = true;
#else
	#declare right_light_on = true;
#end


 /************
 * Includes *
************/

#include "blend.inc"
#include "P1.inc"
#include "P2.inc"
#include "ground.inc"
#include "canyon.inc"
#include "environment.inc"

 /******************
 * scene switches *
******************/


//camera type
#declare CAM_FINAL = 0;

#declare camera_type = CAM_FINAL;


 /********************
 * object positions *
********************/

#declare P1_xspeed = 5;
#declare P1_start_pos = <5,10.5,60>;

//#declare P1_pos = clockl*P1_vel + P1_start_pos;
#declare xpos = P1_start_pos.x + clockl*P1_xspeed;

//we interpolate between 3 curves
#declare ypos1 = P1_start_pos.y;
#declare ypos2 = P1_start_pos.y + 1 - 10*pow((xpos-22)/(40-22),2);
#declare ypos3 = P1_start_pos.y + 0 - 10;

blendf( ypos1, ypos2, xpos, 18, 20 )
blendf( blendedf, ypos3, xpos, 42, 48 )
#declare P1_pos = <xpos, blendedf, P1_start_pos.z>;
#declare P1_pos = P1_pos + <12,0,-9>;

blendf( 0, 70, xpos, 18, 20 )
blendf( blendedf, 0, xpos, 40, 41 )
#declare P1_rot = <0, 90, blendedf>;

blendf( 0, -10, xpos, 16, 18 )
blendf( blendedf, 60, xpos, 20, 42 )
blendf( blendedf, -10, xpos, 41, 43 )
blendf( blendedf, 0, xpos, 45, 47 )
#declare P1_rot = <blendedf, P1_rot.y, P1_rot.z>;


#declare P2_vel = <5.5,0,0>;
#declare P2_start_pos = <2.75,11.5,60>;

#declare P2_pos = clockl*P2_vel + P2_start_pos;
#declare P2_rot = <0,90,0>;
//P2 pulls up just before canyon
#if (P2_pos.x > 15)
	#declare q = (P2_pos.x-15)/4;
	#declare P2_pos = P2_pos + <0,2*pow(q,2),0.3*pow(q,2)>;
	#declare P2_rot = P2_rot + <-q*60,0,-q*20>;
#end
#declare P2_pos = P2_pos + <12,0,-9>;

//camera position and orientation
#declare cam_loc1 = P1_pos+<-2,0.5,0>;
#declare cam_loc2 = <xpos-2, P1_start_pos.y + (1.5 - 10*pow((xpos-24)/(40-22),2)), P1_start_pos.z> + <12,0,-9>;
#declare cam_loc3 = P1_pos+<-2,0.5,0>;

blend( cam_loc1, cam_loc2, xpos, 20, 22 )
blend( blended, cam_loc3, xpos, 40, 44 )
#declare cam_loc = blended;

#declare lookat = P1_pos+<0,0.5-0.5*(clockl/9),0>;
//#declare cam_angle = 90;
#declare sky_vect = y;




 /********************************************************************************************************************
 * CAMERA *
**********/


camera {         
	right x*4/3
	up y
	direction z*3/4 //I prefer this to the "angle" command, it gives me more control.
             
  #switch (camera_type)
  
	  #case (CAM_FINAL)
			location cam_loc
			look_at lookat
		#break
		
	#end //switch(camera_type)
}

          
 /********************************************************************************************************************
 * LIGHTS AND ATMOSPHERE *
*************************/

object { lights }

#declare flare_type = "35mm"
#declare flare_size = 4;//1.8;
#declare flare_brightness = 0.2;
#include "nkflare.inc"


sky_sphere { skydome }


/*
#if ( (xpos > 20) & (xpos < 40) )
	//cunning gold lights when in canyon.
	light_source {
		P1_pos+100*z
		rgb <1.00,0.75,0.25>*0.4
		spotlight
		point_at P1_pos
		radius 0.3
		falloff 0.6
		shadowless
	}
	
	light_source {
		P1_pos-100*z
		rgb <1.00,0.75,0.25>*0.4
		spotlight
		point_at P1_pos
		radius 0.3
		falloff 0.6
		shadowless
	}
#end
*/

 /*****************************************************************************************************************
 * SCENERY *
***********/

union {
	object { ground }
	object { canyon }
}


 /*****************************************************************************************************************
 * FLYING THINGS *
*****************/

object {
	P1
	rotate P1_rot.z*z
	rotate P1_rot.x*x
	rotate P1_rot.y*y
	translate P1_pos
}

object {
	P2
	rotate P2_rot
	translate P2_pos
}




