#declare clockl = clock;
//#declare clockl = (20/100)*4;
/*
SCENE 4

P2 gets into trouble when pulling up away from the canyon.
*/

 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.02
  max_trace_level 10
}
//random seed
#declare rs = seed(132);//116,124,132 //seed(113);

#declare final_image = true; //for include files to turn off test render stuff

//#declare high_quality_gases = true; //set detail of gaseous fx.

#if ( mod( clockl*2, 2 ) < 1 )
	#declare left_light_on = true;
#else
	#declare right_light_on = true;
#end

 /************
 * Includes *
************/

#include "blend.inc"
//#include "P1.inc"
#include "P2.inc"
#include "ground.inc"
#include "canyon.inc"
#include "environment.inc"

 /******************
 * scene switches *
******************/


//camera type
#declare CAM_FINAL = 0;

#declare camera_type = CAM_FINAL;


 /********************
 * object positions *
********************/

#declare P2_start_pos = <31.75,12,51.3>;

#declare P2_vel1 = <0.4,3,0.25>;
#declare P2_pos1 = clockl*P2_vel1 + P2_start_pos;
#declare P2_rot1 = <-85,80,0>;

#declare P2_vel2 = <-0.25,3,0.25>;
#declare P2_pos2 = clockl*P2_vel2 + P2_start_pos + 0.75*P2_vel1 - 0.75*P2_vel2;
#declare P2_rot2 = <-95,85,0>;

#declare P2_vel3 = <-0.6,-3,0.25>;
#declare P2_pos3 = clockl*P2_vel3 + P2_start_pos + 0.75*P2_vel1 + 0.75*P2_vel2 - P2_vel3*2.0;
//#declare P2_pos3 = clockl*P2_vel3 + P2_start_pos + 2.0*P2_vel1 - P2_vel3*2.0;
#declare P2_rot3 = <-95,90,180>;

blend( P2_pos1, P2_pos2, clockl, 0.0, 1.5 )
blend( blended, P2_pos3, clockl, 0.0, 3.0 )
#declare P2_pos = blended;

blend( P2_rot1, P2_rot2, clockl, 0.0, 1.5 )
blend( blended, P2_rot3, clockl, 2.0, 3.5 )
#declare P2_rot = blended;


//camera position and orientation
#declare cam_loc = <31.25,11.5,48>;

#declare lookat = <32, P2_pos.y, 51>;
//#declare cam_angle = 90;
#declare sky_vect = y;




 /********************************************************************************************************************
 * CAMERA *
**********/


camera {         
	right x*4/3
	up y
	direction z*2 //I prefer this to the "angle" command, it gives me more control.
             
  #switch (camera_type)
  
	  #case (CAM_FINAL)
			location cam_loc
			look_at lookat
		#break
		
	#end //switch(camera_type)
}

          
 /********************************************************************************************************************
 * LIGHTS AND ATMOSPHERE *
*************************/

object { lights }

#declare flare_type = "35mm"
#declare flare_size = 4;//1.8;
#declare flare_brightness = 0.2;
#include "nkflare.inc"


sky_sphere { skydome }


/*
#if ( (xpos > 20) & (xpos < 40) )
	//cunning gold lights when in canyon.
	light_source {
		P1_pos+100*z
		rgb <1.00,0.75,0.25>*0.4
		spotlight
		point_at P1_pos
		radius 0.3
		falloff 0.6
		shadowless
	}
	
	light_source {
		P1_pos-100*z
		rgb <1.00,0.75,0.25>*0.4
		spotlight
		point_at P1_pos
		radius 0.3
		falloff 0.6
		shadowless
	}
#end
*/

 /*****************************************************************************************************************
 * SCENERY *
***********/

object { ground }

object { canyon }


 /*****************************************************************************************************************
 * FLYING THINGS *
*****************/

/*object {
	P1
	rotate P1_rot.z*z
	rotate P1_rot.x*x
	rotate P1_rot.y*y
	translate P1_pos
}*/

object {
	P2
	rotate P2_rot.x*x
	rotate P2_rot.y*y
	rotate P2_rot.z*x //apply the z value about x, to get the stall effect
	translate P2_pos
}




