// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]

#version 3.1 ;

#include "colors.inc"

global_settings
{
  assumed_gamma 2.0
}

// ----------------------------------------
/*
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue .6 [1.0 color rgb 1] }
  }
}
*/

// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

//sphere { 0, 0.99 texture {pigment {rgbt<0,0,0,0>}}}

#declare earth_moon = union {

/*
sphere { 0, 4000  //earth
	texture {
//		pigment{ image_map{tga "/home/matt/images/earth7b.tga" map_type 1} 
		pigment{ image_map{tga
"/home/matt/images/earth-seethrough2b.tga" map_type 1} 
			} 
		finish { diffuse 1.5 brilliance 1 ambient 0}
		} 
	rotate 0*x rotate -110*y rotate -clock*100*y*360/64
}// earth

sphere { 0, 3999.99  //ocean
	texture {
		pigment{ image_map{tga "/home/matt/images/ocean2.tga" map_type 1} 
			} 
		finish { diffuse 1. brilliance 1 ambient 0}
		} 
	rotate 0*x rotate 90*y rotate-clock*100*y*360/64 //70
}// ocean


sphere { 0, 4002  //clouds
	texture {
		pigment{ image_map{png "/home/matt/images/clouds1a.png" map_type 1} 
			} 
		finish { diffuse 1. brilliance 1 ambient 0}
		} 
	rotate 0*x rotate -clock*100*y*360/64 //70
}// clouds
*/

sphere { 0, 4000  //earth night image
	texture {
		pigment{ image_map{tga
//	"/home/matt/images/earth-comp.tga" map_type 1} 
//"/home/matt/images/bluemars.tga" map_type 1}
//"/home/matt/images/earth-nighta.tga" map_type 1}
"/home/matt/images/volcano-planet.tga" map_type 1}

			} 
		finish { diffuse 1.5 brilliance 1 ambient 0}
		} 
//	rotate 0*x rotate -110*y rotate -clock*100*y*360/64
//	rotate 0*x rotate (180-110)*y rotate -clock*100*y*360/64
rotate -270*y rotate -clock*100*y*360/64
}// earth

/*
sphere { 0, 4000  //earth day image
	texture {
		pigment{ image_map{tga
"/home/matt/images/earth-comp.tga" map_type 1} 
//"/home/matt/images/bluemars.tga" map_type 1}
//"/home/matt/images/earth-night.tga" map_type 1}

			} 
		finish { diffuse 1.5 brilliance 1 ambient 0}
		} 
//	rotate 0*x rotate -110*y rotate -clock*100*y*360/64
//	rotate 0*x rotate (180-110)*y rotate -clock*100*y*360/64
rotate -150*y rotate -270*y rotate -clock*100*y*360/64

translate <-0.00001,0,0>
//translate <0,0,0.000001> // translation

}// earth
*/

sphere { 0, 1000 //moon
	texture {
		pigment{ image_map{png "/home/matt/images/moon5a-orig.png" map_type 1} 
}///home/matt/images/moonmap.tga			} 
		finish { diffuse 1. brilliance 1 ambient 0}
		} 
	rotate 0*x rotate 35*y rotate -(y*360*(clock*100/64))/28.25
	translate <0,0,-24000> rotate -(y*360*(clock*100/64))/28.25 
}// moon

light_source // sun
{
  0*x color <1,1,1>// /2  
//  translate <92000000, 100, 00000>
translate <0,100,92000000>
}
sphere {0*x, 400000 texture{pigment{color rgbf<1,1,1,1>}
		    finish {phong 5 phong_size 7}}  
                    hollow interior {ior .9}			
translate <000000,100,92000000>
}


sphere {0*x, 200000000 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/images/starsa1c.tga"
			map_type 1}}
		}
	finish {ambient 1 reflection 0}
	hollow
}//stars 


/*
#declare sfield = union {
sphere {0*x, 200000000 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/povray/PE/earth/starsa1b.tga"
			map_type 1}}
		}
	finish {ambient 1 reflection 0}
}//stars 

sphere {0*x, 200000001 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/povray/PE/earth/starsa1b.tga"
			map_type 1}}
		} rotate 90*y
	finish {ambient 1 reflection 0}
}//stars 

sphere {0*x, 200000002 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/povray/PE/earth/starsa1b.tga"
			map_type 1}}
		} rotate 135*y
	finish {ambient 1 reflection 0}
}//stars 
}

object {sfield}
//object {sfield rotate 180*x scale 1.00001}
*/

} //union earth_moon

#declare sfac = 1/10000 ;

camera
{
  location  <0, 000, 20000>*sfac
  direction 1.5*z
  right     4/3*x
  look_at   <0, 0, 0>
}

//object {earth_moon scale sfac rotate <23.5,0,0>}


object {earth_moon scale sfac rotate <0,0,0>}

//mars-red3a.tga diff 1.2
//moon5a-orig(a).png diff 1.2
//earth7.tga
