//      Copyright 2001 Andrew Bowcock
//Simple Shapes

#macro chamferbox(boxwidth,boxdepth,boxheight,topchamfer,sidechamfer)
        
        union{
        box{<-boxwidth/2+sidechamfer/2,boxdepth/2,-boxheight/2+topchamfer/2>,<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<-boxwidth/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>,<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<-boxwidth/2+sidechamfer/2,-boxdepth/2,-boxheight/2+topchamfer/2>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<boxwidth/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>,<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
        
        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2> }
        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/2>}
        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
        
        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,0,boxheight/2-topchamfer/2>}
        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<boxwidth/2-sidechamfer/2,0,boxheight/2-topchamfer/2>}
        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,0,-boxheight/2+topchamfer/2>}
        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<+boxwidth/2-sidechamfer/2,0,-boxheight/2+topchamfer/2>}
        
        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,0>}
        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,0>}
        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<-boxwidth/2+sidechamfer/2,-boxdepth/2+sidechamfer/2,0>}
        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<+boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,0>}
        
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
        
        }
#end

#macro Lshape(Lh,Ll,Ld,Lth,Lr,cr)               //Lh=z dimension, Ll=y dimension, Ld=x dimension
        union{                                  //Lr=bend radius, cr=corner radius
                box{<0,0,Lr><Ld,Lth,Lh-cr>}
                cylinder{<cr,0,Lh-cr><cr,Lth,Lh-cr>,cr}
                cylinder{<Ld-cr,0,Lh-cr><Ld-cr,Lth,Lh-cr>,cr}
                box{<cr,0,Lh-cr><Ld-cr,Lth,Lh>}
                box{<0,Lr,0><Ld,Ll-cr,Lth>}
                box{<cr,Ll-cr,0><Ld-cr,Ll,Lth>}
                cylinder{<cr,Ll-cr,0><cr,Ll-cr,Lth>,cr}
                cylinder{<Ld-cr,Ll-cr,0><Ld-cr,Ll-cr,Lth>,cr}
                
                intersection{
                        cylinder{<0,Lr,Lr><Ld,Lr,Lr>,Lr}
                        cylinder{<-1,Lr,Lr><Ld+1,Lr,Lr>,Lr-Lth inverse}
                        box{<-1,0,0><Ld+1,Lr*1.0001,Lr*1.0001>}
                          }
              }
#end

#macro roundedplate(rpl,rpw,rpr,rpth)
        union{
                box{<-rpl/2,-rpw/2+rpr,0><rpl/2,rpw/2-rpr,-rpth>}
                box{<-rpl/2+rpr,-rpw/2,0><rpl/2-rpr,rpw/2,-rpth>}
                cylinder{<-rpl/2+rpr,-rpw/2+rpr,0><-rpl/2+rpr,-rpw/2+rpr,-rpth>,rpr}
                cylinder{<rpl/2-rpr,-rpw/2+rpr,0><rpl/2-rpr,-rpw/2+rpr,-rpth>,rpr}
                cylinder{<-rpl/2+rpr,rpw/2-rpr,0><-rpl/2+rpr,rpw/2-rpr,-rpth>,rpr}
                cylinder{<rpl/2-rpr,rpw/2-rpr,0><rpl/2-rpr,rpw/2-rpr,-rpth>,rpr}
             }
#end             
