//      Copyright 2001 Andrew Bowcock
#include "slospace.inc"
#debug "Parsing 'atomlat.inc'\n"


#macro atomlattice(campos,lookpos,phse,latticeend,fogend)              // lattice  in directions direction camera is looking
        #declare phse=phse-int(phse);
        #declare atomdepth=7;// should be 7;
        #declare atomx=-atomdepth;
        #declare v_up=vnormalize(lookpos-campos);
        #declare fratom=-<campos.x-int(campos.x),campos.y-int(campos.y),campos.z-int(campos.z)>;
        #declare pigring=pigment {rgb .4}
        union{
                #while (atomx<atomdepth)
                        #declare atomy=-atomdepth;
                        #while (atomy<atomdepth)
                                #declare atomz=-atomdepth;
                                #while (atomz<atomdepth)
                                //#debug concat("x,y,z = ",str(atomx,1,0),",",str(atomy,1,0),",",str(atomz,1,0),"  dotprod = ",str(vdot(vnormalize(lookpos-campos),vnormalize(<atomx,atomy,atomz>)),2,2),",","\n")
                                   #if (((vdot(v_up,vnormalize(<atomx,atomy,atomz>+fratom))>.75)|(vlength(<atomx,atomy,atomz>+fratom)<1))&(vdot(<atomx,atomy,atomz>+fratom,v_up)<latticeend))     // only create atoms in camera direction, up to limit of crystal
                                        #declare r1=seed(int(campos.x)+int(campos.y)*4+int(campos.z)*16+atomx+atomy*4+atomz*16);
                                        #declare vib=<atomx,atomy,atomz>;
                                        #declare rot1=<30,0,10>;
                                        #declare rot2=<60,0,5>;
                                        #declare rot3=<90,0,10>;
                                        #declare rot4=<120,0,5>;
                                        #declare rot5=<150,0,0>;
                                        #declare rot6=<150,0,0>;
                                        #declare rot7=<rand(r1)*360,rand(r1)*360,rand(r1)*360>;
                                        #if (quality>2)
                                                union{
                                                        sphere{0,.08 pigment{Yellow} finish{ambient 1}}
                                                        object{mercury scale 1/80 translate <.3,0,0> rotate <0,240+phse*360,0> rotate rot1}
                                                        object{jupiter scale 1/2000 translate <.3,0,0> rotate <0,120-phse*360> rotate rot2}
                                                        object{saturn scale 1/15000 translate <.3,0,0> rotate <0,180+phse*360> rotate rot3}
                                                        object{earth scale 1/200 translate <.3,0,0> rotate <180,180-phse*360> rotate rot5}
                                                        torus{.3,.002 rotate rot1}
                                                        torus{.3,.002 rotate rot2}
                                                        torus{.3,.002 rotate rot3}
                                                        torus{.3,.002 rotate rot4}
                                                        torus{.3,.002 rotate rot5}
                                                        torus{.3,.002 rotate rot6}
                                                        finish{ambient 4}
                                                        pigment{pigring}
                                                        rotate rot7
                                                        translate vib
                                                      }
                                        #else sphere{0,.08 pigment{Yellow} finish{ambient 1} translate vib}
                                        #end                                                       
                                   #end
                                #declare atomz=atomz+1;
                                #end
                        #declare atomy=atomy+1;
                        #end
                #declare atomx=atomx+1;
                #end
                translate <int(campos.x),int(campos.y),int(campos.z)>
             }
        fog {   
                fog_type 2
                up v_up
                #declare v2np=campos+latticeend*v_up;     //v2np = vector from origin to nearpoint to camera on fogend plane
                //#debug concat("v2np = ",str(v2np.x,4,1),",",str(int(v2np.y),4,1),",",str(v2np.z,4,1),"\n")
                #declare d=vdot(v2np,v_up);               //d = distance from origin to closest pt to origin on fogend plane
                //#debug  concat("distance from origin to fog endplane = ",str(d,4,1),"\n")
                fog_alt 1
                fog_offset d-2
                distance 3
                color rgb<0.2, 0.1, 0.05> 
                turbulence 0.25
                turb_depth 0.25
                }
          
#end                        

#macro atomlattice2(campos,lookpos,phse,slide)              // limited lattice  in directions direction camera is looking
        #declare phse=phse-int(phse);
        #declare atomdepth=20;
        #declare atomx=-2;
        #declare v_up=vnormalize(lookpos-campos);
        #declare fratom=-<campos.x-int(campos.x),campos.y-int(campos.y),campos.z-int(campos.z)>;
        #declare pigring=pigment {rgb .4}
        union{
                #while (atomx<2)
                        #declare atomy=-atomdepth;
                        #while (atomy<atomdepth)
                                #declare atomz=-atomdepth;
                                #while (atomz<atomdepth)
                                //#debug concat("x,y,z = ",str(atomx,1,0),",",str(atomy,1,0),",",str(atomz,1,0),"  dotprod = ",str(vdot(vnormalize(lookpos-campos),vnormalize(<atomx,atomy,atomz>)),2,2),",","\n")
                                   #if (vdot(v_up,vnormalize(<atomx,atomy,atomz>+fratom))>.75)     // only create atoms in camera direction, up to limit of crystal
                                   #declare r1=seed(int(campos.x)+int(campos.y)*4+int(campos.z)*16+atomx+atomy*4+atomz*16);
                                   #declare vib=<atomx,atomy,atomz>;
                                   #if (quality>2)
                                        union{
                                        #declare rot1=<30,0,10>;
                                        #declare rot2=<60,0,5>;
                                        #declare rot3=<90,0,10>;
                                        #declare rot4=<120,0,5>;
                                        #declare rot5=<150,0,0>;
                                        #declare rot6=<150,0,0>;
                                        #declare rot7=<rand(r1)*360,rand(r1)*360,rand(r1)*360>;
                                        sphere{0,.08 pigment{Yellow} finish{ambient 1}}
                                        object{mercury scale 1/80 translate <.3,0,0> rotate <0,240+phse*360,0> rotate rot1}
                                        object{jupiter scale 1/2000 translate <.3,0,0> rotate <0,120-phse*360> rotate rot2}
                                        object{saturn scale 1/15000 translate <.3,0,0> rotate <0,180+phse*360> rotate rot3}
                                        object{earth scale 1/200 translate <.3,0,0> rotate <180,180-phse*360> rotate rot5}
                                        torus{.3,.002 rotate rot1}
                                        torus{.3,.002 rotate rot2}
                                        torus{.3,.002 rotate rot3}
                                        torus{.3,.002 rotate rot4}
                                        torus{.3,.002 rotate rot5}
                                        torus{.3,.002 rotate rot6}
                                        finish{ambient 4}
                                        pigment{pigring}
                                        rotate rot7
                                        translate vib
                                        }
                                        #else
                                        sphere{0,.08 pigment{Yellow} finish{ambient 1} translate vib}
                                  #end

                            /*            #else
                                        sphere{<atomx,atomy,atomz>,.01 pigment{Blue}}
                                        #if (abs(vdot(<atomx,atomy,atomz>+fratom,v_up))<latticeend)
                                                #declare atpos=str(vdot(v_up,vnormalize(<atomx,atomy,atomz>+fratom)),4,2)
                                                //#debug concat(atpos,"\n")
                                                text{ttf "arialn.ttf" atpos .35 0 scale .1 rotate y*-90 pigment{White} translate<atomx,atomy,atomz>}
                                                //sphere{<atomx,atomy,atomz>,.07 pigment{Green} finish{ambient 1}}
                                                #end
                            */  #end
                                #declare atomz=atomz+1;
                                #end
                        #declare atomy=atomy+1;
                        #end
                #declare atomx=atomx+1;
                #end
                rotate <0,15,30>
                translate <int(campos.x)+slide,int(campos.y),int(campos.z)-.3>
             }
        fog {   
                fog_type 2
                up <-.8365163,-.482,.258>
                //#declare v2np=campos+latticeend*v_up;     //v2np = vector from origin to nearpoint to camera on fogend plane
                //#debug concat("v2np = ",str(v2np.x,4,1),",",str(int(v2np.y),4,1),",",str(v2np.z,4,1),"\n")
                //#debug concat("v_up = ",str(v_up.x,4,4),",",str(int(v_up.y),4,4),",",str(v_up.z,4,4),"\n")
                //#declare d=vdot(v2np,v_up);               //d = distance from origin to closest pt to origin on fogend plane
                //#debug  concat("distance from origin to fog endplane = ",str(d,4,1),"\n")
                fog_alt .1
                fog_offset -5104.7-slide
                distance 1.5
                color rgb<0.2, 0.1, 0.05> 
                turbulence 0.25
                turb_depth 0.25
                }
          
#end                        
 
/*
        #debug "Warning - Camera position set in atomlat.inc!\n"

        #declare campos=<4589.8-(clock-.469)/.01,3666.4,928.72>;
        #declare lookpos=<4509.8,3665.94,928.72>;
        camera{location campos look_at lookpos}
        
        light_source{campos colour 1}
        
        atomlattice(campos,lookpos,clock*50,4,120)

*/