//      Copyright 2001 Andrew Bowcock
#debug "Parsing 'computer.inc'\n"
#include "components.inc"

#declare casel=440;
#declare casew=420;
#declare caseh=140;


#declare cols=array[10]{Black,Brown,Red,Orange,Yellow,Green,Blue,Violet,Grey,White}
#declare colrand=seed(0);
#macro rcol()
        cols[(rand(colrand)*9.5)]
#end        

#macro uptilt()
        rotate<15,0,0>
        translate <0,0,20>
#end

#macro screen(pic)              // computer screen with picture "pic" on
        union{
        difference{
                blob{
                        threshold .5
                        cylinder{<0,0,-150>,<0,0,150>,40,2 scale <1,.1,.1> uptilt()}
                        cylinder{<0,-10,-150>,<0,-10,150>,40,-1.5 scale <1,.1,.1> uptilt()}
                        #declare cr=2.8;
                        #declare cs=3;
                        #declare nc=6;
                        #declare cn=0;
                        #while (cn<nc)
                                #declare angl=2*pi*cn/nc;
                                cylinder{<cs*cos(angl),cs/4*sin(angl),0><cs/4*cos(angl),cs/4*sin(angl),30>,cr,.6}
                                #declare cn=cn+1;
                        #end
                        cylinder{0,<0,0,10>,60,.6 scale <1,1,.02>}
                        cylinder{0,<0,0,10>,60,-.6 scale <1,1,.02>translate y*60}
                        
                    }
                prism { conic_sweep .9,1,5  <20,15>,<-20,15>,<-20,-15>,<20,-15>,<20,15>
                    translate <0, -.89, 0>
                    scale <1, 50, 1>
                    pigment {rgb .5}
                    uptilt()
                  }
            pigment {rgb <.95,.9,.9>}
                    }
                 box{<-20,.5,-15><20,.6,15> pigment{image_map{sys pic} rotate x*90 scale <40,1,30> translate<20,0,15>} uptilt() finish{ambient 1.5 diffuse 0}}
                        // errors such as "unable to open file" here mean you haven't created (or can't access) the onscreen pictures - run "onscr.pov" first
                 box{<-18,.45,-14><18,.65,14> pigment{image_map{gif "window.gif" transmit 0,1} rotate x*90 scale <36,1,28> translate<18,0,14>} uptilt() finish{ambient 1.5 diffuse 0}}   
                 }
#end

#macro rgbdots(bl)               // red, green and blue dots making up screen
        #declare xdiscs=100;     // bl=blend factor (0=fully visible, 1=invisible)
        #declare ydiscs=100;
        #declare xsize=4;
        #declare ysize=4;
        #declare r32=sqrt(3)/2;
        union{
                #declare ydisc=0;
                #while (ydisc<ydiscs)
                        #declare xdisc=0;
                        #while (xdisc<xdiscs)
                                disc{0,z,.5 pigment{rgbf<1,bl,bl,1+(1-bl)>} translate <xdisc,ydisc,0>}
                                disc{0,z,.5 pigment{rgbf<bl,1,bl,1+(1-bl)>} translate <xdisc+1,ydisc,0>}
                                disc{0,z,.5 pigment{rgbf<bl,bl,1,1+(1-bl)>} translate <xdisc+.5,ydisc+r32,0>}
                                disc{0,z,.5 pigment{rgbf<1,bl,bl,1+(1-bl)>} translate <xdisc+1.5,ydisc+r32,0>}
                                disc{0,z,.5 pigment{rgbf<bl,1,bl,1+(1-bl)>} translate <xdisc+2.5,ydisc+r32,0>}
                                disc{0,z,.5 pigment{rgbf<bl,bl,1,1+(1-bl)>} translate <xdisc+2,ydisc+r32*2,0>}
                                #declare xdisc=xdisc+3;
                        #end
                        #declare ydisc=ydisc+2*r32;
                #end
                hollow
                translate -z*1.5
                scale <ysize/xdiscs,ysize/ydiscs,1>
                translate <-xsize/2+.005,-ysize/2,0>
                rotate x*90
                uptilt()
                rotate z*120
                scale 10
                translate <ol-560,ow-460,990>
                
        }
#end

#macro key(letter,size,col) //causes CSG error!
          difference{
              prism { conic_sweep  cubic_spline .7,1,11  <-.5,-.3>,<-.5,.3>,<-.3,.5>,<.3,.5>,<.5,.3>,<.5,-.3>,<.3,-.5>,<-.3,-.5>,<-.5,-.3>,<-.5,.3>,<-.3,.5>
                translate <0, -.7, 0>
                rotate x*-90
                scale <1, 1, 2.5>
                     }
              sphere{<0,0,2>,2.2}
              
              text { ttf "timrom.ttf" letter .2, 0 rotate<0,180,0> scale<size,size,1> pigment { rgb 0} translate<.2,-.2,0.001> rotate z*180 }              
              pigment {col}
           } 
 

#end

#macro keyboard()
        #declare brownkey=rgb .6;
        #declare whitekey=rgb .8;
        union{
        object{key("Esc",.3,brownkey) translate <-1,-2,0>}
        object{key("",.5,whitekey) translate <-1,0,0>}
        object{key("->",.5,brownkey) translate <-.5,1,0> scale <1.5,1,1>}
        object{key("Caps",.3,brownkey) translate <-.5,2,0> scale <1.5,1,1>}
        object{key("^",.5,brownkey) translate <-.5,3,0> scale <1.5,1,1>}
        object{key("<-",.5,brownkey) scale <2,1,1> translate <12.5,0,0> }
        //object{key("",.5,brownkey) scale <2,1,1> translate <13,1,0> }
        object{key("",.5,brownkey) scale <1.5,2,1> translate <13,1.5,0> }
        object{key("",.5,brownkey) scale <2,1,1> translate <12.75,3,0> }
        
        object{key("Fn",.3,brownkey) translate <-1,4,0> }
        object{key("Ctrl",.3,brownkey) translate <0,4,0> }
        object{key("0",.3,brownkey) translate <1,4,0> }
        object{key("Alt",.3,brownkey) translate <2,4,0> }
        object{key("",.3,whitekey) scale <8,1,1> translate <6,4,0>}
        object{key("Gr",.3,brownkey) translate <10,4,0> }
        object{key("0",.3,brownkey)  translate <11,4,0> }
        object{key("::",.3,brownkey)  translate <12,4,0> }
        object{key("Ctrl",.3,brownkey)  translate <13,4,0> }
        
        #declare nk=0;
        #while (nk<3)
                object{key("",.3,brownkey) translate <15+nk,-2,0>}
                object{key("",.3,brownkey) translate <15+nk,0,0>}
                object{key("",.3,brownkey) translate <15+nk,1,0>}
                object{key("",.3,brownkey) translate <15+nk,4,0>}
                object{key("",.3,brownkey) translate <19+nk,0,0>}
                object{key("",.3,whitekey) translate <19+nk,1,0>}
                object{key("",.3,whitekey) translate <19+nk,2,0>}
                object{key("",.3,whitekey) translate <19+nk,3,0>}
                object{key("",.3,whitekey) translate <19+nk,4,0>}
                
                #declare nk=nk+1;
        #end
        object{key("",.3,brownkey) translate <16,3,0>}
  
        
        #declare nk=0;
        #while (nk<4)
                object{key(concat("F",str(nk+1,1,0)),.3,whitekey) translate <1+nk,-2,0>}
                object{key(concat("F",str(nk+5,1,0)),.3,brownkey) translate <5.5+nk,-2,0>}
                object{key(concat("F",str(nk+9,1,0)),.3,whitekey) translate <10+nk,-2,0>}
                #declare nk=nk+1;
        #end
        #declare keys=array[4]{"1234567890-= ","QWERTYUIOP[] ","ASDFGHJKL;'# ","\ZXCVBNM,./ "}
        #declare nk=12;
        #declare nr=4;
        #declare rn=0;
        #while (rn<nr)
                #declare kn=0;
                #while (kn<nk)
                        object{key(substr(keys[rn],kn+1,1),.5,rgb .8) translate <kn+rn/2-(rn>2),rn,0>}
                        #declare kn=kn+1;
                #end
                #declare rn=rn+1;
        #end
      
        //difference{
                blob{
                        cylinder{<-20,3,-10><110,3,-10>,14,1.8 scale <.2,1,.1>}
                        cylinder{<-10,12,-17><130,12,-10>,10,-1.5 scale <.2,1,.1>}
                        cylinder{<-20,12,-10><110,3,10>,10,-1.5 scale <.2,1,.1>}
                        
                    }
                    pigment {rgb .9}
             //     }
         }
#end

#macro keyboardwire()
        #declare xs=0;
        #declare ys=0;
        #declare zs=0;
        #declare theta=0;
        #declare phi=0;
        #declare leaddiameter=3;
        union{
               wirepiece(50,10,0)
               wirepiece(52,14,4)
               #declare curlcount=0;
               #while (curlcount<20)
                        wirepiece(50+4*curlcount,20+2*curlcount,14-curlcount/4)
                        wirepiece(52+4*curlcount,30+2*curlcount,10-curlcount/4)
                        #declare curlcount=curlcount+1;
               #end
               wirepiece(133,71,3)
               wirepiece(260,280,4)
               wirepiece(260,180,4)
               translate x*40
               pigment{rgb .7}
                       }
#end

#macro mainboard()
        #debug " - main board\n"
        #declare brdth=1;
        #declare brdl=250;
        #declare brdw=220;
        #declare T_Mainboard=texture{pigment{DarkGreen}}
                                texture{pigment{image_map{gif "mainboard3.gif" filter 63,1}  rotate y*180 scale<brdl,brdw,1>} finish{phong .3}}
      union{  
        box{<0,0,-brdth><brdl,brdw,0> texture{T_Mainboard}}
        union{
                difference{
                        chamferbox(6,30,10,2,4)
                        box{<-2,-13,.5><2,13,6>}
                        box{<-2.5,-13.5,.01><2.5,13.5,1> pigment{rgb .5}}
                        translate z*5 pigment{rgbt<.7,.7,.7,.2>}
                           }
                #declare wireno=0;
                #while (wireno<8)
                        #declare theta=-90;
                        #declare phi=0;
                        #declare xs=0;
                        #declare ys=3*wireno-12;
                        #declare zs=0;
                        #declare leaddiameter=1;
                        object{wirepiece(0,3*wireno-12,5) texture{T_Silver_1A}}
                        #declare leaddiameter=2;
                        union{
                                wirepiece(-1,3*wireno-12,10)
                                wirepiece(-6,4*wireno-16,20)
                                wirepiece(-70,5*wireno-10,80)
                                //wirepiece(-50,5*wireno-40,90)
                                pigment{cols[wireno]}
                              }
                        #declare wireno=wireno+1;
                #end
                translate <5,brdw-50,0>
                }
        
        object{fan(clock*10) translate <235,50,25>}
        object{plug_pci() rotate y*90 pigment{rgb .5} translate <200,100,0>}
      #if (quality>2)
        object{plug_slot1(31,2) rotate y*90 pigment{rgb .5} translate <100,175,0>}
        object{plug_pci() rotate y*90 pigment{rgb .5} translate <120,100,0>}
        object{plug_pci() rotate y*90 pigment{rgb .5} translate <140,100,0>}
        object{plug_pci() rotate y*90 pigment{rgb .5} translate <160,100,0>}
        object{plug_pci() rotate y*90 pigment{rgb .5} translate <180,100,0>}
        object{plug_pci() rotate y*90 pigment{rgb .5} translate <220,100,0>}
        

        object{micropro() translate <180,50,0>}

        object{plug_DIMM() translate <15,160,0>}
        object{plug_DIMM() translate <25,160,0>}
        object{plug_DIMM() translate <35,160,0>}
        object{plug_DIMM() translate <45,160,0>}
        
        object{chip_surfacemount(50,50) translate <90,65,0>}
        object{chip_surfacemount(25,40) translate <100,100,0>}
        
        object{chip(40,true,"JETkey V50") rotate z*90 translate <80,180,0>}
        object{chip(28,true,"Award") rotate z*90 translate <80,130,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <10,40,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <20,40,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <30,40,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <40,40,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <10,90,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <20,90,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <30,90,0>}
        object{chip(28,false,"W24257AK") rotate z*90 translate <40,90,0>}
        object{chip(20,false,"74F244PC") rotate z*90 translate <55,110,0>}
        object{chip(20,false,"74F244PC") rotate z*90 translate <65,110,0>}
        
        object{chip(20,false,"MC74F244N") translate <30,5,0>}
        object{chip(20,false,"MC74F244N") translate <30,15,0>}
        object{chip(14,false,"MC74F244N") translate <70,15,0>}
        object{chip(20,false,"MC74F244N") translate <95,15,0>}
        
        
        object{electrolytic(4,2) rotate <2,3,10> translate <65,8,4>}
        object{electrolytic(4,2) rotate <1,-4,20> translate <70,6,3>}
        object{electrolytic(4,2) rotate <1,2,30> translate <120,60,4>}
        object{electrolytic(4,2) rotate <-3,2,-10> translate <125,30,3>}
        object{electrolytic(8,4) rotate <1,-2,-20> translate <125,50,4>}
        object{electrolytic(8,4) rotate <3,2,-30> translate <150,75,3>}
        #declare capcount=0;
        #while (capcount<6)
                object{electrolytic(4,2) rotate <capcount-3,0,0> translate <115+20*capcount,100,0>}
                object{electrolytic(4,2) rotate <0,capcount-3,0> translate <110+20*capcount,150,0>}
                object{electrolytic(4,2) translate <110+20*capcount,200,0>}
                #declare capcount=capcount+1;
        #end
        #declare capcount=0;
        #while (capcount<3)
                object{capacitorbead(4,"capbead.gif") translate <125+3*capcount,22,0>}
                object{capacitorbead(4,"capbead.gif") translate <155+4*capcount,22,0>}
                object{capacitorbead(4,"capbead.gif") rotate z*90 translate <25,63+4*capcount,0>}
                object{capacitorbead(4,"capbead.gif") rotate z*90 translate <58,22+4*capcount,0>}
                object{capacitorbead(4,"capbead.gif") translate <54+3*capcount,129,0>}
                object{capacitorbead(4,"capbead.gif") translate <63+3*capcount,129,0>}
                #declare capcount=capcount+1;
        #end


        object{resistorbank(8) rotate z*90 translate <55,6,0>}
        object{resistorbank(10) rotate z*90 translate <85,6,0>}
        object{resistorbank(8) rotate z*90 translate <115,4,0>}
        object{resistorbank(10) translate <214,120,0>}
        object{resistorbank(10) translate <214,190,0>}
        object{resistorbank(10) translate <194,120,0>}
        object{resistorbank(8) translate <174,190,0>}
        object{resistorbank(8) translate <154,150,0>}
        object{resistorbank(8) translate <134,190,0>}
        object{resistorbank(10) translate <114,190,0>}
        object{resistorbank(10) translate <4,143,0>}
        object{resistorbank(10) translate <8,143,0>}
        object{resistorbank(10) translate <55,150,0>}
        object{resistorbank(10) translate <65,150,0>}
        
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <65,180,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <65,183,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <65,186,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <65,189,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <65,195,1>}
        #declare rescount=0;
        #while (rescount<26)
                object{resistor(rcol(),rcol(),rcol(),rcol()) rotate z*90 translate <110+3*rescount,15,1>}
                object{resistor(rcol(),rcol(),rcol(),rcol()) rotate z*90 translate <150+3*rescount,90,1>}
                object{resistor(rcol(),rcol(),rcol(),rcol()) translate <48,20+3*rescount,1>}
                #declare rescount=rescount+1;
        #end

        object{TO18() translate <60,140,5>}
        object{TO18() translate <60,150,5.2>}
        object{TO92("P36","TO92") translate <65,170,4.8>}
        object{TO92("P37","TO92") translate <65,175,4.7>}
        
        object{screwterminal() rotate z*180 translate <10,215,0>}
        object{screwterminal() rotate z*180 translate <15,215,0>}
        object{screwterminal() rotate z*180 translate <20,215,0>}
        object{screwterminal() rotate z*180 translate <25,215,0>}
        object{screwterminal() rotate z*180 translate <30,215,0>}
        object{screwterminal() rotate z*180 translate <35,215,0>}


        object{TO220("+PMM","12VCD") translate <195,15,0>}


        object{jumper() translate <50,10,0>}
        object{jumper() translate <50,8,0>}
        object{jumper() translate <52,10,0>}
        object{jumper() translate <52,8,0>}
        object{jumper() translate <54,10,0>}
        object{jumper() translate <54,8,0>}
        object{jumper() translate <58,10,0>}
        object{jumper() translate <58,8,0>}
        
        object{jumper() translate <100,40,0>}
        object{jumper() translate <100,38,0>}
        object{jumper() translate <102,40,0>}
        object{jumper() translate <102,38,0>}
        object{jumper() translate <104,40,0>}
        object{jumper() translate <104,38,0>}
        object{jumper() translate <108,40,0>}
        object{jumper() translate <108,38,0>}
        object{jumper() translate <110,40,0>}
        object{jumper() translate <110,38,0>}
        object{jumper() translate <112,40,0>}
        object{jumper() translate <112,38,0>}
        object{jumper() translate <114,40,0>}
        object{jumper() translate <114,38,0>}
        object{jumper() translate <116,40,0>}
        object{jumper() translate <116,38,0>}
        object{jumper() translate <100,42,0>}
        object{jumper() translate <100,44,0>}
        object{jumper() translate <102,44,0>}
        object{jumper() translate <102,42,0>}
        object{jumper() translate <104,44,0>}
        object{jumper() translate <104,42,0>}
        object{jumper() translate <108,44,0>}
        object{jumper() translate <108,42,0>}
        object{jumper() translate <110,44,0>}
        object{jumper() translate <110,42,0>}
        object{jumper() translate <112,44,0>}
        object{jumper() translate <112,42,0>}
        object{jumper() translate <114,44,0>}
        object{jumper() translate <114,42,0>}
        object{jumper() translate <116,44,0>}
        object{jumper() translate <116,42,0>}
        object{jumper() translate <116,46,0>}
        object{jumper() translate <116,46,0>}
        #declare jumpcount=0;
        #while (jumpcount<20)
                object{jumper() translate <153+2*jumpcount,4,0>}
                object{jumper() translate <123+2*jumpcount,80,0>}
                #declare jumpcount=jumpcount+1;
        #end
      #end  
        object{videoboard() rotate <90,0,-90> translate <204,225,6>}
        object{memboard() rotate <90,0,-90> translate <27,196,0>}
        }
#end

#macro memboard()
        #debug " - memory board\n"
        #declare brdth=1;
        #declare brdl=73;
        #declare brdw=20;
        #declare T_memboard=texture{pigment{rgb<.2,.6,.4>}}
                             texture{pigment{image_map{gif "memboard.gif" filter 38,1}  rotate y*180 scale<brdl*1.001,brdw*1.001,1>}}// finish{phong 1}}
      union{  
        box{<0,0,-brdth><brdl,brdw,0> texture{T_memboard}}
      #if (quality>2)
        object{chip_surfacemount(10,18) translate <15,11,0>}
        object{chip_surfacemount(10,18) translate <29,11,0>}
        object{chip_surfacemount(10,18) translate <43,11,0>}
        object{chip_surfacemount(10,18) translate <57,11,0>}
       #end
       }
#end

#macro videoboard()
        #debug " - video board\n"
        #declare brdth=1;
        #declare brdl=110;
        #declare brdw=50;
        #declare T_memboard=texture{pigment{rgb<.4,.8,.6>}}
                             texture{pigment{image_map{gif "vidboard.gif" filter 64,1}  rotate y*180 scale<brdl*1.001,brdw*1.001,1>}}
      union{  
        difference{
                box{<0,0,-brdth><brdl,brdw,0>}
                box{<-.01,-.01,-brdth-.01><20,4,.01>}
                texture{T_memboard}
                  }
      #if (quality>2)
        object{vidconnector() rotate z*90 translate <0,20,0>}
        
        object{chip_surfacemount(50,50) translate <85,21,0>}
        object{roundedplate(18,7,1,2) pigment{image_map{gif "guibios.gif"} rotate y*180 scale <18,7,1> translate <9,3.5,0>} rotate z*10 translate <85,21,3.51>}
        
        object{chip(14,no,"74LS04N") translate <40,11,0>}
        object{chip(14,no,"74LS04N") translate <40,21,0>}
        object{chip(14,no,"74LS04N") translate <40,31,0>}
        object{chip(20,no,"74LSD") rotate z*90 translate <20,21,0>}
        object{chip(16,no,"74LS123") translate <85,45,0>}
        
        object{electrolytic(4,2) rotate <2,3,5> translate  <55,8,4>}
        object{electrolytic(4,2) rotate <5,3,10> translate <55,16,4>}
        object{electrolytic(4,2) rotate <8,6,8> translate  <55,24,4>}
        object{electrolytic(4,2) rotate <3,6,10> translate <55,32,4>}
        
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,35,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,32.5,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,30,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,27.5,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,25,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,22.5,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,20,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) translate <63,17.5,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) rotate z*90 translate <50,41.5,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) rotate z*90 translate <45,41.5,1>}
        object{resistor(rcol(),rcol(),rcol(),rcol()) rotate z*90 translate <40,41.5,1>}
        
        object{resistorbank(10) translate <105,25,0>}
        object{resistorbank(8) translate <15,25,0>}

        object{TO92("P36","TO92") rotate <2,-5,-90>translate <65,42,4.8>}
        object{TO92("P37","TO92") rotate <3,5,-90>translate <65,47,4.7>}
        object{TO92("P37","TO92") rotate <-2,5,-90>translate <15,47,4.7>}
        object{TO92("P37","TO92") rotate <-6,4,-90> translate <65,7,4.7>}
        
        object{capacitorbead(4,"capbead.gif") translate <15,38,0>}
        object{capacitorbead(4,"capbead.gif") translate <19,38,0>}
        object{capacitorbead(4,"capbead.gif") translate <25,38,0>}
        object{capacitorbead(4,"capbead.gif") translate <27,31,0>}
        object{capacitorbead(4,"capbead.gif") translate <27,21,0>}
        object{capacitorbead(4,"capbead.gif") translate <27,11,0>}
        object{capacitorbead(4,"capbead.gif") rotate z*90 translate <28,48,0>}
        object{capacitorbead(4,"capbead.gif") rotate z*90 translate <40,48,0>}
        object{capacitorbead(4,"capbead.gif") rotate z*90 translate <105,45,0>}
        object{capacitorbead(4,"capbead.gif") rotate z*90 translate <55,45,0>}
        object{capacitorbead(4,"capbead.gif") rotate z*90 translate <60,40,0>}

        
       #end
           }
#end

#macro cardholder()
        union{
                difference{
                        Lshape(90,19,18,1,4,4)
                        object{Lshape(11,25,18,2,4,4) translate <16,-.5,-.5>}
                           }
                object{Lshape(10,19,18,1,4,4) translate x*-3}
             }
#end

#macro metalbox()
        //#debug " - metal box\n"
        #declare mbl=casew-40;
        #declare mbw=casel-20;
        #declare mbh=caseh-30;
        #declare mbth=1;
        union{
                difference{
                        box{<-mbl/2,-mbw/2,0><mbl/2,mbw/2,mbh>}
                        box{<-mbl/2+mbth,-mbw/2+mbth,mbth><mbl/2-mbth,mbw/2-mbth,mbh-mbth>}                     //main space inside
                        box{<-mbl/2+mbth*5,-mbw/2+mbth*5,mbh-mbth-1><mbl/2-mbth*5,mbw/2-mbth*5,mbh+mbth>}       //open top
                        box{<mbl/2-mbth-1,-20,5> <mbl/2+1,25,50>}                                                 // cutout behind fan
                        box{<mbl/2-160,mbw/2-mbth-1,5> <mbl/2-10,mbw/2+1,mbh>}                                 // cutout for cards
                        box{<mbl/2-mbth-1,30,25> <mbl/2+1,32,20>}               //   \
                        sphere{<mbl/2,31,25>,2}                                 //    > hole near fanhole
                        sphere{<mbl/2,31,20>,2}                                 //   /
                        #declare holez=0;
                        #while (holez<4)
                                #declare holex=-6;
                                #while (holex<6)
                                        cylinder{<holex*10-20,mbw/2-mbth-1,holez*10+40> <holex*10-20,mbw/2+mbth+1,holez*10+40>,3}
                                        cylinder{<holex*10-15,mbw/2-mbth-1,holez*10+45> <holex*10-15,mbw/2+mbth+1,holez*10+45>,3}
                                        #declare holex=holex+1;
                                #end
                                #declare holez=holez+1;
                        #end
                          }
                #declare bdcount=0;
                #while (bdcount<6)
                        object{cardholder() rotate y*180 translate <mbl/2-23-20*bdcount,mbw/2-20,95>}
                        #declare bdcount=bdcount+1;
                #end
                difference{
                        Lshape(20,10,110,1,4,5)                 // Lshape beside card rack
                        object{roundedplate(20,10,2,4) rotate x*90 translate <40,-.5,10>}
                        rotate <0,-90,90> translate <mbl/2-160,mbw/2-2,0>
                        }
                object{Lshape(20,20,10,1,4,5) rotate z*90 translate <mbl/2-160,mbw/2-17.5,45>}  // Lshape stamped from Lshape beside cardrack
                object{Lshape(60,20,345,1,5,5) rotate z*180 translate <mbl/2-10,mbw/2,90>}  //Lshape above cardrack
                difference{
                        Lshape(20,20,110,1,4,5)                 // Lshape below grill
                        object{roundedplate(10,10,2,4) translate <20,10,1.5>}
                        object{roundedplate(10,10,2,4) translate <40,10,1.5>}
                        object{roundedplate(10,10,2,4) translate <60,10,1.5>}
                        object{roundedplate(10,10,2,4) translate <80,10,1.5>}
                        rotate <0,0,180> translate <mbl/2-170,mbw/2-2,18>
                        }
                difference{
                        Lshape(20,20,110,1,4,5)                 // Lshape to left of fanhole
                        object{roundedplate(10,10,2,4) translate <20,10,1.5>}
                        object{roundedplate(10,10,2,4) translate <40,10,1.5>}
                        object{roundedplate(10,10,2,4) translate <60,10,1.5>}
                        object{roundedplate(10,10,2,4) translate <80,10,1.5>}
                        rotate <0,0,90> translate <mbl/2-2,-140,18>
                        }
                object{
                        Lshape(20,20,110,1,4,5)                 // 
                        rotate <0,0,90> translate <mbl/2-2,-10,78>
                       }
                object{
                        Lshape(20,20,110,1,4,5)                 // 
                        rotate <0,0,90> translate <mbl/2-2,-10,68>
                       }
                difference{
                        Lshape(10,5,20,1,2,2)
                        cylinder{<10,-3,5><10,1,5>,2}
                        rotate <0,-90,0> translate <mbl/2-160,mbw/2-22,20>
                           }
                #if (quality>1)
                        texture {T_metalbox}
                        #else pigment{rgb .4}
                #end
                //pigment{Blue}
                //translate <60,45,0>
                rotate z*-90
              }
        
#end

#macro computercase()
        #declare sc=20;
        #declare tc1=4;
        #declare tc2=40;
        #declare cl2=casel/2;
        #declare cw2=casew/2;
        #union{
        difference{                
                union{
                        cylinder{<-cl2+tc2,-cw2+sc,caseh-tc2><-cl2+tc2,cw2-sc,caseh-tc2>,tc2}    //front chamfer
                        cylinder{<-cl2+tc2-7,0,caseh-tc2+2>
                                 <-cl2+tc2-7,30,caseh-tc2+2>,
                                 tc2-6
                                 pigment{image_map{gif "dell.gif" map_type 2}scale <1,30,1> rotate y*-30 }
                                 translate y*(-cw2+100)}                                         //label
                        torus{tc2-sc,sc translate <-cl2+tc2,-cw2+sc,caseh-tc2>}
                        torus{tc2-sc,sc translate <-cl2+tc2,cw2-sc,caseh-tc2>}
                        cylinder{<-cl2+tc2,-cw2,caseh-tc2><-cl2+tc2,cw2,caseh-tc2>,tc2-sc}
                        union{
                                box{<-tc2,-cw2+sc,-caseh+tc2><0,cw2-sc,0>}                      //angled front
                                cylinder{<-sc,-cw2+sc,-caseh+tc2><-sc,-cw2+sc,0>,sc}            //angled pillars
                                cylinder{<-tc2-5,-30,0> <-tc2,-30,0>,8}                         //power & reset buttons
                                cylinder{<-tc2-5,-30,-30> <-tc2,-30,-30>,8}
                                torus{10,1 rotate z*90 translate <-tc2,-30,0>}
                                torus{10,1 rotate z*90 translate <-tc2,-30,-30>}
                                cylinder{<-sc,cw2-sc,-caseh+tc2><-sc,cw2-sc,0>,sc}
                                box{<-sc,-cw2,-caseh+tc2><0,-cw2+2,0>}                          //fill-ins
                                box{<-sc,cw2-2,-caseh+tc2><0,cw2,0>}
                                rotate y*-10
                                translate <-cl2+tc2,0,caseh-tc2>
                              }
                        box{<-cl2+tc2,-cw2+sc,caseh-2><cl2,cw2-sc,caseh>}
                        cylinder{<-cl2+tc2,-cw2+sc,caseh-sc><cl2,-cw2+sc,caseh-sc>,sc}          // top & sides of case
                        cylinder{<-cl2+tc2,cw2-sc,caseh-sc><cl2,cw2-sc,caseh-sc>,sc}
                        box{<-cl2+tc2,-cw2,0> <cl2,-cw2+2,caseh-sc>}                            // lhs of case
                        }
                box{<-cl2,cw2-200,20> <-cl2+20,cw2-50,80>}                      //cutout for CD & HDD
                box{<-cl2,cw2-190,22> <-cl2+25,cw2-60,78>}                      //further recess for CD & HDD
                box{<-cl2,cw2-60,103><-cl2+40,cw2-190,113>}                     // cutout for FDD
                box{<cl2-170,cw2-5,5> <cl2-10,cw2+1,110>}                       // cutout for cards
                box{<-5,-cw2-1,5> <40,-cw2+3,50>}                      // cutout behind fan
                sphere{<-cl2-2,cw2-125,108>,23}
                torus{12,2 scale <1,6,1> rotate z*90 translate <-cl2-4,cw2-50,108> pigment{rgb .5}} //cutout around FDD eject button
                pigment{rgb .7}
                }
                box{<-cl2+200,cw2-189,23> <-cl2+10,cw2-61,40> pigment{rgb .6}}      // CD
                box{<-cl2+200,cw2-189,45> <-cl2+10,cw2-61,77> pigment{rgb .6}}
                torus{4,1 rotate z*90 translate <-cl2+10,cw2-170,30> pigment{rgb .1}}
                cylinder{<-cl2+10,cw2-140,33><-cl2+10,cw2-140,35>,8 pigment{rgb .1}}  // CD volume control
                object{metalbox() translate x*20}
                }
#end

#macro insidecomp()
        //union{
                //object{metalbox() translate x*20}
                //computercase()
                object{mainboard() rotate z*-90 translate <-15,60,3>}
              //}
#end


#macro fromabove()
        #declare quality=4;
        #include "BasicShapes.inc"
        videoboard()
        #declare campos=<brdl/2,brdw/2,brdl*.82>;
        #declare lookpos=<brdl/2,brdw/2,0>;
        light_source{campos,1 scale <1,1,300>}
        camera {
                location campos
                sky <0,1,0>
                look_at lookpos
                orthographic
                }
#end

#macro showvidconnector()
        #declare quality=4;
        #include "BasicShapes.inc"
        videoboard()
        #declare campos=<24,20,12>;
        #declare lookpos=<0,20,8>;
        light_source{campos,1}
        camera {
                location campos
                sky <0,0,1>
                look_at lookpos
                }
#end