//      Copyright 2001 Andrew Bowcock
#include "components.inc"

#macro knob1()
        #declare rad1=7;
        #declare rad2=5;
        #declare grip=0;
        #declare griprad=.1;
        #declare ht=14;
        #declare grips=10;
        union{
           cylinder{0,<0,0,ht/10>,rad1*1.1}
           cylinder{<0,0,ht>,<0,0,ht*1.02>,rad2*.8}
           difference{
                cone{0,rad1,<0,0,ht>,rad2}
                #while (grip<grips)
                        cone{<rad1*sin(grip/grips*2*pi),rad1*cos(grip/grips*2*pi),0>,rad1*griprad,
                             <rad2*sin(grip/grips*2*pi),rad2*cos(grip/grips*2*pi),ht>,rad2*griprad}
                        #declare grip=grip+1;
                #end
                     }
             }
#end

#macro knob2()
    #declare rad=8;
    #declare grips=12;
    #declare grip=0;
    #declare griprad=.5;
    #declare ht=14;
    blob{
        threshold .5
        cylinder{0,<0,0,ht*10>,rad*1.4,2 scale <1,1,.1>}
        cylinder{0,<0,0,10>,rad*1.8,1.5 scale <1,1,.02>}
        #while (grip<grips)
                cylinder{0,<0,0,ht>,griprad,1 translate <rad*sin(grip/grips*2*pi),rad*cos(grip/grips*2*pi),0>}
                #declare grip=grip+1;
        #end
        pigment{rgb .3}
        finish{phong .1}
        }
#end


#macro rocker1()
        #declare bw=16;
        #declare bl=27;
        #declare bh=1.5;
        union{
                difference{
                        box{<-bl/2,-bw/2,0><bl/2,bw/2,bh>}
                        box{<-bl/2+1.5,-bw/2+1.5,0.01><0,bw/2-1.5,bh+.1>}
                        cylinder{<10,0,0><10,0,bh+.1>,2}
                        }
                box{<-bl/2+2,-bw/2+2,0><-.5,bw/2-2,bh>}
                box{<-bl/4+2,-bw/2+2,-bh><bl/4-1,bw/2-2,0> rotate y*-15 translate <-bl/4,0,bh>}
                object{led(off) scale 2 translate <10,0,-1>}
             }
#end