//      Copyright 2001 Andrew Bowcock
#macro nut(m)
        #declare af=m*.85;
        #declare sphererad=m;
        #declare h=m*1;
        #declare faces=6;
        #declare face=0;
        difference{
                sphere{0,sphererad*1.2 scale <1,1,.6>}
                #while (face<faces)
                        #declare radianangl=2*pi*face/faces;
                        #declare angl=360*face/faces;
                        box{<0,-sphererad,-sphererad><sphererad,sphererad,sphererad>
                                rotate z*angl
                                translate<af*cos(radianangl),af*sin(radianangl),0>
                           }
                         #declare face=face+1;
                 #end
                 box{<-sphererad,-sphererad,h/2><sphererad,sphererad,sphererad>}
                 box{<-sphererad,-sphererad,-h/2><sphererad,sphererad,-sphererad>}
                 cylinder{<0,0,-sphererad><0,0,sphererad>,m/2}
                 }
        
#end

#macro screw(ds,ls)
union{          
                #declare ds=ds/2;
                #declare sht=0;
                #declare theta=0;
                #declare phi=0;
                #declare leaddiameter=ds/2;
                #declare xs=0;
                #declare ys=-ds/2;
                #declare zs=0;
                #while (sht<ls)
                        wirepiece(0,ds/2,sht)
                        wirepiece(0,-ds/2,sht+ds/4)
                        #declare sht=sht+ds/2;
                #end
                cylinder{0,<0,0,ls>,ds/2}
                scale <1,1,.3>
                texture{T_Brass_5A}
                
            }
#end

#macro screwhead_cs(rad1)
        #declare rad2=rad1/2.5;
        #declare headl=rad2;
        difference{
                cone{0,rad1,<0,0,-headl>,rad2}
                box{<-rad1/8,0,0><rad1/8,rad1,rad1> rotate x*45 translate z*-rad1*.6}
                box{<0,-rad1/8,0><rad1,rad1/8,rad1> rotate -y*45 translate z*-rad1*.6}
                texture{T_Blackmetal}
                }
#end                

#macro screwhead(rad)
        difference{
                sphere{0,rad }
                box{<-rad/8,0,0><rad/8,rad*2,rad*2> rotate x*45 }
                box{<0,-rad/8,0><rad*2,rad/8,rad*2> rotate y*-45}
                scale <1,1,.5>
                texture{T_Blackmetal}
                }
#end


#macro screwhead_slot(rad)
        difference{
                sphere{0,rad }
                box{<-rad,-rad/6,0><rad,rad/6,rad*2>}
                scale <1,1,.5>
                texture{T_Silver_1A}
                }
#end


#macro screwhead_allen(rad)
        #declare s2=sqrt(3)/2;
        union{
                sphere{0,rad  scale<1,1,.5>}
                prism{0,3.1,7,<1,0><.5,s2><-.5,s2><-1,0><-.5,-s2><.5,-s2><1,0> rotate x*90 scale rad/3}
                texture{T_Silver_1A}
                }
#end