//      Copyright 2001 Andrew Bowcock
#debug "Parsing 'slospace.inc'\n"

#declare glow=.5;
#declare translucent = material{texture{pigment{rgbt <0,0,0,1>}}
                                interior{ior 1.01 media{emission<.2,.2,.2> density {waves}}    
                                        fade_distance  25 fade_power 1.5}}
                                        
#declare hardrings =material{texture{pigment{rgb .5} finish{ambient glow}}}
#declare rings = material{texture{pigment{rgbt <0,0,0,1>}}
                                interior{media{emission<.2,.2,.2> scattering{2,rgb <1,1,1>} density {waves turbulence 5} }    
                                        }}//fade_distance  25 fade_power 1.5}}
                                
        #declare dsun=1392;
        #declare dmercury=4.88;
        #declare dvenus=12.104;
        #declare dearth=12.756;
        #declare dmars=6.787;
        #declare djupiter=137;
        #declare dsaturn=112;
        #declare duranus=51.8;
        #declare dneptune=49.5;
        #declare dpluto=3;

#macro sun()
        light_source{<0,0,0> colour <.8,.8,.6>*2
        looks_like{sphere{<0,0,0>,.08
        hollow
        pigment {colour rgbt<1,.7,.4,.3>}
        interior{media{//scattering{1,<.1,.1,.1>}
                        absorption<.2,.3,.6>
                        emission<.8,.8,.4>*3
                        density {spherical scale .1 }
                      }    
        fade_distance  .5 fade_power 1.5
        } }
        } shadowless}
#end

#declare sun2=
        light_source{<0,0,0> colour .1 //<3,3,3>
        looks_like{sphere{<0,0,0>,dsun/2
        hollow
        pigment {colour rgbt<.3,.2,.1,.3>}
        interior{media{//scattering{1,<.1,.1,.1>}
                        absorption<.2,.3,.6>
                        emission<.08,.08,.04>
                        density {spherical scale dsun/2*1 }
                      }    
        fade_distance  .05 fade_power 1.5
        } }
        } shadowless}



#declare mercury=
        sphere{<0,0,0>,dmercury/2 pigment{
        #if (quality>5) image_map{gif "mercurysurface.gif" map_type 1}
        #else colour Red
        #end
        }
        finish{ambient glow}
        //finish{roughness 10}
        }

#declare venus=
        sphere{<0,0,0>,dvenus/2 pigment{
        #if (quality>5) image_map{gif "venussurface.gif" map_type 1}
        #else colour Green
        #end
        }finish{ambient glow}
        //finish{roughness 10}
        }

#declare mars=
        sphere{<0,0,0>,dmars/2 pigment{
        #if (quality>5) image_map{gif "marssurface.gif" map_type 1 }rotate<0,90,0>
        #else colour rgb<.8,.5,.4>
        #end
        }
        finish{ambient glow}
        }


#declare earth=
   union{
    sphere{<0,0,0>,dearth/2 pigment{#if (quality>5) image_map{gif "earth.gif" map_type 1}#else colour Blue #end }    finish{ambient glow}}
    #if (quality>5)
    
    
    sphere{<0,0,0>,dearth/2*1.04  hollow
        pigment {colour rgbt<0,0,0,1>}
        interior{media{scattering{1,<.5,.5,.5>} absorption<.4,.4,.4> emission<.05,0,.05> density {spherical scale 10 } }    
        fade_distance  .1 fade_power 2 } }
    #end
         }

#declare jupiter=
        sphere{<0,0,0>,djupiter/2 pigment{
        #if (quality>5) image_map{gif "jupitersurface.gif" map_type 1 }turbulence 1  rotate<0,90,0>
        #else colour rgb<.8,.5,.4>
        #end
        }
        finish{ambient glow}
        }


#declare saturn=
     #declare d1=261;
     #declare t1=20;
     #declare d2=207;
     #declare t2=26;
     #declare d3=149;
     #declare t3=4;
     #declare solidsat=sphere{<0,0,0>,dsaturn/2 pigment{
          #if (quality>5) image_map{gif "saturnsurface.gif" map_type 1 } turbulence 1  rotate<0,90,0>
          #else colour rgb<.4,.5,.5>
          #end
          }
          finish{ambient glow}
          }
          #if (quality>5)
                  union{
                          torus{d1/2,t1/2 scale <1,0.02,1> hollow material{hardrings}}
                          torus{d2/2,t2/2 scale <1,0.02,1> hollow material{hardrings}}
                          torus{d2/2,t2/2 scale <1,0.02,1> hollow material{hardrings}}
                          solidsat
                  }
          #else solidsat
          #end

#declare uranus=
        sphere{<0,0,0>,duranus/2 pigment{
        #if (quality>5) image_map{gif "uranussurface.gif" map_type 1 } rotate<0,90,0>
        #else colour rgb<.8,.5,.4>
        #end
        }}

#declare neptune=
        sphere{<0,0,0>,dneptune/2 pigment{
        #if (quality>5) image_map{gif "neptunesurface.gif" map_type 1 } rotate<0,90,0>
        #else colour rgb<.8,.5,.4>
        #end
        }}

#declare pluto=
        sphere{<0,0,0>,dpluto/2 pigment{
        #if (quality>5) image_map{gif "plutosurface.gif" map_type 1 } rotate<0,90,0>
        #else colour rgb<.8,.5,.4>
        #end
        }}
