// Persistence of Vision Ray Tracer Scene Description File
// File: CLock.pov
// Vers: 3.1
// Desc: This file will become the include file for the clock face and 
//       be included in Grandfather.inc
// Date: 04/10/01
// Auth: Josh English, image maps by David Jones
//

#version 3.1;
#version unofficial MegaPov 0.7;

// ----------------------------------------
//plane { y, -9 pigment {color rgb <0.7,0.5,0.3>}}

// clock will start at y=60 fo rthe center of the face

// facepos declare the center of the clock, the next three variables depend on
// facepos to be declared.

#ifndef (facepos)
  #declare facepos = <0,0,-.1>;
#end

#declare hourpos = facepos + <0,0,-0.15>;
#declare mintpos = facepos + <0,0,-0.20>;
#declare secdpos = facepos + <0,0,-0.25>;

// These variables will allow us to move the hands of the clock, rotation is a
// numerical value that is used later in rotate secondrotation*z.
#ifndef (secondrotation)
  #declare secondrotation = -6*clock;
#end
#ifndef (minuterotation)
  #declare minuterotation = 8/12*360; // 40 minutes
#end
#ifndef (hourrotation)
  #declare hourrotation = 2/12*360; // 2pm
#end

// We may need more than this  
//#declare CamShot=11;    
#if (CamShot <= 10)
 #declare dist1 = 0; // Two amounts of distortion
#else
 #declare dist1 = 1;
#end

// These 16 values control the bezier curves. We will add various amounts to these
// #declare c00 = <-9, 9,0> + dist2*<sin(clock),cos(clock)*2, pow(sin(clock),2)>

#if (CamShot <=17)
  #declare clkshft = clock-27;
  #declare kurl = 1-cos((pi/2)*(anim_clock-27)/10);
#else
  #declare clkshft = 10;
  #declare kurl = 1;
#end  

#declare c00 = <-9, 9,0>
                 + dist1*<-4*sin(pi*clkshft/7),(clkshft/7)+2.5*sin(clkshft/4),0>;
#declare c01 = <-3, 9,0>
                 + dist1*<3.5*pow(1-cos(clkshft/pi),1.5) ,(clkshft/7)-(8/3)*sin(clkshft/5) ,0>;
#declare c02 = < 3, 9,0>
                 + dist1*<0 ,(clkshft/7) ,0>;
#declare c03 = < 9, 9,0>
                 + dist1*<3*sin(pi*clkshft/14),(clkshft/7)-3.5*(1-cos(pi*clkshft/3)),-kurl>;

#declare c04 = <-9, 3 ,0> -2*z*kurl*dist1
                 + dist1*<3.5*pow(1-cos(clkshft/pi),1.5) ,-(8/3)*sin(clkshft/5) + (clock-27)/7,0>;
#declare c05 = <-3, 3 ,0> -2*z*kurl*dist1
                 + dist1*<0 ,0 + (clock-27)/7,-5*clkshft/21>;
#declare c06 = < 3, 3 ,0> -2*z*kurl*dist1
                 + dist1*<3*sin(clkshft/2),2*(1-cos(clkshft/3)) + (clock-27)/7,0>;
#declare c07 = < 9, 3 ,0> -2*z*kurl*dist1
                 + dist1*<-4*sin(pi*clkshft/7),2.5*sin(clkshft/4) + (clock-27)/7,-2*kurl>;

#declare c08 = <-9,-3,0> -3.5*z*kurl*dist1
                 + dist1*3*<-clkshft/21,clkshft/21 - (clkshft)/7,0>;
#declare c09 = <-3,-3 ,0> -3.5*z*kurl*dist1
                 + dist1*5*sin( pi*clkshft/42)*<cos( clkshft),sin(clkshft)-(clkshft)/7,0>;
#declare c10 = < 3,-3,0> -3.5*z*kurl*dist1
                 + dist1*5*sin(-pi*clkshft/42)*<sin(-clkshft),cos(clkshft)-(clkshft)/7,0>;
#declare c11 = < 9,-3,0> -3.5*z*kurl*dist1
                 + dist1*4*<clkshft/14,clkshft/17.5 - (clkshft)/7,0>;
                  
#declare c12 = <-9,-9,0> -8*z*kurl*dist1
                 - dist1*<clkshft/21,7*sin((7*pi/2)*(clkshft/21)) - (clkshft/10),0>;
#declare c13 = <-3,-9,0> -8*z*kurl*dist1
                 - dist1*<         0,7*sin((9*pi/2)*(clkshft/21)) - (clkshft/10),0>;
#declare c14 = < 3,-9,0> -8*z*kurl*dist1
                 - dist1*<         0, 4*sin((13*pi/2)*(clkshft/21)) - (clkshft/10),0>;
#declare c15 = < 9,-9,0> -8*z*kurl*dist1
                 - dist1*<         0,4*sin((11*pi/2)*(clkshft/21)) - (clkshft/10),0>;

// Face
bicubic_patch  {
	type 1
	flatness 0.0 u_steps 4 v_steps 4
	facepos+c00, facepos+c01, facepos+c02, facepos+c03,
	facepos+c04, facepos+c05, facepos+c06, facepos+c07,
	facepos+c08, facepos+c09, facepos+c10, facepos+c11,
	facepos+c12, facepos+c13, facepos+c14, facepos+c15
	uv_vectors  <0, 1>,<1, 1>, <1, 0>, <0, 0>
	uv_mapping
	texture {
		pigment  {
			image_map { tga "clokface.tga" } }
		normal {
		  bump_map { tga "clokfacebump.tga" } 
		  bump_size 3 }
		finish { ambient 0.5 }
	}
}

//Hour Hand
bicubic_patch  {
	type 1
	flatness 0.0 u_steps 4 v_steps 4
	hourpos+c00, hourpos+c01, hourpos+c02, hourpos+c03,
	hourpos+c04, hourpos+c05, hourpos+c06, hourpos+c07,
	hourpos+c08, hourpos+c09, hourpos+c10, hourpos+c11,
	hourpos+c12, hourpos+c13, hourpos+c14, hourpos+c15
	uv_vectors  <0, 1>,<1, 1>, <1, 0>, <0, 0>
	uv_mapping
	texture {
		pigment {image_map { tga "hourhand.tga" } 
		         translate <-0.5,-0.5,0> rotate hourrotation*z translate <0.5,0.5,0> }
     finish { ambient 0.5 } } }

//Minute Hand
bicubic_patch  {
	type 1
	flatness 0.0 u_steps 4 v_steps 4
	mintpos+c00, mintpos+c01, mintpos+c02, mintpos+c03,
	mintpos+c04, mintpos+c05, mintpos+c06, mintpos+c07,
	mintpos+c08, mintpos+c09, mintpos+c10, mintpos+c11,
	mintpos+c12, mintpos+c13, mintpos+c14, mintpos+c15
	uv_vectors  <0, 1>,<1, 1>, <1, 0>, <0, 0>
	uv_mapping
	texture {
		pigment {image_map { tga "minutehand.tga" } 
		         translate <-0.5,-0.5,0> rotate minuterotation*z translate <0.5,0.5,0> }
     finish { ambient 0.5 } } }

//Second Hand
bicubic_patch  {
	type 1
	flatness 0.0 u_steps 4 v_steps 4
	secdpos+c00, secdpos+c01, secdpos+c02, secdpos+c03,
	secdpos+c04, secdpos+c05, secdpos+c06, secdpos+c07,
	secdpos+c08, secdpos+c09, secdpos+c10, secdpos+c11,
	secdpos+c12, secdpos+c13, secdpos+c14, secdpos+c15
	uv_vectors  <0, 1>,<1, 1>, <1, 0>, <0, 0>
	uv_mapping
	texture {
		pigment {image_map { tga "secondhand.tga" } 
		         translate <-0.5,-0.5,0> rotate secondrotation*z translate <0.5,0.5,0> }
     finish { ambient 0.5 } } }

#ifndef (HelloGrandfather)
#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -20.0>
  direction 1*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

background { rgb 1 }

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

camera
{
  location  <0.0, 0.5, -30.0>
  direction 1*z
  right     4/3*x
  look_at   facepos
}

#end