// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#declare HelloGrandfather = true;
#include "textures.inc"
#macro Frame(wid,dep,rad,tex)
   #declare xe = wid/2;
   #declare ze = dep/2;
   union { 
		intersection {
		  cylinder { <-xe,0,-(ze-rad)> <xe,0,-(ze-rad)> rad }
		  cylinder { <-(xe-rad),0,-ze> <-(xe-rad),0, (ze)> rad } }
		intersection {
		  cylinder { <-(xe),0,-(ze-rad)> < xe,0,-(ze-rad)> rad  }
		  cylinder { < (xe-rad),0,-(ze)> < (xe-rad),0, (ze)> rad  } }
		intersection {
		  cylinder { <-(xe),0, (ze-rad)> < xe,0,(ze-rad)> rad  }
		  cylinder { < (xe-rad),0,-(ze)> < (xe-rad),0, (ze)> rad  } }
		intersection {
		  cylinder { <-xe,0, (ze-rad)> < xe,0, (ze-rad)> rad  }
		  cylinder { <-(xe-rad),0,-(ze)> <-(xe-rad),0, (ze)> rad  } }
		
		cylinder { <-(xe-rad),0,-(ze-rad)> < (xe-rad),0,-(ze-rad)> rad }
		cylinder { <-(xe-rad),0,-(ze-rad)> <-(xe-rad),0, (ze-rad)> rad }
		cylinder { <-(xe-rad),0, (ze-rad)> < (xe-rad),0, (ze-rad)> rad }
		cylinder { < (xe-rad),0,-(ze-rad)> < (xe-rad),0, (ze-rad)> rad }
		#local c=2*(wid+dep);
		#local r1 = atan2(ze,xe);
		#local r2 = pi-r1;
		#local r3 = pi+r1;
		#local r4 = 2*pi - r1;
     texture { radial // rotate <0,ri,0>
               texture_map { [0.000 tex ] [(r1/(2*pi)) tex ] 
                             [(r1/(2*pi)) tex rotate  90*y] [(r2/(2*pi)) tex rotate  90*y]
                             [(r2/(2*pi)) tex rotate 180*y] [(r3/(2*pi)) tex rotate 180*y]
                             [(r3/(2*pi)) tex rotate 270*y] [(r4/(2*pi)) tex rotate 270*y]
                             [(r4/(2*pi)) tex] [1 tex] } } 

   }
#end

//
#declare mypig =  pigment {wood frequency 19 turbulence 0.05 scale <1,1,3> } 
//#declare mypig = pigment{ rgb 1 }
#declare basecutout =
prism {
	quadratic_spline
	linear_sweep
	-13, 	//Base height
	13, 	//Top height
	11,
	<0.01935, -0.20000>,
	<-0.00645, -0.00645>,
	<-0.00645, 1.000000>,
	<0.17419, 0.53548>,
	<0.34194, 0.81935>,
	<0.60000, 0.60000>,
	<0.47097, 0.35484>,
	<0.70323, 0.25161>,
	<1.00000, 0.22581>,
	<0.93548, 0.00645>,
	<-0.00645, -0.00645>
	sturm
	rotate -90*x
	scale <1,1,1>}
		
//#declare grandfather = 
//union {
//  box { <-11.5,0,0> <11.5,78,12> }
//  difference { box {<-12.5,0,0> <12.5,6,12.5> } 
//               cylinder { <0,0,-1> <0,0,13> 2 }
//               object { basecutout scale <6,3,1> } }
//  object { Frame(25,13,0.5,mypig) translate <0,6,6> }
//  object { Frame(25,13,0.5,mypig) translate <0,6.25,6> }
//  pigment {rgb 1 filter 0.7}
//}

//cylinder { <0,60,-0.01> <0,60,0.01> 9 pigment { rgb <1,1,0> filter 0.8} }
//object { grandfather  }

#declare panelTex = texture {
  pigment { wood frequency 2 scallop_wave
            scale <1,6,1> 
            rotate <17,5,-3> 
            turbulence 0.05
            octaves 4
            lambda 1.5
            color_map { [0.0 color rgb <0.25, 0.10, 0.10>]
                        [0.3 color rgb <0.25, 0.10, 0.10>]
                        [0.6 color rgb <0.60, 0.15, 0.10>]
                        [0.6 color rgb <0.70, 0.31, 0.20>]
                        [1.0 color rgb <0.25, 0.10, 0.10>] } 
            warp { repeat x*4 offset <0,16,20> } } 
  normal { gradient x scale 4 scallop_wave } 
  finish { phong 0.25 phong_size 3 } }
// end texture

#declare dowelTex = texture {
  pigment { wood frequency 2 scallop_wave
            scale <1,6,1> 
            rotate <17,5,-3> 
            turbulence 0.05
            octaves 4
            lambda 1.5
            color_map { [0.0 color rgb <0.25, 0.10, 0.10>]
                        [0.3 color rgb <0.25, 0.10, 0.10>]
                        [0.6 color rgb <0.60, 0.15, 0.10>]
                        [0.6 color rgb <0.70, 0.31, 0.20>]
                        [1.0 color rgb <0.25, 0.10, 0.10>] } 
            } 
  //normal { gradient x scale 4 scallop_wave } 
  finish { phong 0.5 phong_size 1 } }
// End Texture



#declare Grandfatherclock = union {

  difference { box {<-12.5,0,0> <12.5,6,12.5> } 
              // cylinder { <0,0,-1> <0,0,13> 2 }
               object { basecutout scale <7,5,1> } 
               object { basecutout scale <-7,5,1> }
       texture { panelTex }}

object { Frame(25,12,2,dowelTex) translate <0,6,6> }
object { Frame(24,11,0.5,dowelTex) translate <0,8,5> }
cylinder {<11.25,8,1><11.25,68,1> 0.5 pigment { mypig }}
cylinder {<-11.25,8,1><-11.25,68,1> 0.5 pigment { mypig }}
box{ <-11.25,8,1><11.25,11,1.5> texture { panelTex }}
box {<-11.75,11.01,1> <-9,48,1.05> texture { panelTex } }
box {< 11.75,11.01,1> < 9,48,1.5> texture { panelTex } }
// Side Wall
box{< -11.75,8,1.15> <-11.5,66,10> pigment { mypig } }
box{< 11.75,8,1.15> <11.5,66,10> pigment { mypig } }
// Back Wall
box { <-11.75,8,9.75> <11.75,66,10> pigment { LightWood } }
// Division
sphere { <11.25,48,1> 0.75 pigment { mypig } }
sphere { <-11.25,48,1> 0.75 pigment { mypig } }

#if (CamShot=11)
#else
  box { <-11.25,47.5,0.75> <11.25,48.5,1.2> pigment { mypig } }
#end  

// Glass
box { <-11.5,11.01,1> <11.5,48,1.05> 
      pigment { rgbf <1,1,1,0.9> }
      normal { bozo scale 300 }
      finish { reflection 0.05 } }


// top Decoration
#declare SmallCurve = 
intersection { 
  box { <-4,0,-1> <0,4,10> }
  difference { 
    cylinder { <0,0,-0.5> <0,0,10.5> 4 } 
    cylinder { <0,0,-0.6> <0,0,10.6> 3 } }
  pigment {mypig } }
#declare BigCurve = 
intersection { 
  box { <5,0,-1> <0,-5,10> }
  difference { 
    cylinder { <0,0,-0.5> <0,0,10.5> 5 } 
    cylinder { <0,0,-0.6> <0,0,10.6> 4 } }
  pigment {mypig } }

object { SmallCurve translate <-8,66,1> }
object { SmallCurve translate <0,74,1> }
object { BigCurve   translate <-8,74,1> }
object { SmallCurve translate <-8,66,1> scale <-1,1,1> }
object { SmallCurve translate <0,74,1> scale <-1,1,1>  }
object { BigCurve   translate <-8,74,1>  scale <-1,1,1> }

union {
  box { <-11.25,48,1> <11.25,66,1.25>  }
  cylinder { <-8,66,1> <-8,66,3> 4 }
  cylinder { < 8,66,1> < 8,66,3> 4 }
  cylinder { < 0,74,1> <0,74,3> 4 }
  box { <-4,74,1> <4,66,3>  }
  difference {
    box { <-8,74,1> <8,66,3> }
    cylinder { <-8,74,0> <-8,74,4> 4 }
    cylinder { < 8,74,0> < 8,74,4> 4 }}
  texture { panelTex }
}

// Pendulum by D Jones
union {
  cylinder { <0,0,0> <-3,-15,0> 1 }
  cylinder { <0,0,0> <3,-15,0> 1   }
  box { <-5, -14, -1> < 5, -16,  1> }
  cylinder { <-3, -15, 0>, <-3, -40, 0>, 1 }  
  cylinder { <0, -15, 0>, <0, -40, 0>, 1 }  
  cylinder { <3, -15, 0>, <3, -40, 0>, 1 }  
  box { <-5, -39, -1> < 5, -41,  1> }
  cylinder { <-3,-40, 0> < 0,-48, 0> 1 }
  cylinder { < 3,-40, 0> < 0,-48, 0> 1 }
  cylinder { <0,-45,-1> <0,-45, 1> 5 }
  texture {  pigment { color Gold }
             finish { phong 0.25  metallic reflection 0.75 } }
  rotate <0,0,6*sin(pi*anim_clock)> 
  translate <0,60,6> } 


#include "clock.pov"

}// end Grandfather Clock

