//------------------------------------------------------------FICHIER-dc_rain
// Persistence Of Vision raytracer version 3.1
// dc_rain
// 02 mai 2001
// derniere modification : 16/06/01
#version 3.1;
global_settings { assumed_gamma 2.2 }
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"      
#include "glass.inc"
//-----------------------------------------------------------------camera----
camera { location <0, 0, 0> up <0, 1, 0> right <320/240, 0, 0>
//rotate <90, 0, 180> translate <0, -1499, 1700>   
//rotate <90, 0, 180> translate <0, -10499, 1700> //devant la maison
rotate <90, 0, 165> translate <1600, 1100, 1700>//vue de cote de la fenetre 
//rotate <90, 0, 180> translate <1700, 1200, 1700> //en face de la fenetre 
//rotate <180, 0, 0> translate <0, 0, 200000> //pour voir de tres tres haut 
       }    
//light_source {<0, 0, 1700> color White}  
//light_source {<1600, 1100, 1700> color White}
light_source {<0, 0, 10000> color rgb<1.5-1*clock/650,1.5-1*clock/650,1.5-1*clock/650>}
//light_source {<0, 0, 200000> color White} 
//light_source {<100, -10000, 1000> color White} 
//variable aleatoire
#declare R1 = seed(clock*1000);    

//------------------------------------------------------Le-ciel-------------- 
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.9, 0.8, 1> ]
            [0.6-(0.6*clock/650) P_Cloud3 scale <0.05, 0.40, 0.05> rotate z*2 ]
            [1-(0.5*clock/650) P_Cloud3 scale <0.25, 0.15, 0.50> ]
        }
    }
    rotate <90, 0, 90>
}     
 
//------------------------------------------------------La-piece-------------
difference {
  box{<-2250, -1750, -200>< 2250,  1750,  2400>}  
  box{<-2000, -1500, 0>< 2000,  1500,  2200>}
  box{<1400, 1400, 1450>< 1995,  1635,  1950>} 
  box{<1460, 1400, 1500>< 1940,  1800,  1900>}  
  texture { pigment{granite color_map{[0.0 rgb <.6,.9,.9>] [0.7 rgb <.4,.55,.55>] [1.0 rgb <.2,.45,.45>]}scale 150} 
  normal { crackle , 50 turbulence 2 ramp_wave } normal {granite 1 scale 10}}
}  

//---------------------------------------------------------La fenetre-----------
union { 
difference { 
  box{<1460, 1620, 1500>< 1940,  1650,  1900>} 
  box{<1500, 1600, 1490>< 1900,  1700,  1910>} 
  cylinder{<1500,1620,1540><1500,1620,1860>10}
  cylinder{<1900,1620,1540><1900,1620,1860>10} 
  sphere{<1500,1620,1540>10}   
  sphere{<1500,1620,1860>10} 
  sphere{<1900,1620,1540>10} 
  sphere{<1900,1620,1860>10} 
  texture { pigment { wood color_map {
            [ 0.0     rgbft <1.0, 0.85, 0.5, 0, 0> ]
            [ 0.5     rgbft <0.9, 0.7, 0.46, 0, 0> ]
            [ 0.7     rgbft <0.9, 0.7, 0.46, 0, 0> ]
            [ 1.0     rgbft <1.0, 0.85, 0.5, 0, 0> ]
         } turbulence 0.02 octaves 4 lambda 3 ramp_wave scale 0.175 } } } 
difference { 
  box{<1500, 1620, 1500>< 1900,  1650,  1900>} 
  box{<1460, 1600, 1540>< 1940,  1700,  1860>}
  cylinder{<1500,1620,1540><1900,1620,1540>10}
  cylinder{<1500,1620,1860><1900,1620,1860>10}  
  sphere{<1500,1620,1540>10}   
  sphere{<1500,1620,1860>10} 
  sphere{<1900,1620,1540>10} 
  sphere{<1900,1620,1860>10} 
  texture { pigment { wood color_map {
            [ 0.0     rgbft <1.0, 0.85, 0.5, 0, 0> ]
            [ 0.5     rgbft <0.9, 0.7, 0.46, 0, 0> ]
            [ 0.7     rgbft <0.9, 0.7, 0.46, 0, 0> ]
            [ 1.0     rgbft <1.0, 0.85, 0.5, 0, 0> ]
         } turbulence 0.02 octaves 4 lambda 3 ramp_wave rotate 90*x } } }
}
 
union{    
  box{<1500, 1630, 1540>< 1900,  1635,  1860>} 
  texture{T_Glass1 }
  interior { ior 1.5 }
} 
#if (clock>150)
difference { 
#include "gouttes.inc" 
object{goutte translate<1500,1635,1540>}
  box{<1500, 1600, 1540>< 1900,  1635,  1860>}  
  texture{T_Glass1 }
  interior { ior 1.33 }
}
#end                                 
//---------------------------------------------------------Le sol------
object { plane {z, 0} 
 texture { pigment{granite color_map{[0.0 rgb <.55,.75,.35>] [0.7 rgb <.25,.35,.15>]
  [1.0 rgb <.35,.65,.25>]}scale .5}normal {granite 1 scale 2.5}}
}                                         
      
#declare Candle =union{lathe{linear_spline 27,
<0.0000000000,0.0000000000>,
<7.240741E-02,3.003827E-02>,
<8.423334E-02,0.0392000000>,
<9.441235E-02,5.047037E-02>,
<0.1028877000,6.362963E-02>,
<0.1096667000,0.0783000000>,
<0.1147864000,9.422963E-02>,
<0.1184025000,0.1116704000>,
<0.1207000000,0.1310000000>,
<0.1218333000,0.1525333000>,
<0.1218333000,0.1763333000>,
<0.1207000000,0.2024000000>,
<0.1182444000,0.2312370000>,
<0.1135222000,0.2653630000>,
<0.1054000000,0.3078000000>,
<9.324814E-02,0.3600605000>,
<7.845185E-02 0.4176173000>,
<0.0629000000,0.4744333000>,
<4.822963E-02,0.5254210000>,
<3.507037E-02,0.5692901000>,
<0.0238000000,0.6057000000>,
<1.473333E-02,0.6344136000>,
<7.933334E-03,0.6556087000>,
<0.0034000000,0.6695666000>,
<1.007407E-03,0.6769086000>,
<1.259259E-04,0.6796135000>,
<0.0000000000,0.6799999000>
 texture{ pigment{rgbt <0.7,0,0,0.7-.3*rand(R1)>} finish {ambient 0.7}}
 interior{ media{ emission 0.5 scattering{1,.01} intervals 10  samples 1, 15 confidence 0.9999  variance 1/1000 
 density { radial turbulence .35 }}}
hollow 
scale<1.25,2,1.25>*(2.5-0.5*rand(R1)) rotate<2-4*rand(R1),0,2-4*rand(R1)> translate y*1.25}  //

intersection{
cylinder{y*-8,y*1,.5 pigment{rgb<1,1,.97>} finish{ambient .5 diffuse .2}}
sphere{<.05,1,0>,.5 inverse pigment{rgb 1} finish{ambient .5 diffuse .2}}}
cylinder{y*.8,y*1.5,.1 pigment{rgb 0}} 
union {
  cylinder {<0.5, -2, 0>,<0.5, 1, 0>,  0.1 rotate -130*y } 
  cylinder {<0.5, -4, 0>,<0.5, 1, 0>,  0.1 rotate -110*y }
  cylinder {<0.5, -1.5, 0>,<0.5, 1, 0>,  0.1 rotate -60*y }
  cylinder {<0.5, -2, 0>,<0.5, 1, 0>,  0.1 rotate -170*y }
  pigment{rgb<1,1,1>} finish{ambient .6 diffuse .2}
}
}

object{Candle rotate 90*x scale 20 translate <1900, 1565, 1600>}  

light_source {<1900, 1565, 1650> color <0.8+0.2*rand(R1),0.5,0.5> shadowless} 

#include "bougoire.inc" 
object{bougoire rotate 90*x scale 25 translate<1900,1565,1450> texture{New_Brass}}  
          
#include "poignee.inc" 
object{poignee rotate 180*x scale 15 translate<1480,1600,1700> pigment {Gray}}  

union{
cylinder {<1940, 1625, 1750>,<1940, 1625, 1850>,  5}
sphere {<1940,1625,1750>5} sphere {<1940,1625,1850>5} 
cylinder {<1940, 1625, 1550>,<1940, 1625, 1650>,  5}
sphere {<1940,1625,1550>5} sphere {<1940,1625,1650>5}
pigment {Black} } 
     
//-------//-------//-------//-------//-------//-------//-------//
// tree3-b.pov
//
// Sample scene for the mesh tree.
//
// By: Paul T. Dawson

//-------//-------//-------//-------//-------//-------//-------//
// Macro include files.
        #include "meshcone.inc"
        #include "meshtree.inc"
//-------//-------//-------//-------//-------//-------//-------//
// Build one tree.
        #declare Entire_Tree = MeshTree (8,8,8,12,20,140,10,4,5,2,3,1,2,   
        texture { pigment { Cherry_Wood } },    // T_Tree_1
        texture { pigment { Jade } },           // T_Tree_2
        9432  // Seed_1
        )

//-------//-------//-------//-------//-------//-------//-------//
// Show the tree.
        object { Entire_Tree scale 300 rotate 90*x translate <500, 20000,0>}
        object { Entire_Tree scale 300 rotate 90*x translate <3000, 25000,0>}
        object { Entire_Tree scale 300 rotate 90*x translate <20000, 40000,0>}
//------------------------------------------------------La-maison-------------
union { 
  union {
    cylinder {<-1500, -1800, 1400>,<-1500, 1810, 1400>,  400}
    box{<-1100, -1800, 0>< -1900,  -1810,  1400>}
    texture { pigment { Cherry_Wood } }
  }
  object{box{<-3100, 0, -500>< 3100,  20,  2300>} rotate -60*x translate<0,-2000,2500>} 
  object{box{<-3100, 0, -500>< 3100,  20,  2300>} rotate 60*x translate<0,2000,2500>} 
  box{<2600, 0, 0>< 3000,  1000,  4500>} 
  light_source {<750, 0, 1000> color rgb<3,2,2>} 
difference {
  box{<-3000, -2000, 0>< 3000,  2000,  4000>}  
  box{<-2800, -1800, -10>< 2800,  1800,  2000>}
  object{box{<-3100, -2000, 0>< 3100,  0,  3000>} rotate -60*x translate<0,-2000,2500>} 
  object{box{<-3100, 0, 0>< 3100,  2000,  3000>} rotate 60*x translate<0,2000,2500>} 
  box{<0, -2010, 800>< 1500,  -1790,  1700>}
  cylinder {<-1500, -2010, 1400>,<-1500, 1790, 1400>,  400}
  box{<-1100, -2010, 0>< -1900,  -1790,  1400>}  
  material { texture { pigment { color rgb <.7, .5, .5> } normal{ bozo , 4 } scale  25 } } 
}rotate 0*z texture{pigment {Cherry_Wood}} 
translate <15000, 45000,0>
}       

#if (clock<99)
height_field{ tga "titre.tga" smooth water_level 0.5+0.5*clock/100
scale <320,20,240> translate <-160,0,-120> rotate 180*z 
translate <0, 229, 1700> rotate <0,0,-15> translate <1600, 1100, 0>
texture{pigment {color rgb <.5,.5,.5> transmit 0} finish{ambient 0}}}  
 
height_field{ tga "fond.tga" smooth water_level 0.5+0.5*clock/100
scale <320,15,240> translate <-160,0,-120> rotate 180*z 
translate <0, 229, 1700> rotate <0,0,-15> translate <1600, 1100, 0>
texture {New_Brass finish{ambient 1}}}  
#end

#if (clock>98)
#if (clock<150)
height_field{ tga "titre.tga" smooth water_level 0.5+0.5*99/100
scale <320,20,240> translate <-160,0,-120> rotate 180*z 
translate <0, 229, 1700> rotate <0,0,-15> translate <1600, 1100, 0>
texture{pigment {color rgb <.5,.5,.5> transmit 0+1*(clock-100)/50} finish{ambient 0}}}
 
height_field{ tga "fond.tga" smooth water_level 0.5+0.5*99/100
scale <320,15,240> translate <-160,0,-120> rotate 180*z 
translate <0, 229, 1700> rotate <0,0,-15> translate <1600, 1100, 0>
texture { pigment { rgb <0.70, 0.56, 0.37> transmit 0+1*(clock-100)/50}
finish { ambient 1-1*(clock-100)/50 diffuse 1.0 brilliance 15 phong 0.41 phong_size 5}}
} 
#end
#end