#declare __maxBoulders = 100;
#declare __boulderCount = 0;
//#declare __time = 0;
#declare __boulderLocs = array[ __maxBoulders ];
#declare __boulderVels = array[ __maxBoulders ];
#declare __boulderTimes = array[ __maxBoulders ];
#declare __boulderHasHitShield = array[ __maxBoulders ];
#declare __boulderHitRotationVec = array[ __maxBoulders ];
#declare __timeQuantum = 0.01;

#macro LaunchBoulder( pLocation, pVelocity, pTime )
  #declare __boulderLocs[ __boulderCount ] = pLocation;
  #declare __boulderVels[ __boulderCount ] = pVelocity;
  #declare __boulderTimes[ __boulderCount ] = pTime;
  #declare __boulderHasHitShield[ __boulderCount ] = -1;
  #declare __boulderHitRotationVec[ __boulderCount ] = <0, 0, 0>;  
  #declare __boulderCount = __boulderCount + 1;
#end

#macro DeleteRow( rowCount )
  #declare i = rowCount;
  #while (i < __boulderCount - 1)
    #declare __boulderLocs[i] = __boulderLocs[i+1];
    #declare __boulderVels[i] = __boulderVels[i+1];
    #declare __boulderHasHitShield[i] = __boulderHasHitShield[i+1];
    #declare __boulderHitRotationVec[i] = __boulderHitRotationVec[i+1];    
    #declare i = i + 1;
  #end
  #declare __boulderCount = __boulderCount - 1;  
#end

/***
#macro DrawBoulders( pTime )
#debug concat( "time now = ", str( pTime, 4, 4), "\n" )
  #if (pTime < __time)
    #error concat( "You cannot go backwards in time! Current time = ", str(__time,4,4), ", requested time = ", str( pTime, 4, 4,) )
  #end  
  #while (__time < pTime)
    #local i = 0;
    #while (i < __boulderCount)
      // Displacement: s = ut + 1/2at^2
      #declare newPos = __boulderLocs[i] + __boulderVels[i]*__timeQuantum + 0.5*9.8*-y*__timeQuantum*__timeQuantum;
      // Velocity: v = u + at
      #declare newVel = __boulderVels[i] + 9.8*-y*__timeQuantum;

      #if ((__boulderHasHitShield[i] = -1) & (vlength( newPos-ShieldOrigin) < ShieldRadius))
#debug concat( "impact at time = ", str(__time, 4, 4), "\n" )
        #declare __boulderHasHitShield[i] = __time;
        #declare yAngle = degrees( acos( (newPos.y - ShieldOrigin.y) / ShieldRadius ) );
        #declare zAngle = degrees( atan( (newPos.x - ShieldOrigin.x) / (newPos.z - ShieldOrigin.z) ) );
        #declare __boulderHitRotationVec[i] = <0, yAngle, zAngle>;
      #end
            
      #declare __boulderLocs[i] = newPos;
      #declare __boulderVels[i] = newVel;      
      #declare i = i + 1;
    #end
    #declare __time = __time + __timeQuantum;
  #end

  #declare i = 0;
  #while ( i < __boulderCount )  
    difference {
      //sphere { 0, 2*m translate __boulderLocs[i] }
      object {CatapultStone translate __boulderLocs[i]}
      sphere { ShieldOrigin, ShieldRadius texture { pigment { color rgbt 1 } } }
      //texture { pigment { color rgb 0.8 } finish { ambient 0.9 } }
    }  
    #declare i = i + 1;
  #end  
#end
***/
#macro DrawBoulders( pTime, pIntersectShield )
  #local i = 0;
  #while (i < __boulderCount)
    #declare __time = __boulderTimes[ i ];
    #while (__time < pTime)
      // Displacement: s = ut + 1/2at^2
      #declare newPos = __boulderLocs[i] + __boulderVels[i]*__timeQuantum + 0.5*9.8*-y*__timeQuantum*__timeQuantum;
      // Velocity: v = u + at
      #declare newVel = __boulderVels[i] + 9.8*-y*__timeQuantum;

      #if ((__boulderHasHitShield[i] = -1) & (vlength( newPos-ShieldOrigin) < ShieldRadius))
#debug concat( "impact at time = ", str(__time, 4, 4), "\n" )
        #declare __boulderHasHitShield[i] = __time;
        #declare yAngle = degrees( acos( (newPos.y - ShieldOrigin.y) / ShieldRadius ) );
        #declare zAngle = degrees( atan( (newPos.x - ShieldOrigin.x) / (newPos.z - ShieldOrigin.z) ) );
        #declare __boulderHitRotationVec[i] = <0, yAngle, zAngle>;
      #end
            
      #declare __boulderLocs[i] = newPos;
      #declare __boulderVels[i] = newVel;      
      #declare __time = __time + __timeQuantum;
    #end
    #declare i = i + 1;
  #end

  #declare i = 0;
  #while ( i < __boulderCount )  
    #if (pIntersectShield)
      difference {
        //sphere { 0, 2*m translate __boulderLocs[i] }
        object {CatapultStone translate __boulderLocs[i]}
        sphere { ShieldOrigin, ShieldRadius texture { pigment { color rgbt 1 } } }
        //texture { pigment { color rgb 0.8 } finish { ambient 0.9 } }
      }  
    #else
#debug concat( "StoneLoc = <", str( __boulderLocs[i].x, 4, 4), ", ", str(__boulderLocs[i].y, 4, 4), ", ", str(__boulderLocs[i].z, 4, 4), ">\n")
      object {CatapultStone translate __boulderLocs[i]}
    #end  
    #declare i = i + 1;
  #end  
#end

#macro ComputeImpactPoints( pTime )
  #declare i = __boulderCount - 1;
  #declare expiryTime = 1;
  #while ( i >= 0 )
    #if (__boulderHasHitShield[i] > expiryTime)
      // Expire any old impact splshes
      #if ( pTime - __boulderHasHitShield[i] > expiryTime ) 
        DeleteRow( i )
      #else  
        #declare aVec = (__boulderHitRotationVec[i]);
        #declare hitTime = __boulderHasHitShield[i];
        #declare timeDiff = (pTime - hitTime); 
        #declare splashSize = timeDiff / expiryTime - (1/2);
        #declare splashSize = (0.25 - (splashSize * splashSize) ) * 4;
        // splashSize now runs from 0 at time = hitTime to 1 at time = hitTime + expiryTime/2 to 0 at hitTime + expiryTime
        texture {
          pigment {
            cylindrical
            color_map {
              [0                     color rgbt <1, 0, 0, 1>]
              [(1-0.2*splashSize)    color rgbt <1, 0, 0, 1>]
              [(1-0.05 * splashSize) color rgbt <1, 0, 0, 0>]
              [1                     color rgbt <1, 0, 0, 0>]
            }
            scale 75*m
            rotate aVec.y*-x
            rotate aVec.z*y    
          }
        }
      #end
    #end  
    #declare i = i - 1;
  #end  
#end

