#include "colors.inc"
#include "textures.inc"
#include "ConversionUnits.inc"
#include "glass.inc"
#include "metals.inc"

// An ornament -- of this castle!
#declare CastleOrnament = 
    union {
      object {
        union { #include "Castle.inc" }
        translate <0, 0, -50*m>
        scale 0.0005
        translate 5*mm*y
      }
      cylinder {
        <0, 0, 0>
        <0, 5*mm, 0>
        5*cm
        texture { pigment { color Green } }
      }
      
      difference {
        sphere {
          <0, 0, 0>
          5.5*cm
        }
        sphere {
          <0, 0, 0>
          5*cm
        }
        box { <-100, 0, 100> <100, -100, -100> }
        texture { T_Glass2 } interior { I_Glass }
      }
    }          

// The book spine will need to be scaled. It's 1 unit high, goes from -1 to 1 (x) and 1 unit deep
#declare Spine = 
    prism { // TransSweep001
      linear_sweep
      cubic_spline
      0.0,1.0
      37  // control points
      <-0.933199, 0.228239>,
      <-0.996649, 0.143256>,
      <-0.908832, 0.025641>,
      <-0.338269, -0.134139>,
      <0.485633, -0.130047>,
      <0.931624, 0.002849>,
      <1.004609, 0.174653>,
      <0.937477, 0.241919>,
      <0.860462, 0.305537>,
      <0.941223, 0.376946>,
      <0.994137, 0.445619>,
      <1.001018, 0.482917>,
      <0.992863, 0.499318>,
      <0.949229, 0.495332>,
      <0.917747, 0.44438>,
      <0.850249, 0.379151>,
      <0.782523, 0.292616>,
      <0.895234, 0.198746>,
      <0.941168, 0.123032>,
      <0.84664, 0.03299>,
      <0.474579, -0.051821>,
      <-0.306535, -0.054665>,
      <-0.737561, 0.026111>,
      <-0.930534, 0.096396>,
      <-0.87724, 0.19825>,
      <-0.788377, 0.296676>,
      <-0.869508, 0.407913>,
      <-0.938758, 0.458816>,
      <-0.966361, 0.499153>,
      <-0.997949, 0.499585>,
      <-0.999449, 0.485518>,
      <-0.995245, 0.448941>,
      <-0.944377, 0.392901>,
      <-0.86564, 0.303964>,
      <-0.933199, 0.228239>,
      <-0.996649, 0.143256>,
      <-0.908832, 0.025641>
    }


#macro CreateBook( pWidth, pHeight, pDepth, pCoverTexture, pSpineWriting, pWritingHeight, pWritingTexture )
  union {
    // Create the spine
    object {
      Spine
      scale <pWidth/2, pHeight, 0.1*pDepth >
      // The spine originally goes from 0.5 (open part) to 0(spine). As we're shifting back
      // along the z axis (ie getting more negative) we shift backwards the whole depth.
      translate -pDepth * z
      texture {pCoverTexture}
    }    
    box {
      <-pWidth/2, 0, 0>
      <-pWidth/2+3*mm, pHeight, -0.95*pDepth>
      texture {pCoverTexture}
    }  
    box {
      <pWidth/2, 0, 0>
      <pWidth/2-3*mm, pHeight, -0.95*pDepth>
      texture {pCoverTexture}
    }
    difference {  
      box {
        <-pWidth/2+3*mm, 3*mm, -3*mm>
        <pWidth/2-3*mm, pHeight-3*mm, -pDepth+3*mm>
      }
      cylinder {
        <-pWidth/2, 0, -pDepth + 0.025*pDepth>  
        <-pWidth/2, pHeight, -pDepth + 0.025*pDepth>  
        pDepth * 0.02
      }  
      cylinder {
        <pWidth/2, 0, -pDepth + 0.025*pDepth>  
        <pWidth/2, pHeight, -pDepth + 0.025*pDepth>  
        pDepth * 0.02
      }
      cylinder {
        <0, 0, -pDepth - pDepth>  
        <0, pHeight, -pDepth - pDepth>  
        pDepth * 1.04
      }        
      texture {
        pigment {
          gradient x
          color_map {
            [0 color rgb <0.7, .65, 0.15>]
            [1 color rgb <0.8, 0.75, 0.25>]
          }
          sine_wave
          scale 0.01
          turbulence 0.4            
        }
      }
    }
    
    #ifndef (Font)
      #declare Font="timrom.ttf"
    #end
    #debug pSpineWriting
    #if (strlen( pSpineWriting ) > 0)
      intersection {
        text {
          ttf Font pSpineWriting 1, 0
          translate -1*z
          translate -0.3*y
          scale <pWritingHeight, pWritingHeight, 1>
          rotate 90*z
          translate 2*cm*y
        }          
        cylinder { <0, 0, 3*pDepth> <0, pHeight, 3*pDepth> pDepth*4.025 }
        cylinder { <0, 0, 3*pDepth> <0, pHeight, 3*pDepth> pDepth*4.01 inverse }
        texture { pWritingTexture }
      }  
    #end  
  }  
#end
 

#macro SolveQuadratic( pA, pB, pC )
  // Return the positive root of ax^2 + bx + c = 0
  ((-pB + sqrt(pB * pB - 4 * pA * pC))/(2*pA))
#end
   
// Now create a bookcase
#declare r = seed( 5038 );
#macro CreateBookcase(pLength, pHeight, pDepth, pShelfSpacing, pHeightOfLowestShelfFromFloor, pTexture, pPopulate)
  // Bookcase goes from -Length/2 to Length/2, and from 0 to -pDepth with the back at 0, but the sides of the bookcase
  // come in 2cm, so remember this when placing books.
  union {
    #local counter = pHeightOfLowestShelfFromFloor;
    #while (counter < pHeight)
      box {
        <-pLength/2, counter, 0>
        <pLength/2, counter + 2*cm, -pDepth>
        texture {
          pTexture
          rotate <30*rand(r)-15, 30*rand(r)-15, 30*rand(r)-15>
          scale (1+(rand(r)-0.5)/5)
        }
      }  
      
      #if (pPopulate & (counter + pShelfSpacing < pHeight))
        #declare dist = -pLength/2+2*cm;
        #declare doUpright = false;
        #declare endPoint = (pLength/2 - 2*cm);
        #while (dist < (pLength/2 - 2*cm))
          #declare doAnUpright = false;
          #declare bookThickness = rand(r)*10*cm + 3*cm;
          #declare bookHeight = 20*cm + rand(r) * 20*cm;
          #declare bookDepth = 15*cm + 25*cm*rand(r);
          #if (bookThickness + dist < endPoint )
            #if (doUpright = false)
              #if (rand(r) > 1.9)
                // 10% chance of book inclined at an angle
                #if (endPoint - (dist+bookThickness) < 15*cm)
                  #declare nextDist = endPoint;
                #else
                  #declare nextDist = dist + 15*cm*rand(r);
                #end
                
                // Compute the distance to the point where the book intersects the bookcase
                #declare pointA = SolveQuadratic( bookThickness * bookThickness - bookHeight * bookHeight,
                                                  -2*bookThickness*bookThickness*(nextDist - dist),
                                                  (bookThickness * bookThickness * (nextDist - dist) * (nextDist - dist)) - bookThickness * bookThickness * bookHeight * bookHeight ) );
                #declare theta = asin( pointA / bookThickness );
                object {
                  CreateBook( bookThickness, bookHeight, bookDepth, texture { pigment { color rgb <rand(r), rand(r), rand(r)> } }, "", 0, 0 )
                  rotate -x*theta
                  translate (dist+bookThickness/2) * x
                }
                // Force the next book to be upright
                #declare doUpright = true;
                #declare doAnUpright = false; 
              #else
              
                // Normal upright book
                #declare doAnUpright = true;
                
              #end // if (rand(r) > ... )
            #end // if (doUpright = false)    
              
            #if (doAnUpright)
              #declare nextDist = dist + bookThickness + 1*mm;
              #declare doUpright = false;
              object {
                CreateBook( bookThickness, bookHeight, bookDepth, texture { pigment { color rgb <rand(r), rand(r), rand(r)> } }, "", 0, 0 )
                translate <(dist+bookThickness/2), counter, 0>
              }
            #end // if (doUpright)
            #declare dist = nextDist;        
          #else
            #declare dist = pLength;  // Force loop termination  
          #end // if 
        #end // while
      #end // if (pPopulate)
      
      #local counter = counter + pShelfSpacing;
    #end
    // ends
    box { <-pLength/2, 0, 0> <-pLength/2 + 2*cm, pHeight, -pDepth> texture { pTexture } }
    box { <pLength/2, 0, 0> <pLength/2 - 2*cm, pHeight, -pDepth> texture { pTexture } } 
    
    // back
    #if (counter > pHeight)
      #declare counter = counter - pShelfSpacing;
    #end
      
    box { <-pLength/2, pHeightOfLowestShelfFromFloor, 0> <pLength/2, counter, -1*mm> texture { pTexture } }
  }  
#end

#declare EyeOfNewt = 
    union { // Eye
      sphere { 
        <0,0,0>,1
        texture { pigment { color rgb <1, 1, 1> } finish { phong 0.2 phong_size 10 } }
      }
      sphere { 
        <0,0,0>,1
        texture { pigment { color rgb <0.7, 0.55, 0.425> } }
        scale <0.4, 0.4, 0.1>
        translate -0.98*z
      }
      sphere { 
        <0,0,0>,1
        texture { pigment { color rgb <0, 0, 0> } }
        scale <0.15, 0.15, 0.1>
        translate -1.05*z          
      }
      scale <1*cm, 1*cm, 0.5*cm>
    }  

#declare jar_height = 15*cm;
#declare jar_radius = 5*cm;
#declare jar_texture = texture {T_Green_Glass};
#declare EyeOfNewtJar = 
    union {
      object {#include "jar.inc"}
      intersection {
        difference {
          cylinder {
            <0, 5*cm, 0>
            <0, 10*cm, 0>
            jar_radius+0.1*mm
          }
          cylinder {
            <0, 0, 0>
            <0, jar_height, 0>
            jar_radius
          }
        }  
        box {
          <-4*cm, 0, 0>
          <4*cm, jar_height, -100>
        }  
        texture {
          pigment {
            color rgb <0.9, .85, 0.55>
          }
        }    
      }
      #ifndef (fastRender)
        intersection {
          union {
            #declare xx = seed( 3467 );
            #local _counter = 0;
            #while (_counter < 20)
              object {
                EyeOfNewt
                rotate <360*rand(xx),360*rand(xx),360*rand(xx)>
                translate <2*jar_radius*rand(xx)-jar_radius, 0.5*cm+1*cm*rand(xx), 2*jar_radius*rand(xx)-jar_radius>
              }   
              #local _counter = _counter + 1;
            #end  
          }          
          cylinder {
            <0, 0.5*cm, 0>  
            <0, 10*cm, 0>
            jar_radius-1.5*cm
          }  
        }  
        intersection {
          difference {
            cylinder {
              <0, 5*cm, 0>
              <0, 10*cm, 0>
              jar_radius+0.3*mm
            }
            cylinder {
              <0, 0, 0>
              <0, jar_height, 0>
              jar_radius+0.1*mm
            }
          }
          text {
            ttf "bradhITC.ttf" /*"timrom.ttf"*/ "Eye of Newt" 1, 0
            translate <0, -0.3, -1>
            scale <1.5*cm, 2*cm, 1>
            translate <-3.8*cm, 7.5*cm, 0>
          }  
          texture {
            pigment {
              color rgb <0.0, .0, 0.5>
            }
          }
          bounded_by {box {<-4*cm, 5*cm, 0> <4*cm, 10*cm, -(jar_radius + 1*mm)> } }
        } 
      #end  
    }


#undef thread_diameter
#undef jar_inner_radius
#undef jar_rounding_radius
#undef screw_revolutions
#undef screw_inner_radius
#declare jar_height = 25*cm;
#declare jar_radius = 3*cm;
#declare jar_texture = texture {T_Chrome_1D};
#declare DragonsBloodJar = 
    union {
      object {#include "jar.inc"}
      intersection {
        difference {
          cylinder {
            <0, 10*cm, 0>
            <0, 15*cm, 0>
            jar_radius+0.1*mm
          }
          cylinder {
            <0, 0, 0>
            <0, jar_height, 0>
            jar_radius
          }
        }  
        box {
          <-4*cm, 0, 0>
          <4*cm, jar_height, -100>
        }  
        texture {
          pigment {
            color rgb <0.9, .85, 0.55>
          }
        }    
      }
      cylinder { <0, 1*cm, 0> <0, 17*cm> jar_radius * 0.9 pigment { color rgb <0.5, 0.1, 0.2> } } 
      #ifndef (fastRender)  
        intersection {
          difference {
            cylinder {
              <0, 10*cm, 0>
              <0, 15*cm, 0>
              jar_radius+0.3*mm
            }
            cylinder {
              <0, 0, 0>
              <0, jar_height, 0>
              jar_radius+0.1*mm
            }
          }
          union {
            text {
              ttf "bradhITC.ttf" /*"timrom.ttf"*/ "Dragons" 1, 0
              translate <0, -0.3, -1>
              scale <2*cm, 2.5*cm, 1>
              translate <-2.9*cm, 13.5*cm, 0>
            }  
            text {
              ttf "bradhITC.ttf" /*"timrom.ttf"*/ "Blood" 1, 0
              translate <0, -0.3, -1>
              scale <2*cm, 2.5*cm, 1>
              translate <-2.2*cm, 11.5*cm, 0>
            }  
          }  
          texture {
            pigment {
              color rgb <0.0, .0, 0.2>
            }
          }
          bounded_by {box {<-4*cm, 10*cm, 0> <4*cm, 15*cm, -(jar_radius + 1*mm)> } }
        } 
      #end  
    }

#declare MixingBowl = 
  // Draw the mixing bowl
  union {
    union {
      difference { sphere { 0, 12*cm } sphere {0, 10*cm } plane { -y 0 } }
      difference { torus { 11*cm, 1*cm } plane { y 0 } }
      scale <2, 1, 2>
      translate 12*cm*y
    }  
    difference { sphere {-38*cm*y, 40*cm} plane { y 0 } }
    texture { T_Wood7 }
  }  


#macro WizardsStaff( _brightness ) 
  union {
    cylinder {
      <0, 0, 0>
      <0, 1.5*m, 0>
      4*cm
      texture { Gold_Metal }
    }
    
    sphere {
      0,
      14*cm
      scale <1, 0.1, 1>
      translate 1.45*m*y
      texture { Gold_Metal }
    }
    
    sphere {
      0,
      10*cm
      scale <1, 0.1, 1>
      translate 1.4*m*y
      texture { Gold_Metal }
    }
    
    difference {
      sphere { 0 1 }
      sphere { 0 0.9 }
      plane { -0.3*y 0 }
      translate 0.5*y
      texture { Gold_Metal }
      scale <10*cm, 14*cm, 10*cm>
      translate 1.5*m*y
    }
      
    sphere {
      0,
      1
      hollow
      material {
        texture {
          pigment {
            color rgbf 1
          }
        }
        interior {
          media {
            emission 1/(7*cm)
            density {
              spherical
              color_map {
                [0.0  color rgb <0, 0, 0.2> ]
                [0.7-0.5*_brightness  color Blue]
                [1.0  color White]
              }
            }
          }
        }
      }
      scale <12*cm, 18*cm, 12*cm>
      translate (1.5*m+14*cm)*y
    }
    light_source {
      0,
      <0 + _brightness, 0 + _brightness, 0.5 + 0.5*_brightness>
      fade_distance 15*cm + 30*cm*_brightness
      fade_power 2
      translate (1.5*m+14*cm)*y
    }  
  }  
#end

#declare OnyxJar = 
  lathe { // RotSweep001
    cubic_spline
    12  // control points
    <-0.001565, 0.001565>,
    <0.000097, 0.000131>,
    <0.056085, 0.00221>,
    <0.055743, 0.039493>,
    <0.027821, 0.054422>,
    <0.020485, 0.076292>,
    <0.019573, 0.095824>,
    <0.027444, 0.102235>,
    <0.015351, 0.100986>,
    <0.014425, 0.080959>,
    <0.022809, 0.052368>,
    <0.027558, 0.038932>
    material {
      texture {      
         pigment {
            color rgb <0.0, 0.0, 0.0>
         }      
         finish {
            ambient 0.1
            phong 0.8
            phong_size 10
            reflection 0.1
         }
      }
    }
  }

#declare DisturbedJar = 
  lathe { // RotSweep002
    cubic_spline
    13  // control points
    <0.00406, 0.000151>,
    <0.099911, 0.000436>,
    <0.14554, 0.093114>,
    <0.097945, 0.155719>,
    <0.09275, 0.145966>,
    <0.0904, 0.138735>,
    <0.086675, 0.14883>,
    <0.087353, 0.164349>,
    <0.042266, 0.164335>,
    <0.00993, 0.161943>,
    <0.013061, 0.18111>,
    <0.001827, 0.182517>,
    <0.001767, 0.178995>
    material {
      texture {      
        pigment {
          color rgb <0.0, 0.0, 0.501961>
        }      
        normal {
          bumps , 1.0
          scale  0.1
        }      
        finish {
          ambient 0.1
          phong 1.0
          phong_size 29.8
        }
      }   
      scale  0.1
    }
  }

#undef thread_diameter
#undef jar_inner_radius
#undef jar_rounding_radius
#undef screw_revolutions
#undef screw_inner_radius
#declare jar_height = 18*cm;
#declare jar_radius = 4.3*cm;
#declare jar_texture = texture { pigment { color rgbt <0, 0, 0.4, 0.8> } };

#declare OxTongueJar = 
    union {
      object {#include "jar.inc"}
      intersection {
        difference {
          cylinder {
            <0, 10*cm, 0>
            <0, 15*cm, 0>
            jar_radius+0.1*mm
          }
          cylinder {
            <0, 0, 0>
            <0, jar_height, 0>
            jar_radius
          }
        }  
        box {
          <-4*cm, 0, 0>
          <4*cm, jar_height, -100>
        }  
        texture {
          pigment {
            color rgb <0.9, .85, 0.55>
          }
        }    
      }
      cylinder { <0, 1*cm, 0> <0, 17*cm> jar_radius * 0.9 pigment { color rgb <0.5, 0.1, 0.2> } } 
      #ifndef (fastRender)  
        intersection {
          difference {
            cylinder {
              <0, 10*cm, 0>
              <0, 15*cm, 0>
              jar_radius+0.3*mm
            }
            cylinder {
              <0, 0, 0>
              <0, jar_height, 0>
              jar_radius+0.1*mm
            }
          }
          text {
            ttf "bradhITC.ttf" /*"timrom.ttf"*/ "Ox Tongue" 1, 0
            translate <0, -0.3, -1>
            scale <2*cm, 2.5*cm, 1>
            translate <-2.9*cm, 13.5*cm, 0>
          }  
          texture {
            pigment {
              color rgb <0.0, .0, 0.2>
            }
          }
          bounded_by {box {<-4*cm, 10*cm, 0> <4*cm, 15*cm, -(jar_radius + 1*mm)> } }
        } 
      #end  
    }

  