#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "ConversionUnits.inc"

camera { 
  location <0, 1, -3>
  look_at <0, 1, 0>
}

light_source {
  <5, 5, -5>
  color White
}

#declare WizardsStaff = 
    union {
      cylinder {
        <0, 0, 0>
        <0, 1.5*m, 0>
        4*cm
        texture { Gold_Metal }
      }
      
      sphere {
        0,
        14*cm
        scale <1, 0.1, 0>
        translate 1.45*m*y
        texture { Gold_Metal }
      }
      
      sphere {
        0,
        10*cm
        scale <1, 0.1, 0>
        translate 1.4*m*y
        texture { Gold_Metal }
      }
      
      difference {
        sphere { 0 1 }
        sphere { 0 0.9 }
        plane { -0.3*y 0 }
        translate 0.5*y
        texture { Gold_Metal }
        scale <10*cm, 14*cm, 10*cm>
        translate 1.5*m*y
      }
        
      sphere {
        0,
        1
        hollow
        material {
          texture {
            pigment {
              color rgbf 1
            }
          }
          interior {
            media {
              emission 1/(7*cm)
              density {
                spherical
                color_map {
                  [0.0  color rgb <0.1, 0.1, 0> ]
                  [0.9  color rgb <0.3, 0.3, 0> ]
                  [1.0  color White]
                }
              }
            }
          }
        }
        scale <12*cm, 18*cm, 12*cm>
        translate (1.5*m+14*cm)*y
      }
    }  

object { WizardsStaff }           