// The wizards room is in the top tower (the big one) and has the dimensions
// of 8m radius (less the 30cm for the wall), 50m up and a ceiling height of 13m
#ifndef (__WIZARDS_ROOM__)
#declare __WIZARDS_ROOM__ = true;

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "ConversionUnits.inc"
#include "MiscObjects.inc"

#declare RoomOffset = <0, 50*0.85*m, 75*m>;

#declare innerRadius = 8*m - 30*cm;

//Make the floor polished floorboards
#declare r = seed( 100 );
intersection {
  union {
    box { <-1000, 0, -1000> <1000, 0.1*mm, 1000> pigment { color Black } }
    #declare i = -innerRadius;
    #while ( i < innerRadius )
      box {
        <i, 0, -1000>
        <i+40*cm, 1*mm, 1000> 
        texture {
          T_Wood1
          finish { reflection 0.1 phong 0.1 }
          translate <rand(r), rand(r), 0>
          rotate (rand(r)*30-15)*y
        }  
      }  
      #declare i = i + 41*cm;
    #end
  }
  cylinder { <0, 0, 0>, <0, 1, 0> innerRadius texture { pigment { color rgbt 1} } }
  translate RoomOffset
}


#ifndef (fastRender)
  #declare i = 0;
  #while ( i < 4 )
    light_source {
      <0, 3.0, (innerRadius -20*cm)>
      color Yellow
      fade_distance 3*m
      fade_power 2
      looks_like {
        box {
          //<10*cm, 3.1*m, (innerRadius -10*cm)>
          //<-10*cm, 2.9*m, (innerRadius -30*cm)>
          //rotate (-45 + 90 * i) * y
          //translate RoomOffset
          <-10*cm, -10*cm, -10*cm>
          <10*cm, 10*cm, 10*cm>
          pigment { color rgb <1,0,0 > } 
          finish { ambient 1.0 }
        }        
      }
      rotate (-45 + 90 * i) * y
      translate RoomOffset
    }
    #declare i = i + 1;  
  #end
#end

#ifndef (noBookcases)
  object {
    CreateBookcase( 3*m, 2*m, 50*cm, 45*cm, 2*cm, texture { T_Wood2 rotate 90*y scale 0.01 }, true )
    translate z*(sqrt(innerRadius*innerRadius- (0.5*3*m)*(0.5*3*m)))
    rotate 30*y
    translate RoomOffset
  }
  
  
  object {
    CreateBookcase( 6*m, 2*m, 50*cm, 45*cm, 2*cm, texture { T_Wood2 rotate 90*y scale 0.01 }, true )
    translate z*(sqrt(innerRadius*innerRadius- (0.5*6*m)*(0.5*6*m)))
    rotate -35*y
    translate RoomOffset
  }
#end

#declare bookTitles = array[50] {
    "Of newts and toads",
    "Basic Spells",
    "Wunderlust explained",
    "WizardEye maps",
    "Intermediate spellcasting",
    "Dragon summoning",
    "Elemental summoning",
    "Harnessing AirPower",
    "Incantations",
    "Making a power staff",
    "Mages guide to power",
    "Chants and Charms",
    "Book of Shadows",
    "Blinking explained",
    "Harnessing the sun",
    "Destroying curses",
    "History of Omen-Ra",
    "Ring creation",
    "Golem creations",
    "Fireball casting tricks",
    "Summoning plagues",
    "Enslaving damsels",
    "Levitations",
    "Learn the dark side",
    "Leomunds Spells",
    "Protection Spells",
    "Magic Mouth",
    "Incantations and Chants",
    "Leomund's Spells",
    "Obtaining dragon's blood",
    "Reagent collecting",
    "Conjuring tricks",
    "Sorcery: A guide",
    "Interdimensionl travel",
    "Astral planes",
    "Necromancy: Dead easy",
    "Combat evil easily",
    "Mind Control Spells",
    "A history of magiks",
    "Children's Glimmors",
    "Essential Ingredients",
    "Wizards of lore",
    "Spell Memorization Tips",
    "tfaulkes@hotmail.com",
    "Combat Spells",
    "Invisibilities",
    "Monster Summoning",
    "Harnessing the sun",
    "Tome of Magic",
    "Death and Decay" };


#macro CreateSpecialBookcase(pBookRotation)
  // Bookcase goes from -Length/2 to Length/2, and from 0 to -pDepth with the back at 0, but the sides of the bookcase
  // come in 2cm, so remember this when placing books.
  #declare pLength = 4*m;
  #declare pHeight = 3*m;
  #declare pDepth = 50*cm;
  #declare pShelfSpacing = 45*cm;
  #declare pHeightOfLowestShelfFromFloor = 2*cm;
  #declare pTexture =  texture { T_Wood2 rotate 90*y scale 0.01 };
  #declare createdSpecialBook = false;
  #declare shelfCounter = 0;
  
  union {
    #local counter = pHeightOfLowestShelfFromFloor;
    #while (counter < pHeight)
      #declare shelfCounter = shelfCounter + 1;
      box {
        <-pLength/2, counter, 0>
        <pLength/2, counter + 2*cm, -pDepth>
        texture {
          pTexture
          rotate <30*rand(r)-15, 30*rand(r)-15, 30*rand(r)-15>
          scale (1+(rand(r)-0.5)/5)
        }
      }  
      
      #if (counter + pShelfSpacing < pHeight)
        #declare dist = -pLength/2+2*cm;
        #declare doUpright = false;
        #declare endPoint = (pLength/2 - 2*cm);
        #while (dist < (pLength/2 - 2*cm))
          #if ((shelfCounter = 4) & (dist > 0) & (!createdSpecialBook))
            object {
              CreateBook( 10*cm,
                          35*cm,
                          35*cm,
                          texture { pigment { color rgb <0, 0, 1> } },
                          "Elementary Weather Control",
                          2.5*cm,
                          texture { Gold_Metal } )
              translate 35*cm*z
              rotate pBookRotation *-x
              translate -35*cm*z
              translate <(dist + 5*cm), counter+2*cm, 0>
              #declare SpecialBookLoc = <(dist + 5*cm), counter+2*cm, 0*cm>+vaxis_rotate(35*cm*y,-x, pBookRotation)-35*cm*z
            }
            #declare dist = dist + 10.1*cm;
            #declare createdSpecialBook = true;
          #else    
            #declare doAnUpright = false;
            #declare bookThickness = rand(r)*6*cm + 8*cm;
            #declare bookHeight = 30*cm + rand(r) * 7*cm;
            #declare bookDepth = 28*cm + 12*cm*rand(r);
            #if (bookThickness + dist < endPoint )
              #declare nextDist = dist + bookThickness + 1*mm;
              #declare doUpright = false;
              object {
                CreateBook( bookThickness,
                            bookHeight, 
                            bookDepth, 
                            texture { pigment { color rgb <rand(r)/2, rand(r)/2, rand(r)/2> } },
                            bookTitles[ rand(r) * dimension_size(bookTitles,1)],
                            2*cm+0.5*rand(r)*cm,
                            texture { Gold_Metal } )
                translate <(dist+bookThickness/2), counter+2*cm, 0>
              }
              #declare dist = nextDist;        
            #else
              #declare dist = pLength;  // Force loop termination  
            #end // if 
          #end  
        #end // while
      #end // if (pPopulate)
      
      #local counter = counter + pShelfSpacing;
    #end
    // ends
    box { <-pLength/2, 0, 0> <-pLength/2 + 2*cm, pHeight, -pDepth> texture { pTexture } }
    box { <pLength/2, 0, 0> <pLength/2 - 2*cm, pHeight, -pDepth> texture { pTexture } } 
    
    // back
    #if (counter > pHeight)
      #declare counter = counter - pShelfSpacing;
    #end
      
    box { <-pLength/2, pHeightOfLowestShelfFromFloor, 0> <pLength/2, counter, -1*mm> texture { pTexture } }
  }  
#end
    
#macro SpecialBookcase( pAngle )
object {
  CreateSpecialBookcase( pAngle )
  translate z*(sqrt(innerRadius*innerRadius- (0.5*4*m)*(0.5*4*m)))
  rotate 140*y
  translate RoomOffset
  #declare SpecialBookLoc = vaxis_rotate( SpecialBookLoc + z*(sqrt(innerRadius*innerRadius- (0.5*4*m)*(0.5*4*m))), y, 140 ) + RoomOffset;
}
#end

/*
#declare Font="timrom.ttf"
object {
  CreateBook( 10*cm, 30*cm, 25*cm, texture { pigment { color rgb <0.1, 0.4, 0.7> } }, "A treatise on cane toads", 2.7*cm, texture { Gold_Metal } )  
  //rotate -90*x
//  rotate 45*y
//  translate RoomOffset
//  translate <0, 1.8*m, -5*m>
} 
*/  


#ifndef ( __FORCES__ )
  light_source {
    <-10, 10, -20>
    White
  }
    
  camera {
  //  location <0, 1, -3>
  //  look_at < 0, 1, 0>
    location <0, .5, -25*cm>
    look_at <0, 0, -25*cm>
    
  }
#end

// A fine rug
union {
  cylinder {
    <0, 0, 0>
    <0, 5*mm, 0>
    4*m
    texture {
      pigment {
       color rgb <0.1, 0.0, 0.5>
      }
    }
  }  
  difference {
    cylinder {
      <0, 0, 0>
      <0, 5.1*mm, 0>
      3.8*m
    }
    cylinder {  
      <0, 0, 0>
      <0, 5.3*mm, 0>
      3.8*m
    }
    pigment { 
      color rgb <1, 1, 0>
    }  
  }
  translate RoomOffset   
}  
    
#end // #ifndef