#include "ConversionUnits.inc"
#include "colors.inc"
#include "textures.inc" 
#include "stones.inc"
#include "woods.inc"
#include "glass.inc"
 
//#declare fastRender = true;
#declare __FORCES__ = version;

#include "CommonDefinitions.inc"
#include "Castle.inc"
#include "MiscObjects.inc"
#include "Warrior.pov"
#include "CatapultShots.inc"
   
#declare fps=25;
#declare skyClock = 0;
#declare shieldClock = 0;
#declare boulderClock = 0;
#declare mixingClock = 0;
#declare doMixing = false;
#declare doStartSeg = true;
#declare startSegClock = clock;
#declare fps = 25;

#declare doMixing = false;
#declare mixingClock = clock;

#macro Time( pTime )
  (pTime / TotalTimeInSeconds)
#end

#declare TotalTimeInSeconds = 35;  

#declare sceneTimings = array[13] {
      9.0,    // Watch the warriors walk
      3.0,    // Get the ingredients
      6.0,    // Look out of window at ground forces.
      22.4,   // Mix ingredients, fire stone
      4.0,    // catapult rock colliding with fire stone.
      3.0,    // Reach for wand
      4.0,    // erect shield.
      5.0,    // Fire ground catapults.
      6.0,    // Extract "Elementary weather control book
      3.0,    // Sky darkens
      2.0,    // lightning flashes
      2.0,    // sky lightens
      3.0     // man runs away
    }  

#declare doStartSeg = false;
#declare doGetIngredients = false;
#declare doLookAtGroundForces = false;
#declare doMixing = false;
#declare doRockStoneCollision = false;
#declare doGetWand = false;
#declare doErectShield = false;
#declare doFireCatapults = false;
#declare doGetBook = false;
#declare doDarkenSky = false;
#declare doLightningFlashes = false;
#declare doLightenSky = false;
#declare doManRunning = false;
#declare doMain = false;

clockToSegmentTime( clock, sceneTimings )
//#declare segment = -5;
#if (segment < 0)
  // Manually controlled segment
  #declare sTime = 0;
  #declare eTime = 1;
  #declare vClock = clock;
  #declare segment = -segment;
#else  
  #declare vClock = (clock - sTime) / (eTime - sTime);
#end  
#switch (segment)
  
  #case( 1 )  #declare doStartSeg = true;              #break   // done
  #case( 2 )  #declare doGetIngredients = true;        #break   // done
  #case( 3 )  #declare doLookAtGroundForces = true;    #break   // done       
  #case( 4 )  #declare doMixing = true;                #break   // Done      
  #case( 5 )  #declare doRockStoneCollision = true;    #break      
  #case( 6 )  #declare doGetWand = true;               #break      
  #case( 7 )  #declare doErectShield = true;           #break   // Done
  #case( 8 )  #declare doFireCatapults = true;         #break   // Done
  #case( 9 )  #declare doGetBook = true;               #break   // Done      
  #case( 10 ) #declare doDarkenSky = true;             #break   // Done
  #case( 11 ) #declare doLightningFlashes = true;      #break      
  #case( 12 ) #declare doLightenSky = true;            #break   // Done      
  #case( 13 ) #declare doManRunning = true;            #break   // done
#end    

//#undef noBookcases
#switch (segment)
  #case (4)   #declare noBookcases = true; #break
#end  
#include "WizardsRoom.inc"
#include "Landscape.inc"

#declare shieldClock = 0;
#declare skyClock = 0;
#declare skyClock1 = 0; 
#declare catapultFiringTimes = array[4] {2.4, 0.0, 1.2, 1.5 }

// Draw the catapults and the milling armies
#switch (segment)
  #range (1,2)
    #break
  #case (6)
    // Getting the wand, no forces
    #break      
  #case (9)
    #if (clock > 0.4)
      #break
      // otherwise, fall through
    #end    
  #range (3,14)  
    #declare CatapultLocations = array[4];
    #declare i = 0;
    #declare aRand = seed( 3848 );
    #while ( i < 4 )
      object {
        #declare anAngle = -30+60*rand( aRand );
        #declare aLength = (75+50*rand( aRand ))*m;  
        #declare loc1 = trace( Ground, vaxis_rotate( <0, 1000, -(aLength-CatapultLength/2)>, y, anAngle ), -y ); 
        #declare loc2 = trace( Ground, vaxis_rotate( <0, 1000, -(aLength+CatapultLength/2)>, y, anAngle ), -y ); 
        #declare CatapultLocations[i] = loc1;
        #declare catapultRotation = 0;
        #if ( i = 1 )
          #if (doLookAtGroundForces | doMixing)
            #declare loaded = true;
          #else
            #if (doRockStoneCollision)
              #if (vClock < 0.05)
                #declare catapultRotation = 90* (1- cos( pi/2 * ((vClock - (catapultFiringTimes[i] - 0.05))/0.05)));
                #declare loaded = true;
              #else
                #declare catapultRotation = 90;
                #declare loaded = false;
              #end
            #else
              #declare loaded = false;  
            #end
          #end        
        #else
          #if (doErectShield)
            #declare loaded = true;
          #else
            #if (doFireCatapults & (vClock < catapultFiringTimes[i]) )
              #if (vClock > (catapultFiringTimes[i] - 0.05))
                #declare catapultRotation = 90* (1- cos( pi/2 * ((vClock - (catapultFiringTimes[i] - 0.05))/0.05)));
              #else
                #declare catapultRotation = 0;
              #end  
              #declare loaded = true;
            #else
              #if (doFireCatapults & (vClock >= catapultFiringTimes[i] ) )
                #declare catapultRotation = 90;
                #declare loaded = false;
              #else
                #declare loaded = false;
              #end
            #end         
          #end    
        #end  
        Catapult( 0, catapultRotation, loaded )
        rotate -90*y
        rotate degrees( asin( (loc2.y-loc1.y)/CatapultLength ) ) * x
        translate aLength*-z
        translate y* (loc1.y+loc2.y)/2
        rotate anAngle * y
        
      }
      #declare i = i + 1;
    #end
    #declare i = 0;
    #while ( i < 4 )
      #ifndef (fastRender)  
        #declare manCount = 0;
        #while (manCount < 80)
          #switch (segment)
            #range( 0, 10)
              RandomWarrior(
                   vClock,  //pClock
                   0.4,     // pFractionStationary
                   CatapultLocations[i] + vaxis_rotate( <0, 0, 40*rand( aRand )>, y, 360*rand( aRand ) ), // pInitialDisplacement
                   vaxis_rotate( -z, y, 360*rand(aRand)), // pWalkDirection
                   sceneTimings[ segment-1 ],   // pNumberOfSeconds
                   0.8, // pStepsPerSecond
                   1.6 + 0.2*rand( aRand)  // pDistancePerStep
              )
              #break
            #case (12)
              RandomWarrior(
                   vClock,  //pClock
                   0.4,     // pFractionStationary
                   CatapultLocations[i] + vaxis_rotate( <0, 0, 40*rand( aRand )>, y, 360*rand( aRand ) ), // pInitialDisplacement
                   vaxis_rotate( -z, y, 30-60*rand(aRand)), // pWalkDirection
                   sceneTimings[ segment-1 ],   // pNumberOfSeconds
                   0.8, // pStepsPerSecond
                   1.6 + 0.2*rand( aRand)  // pDistancePerStep
              )
              #break               
           #else
              RandomWeapon( trace( Ground, CatapultLocations[i] + vaxis_rotate( <0, 0, 40*rand( aRand )>, y, 360*rand( aRand ) ) +100*y, -y ) )
          #end  
          #declare manCount = manCount + 1;
        #end  
      #end  
      #declare i = i + 1;      
    #end    
    #break
#end
    
#declare shieldClock = 0;
#declare ShieldOrigin = <0, 0, WallLength/2>;
#declare ShieldRadius = 100;
#declare wizLoc = <0, height1 + 1.8*m, 67.33>;
camera { location <-25, 110, -180> look_at <-25, 0, -80> }

#if (doLightningFlashes)
  #declare shieldClock = 1;
  #declare skyClock = 1;
  #declare skyClock1 = 1;
  #declare lightningRand = seed( 4250 );
  #declare counter = 0;
  #while (counter < 10)
    #declare aTime = (rand(lightningRand)* 0.95);
    #if ( ( aTime >= vClock) & (aTime <= vClock + 0.05))

      // // Draw a lightning flash
      #declare skyLoc = <1000*rand(lightningRand)-500, 1500, 1000*rand(lightningRand)-500>;
      #declare groundLoc = trace( Ground, <200*rand(lightningRand)-100, 1500, -45-100*rand(lightningRand)>, -y);
      #declare incr = 50*m;
      #while (skyLoc.y > groundLoc.y)
        #declare nextLoc = skyLoc + (vnormalize( groundLoc - skyLoc ) + <0.4*rand(lightningRand)-0.2, 0.4*rand(lightningRand)-0.2,0.4*rand(lightningRand)-0.2> ) * incr;
        light_source {
          0
          color rgb <1, 1, 0>
          fade_distance 30*m
          fade_power 3
          looks_like {
            union {
              cylinder { 0 nextLoc-skyLoc 1*m texture { pigment { color rgb <0.8, 0.8, 0> } finish { ambient 1 } } }
              cylinder {
                0
                nextLoc-skyLoc
                10*m
                hollow
                material { texture { pigment { rgbt 1 } } }
                interior {
                  media {
                    emission .1
                    density {
                      cylindrical
                      color_map {
                        [0.0 color rgb <0.2, 0.2, 0> ]
                        [1.0 color rgb <1.0, 1.0, 0> ]
                      }
                    }
                  }  
                }
              }
            }          
          }
          translate skyLoc  
        }  
        #declare skyLoc = nextLoc;
      #end
    #end
    #declare counter = counter + 1;
  #end
  camera {
    location <-200, 10, -175>
    look_at <0, 70, 0>
    //location trace( Ground, <-100, 30, -100>, -y)+1.8*y
    //look_at <0, 50, 75>
  }  
    
#end
              
#if (doManRunning)
  #declare startLocation =<-20, 1.8*m, -90>;
  #declare i = 0;
  #while (i < 30 )
    object { RunningWarrior( vClock, startLocation + <40*rand(aRand)*m, 0, -50*rand(aRand)*m>, vaxis_rotate( -z, y, 30-60*rand(aRand)), 3, 5, 1.9 ) }
    #declare i = i + 1;
  #end
  
  camera {
    //location < 0, height1+1.8*m, 67.33>
    //look_at startLocation
    location <0, 5*m, -85*m>
    look_at <0, 0, -95*m>
  }
    
#end              
    
#if (doMixing)
  #declare mixingClock = vClock;
  #declare noBookcases = true;
  #include "castSpell.pov"
  #undef noBookcases
  DrawSpell()
#end   

#if (doGetIngredients)
  #include "GetIngredients.pov"
#end

#if (doLookAtGroundForces)
  #declare noBookcases = true;
  #include "castSpell.pov"
  #undef noBookcases
  object { aBowl }
  object { MagicStone translate <-40*cm, height1+1*m + 3*cm, 67.33*m> }
  object { DragonsBloodJar rotate 243*y translate <38*cm, height1+1*m, 67.3*m > } 
  object { NewtEyes }  

  camera {
    location From( <0, (height1+1.8)*m, 68*m>, 0.1 ) To ( <0, 20*m, -40*m>, 0.2 ) To (<0, 20*m, -40*m>, 0.8 ) To ( <0, (height1+1.8)*m, 68*m>, 0.9 )
    look_at <0, 0, -75>
  }  
#end

#declare skyClock = 0;
#declare skyClock1 = 0;

#if (doGetWand)
  #ifndef (RoomOffset)
    #include "WizardsRoom.inc"
  #end  
  object {
    #declare bright = 0;
    Declare_From( bright, 0, 0.6) Declare_To (bright, 1, 0.7)
    WizardsStaff( bright )
    rotate 10*x
    rotate -10*z
    translate 7.3*m*z
    rotate -61*y
    translate From( RoomOffset, 0.8 ) To (RoomOffset + <0.8, 0.3, -0.8>, 1)
  }  

  // Draw the right hand
  #declare hand = 1;
  //#undef SkinTexture
  #declare Finger1Angle1 = 10;
  #declare Finger1Angle2 = 10;
  #declare Finger1Angle3 = 10;
  #declare Finger2Angle1 = 10;
  #declare Finger2Angle2 = 10;
  #declare Finger2Angle3 = 10;
  #declare Finger3Angle1 = 10;
  #declare Finger3Angle2 = 10;
  #declare Finger3Angle3 = 10;
  #declare Finger4Angle1 = 10;
  #declare Finger4Angle2 = 10;
  #declare Finger4Angle3 = 10;
  #declare ThumbAngle1 = 60;
  #declare ThumbAngle2 = 10;
  #declare ThumbAngle3 = 30;
  #declare WristAngle = 0;
  #declare ThumbJoint2TransverseAngle = 10;

  object {
    #include "hand.inc"
    rotate 90*x
    rotate 90*z
    rotate 15*y
    translate From(7*m*z, 0) To (7.5*m*z, 0.6)
    rotate -59*y
    translate From( RoomOffset + 1.3*y, 0.8) To (RoomOffset + <0.8, 1.6, -0.8>, 1)
  }

  camera {
    location 1.8*y
    look_at From( <1, 1.2, 1>, 0.8 ) To (<1.4, 1.5, 1>, 1)
    translate 7.2*m*z
    rotate -65*y
    translate From( RoomOffset, 0.8) To (RoomOffset + <0.7, 0, -0.8>, 1)
  }  
#end 

#if (doRockStoneCollision)
#debug concat ( "vClock = ", str( vClock, 4, 4) , "\n" )
  #declare collisionTime = 0.5;
  #declare collisionLocation = <13.4082, 24.0368, -34.6855>;
  #declare old_eTime = eTime;
  #declare old_sTime = sTime;
  #declare sTime = 0.0;
  #declare eTime = collisionTime;
  #declare aTime = sceneTimings[segment-1]*vClock;
  #include "CastSpell.pov"
  
  
  #if (aTime > 0.05)      
     LaunchBoulder( CatapultLocations[1] + <-CatapultLength/2, CatapultLength, 0>, <-CatapultLocations[1].x/4, 17, 38>, 0.05 )
  #end     
  
  #if (vClock < eTime)
    DrawBoulders( aTime, false )
    FireBullet()
  #else
    #declare explode_object = object { CatapultStone translate collisionLocation} 
    #declare object_centre = collisionLocation;
    #declare object_size = <4, 4, 4>;
    #declare object_hollow = false;
    #declare particle_res = 15;
    #declare exp_location = object_centre+1*m*z;
    #declare exp_strength = 10;
    #declare exp_gravity = 9.8;  
    #declare explode_start = collisionTime * (old_eTime-old_sTime) + old_sTime;// * sceneTimings[segment-1];
    #declare time_scale = sceneTimings[segment-1]/(old_eTime-old_sTime);
    #declare exp_turb = 1;
    #declare scale_turb = 1;
    #declare rotate_turb = 1;
    #declare vel_turb = .3;
    #declare dir_turb = .1;
    #declare spin_turb = .5;
    #include "explode.inc"
    
  #end  

  camera {
    location From ( <0, (height1+1.8)*m, 67.6*m>, sTime ) To (collisionLocation + <0, 5*m, 20*m>, eTime)
    look_at From( <0, 0, -75>, sTime) To (collisionLocation, eTime)
    //location <0, (height1+1.8)*m, 67.6*m>
    //look_at <0, 0, -75>
  }  
#end

#if (doDarkenSky)
  #declare skyClock = vClock;
  #declare skyClock1 = vClock
  camera {
    //location trace( Ground, <-100, 30, -100>, -y)+1.8*y
    //look_at <0, 50, 75>
    location <-200, 10, -175>
    look_at <0, 70, 0>
}  
#end

#if (doLightenSky)
  #declare skyClock = 1-vClock;
  #declare skyClock1 = 1;
  #if (vClock >= 0.5)
    #declare shieldClock = 1-2*(vClock-0.5);
  #else  
    #declare shieldClock = 1;
  #end  
  camera {
    //location trace( Ground, <-100, 30, -100>, -y)+1.8*y
    //look_at <0, 50, 75>
    location <-200, 10, -175>
    look_at <0, 70, 0>
  }  
#end

#if (doLightningFlashes)
  #declare skyClock = 1; 
  #declare skyClock1 = 1;
#end      

#if (doErectShield)
  #declare BulletImage = 
     union {
        sphere { 0, 1 pigment { color rgbt <1, 1, 0, 0.4>} }
        sphere { 0, 1.8
           hollow on
           pigment {color rgbt <1, 1, 0, 0.9>}
           finish {ambient .9 diffuse .6}
           interior {
              media {
                 emission rgb <1, 1, 0>
              }   
              fade_distance 40
              fade_power 1
           }   
       }
       scale <0.2, 0.2, 1.2>
     }   

  #if (vClock <= 0.2)
    light_source { 
      <0, 0, 0>
      color rgb <1, 1, 0>
      fade_distance 20
      fade_power 1
      looks_like { BulletImage }
      translate From (<0, height1+1.8*m, 68>, 0) To (vaxis_rotate( <0, 0, -ShieldRadius>, x, 45 ) + ShieldOrigin, 0.2)
    }
    #declare shieldClock = 0;
  #else
    #declare shieldClock = (vClock - 0.2) / (1.0-0.2);
  #end
    
  camera {
    location trace( Ground, <-15, 100, -130>, -y) + 1.8*y
    look_at < 0, 50, 75>
  }  
#end

#if (doMain)            
  #if (true)
    camera {
      //location <0, 1.8*m, -100*m>
      #declare loc = <-5, 101.8*m, -900*m>;
      #declare trueLoc = trace(Ground, loc, -y);
      location trueLoc + 1.8*y 
      //look_at <0, 20*m, 0*m> 
      look_at <0, trueLoc.y+1.8*m, trueLoc.z>
      
      //location <-5, 101.8*m, -900*m>
      //look_at <0, 0, -900*m>
    }
  #else
    // Wizards camera
    camera {
      //location <0, (height1+1.8)*m, 68*m>
      //look_at <0, 0, -75>
      location <-240*m, 61.8*m, -120*m>
      look_at <0, 10*m, 0*m>
  
    }
  #end
#end  

// Draw the sun
light_source {
  <2000*m, 2000*m, -1500*m>
  color White
}

// Draw the sky           
  
plane { y, 1500
  hollow              // We're using media, so this must be hollow!!
  texture {
    pigment {
      leopard
      color_map {
        [0 color rgbt <0, 0, 0, 1-skyClock> ]
        [0.40001-0.4*skyClock color rgbt <0, 0, 0, 1-skyClock> ]
        [0.50002-0.5*skyClock color rgbt <1-0.9*skyClock, 1-0.9*skyClock, 1-0.9*skyClock, 1-skyClock> ]
        [0.9 White*(1-skyClock/2) ]
        [1 White]
      }
      turbulence 2+skyClock
      scale 500
    }
    finish { ambient 0.8 - 0.5*skyClock }
    translate -2000*z*skyClock1
  }  
} 

/*                                                                     
#if (skyClock > 0.6)
  light_source {
    <0, 45*m, 75*m>
    Yellow
    fade_distance 10*m
    fade_power 2
  }
#end
*/

#if (doStartSeg)
  MarchingForces( <0, 0, -891*m> )
  #declare loc = <-9, 101.8*m, -950*m>;
  #declare trueLoc = trace(Ground, loc, -y) + 1.8*y;
  #switch (vClock)
    #range (0, 0.2)
      camera {
        location trueLoc 
        look_at <0, trueLoc.y, trueLoc.z-50*m>
      }  
      #break
    #range ( 0.2, 0.5 )
      camera {
        location trueLoc
        look_at vaxis_rotate( <0, trueLoc.y, trueLoc.z-50*m>-trueLoc, y, From( 0, 0.2 ) To (-170, 0.5) ) + trueLoc
      }  
      #break
    #range ( 0.5, 0.6 )
      camera {
        location trueLoc
        look_at From( vaxis_rotate( <0, trueLoc.y, trueLoc.z-50*m>-trueLoc, y, -170) + trueLoc, 0.5) To (wizLoc, 0.6)
      }  
      #break
      
    #range (0.6, 0.8)
      // Move to look at wizards head
      camera {
        location <From (trueLoc.x, 0.6) To (wizLoc.x, 0.75) To (wizLoc.x, 0.8),
                  From (trueLoc.y, 0.6) To (wizLoc.y, 0.75) To (wizLoc.y, 0.8),
                  From (trueLoc.z, 0.6) To (wizLoc.z-30*cm, 0.8)>
        //location From( trueLoc, 0.6 ) To (<0, wizLoc.y, wizLoc-, 0.7) To (wizLoc-30*cm*z, 0.75)
        look_at wizLoc
      }  
      #include "face.pov"
      object { head(  0.5, <0.0, 0.3, 1.0>, 0, 0, 0, 0, 0, 0, 0, 0 ) translate wizLoc }
      #break
      
    #range (0.8, 0.86)
      // Normal look at wizards head
      camera {
        location wizLoc-30*cm*z
        look_at wizLoc
      }
      #include "face.pov"
      object { head(  0.5, <0.0, 0.3, 1.0>, 0, 0, 0, 0, 0, 0, 0, 0 ) translate wizLoc }
      #break
      
    #range (0.86, 0.92)  
      // Wizard develops a scowl
      camera {
        location wizLoc-30*cm*z
        look_at wizLoc
      }
      #declare BM_Squint = 0;
      Declare_From( BM_Squint, 0, 0.86 ) Declare_To( BM_Squint, 1, 0.92)
      #declare jawSize = 0;
      Declare_From( jawSize, 0, 0.86 ) Declare_To( jawSize, -0.5, 0.92 )
      #include "face.pov"
      object { head(  0.5,                // build
                      <0.0, 0.3, 1.0>,    // eye
                      0,                  // R_Lid
                      0,                  // L_Lid
                      0,                 // EyeRot
                      jawSize,                  // lip    -- -0.5 to 0.5
                      0,                  // Twist
                      0,                  // Tip
                      0,                  // Tilt
                      0                  // Face Map
                      ) translate wizLoc }// rotate 90*y}

      #break
      
    #range (0.92, 1.01)  
      camera {
        location wizLoc-30*cm*z
        look_at wizLoc
      }
      #declare BM_Squint = 1;
      #include "face.pov"
      object { head(  0.5, <0.0, 0.3, 1.0>, 0, 0, 0, -0.5, 0, 0, 0, 0 ) translate wizLoc }
      #break
  #end
#end


#if (doGetBook)
  #include "WizardsRoom.inc"
  #declare shieldClock = 1;
  #declare anAngle = 0;
  Declare_From(anAngle,0,0.85) Declare_To (anAngle,45, 0.95)
  object { SpecialBookcase( anAngle ) }
  
  // Draw the right hand
  #declare hand = 1;
  //#undef SkinTexture
  #declare Finger1Angle1 = 5;
  #declare Finger1Angle2 = 5;
  #declare Finger1Angle3 = 5;
  #declare Finger2Angle1 = 70;
  #declare Finger2Angle2 = 70;
  #declare Finger2Angle3 = 70;
  #declare Finger3Angle1 = 70;
  #declare Finger3Angle2 = 70;
  #declare Finger3Angle3 = 70;
  #declare Finger4Angle1 = 70;
  #declare Finger4Angle2 = 70;
  #declare Finger4Angle3 = 70;
  #declare ThumbAngle1 = 80;
  #declare ThumbAngle2 = 60;
  #declare ThumbAngle3 = 80;
  #declare WristAngle = 0;
  #declare ThumbJoint2TransverseAngle = 0;

  #if (vClock > 0.7)
    object {
      #include "hand.inc"
      rotate 90*x
      rotate 180*z
      rotate -45*x
      rotate 95*y
      translate From(SpecialBookLoc+<-31*cm, 0.5*cm,31.5*cm>, 0.6) To (SpecialBookLoc+<-1*cm, 0.5*cm,-1.5*cm> , 0.7) 
    }
  #end
  
  camera {
    location From(wizLoc, 0.0 ) To (wizLoc + 2*m*z, 0.2) To (<4, height1 + 1.5*m, 70*m>, 0.35) To (<4.15, height1 + 1.55*m, 69.85*m>, 0.5)
    look_at From ( <0,0,-75>, 0 )
              To (vaxis_rotate(<0, 1.3*m, 8*m>, y, 140) + RoomOffset , 0.3)
              To (vaxis_rotate(<0, 1.3*m, 8*m>, y, 140) + RoomOffset , 0.45)
              //To (<8, height1 + 1.3*m, 60*m>, 0.5)
              To (<18, height1 + 1.3*m, 60*m>, 0.6)
  }  
#end

#if (doFireCatapults)

  #declare aTime = sceneTimings[segment-1]*vClock;
  #declare i = 0;
  #while ( i < 4 )
    #if (i != 1)
      #if (aTime > catapultFiringTimes[i])      
        LaunchBoulder( CatapultLocations[i] + <-CatapultLength/2, CatapultLength, 0>, <-CatapultLocations[i].x/4, 30, 35>, catapultFiringTimes[i] )
      #end  
    #end
    #declare i = i + 1;  
  #end     
  
 
  DrawBoulders( aTime, true )
  
  #declare shieldClock = 1;
  camera {
    location trace( Ground, <-15, 100, -130>, -y) + 1.8*y
    look_at < 0, 50, 75>
  }  


#end

// Draw the shield 
#if (shieldClock > 0)
  #declare shieldRand = seed( 3452 );
  
  intersection {
    difference {
      sphere {
        0,
        ShieldRadius
      }
      sphere {
        0,
        ShieldRadius-10*cm
      }
    }  
    blob {
      threshold 0.1
      sphere {<0, ShieldRadius-1*m, 0>, shieldClock*200*m, 2 rotate -45*x }
      #declare i = 0;
      #while ( i < 32)
        #declare anAngle = atan( 200*m*shieldClock / ShieldRadius)*0.9;
        sphere { <0, ShieldRadius-10*cm, 0> shieldClock*30*m 2 rotate degrees( anAngle ) * x rotate 360*rand( shieldRand ) * y rotate -45*x }
        #declare i = i + 1;
      #end    
    }  
    material {
      texture {
        pigment { color rgbf <0.98, 0.88, 0.88, 0.8> }
        finish { F_Glass3 }
      }  
      #ifdef (aTime)
        ComputeImpactPoints( aTime )
      #end
      #ifndef (fastRender)  
        interior { I_Glass }
      #end  
    }
    translate ShieldOrigin
  }         
#end  

