#include "warrior.inc"
#include "ConversionUnits.inc"


/*
object { SwordObject }
object { Banner }
object { Pike }
object { ShieldObject }
*/

#ifdef (doDemo)
camera {
  //location <0, 5, -5>
  //look_at <0, 2, 10>
  location <6, 3, -20>
  look_at <0, 1.4, -.2>
}

light_source {
  <100, 100, -100>
  color rgb <1, 1, 1>
}
 
#declare Ground = 
  union {
    plane {
      y
      0
    }
    sphere {
      <0, -9, -5>
      10
    }  
    pigment { color rgb <0, 0.5, 0> }
  }  

object { Ground }

#end
/*
#declare setSpacing = 30*m;  
#declare forceRand = seed( 64 );
#declare k = 0;
#while (k < 4)
  #declare j = 0;
  #while (j < 10)
    #declare i = -4;
    #while ( i <= 4)
      #if (j = 0)  
        object { SwordWarrior( -45, 0, 90, 0, 0, 0,
                               0, 0, 60, 0, 0, 0)
                 translate <i*m, 0, setSpacing*k + j*1.5*m>
        }
      #else
        #switch (rand(forceRand))  
          #range (0, 0.1)
            object { BannerWarrior(0, 0, 0,
                                   0, 0, 0)
            
                 translate <i*m, 0, setSpacing*k + j*1.5*m>
            }
            #break
            
          #range (0.1, 0.6)
            object { SwordWarrior( 0, 0, 0, 0, 0, 0,
                                   0, 0, 60, 0, 0, 0)
                 translate <i*m, 0, setSpacing*k + j*1.5*m>
            }
            #break
            
          #else
            object { PikeWarrior( 0, 0, 0, 0, 0, 0,
                                   0, 0, 90, 0, 0, 0)
                 translate <i*m, 0, setSpacing*k + j*1.5*m>
            }
            #break
        #end
      #end    
      #declare i = i + 1;
    #end  
    #declare j = j + 1;
  #end
  object { Catapult(0, 0) rotate 90*y translate <0, 0, 19*m + setSpacing*k> }
  #declare k = k + 1;
#end 
*/ 
/*         
object { SwordWarrior( 0, 0, 0, 0, 0, 0,
                       0, 0, 0, 0, 0, 0)
         translate 1*m*x
}
object { BannerWarrior(45, 45, 30,
                       45, 45, 30)

}

object { PikeWarrior( 0, 0, 0, 0, 0, 0,
                       0, 0, 45, 0, 0, 0)
         translate -1*m*x
}
         
*/

#declare stepsPerSecond = .75;
#declare distancePerStep = 1.7*m;
#declare distancePerRunningStep = 1.5*m;           
#declare vClock = clock;

// This is a good man running
/*
object { SwordWarrior( 
            // Left side (1's)
            0,
            (11.2+15*sin(2*pi*stepClock+radians(180))),
            (40-25*sin(2*pi*stepClock + radians(0))),
            
            0+30*sin(2*pi*stepClock+radians( 270 )),
            30+30*sin(2*pi*stepClock + radians( 360 )),            
            15*sin(2*pi*stepClock + radians( 270 )),
            
            // Right side
            0,
            (11.2+15*sin(2*pi*stepClock + radians(0))),
            (42.2-25*sin(2*stepClock*pi + radians(180))),
            
            0+30*sin(2*pi*stepClock+radians( 90 )),
            30+30*sin(2*pi*stepClock + radians( 180 )),            
            15*sin(2*pi*stepClock+radians(90))
          )  
            
  translate -numberOfSeconds*distancePerSecond*z *stepClock
}
*/

#declare forceRand = seed( 164 );
                                     
#macro RandomWeapon( pLocation )
  object {
    #switch (rand(forceRand))  
      #range (0, 0.1)
        object { BannerObject }
        #break
        
      #range (0.1, 0.35)
        object { SwordObject }
        #break
        
      #range (0.35, 0.6)
        object { ShieldObject }
        #break

      #else
        object { PikeObject }
        #break
    #end

    rotate 90*x
    rotate rand( forceRand ) *360 * y
    
    translate pLocation
  }  
#end

#macro RandomWarrior( pClock, pFractionStationary, pInitialDisplacement, pWalkDirection, pNumberOfSeconds, pStepsPerSecond, pDistancePerStep )
  #declare __stepClock = pNumberOfSeconds*pStepsPerSecond*pClock*2;
  #declare stationary = false;
  #declare phaseOffset = 80*rand( forceRand ) - 40;
  object {
    #switch (rand(forceRand))  
      #range (0, 0.1)
        #if (rand( forceRand ) < pFractionStationary )
          #declare stationary = true;
          object { BannerWarrior( 
                      // Left side
                      0, 0, 0,
                      0, 0, 0
                    )  
          }
        #else          
          object { BannerWarrior( 
                      // Left side (1's)
                      0+20*sin(2*pi*__stepClock+radians( 270+phaseOffset )),
                      20+20*sin(2*pi*__stepClock + radians( 360+phaseOffset )),            
                      15*sin(2*pi*__stepClock + radians( 270+phaseOffset )),
                      
                      // Right side
                      0+20*sin(2*pi*__stepClock+radians( 90+phaseOffset )),
                      20+20*sin(2*pi*__stepClock + radians( 180+phaseOffset )),            
                      15*sin(2*pi*__stepClock+radians(90+phaseOffset))
                    )  
          }  
        #end  
        #break
        
      #range (0.1, 0.6)
        #if (rand( forceRand ) < pFractionStationary )
          #declare stationary = true;
          object { SwordWarrior( 
                      // Left side (1's)
                      0, 0, 0, 0, 0, 0,
                      0, 0, 0, 0, 0, 0
                    )  
          }
        #else
          object { SwordWarrior( 
                      // Left side (1's)
                      0,
                      (11.2+15*sin(2*pi*__stepClock+radians(180+phaseOffset))),
                      (40-25*sin(2*pi*__stepClock + radians(0+phaseOffset))),
                      
                      0+20*sin(2*pi*__stepClock+radians( 270+phaseOffset )),
                      20+20*sin(2*pi*__stepClock + radians( 360+phaseOffset )),            
                      15*sin(2*pi*__stepClock + radians( 270+phaseOffset )),
                      
                      // Right side
                      0,
                      (11.2+15*sin(2*pi*__stepClock + radians(0+phaseOffset))),
                      (42.2-25*sin(2*__stepClock*pi + radians(180+phaseOffset))),
                      
                      0+20*sin(2*pi*__stepClock+radians( 90+phaseOffset )),
                      20+20*sin(2*pi*__stepClock + radians( 180+phaseOffset )),            
                      15*sin(2*pi*__stepClock+radians(90+phaseOffset))
                    )  
          }
        #end  
        #break
        
      #else
        #if (rand( forceRand ) < pFractionStationary )
          #declare stationary = true;
          object { PikeWarrior( 
                      // Left side (1's)
                      0, 0, 0, 0, 0, 0,
                      0, 0, 0, 0, 0, 0
                    )  
          }
        #else
          object { PikeWarrior( 
                      // Left side (1's)
                      0,
                      (11.2+15*sin(2*pi*__stepClock+radians(180+phaseOffset))),
                      (40-25*sin(2*pi*__stepClock + radians(0+phaseOffset))),
                      
                      0+20*sin(2*pi*__stepClock+radians( 270+phaseOffset )),
                      20+20*sin(2*pi*__stepClock + radians( 360+phaseOffset )),            
                      15*sin(2*pi*__stepClock + radians( 270+phaseOffset )),
                      
                      // Right side
                      0,
                      (11.2+15*sin(2*pi*__stepClock + radians(0+phaseOffset))),
                      60+(42.2-25*sin(2*__stepClock*pi + radians(180+phaseOffset))),
                      
                      0+20*sin(2*pi*__stepClock+radians( 90+phaseOffset )),
                      20+20*sin(2*pi*__stepClock + radians( 180+phaseOffset )),            
                      15*sin(2*pi*__stepClock+radians(90+phaseOffset))
                    )  
          }
        #end  
        #break
    #end
    #if (!stationary)
      translate -y*(0.02+0.02*(sin(2*pi*pClock + radians(90+phaseOffset))))
    #end

    rotate 90*-y
    
    #local aVec = vnormalize( pWalkDirection );
    rotate -y * degrees(atan2( aVec.z, aVec.x ) )  
    #if (!stationary)
      #local aLoc = trace( Ground, 10000*m*y + pInitialDisplacement + aVec * (pNumberOfSeconds*pStepsPerSecond*pDistancePerStep *pClock) , -y );
    #else  
      #local aLoc = trace( Ground, 10000*m*y + pInitialDisplacement , -y );
    #end  
    translate aLoc
  }  
#end

#macro MarchingForces( pInitialDisplacement )
  #ifdef (segment)
    #declare numberOfSeconds = sceneTimings[ segment-1 ];
  #else
    #declare numberOfSeconds = 4;    
  #end
  #declare stepClock = numberOfSeconds*stepsPerSecond*vClock;
    
  #declare setSpacing = 30*m;  
  #declare k = 0;
  #while (k < 4)
    #declare j = 0;
    #while (j < 10)
      #declare i = -4;
      #while ( i <= 4)
        #declare phaseOffset = 80*rand( forceRand ) - 40;
        #if (j = 0)  
          object { SwordWarrior( 
                      // Left side (1's)
                      -45,
                      (11.2+15*sin(2*pi*stepClock+radians(180+phaseOffset))),
                      (90-10*sin(2*pi*stepClock + radians(0+phaseOffset))),
                      
                      0+20*sin(2*pi*stepClock+radians( 270+phaseOffset )),
                      20+20*sin(2*pi*stepClock + radians( 360+phaseOffset )),            
                      15*sin(2*pi*stepClock + radians( 270+phaseOffset )),
                      
                      // Right side
                      0,
                      (11.2+15*sin(2*pi*stepClock + radians(0+phaseOffset))),
                      (42.2-25*sin(2*stepClock*pi + radians(180+phaseOffset))),
                      
                      0+20*sin(2*pi*stepClock+radians( 90+phaseOffset )),
                      20+20*sin(2*pi*stepClock + radians( 180+phaseOffset )),            
                      15*sin(2*pi*stepClock+radians(90+phaseOffset))
                    )  
          
            rotate 180*y              
            translate -y*(0.02+0.02*(sin(2*pi*stepClock + radians(90+phaseOffset))))
            #declare startVect = <i*m, 10000*m, -setSpacing*k - j*1.5*m + (numberOfSeconds*stepsPerSecond*distancePerStep *vClock)> + pInitialDisplacement;
            #declare hitLoc = trace( Ground, startVect, -y );
            translate hitLoc
            translate pInitialDisplacement
          }
        #else
          object {
            RandomWarrior(vClock, 0.00, <i*m, 0, -setSpacing*k - j*1.5*m>+pInitialDisplacement, z, numberOfSeconds, stepsPerSecond, distancePerStep )
            //rotate 180*y
            //#declare startVect = <i*m, 10000*m, -setSpacing*k - j*1.5*m + (numberOfSeconds*stepsPerSecond*distancePerStep *vClock)> + pInitialDisplacement;
            //#declare hitLoc = trace( Ground, startVect, -y );
            //translate hitLoc
            //translate pInitialDisplacement
          }  
        #end
        #declare i = i + 1;
      #end  
      #declare j = j + 1;
    #end
    object {
      #declare loc = pInitialDisplacement + <0, 0, -19*m + -setSpacing*k+ (numberOfSeconds*stepsPerSecond*distancePerStep *vClock)>;
      #declare loc1 = trace( Ground, <0, 1000*m, loc.z-CatapultLength/2*0.75>, -y );
      #declare loc2 = trace( Ground, <0, 1000*m, loc.z+CatapultLength/2*0.75>, -y );
      Catapult(360/(80*cm*2*pi)*(-numberOfSeconds*stepsPerSecond*distancePerStep *vClock), 0, false)
      rotate -90*y
      rotate (degrees( asin( (loc2.y - loc1.y) / CatapultLength ) ) ) *-x
      translate (loc1+loc2)/2 
    }
    #declare k = k + 1;
  #end 
#end


#macro RunningWarrior(pClock, pStartLocation, pDirectionVector, pTime, pStepsPerSecond, pDistancePerRunningStep )
  object { Warrior( 
              // Left side (1's)
              0,
              (11.2+15*sin(2*pi*pClock+radians(180))),
              (40-25*sin(2*pi*pClock + radians(0))),
              
              0+30*sin(2*pi*pClock+radians( 270 )),
              30+30*sin(2*pi*pClock + radians( 360 )),            
              15*sin(2*pi*pClock + radians( 270 )),
              
              // Right side
              0,
              (11.2+15*sin(2*pi*pClock + radians(0))),
              (42.2-25*sin(2*pClock*pi + radians(180))),
              
              0+30*sin(2*pi*pClock+radians( 90 )),
              30+30*sin(2*pi*pClock + radians( 180 )),            
              15*sin(2*pi*pClock+radians(90))
            )

    #declare aDirectionVector = <pDirectionVector.x, 0 pDirectionVector.z>;  
    #declare loc = pStartLocation + vnormalize( aDirectionVector ) * pTime*pStepsPerSecond*pDistancePerRunningStep*pClock;
    #declare loc = trace( Ground, loc, -y );
#debug concat ( "loc = <", str( loc.x, 4, 4), ", ", str( loc.y, 4, 4), ", ", str( loc.z, 4, 4), ">\n" )
    translate loc
  }
#end

// Walking warrior
/*
object { SwordWarrior( 
            // Left side (1's)
            0,
            (11.2+15*sin(2*pi*vClock+radians(180))),
            (40-25*sin(2*pi*vClock + radians(0))),
            
            0+20*sin(2*pi*vClock+radians( 270 )),
            20+20*sin(2*pi*vClock + radians( 360 )),            
            15*sin(2*pi*vClock + radians( 270 )),
            
            // Right side
            0,
            (11.2+15*sin(2*pi*vClock + radians(0))),
            (42.2-25*sin(2*vClock*pi + radians(180))),
            
            0+20*sin(2*pi*vClock+radians( 90 )),
            20+20*sin(2*pi*vClock + radians( 180 )),            
            15*sin(2*pi*vClock+radians(90))
          )  

  translate -y*(0.02+0.02*(sin(2*pi*vClock + radians(90))))
  //translate -numberOfSeconds*distancePerSecond*z *vClock
}
*/