/*
	Brass and Steel
	By Daniel Dresser
*/

/*
	This code is suffering badly from lack of commenting, poor structure,
	and poor variable names.  I apologize.
*/
	
/*
  Dimensions are in millimetres
  -habits die hard
*/

/*
	Rendered at 320x240, AA 0.3, +KF4.3 +KFF860
*/	
	
#version 3.1; //	I don't know if this rendering will run on 3.5 

#include "metals.inc"
#include "colors.inc"
#include "glass.inc"
#include "woods.inc"
#include "match.inc"

global_settings{ambient_light <0.5,0.5,0.5>}

#declare Quik1 = false;
#declare oops = 50;//An offset to move the whole back portion
									 //It got introduced when halfway through I
									 //rechecked the blade path

#switch(clock)
	#range (0,3.5)
		#declare RealTime=clock;
	#break
	#range (3.5,4)
		#declare RealTime=3.493; //Freeze and camera rotate
														 //The extra -0.007 is a spoof to get
														 //the blades in a prettier position
	#break		                                        
	#range (4,5)
		#declare RealTime=clock-0.5;
	#break
#end
	
#declare DoorPos=0;
#if ((RealTime>0)&(RealTime<1))
	#declare DoorPos=sin((RealTime-0)*pi)*45;
#end

#switch(RealTime)
	#range(0,1)
		#declare RotTime=0;
	#break
	#range(1,2)
		#declare RotTime=(RealTime-1)*(10+2/3)
	#break
	#range(2,2.5)
		#declare TempTime=(RealTime-2)/0.5
		#declare RotTime=(RealTime-1)*(10+2/3)+TempTime*TempTime*5
	#break
	#range(2.5,10)
		#declare RotTime=(RealTime-1)*(10+2/3)+5+(RealTime-2.5)*20;
	#break	
#end		

#declare FlareOn=false
#if ((RealTime<0.925)&(RealTime>0.91))
	#declare FlareOn=(RealTime-0.91)/0.015
#end		
#declare FireOn = (RealTime>0.925);
//#declare FireOn = false;
#declare FireTime = RealTime*200;

//#declare FeedRot=-clock*360*10;
//#declare FeedSlide=56*pi*FeedRot/360;
//#declare FeedSlide=-732.0508+74+50+10+190;
/*#if (RealTime<0.5)
	#declare FeedSlide=-(RealTime*1000);
#else
	#declare FeedSlide=-(1000-RealTime*1000);
#end*/
#switch (RealTime)
	#range(0,3.1)
		#declare FeedSlide=0;
	#break
	#range(3.1,3.2)
		#declare TempTime=(RealTime-3.1)/0.1;
		#declare FeedSlide=(-732.0508+74+50+10+190+30)*TempTime;
	#break
	#range(3.2,3.6)
		#declare TempTime=(RealTime-3.2)/0.4;
		#declare FeedSlide=(-732.0508+74+50+10+190+30)-30*TempTime;
	#break
	#range(3.6,3.7)
		#declare TempTime=(RealTime-3.6)/0.1;
		#declare FeedSlide=(-732.0508+74+50+10+190+30-30)*(1-TempTime);
	#break
	#range(3.7,10)
		#declare FeedSlide=0;
	#break	
#end	
#declare FeedRot=((FeedSlide*360)/pi)/56;

#switch (RealTime)
	#range(0,3.6)
		#declare ChopFeedSlide=FeedSlide;
		#declare ChopRotTime=RotTime;
	#break
	#range(3.6,10)
		#declare ChopRotTime=RotTime
		#declare ChopFeedSlide=(-732.0508+74+50+10+190+30)-30
	#break
#end		

#switch (RealTime)
	#range(0,3.1)
		#declare ClaspRot=90;
	#break 
	#range(3.1,3.15)
		#declare TempTime=(RealTime-3.1)/0.05;
		#declare ClaspRot=90-90*TempTime;
	#break
	#range(3.15,5)
		#declare ClaspRot=0;
	#break
#end		
		

#switch (RealTime)
	#range(0,2)
		#declare PencilPos=-1;
	#break
	#range(2,3)
		#declare PencilPos=1;
	#break	
	#range(3,3.1)	
		#declare PencilPos=1-(RealTime-3)/0.1
	#break
	#range(3.1,3.7)
		#declare PencilPos=0;
	#break
	#range(3.7,3.8)
		#declare PencilPos=(RealTime-3.7)/0.1;
	#break
	#range(3.8,10)
		#declare PencilPos=1;
	#break	
#end 		

#declare MatchStage1=RealTime*2;
#declare MatchStage2=(RealTime-0.5)*5;
#declare MatchStage3=(RealTime-0.7)/0.15;


//Name Plate Shot                    
/*camera{
	//up    <0,0.75,0>
  //right  <1,0,0>
  up    <0,0.24,0>
  right  <0.32,0,0>
  //up    <0,0.12,0>
  //right  <0.16,0,0>
  //up    <0,0.06,0>
  //right  <0.08,0,0>
	//location <400,-400,-1200>
	//location <-1000,-300,1000>
	//location <20,-20,60>
	//location <100,-100,-200>
	//location <300,000,1300>
	location <800,25,75>
	//look_at <0,-800,500>
	//look_at <500,300,300>
	look_at <645,-50,5>	
	sky <0,0,1>
	//orthographic
}*/

//Blade path for checking
/*torus{
	200+64,178
	rotate x*90
	pigment{rgbf<0.5,0.5,1,0.8>}
	clipped_by{plane{-z,0}}
}*/

/*plane{
	z,0
	pigment{rgbf<0.5,0.5,1,0.8>}
}*/		

//Comm tech shot - I used this still for a school project
//light_source{<-9500,3000,-10000> rgb<2,2,2> area_light
//	x*200,y*200,4,4}
/*camera{
	up    <0,0.75,0>
  right  <1,0,0>
  //up    <0,0.24,0>
  //right  <0.32,0,0>
  //up    <0,0.12,0>
  //right  <0.16,0,0>
  //up    <0,0.06,0>
  //right  <0.08,0,0>
	//location <400,-400,-1200>
	location <-2000,1000,-3000>
	//location <20,-20,60>
	//location <100,-100,-200>
	//location <2000,2000,0>
	//look_at <0,-800,500>
	look_at <-200,0,0>
	sky <0,0,1>
	//orthographic
}*/

//Actual Camera Path
#switch (clock)
	#range (0,0.2)
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <690,-65,15>
			look_at <645,-50,5>	
		}   
	#break
	#range (0.2,0.5)
		#declare tempclock=(clock-0.2)/0.3;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <690,-65,15>+vrotate(z*-600,-y*180*tempclock)+z*600-x*690*tempclock
			look_at <645,-50,5>+<-645,750,3000-5>*tempclock*tempclock
		}   
	#break
	#range (0.5,0.7)
		#declare tempclock=(clock-0.5)/0.2;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <0,-65,15+1200>
			look_at <0,700,3000>+z*-1250+vrotate(z*1250,y*180*tempclock)-y*1400*tempclock
		}
	#break	
	#range (0.7,1)
		#declare tempclock=(clock-0.7)/0.3;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <0,-65,15+1200>+65*y*tempclock-15*z*tempclock
			look_at <0,-700,500>
		}
	#break
	#range (1,1.5)
		#declare tempclock=(clock-1)/0.5;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <0,0,1200>-z*850+vrotate(vrotate(z*1200,-x*(90+acos(200/1200)*180/pi)*tempclock),-z*45)*<1,1,850/(1200*sin(acos(200/1200)))>
			#if (tempclock<=0.25)
				look_at <0,-700,500>+y*1000*tempclock*4
			#else
				look_at <0,300,500>+<sin(pi/4)*400,-300+sin(pi/4)*400,-500>*(tempclock-0.25)/0.75
			#end
		}
	#break
	#range (1.5,1.75)
		#declare tempclock=(clock-1.5)/0.5;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location vrotate(<200,0,-500>,z*(45+tempclock*90))
			look_at vrotate(<400,0,0>,z*(45+tempclock*90))
		}
	#break
	#range (1.75,2)
		#declare tempclock=(clock-1.5)/0.5;
		#declare tempclock2=(clock-1.75)/0.25;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location vrotate(<200,0,-500>,z*(45+tempclock*90))*(1-tempclock2)+
								<0,500,-1000>*tempclock2
			look_at vrotate(<400,0,0>,z*(45+tempclock*90))*(1-tempclock2)+
							<0,0,0>*tempclock2
		}
	#break
	#range (2,3)
		#declare tempclock=(clock-2);
		#if (clock<2.8)
		#declare tempclock2=0;
		#else
		#declare tempclock2=(clock-2.8)/0.2;
		#end
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
	  	//<0,2000,1500>
			location (<0,500,-1000>+<0,1500,2500>/2+
							 vrotate(vrotate(-z*sqrt(1500*1500+2500*2500)/2,y*360*tempclock),-x*atan2(1500,2500)*180/pi))*(1-tempclock2)+
							 +<300,300,-1200>*tempclock2
			look_at  <0,0,0>
		}
	#break
	#range (3,3.2)
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <300,300,-1200>
			look_at <0,0,0>
		}
	#break
	#range (3.2,3.5)
		#declare tempclock=(clock-3.2)/0.3;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <300,300,-1200>+z*500*tempclock-x*150*tempclock
			look_at <0,0,0>
		}
	#break
	#range (3.5,4)
		#declare tempclock=(clock-3.5)/0.5;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location vrotate(<300,300,-425>,<0,360*tempclock,0>)*<0.5,1,1>+z*-275
								-y*sin(tempclock*pi)*150	
			look_at <0,0,0>
		}
	#break
	#range (4,4.3)
		#declare tempclock=(clock-4)/0.3;
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <150,300,-700>-z*500*tempclock+x*150*tempclock
			look_at <0,0,0>
		}
	#break
	#range (4.3,10)
		camera{
			up    <0,0.75,0>
	  	right  <1,0,0>
			location <300,300,-1200>
			look_at <0,0,0>
		}
	#break
#end

/*camera{
			up    <0,0.75/5,0>
	  	right  <1/5,0,0>
			location <150,150,400>
			look_at <0,0,0>       
		}*/

#declare brass1=texture{T_Copper_1C finish{ambient 0.7}}
//#declare brass1=texture{pigment{rgb<1,1,0>} finish{ambient 0.5}}

#declare caststeel=texture{
		T_Chrome_3B
		normal { bumps 0.4 scale 1 }
		finish { ambient 0.3}//0.4
	}
//#declare caststeel=texture{pigment{rgb<0,0.8,0>} finish{ambient 0.5}}

#declare polishedsteel=texture{T_Chrome_3B finish{ambient 0.5}}
//#declare polishedsteel=texture{pigment{rgb<1,0,0>} finish{ambient 0.9}}

#macro polelight(On)
union{
	cylinder{
		<0,-1000,0>
		<0,940,0>
		10
	}
	
	//Top
	cylinder{
		<0,950,0>
		<0,935,0>
		30
	}
	#declare theta=0;
	#while (theta<360)
		cylinder{
			<0,949,14>
			<0,954,14>
			1
			rotate y*theta
		}	
		#declare theta=theta+90;
	#end
	cylinder{
		<0,953,0>
		<0,955,0>
		15
	}
	
	//Pipe
	torus{
		10,5
		rotate x*90
		clipped_by{box{<0,0,20>,<-30,-30,-20>}}
		translate <10,935,-20>
	}
	torus{
		sqrt(20*20+5*5),5
		clipped_by{plane{-x,0}}
		scale <0.9,1,1>
		rotate x*atan2(10,40)*180/pi
		translate <10,920,0>
	}	
	cylinder{
		<10,915,20>
		<-10,915,20>
		5
	}
	torus{
		sqrt(30*30+5*5),5
		clipped_by{plane{x,0}}
		scale <0.6,1,1>
		rotate x*atan2(-10,60)*180/pi
		translate <-10,910,-10>
	}
	torus{
		10,5
		rotate x*90
		clipped_by{box{<0,0,20>,<30,30,-20>}}
		translate <-10,895,-40>
	}
	
	//bottle
	sphere{
		<0,865,-40>
		30
	}
	cylinder{
		<0,865,-40>
		<0,800,-40>
		30
	}
	sphere{
		<0,800,-40>
		30
	}
	
	//bottle holders
	prism{
		860,855
		5
		<10,0>
		<30,-40>
		<-30,-40>
		<-10,0>
		<10,0>
	}
	
	prism{
		805,810
		5
		<10,0>
		<30,-40>
		<-30,-40>
		<-10,0>
		<10,0>
	}
		
	#if (!On=0)
	  light_source{
			<0,1000,0>
			rgb<1.5,1.5,1.5>
	  }
	  object{
		  lathe{ 
		  	cubic_spline
		  //sor{
	  		4
	  		<-100,1090>
	  		<15,950>
	  		<15,1040>
	  		<40,1065>
	  		sturm
		  }
		  //texture{pigment{Red} finish{ambient 1}}
		  pigment{Clear}
	  	no_shadow
	  	hollow on
	  	interior{
				media{
					emission rgb<0.05,0.05,0.05>
      		//scattering{1,0.001}
        	density{
	        	planar
	        	rotate y*90
        		color_map{ 
        			[0 rgb <0,0,0.5>]
        			[0.5 rgb <0.3,0.3,0.8>]
	        		[0.8 rgb <0.8,0.8,0.8>]
	        		[1 Black]
        		}	
        		scale <1,80,1>
        		translate y*1040
        	}	
				}
			}
	  }	
	#end
	
	//Tweaking
	translate y*-1000
	scale 2
	translate y*1000
	texture{brass1}
}	
#end	

/*light_source{
	<1000,1000,3000>
	rgb<1.5,1.5,1.5>
}*/

/*light_source{
	<0,1000,3000>
	rgb<1,1,1>
	rotate y*120
}*/

/*light_source{
	<0,1000,3000>
	rgb<1,1,1>
	rotate y*240
}*/

object{
	#if (MatchStage1*270<270)
		polelight(0)
	#else
		polelight(1.5)
	#end
	//rotate y*180
	translate <0,0,3000>
}
object{
	#if (MatchStage1*270<30)
		polelight(0)
	#else
		polelight(1.5)
	#end
	translate <0,0,3000>
	rotate y*120
}
object{
	#if (MatchStage1*270<150)
		polelight(0)
	#else
		polelight(1.5)
	#end
	translate <0,0,3000>
	rotate y*240
}

#switch(MatchStage1)
	#range(0,1)
		object{
			match(y*30,0,RealTime*200)
			rotate x*-90
			scale 2 //A bit of exaggeration
			translate <3020,1020,0>
			rotate y*MatchStage1*270
		}
	#break
	#range(1,10)
		#switch(MatchStage2)
			#range(0,1)
				object{
					match(z*-30,0,RealTime*200)
					rotate x*-90
					scale 2 //A bit of exaggeration
					translate z*1160
					rotate y*MatchStage2*180
					translate <0,1020,1860>-y*1520*MatchStage2
				}
			#break
			#range(1,4)
				#if (!((-500-300*MatchStage3*MatchStage3)<-725))
				object{
					match(z*30+MatchStage3*<0.7,0.3,0>*360,0,RealTime*200)
					rotate x*-90
					scale 2 //A bit of exaggeration
					translate <0,-500,700>-z*MatchStage3*25-y*300*MatchStage3*MatchStage3
				}
				#end
			#break
		#end
	#break
#end

/*light_source{
	<4000,3000,3000>
	rgb<1.5,1.5,1.5>
}*/

plane{
	y,-1000
	texture{
		pigment{
			spherical
			color_map{
				[0 Black]
				[0.75 rgb<0.5,0.5,0.5>]
				[1 rgb<0.5,0.5,0.5>]
				//[1 rgb<1.5,1.5,1.5>]
			}
			scale 10000
		}	
		//finish{ambient 0.5}
	}
}

/*box{
	<-1000,-1000,-1000>
	<1000,-2000,1000>
	pigment {White}
	finish{ambient 1}
}*/	



#declare roller = object{
		cylinder{
			<0,0,31>
			<0,0,40>
			15
		}
		texture{polishedsteel}
	}

#declare bladegear = union{
	prism{
		linear_sweep
		linear_spline
		-1,1,
		65
		#declare theta=0;
		#while (theta<360)
			vrotate(<15,-2>,z*theta) 
			vrotate(<17,-0.9>,z*theta)
			vrotate(<17,0.9>,z*theta)
			vrotate(<15,2>,z*theta)
			#declare theta=theta+22.5;
		#end
		<15,-2>
	}
	cylinder{
		<0,-2,0>
		<0,2,0>
		5
	}
	rotate z*90
	texture{brass1}
}

#declare holdergear = union{
	prism{
		linear_sweep
		linear_spline
		-10,10,
		//64
		49
		#declare theta=0;
		#while (theta<360)
			vrotate(<24,-4>,z*theta) 
			vrotate(<30,-2>,z*theta)
			vrotate(<30,2>,z*theta)
			vrotate(<24,4>,z*theta)
			#declare theta=theta+30;
		#end
		<24,-4>
	}
	cylinder{
		<0,-11,0>
		<0,11,0>
		15
	}
	texture{brass1}
}

#declare drivewheel1 = union{
		difference{
			cylinder{
				<0,0,-5>
				<0,0,5>
				185
			}
			cylinder{
				<0,0,-10>
				<0,0,10>
				165
			}	
		}
		cylinder{
			<0,170,0>
			<0,-170,0>
			1
			scale <10,1,5>
		}
		cylinder{
			<0,170,0>
			<0,-170,0>
			1
			scale <10,1,5>
			rotate z*90
		}	
		texture{brass1}
	}

#declare drivewheel2 = union{
		difference{
			cylinder{
				<0,0,-5>
				<0,0,5>
				85
			}
			cylinder{
				<0,0,-10>
				<0,0,10>
				65
			}	
		}
		cylinder{
			<0,75,0>
			<0,-75,0>
			1
			scale <10,1,5>
		}
		cylinder{
			<0,75,0>
			<0,-75,0>
			1
			scale <10,1,5>
			rotate z*90
		}	
		texture{brass1}
	}

#declare drivegear = union{
		difference{
			prism{
				linear_sweep
				linear_spline
				-30,30,
				73
				#declare theta=0;
				#while (theta<360)
					vrotate(<175,-20>,z*theta) 
					vrotate(<194.9,-7>,z*theta)
					vrotate(<194.9,7>,z*theta)
					vrotate(<175,20>,z*theta)
					#declare theta=theta+20;
				#end
				<175,-20>
			}
			cylinder{
				<0,-40,0>
				<0,40,0>
				145
			}	
		}
		cylinder{
			<0,-50,0>
			<0,50,0>
			50
		}
		cylinder{
			<-150,0,0>
			<150,0,0>
			1
			scale <1,10,30>
		}
		cylinder{
			<-150,0,0>
			<150,0,0>
			1
			scale <1,10,30>
			rotate y*90
		}	
		rotate x*90
		texture{brass1}
	}

#declare biggearcontact = union{
		prism{
			linear_sweep
			linear_spline
			-30,30,
			49
			#declare theta=0;
			#while (theta<360)
				vrotate(<110,-20>,z*theta) 
				vrotate(<130,-7>,z*theta)
				vrotate(<130,7>,z*theta)
				vrotate(<110,20>,z*theta)
				#declare theta=theta+30;
			#end
			<110,-20>
		}
		cylinder{
			<0,-40,0>
			<0,40,0>
			50
		}
		rotate x*90
		texture{brass1}
	}

#declare biggear = union{
	difference{
	prism{
		linear_sweep
		linear_spline
		-30,30,
		257
		#declare theta=0;
		#while (theta<360)
			vrotate(<595,-20>,z*theta) 
			vrotate(<615,-7>,z*theta)
			vrotate(<615,7>,z*theta)
			vrotate(<595,20>,z*theta)
			#declare theta=theta+5.625;
		#end
		<595,-20>
	}
	cylinder{
		<0,-31,0>
		<0,31,0>
		530
	}
	}
	difference{
		cylinder{
			<0,-40,0>
			<0,40,0>
			555
		}
		cylinder{
			<0,-50,0>
			<0,50,0>
			545
		}
	}	
	rotate x*90
	texture{brass1}
}		

//  This is a horribly annoying crown gear 
//  - it does awful things to render time		
//	even after I fiddle with the bounding boxes
#declare weirdgear = difference{
		union{
			difference{
				cylinder{
					<0,0,3>
					<0,0,-50>
					530
				}
				union{
					
					/*#declare theta=0;
					#while (theta<360)
						intersection{
							plane{
								<6,0,-3>
								0
								//bounded_by{box{<4,490,7>  <-4,540,-7>}}
								translate z*-1
								rotate z*theta
							}
							plane{
								<-6,0,-3>
								0                
								//bounded_by{box{<4,490,7>  <-4,540,-7>}}
								rotate z*0.703125
								translate z*-1
								rotate z*theta
							}
							bounded_by{box{<8,490,7>,<-8,540,-7>}rotate z*theta}
						}
						#declare theta=theta+1.40625;
					#end*/
					
					#declare theta=0;
					#while (theta<360)
						union{
						#declare subtheta=-11.25;
						#while (subtheta<11.25)
							intersection{
								plane{
									<6,0,-3>
									0
									//bounded_by{box{<4,490,7>  <-4,540,-7>}}
									translate z*-1
									rotate z*subtheta
								}
								plane{
									<-6,0,-3>
									0                
									//bounded_by{box{<4,490,7>  <-4,540,-7>}}
									rotate z*0.703125
									translate z*-1
									rotate z*subtheta
								}
								bounded_by{box{<8,490,7>,<-8,540,-7>}rotate z*subtheta}
							}
							#declare subtheta=subtheta+1.40625;
						#end
						bounded_by{box{<210,450,8>,<-210,541,-8>}}
						rotate z*theta
						}
						#declare theta=theta+22.5;
					#end
				}
			}
			cylinder{
				<0,0,-3>
				<0,0,-30>
				530
			}
		}
		cylinder{
			<0,0,10>
			<0,0,-3000>
			500
		}
		scale <1,1,-1>
		texture{brass1}
	}	
					
				
	
#declare blade = difference{
		sphere{
			<0,0,0>,1
			scale <200,200,200>
		}
		sphere{
			<0,0,0>,1
			scale <199.5,199.5,500>
		}
		scale <0.8,1,1>
		texture{T_Chrome_2A}
	}

#macro bladeholder(rotphase,gearoffset)
	union{
	union{
		//Arc
		difference{
			torus{
				168,10
				rotate x*90
				scale <1,1,2>
			}
			union{
			box{
				<-1000,0,-1000>
				<1000,-1000,1000>
			}
			//cylinder{
			//<0,0,-100>
			//<0,0,100>
			//168
			//}
			prism{
				linear_sweep
				linear_spline
				-100,100
				19,
				<168,-0.1>
				#declare theta=0;
				#while (theta<180) 
					vrotate(<168,16.546555764>,z*theta)
					#declare theta=theta+11.25;
				#end
				<-168,-0.1>
				<168,-0.1>
				
				rotate x*-90
			}				
			}
			translate y*64
		}
		//Extensions
		difference{
		union{
			cylinder{
				<168,64,0>
				<168,-20,0>
				10
				scale <1,1,2>
			}
			cylinder{
				<-168,64,0>
				<-168,-20,0>
				10
				scale <1,1,2>
			}
		}
		box{
			<168,100,100>
			<-168,-100,-100>
		}
		}
		
		//Stalk
		cylinder{
			<0,235,0>
			<0,327,0>
			10
		}	
		texture{brass1}
	}
	object{
			blade
			rotate x*180*rotphase
	}
	object{
		bladegear
		rotate x*180*rotphase
		translate x*165
	}
	object{
		bladegear
		rotate x*11.25
		rotate x*180*-rotphase
		translate x*165
		translate y*32
	}
	#declare theta=0;
	#declare bool = 1;
	#while (theta<=90)
		object{
			bladegear
			#if (bool)
				rotate x*180*rotphase
			#else
				rotate x*11.25
				rotate x*180*-rotphase
			#end
			translate x*165
			rotate z*theta
			translate y*64
		}
		#declare theta=theta+11.25;
		#declare bool = 1-bool;
	#end
	object{
		holdergear
		translate y*312
		rotate y*gearoffset
	}
	}
#end	


//Stuff that is rotated
#if (!Quik1)
union{
	object{
		bladeholder(RotTime,0)
		rotate -y*180*(RotTime)
		translate<0,200,0>
	}
	object{
		holdergear
		rotate y*((180*RotTime))
		translate y*512
		rotate -z*6.2
		translate z*7
	}

	object{
		bladeholder(RotTime+0.5,15)
		rotate y*((180*RotTime)+15)
		translate<0,200,0>
		rotate z*90
	}
	object{
		holdergear
		rotate -y*(180*RotTime)
		translate y*512
		translate z*-15
		rotate -z*96
		rotate z*180
	}
	object{
		holdergear
		rotate y*((180*RotTime))
		translate y*512
		rotate -z*101.8
		translate z*7
		rotate z*180
	}

	object{
		bladeholder(RotTime,0)
		rotate -y*180*(RotTime)
		translate<0,200,0>
		rotate z*180
	}
	object{
		holdergear
		rotate y*((180*RotTime))
		translate y*512
		rotate -z*6.2
		translate z*8
		rotate z*180
	}
	
	object{
		bladeholder(RotTime+0.5,15)
		rotate y*(180*RotTime)
		translate<0,200,0>
		rotate z*270
	}
	object{
		holdergear
		rotate -y*(180*RotTime)
		translate y*512
		translate z*-15
		rotate -z*96
	}
	object{
		holdergear
		rotate y*((180*RotTime))
		translate y*512
		rotate -z*101.8
		translate z*7
	}

	//Inner support of biggear
	union{
		torus{
			467,15
			rotate x*90
		}
		cylinder{
			<0,452,0>
			<0,482,0>
			15
		}
		cylinder{
			<0,452,0>
			<0,482,0>
			15
			rotate z*90
		}
		cylinder{
			<0,452,0>
			<0,482,0>
			15
			rotate z*180
		}
		cylinder{
			<0,452,0>
			<0,482,0>
			15
			rotate z*270
		}
	
		cylinder{
			<0,467,0>
			<0,540,0>
			15
			rotate z*45
		}
		cylinder{
			<0,467,0>
			<0,540,0>
			15
			rotate z*135
		}
		cylinder{
			<0,467,0>
			<0,540,0>
			15
			rotate z*225
		}
		cylinder{
			<0,467,0>
			<0,540,0>
			15
			rotate z*315
		}
		texture{brass1}
	}
	object{
		biggear
	}
	rotate z*180*RotTime/21.33333333333333333333333333333333
}


object{
	weirdgear
	translate z*35  
	rotate z*6.1
	//rotate z*1.40625/2
}
#end
 

//weirdgear supports
#declare theta=0;
#while (theta<360)
object{
	difference{
		union{
			cylinder{
				<-20,0,0>
				<20,0,0>
				50
			}
			cylinder{
				<-30,0,0>
				<30,0,0>
				40
			}
			torus{
				40,10
				rotate z*90
				translate x*20
			}
			torus{
				40,10
				rotate z*90
				translate x*-20
			}
			scale <1,0.5,1>
			rotate x*30
			translate z*50
		}
		plane{z,40}
	}
	translate <0,540,0>
	rotate z*theta
	texture{caststeel}
}
#declare theta = theta + 90;
#end

//Drive gear assembly
union{
	object{
		biggearcontact
		rotate z*15
	}
	cylinder{
		<0,0,-60>
		<0,0,400+oops>
		20
		texture{brass1}
	}
	object{
		//biggearcontact
		drivegear
		translate z*300
		translate z*oops
	}
	rotate -z*(180*RotTime/4)
	translate <400,608,0>
}

// The first time I layed things out, 
// the piston shaft was too close to
// the blades, hence the offset variable oops
union{

union{
	cylinder{
		<0,0,225>
		<0,0,375>
		20
		texture{brass1}
	}	
	object{
		//drivegear
		biggearcontact
		translate z*300
	}
	object{
		drivewheel2
		translate z*365
	}
	object{
		drivewheel1
		translate z*235
	}	
	rotate z*(180*RotTime*3/8)
	translate <400,303,0>
}


//drivewheel to piston linkage linkage
union{
  difference{
  	union{
			box{
				<0,10,5>
				<250,5,-5>
			}
			box{
				<0,-10,5>
				<250,-5,-5>
			}
			box{
				<15.1,9,2>
				<245,-9,-2>
			}
			difference{
				cylinder{
					<250,0,-5>
					<250,0,5>
					10
				}
				cylinder{
					<250,0,10>
					<250,0,-10>
					5
				} 	
			}   	
			difference{
				cylinder{
					<0,0,-5>
					<0,0,5>
					10
				}
				cylinder{
					<0,0,10>
					<0,0,-10>
					5
				}
			}
		}	
		box{
			<15,20,-2>
			<-20,-20,2>
		}	
	}	
	//holder pegs
	cylinder{
		<250,0,-7>
		<250,0,20>
		5
	}
	cylinder{
		<0,0,-7>
		<0,0,7>
		5
	}	
	
	#declare endx=-175*cos(pi*RotTime*3/8);
	#declare endy=-175*sin(pi*RotTime*3/8);
	rotate z*(180/pi)*atan2(endy,sqrt(pow(250,2)-pow(endy,2)))
	translate <400+endx-sqrt(pow(250,2)-pow(endy,2)),303,215>
	texture{polishedsteel}
}

//piston linkage
difference{
	union{
		box{
			<0,10,5>
			<-450,5,-5>					
		}
		box{
			<0,-10,5>
			<-450,-5,-5>			
		}
		box{
			<0,9,2>
			<-450,-9,-2>
		}
		box{
			<0,10,5>
			<-450,-10,-5>
		}
		difference{
			cylinder{
				<0,0,-5>
				<0,0,5>
				10
			}
			cylinder{
				<0,0,10>
				<0,0,-10>
				5
			}
		}
		cylinder{
			<-450,0,0>
			<-480,0,0>
			50
		}
	}
	box{
		<-15,20,-2>
		<20,-20,-10>
	}
	box{
		<-15,20,2>
		<20,-20,10>
	}	
	translate <400+endx-sqrt(pow(250,2)-pow(endy,2))303,215>
	texture{polishedsteel}
}

//Piston Shaft
union{
	cylinder{
		<-55,303,0>
		<-575,303,0>
		70
		scale <1,1,1>
		translate z*215
	}
	cylinder{
		<-45,303,215>
		<-60,303,215>
		30
	}
	/*cylinder{
		<-75,303,215>
		<-555,303,215>
		50
	}*/
	texture{polishedsteel}
}	

//Steam supply linkage
union{
	box{
		<0,10,5>
		<210,5,-5>
	}
	box{
		<0,-10,5>
		<210,-5,-5>
	}
	box{
		<0,9,2>
		<210,-9,-2>
	}
	difference{
		cylinder{
			<210,0,-5>
			<210,0,5>
			10
		}
		cylinder{
			<210,0,10>
			<210,0,-10>
			5
		} 	
	}   	
	difference{
		cylinder{
			<0,0,-5>
			<0,0,5>
			10
		}
		cylinder{
			<0,0,10>
			<0,0,-10>
			5
		}
	}	
	//holder pegs
	cylinder{
		<210,0,-20>
		<210,0,7>
		5
	}
	cylinder{
		<0,0,-45>
		<0,0,45>
		5
	}	
	
	#declare endx2=-75*cos(pi*(RotTime*3/8-0.5));
	#declare endy2=-75*sin(pi*(RotTime*3/8-0.5));
	rotate z*(180/pi)*atan2(endy2,sqrt(pow(210,2)-pow(endy2,2)))
	translate <400+endx2-sqrt(pow(210,2)-pow(endy2,2)),303,385>
	texture{polishedsteel}
}


//Steam supply block
box{
  <55,333,415>
  <-425,273,355>
  texture{polishedsteel}
}


//Steam supply slider
union{
	box{
		<0,40,40>
		<-230,-40,-40>
	}
	
	box{
	  <270,40,40>
	  <-10,30,30>
	}
	box{
	  <270,40,-40>
	  <-10,30,-30>
	}
	box{
	  <270,-40,40>
	  <-10,-30,30>
	}
	box{
	  <270,-40,-40>
	  <-10,-30,-30>
	}
	
	#declare spar=box{
			<sqrt(2450),5,5>
			<-sqrt(2450),-5,-5>
		}	
	
	object{
		spar
		rotate z*45
		translate <135,0,35>
	}
	object{
		spar
		rotate z*-45
		translate <135,0,35>
	}	
	object{
		spar
		rotate z*45
		translate <135,0,-35>
	}	
	object{
		spar
		rotate z*-45
		translate <135,0,-35>
	}	
	
	difference{
		union{
  	  cylinder{
  	  	<0,0,40>
  	  	<0,0,30>
  	  	40
  	  	scale <0.8,1,1>
  	  	translate x*270
  	  }
  	  cylinder{
  	  	<0,0,-40>
  	  	<0,0,-30>
  	  	40
  	  	scale <0.8,1,1>
  	  	translate x*270
  	  }
		}
		cylinder{
  	  <270,0,-50>
  	  <270,0,50>
  	  5
 	  }	
	}
	
	//Connection to piston intakes
	box{
		<-50,40,210>
		<-180,-40,0>
	}	
	
	texture{polishedsteel}
	translate <400+endx2-sqrt(pow(210,2)-pow(endy2,2))-270,303,385>
}

#macro steampuff (Stage)
	box{
		<25,0,25>
		<-25,200,-25>
		hollow on
		pigment{rgbf 1.0}
		interior{
			media{
				emission 0.05
      	scattering{1,0.1}
				density{
					gradient y
					scale <1,200,1>
				}
				density{
					spherical
					translate y*(250-Stage*300)/40
					warp{turbulence <1,1,1>}
					scale<10,40,10>	
				}
			}
		}
		scale <1,-1,1>
		translate y*200
	}
#end	
				
				

//Steam puff 1
#if (mod((RotTime*3/16+0.1),1) > 0.7)
object{
	steampuff((mod((RotTime*3/16+0.1),1)-0.7)*10/3)
	translate <-230,300,555>
}
#end

//Steam puff 2
#if (mod((RotTime*3/16-0.1),1) < 0.3)
object{
	steampuff((mod((RotTime*3/16-0.1),1))*10/3)
	translate <-140,300,555>
}
#end



//Piston intake block
union{
	difference{
		box{
    	<75,30,30>
	  	<-75,-30,-30>
		}
		union{
			torus{
				30,20
				rotate x*90
				translate<75,30,0>
			}
			torus{
				30,20
				rotate x*90
				translate<-75,30,0>
			}
		}
	}
	box{
		<74,30,30>
		<210,-30,-30>
	}
	box{
		<-74,30,30>
		<-210,-30,-30>
	}	
	texture{polishedsteel}
	translate <-185,303,555>
}

#declare pipebend90 = union{
		difference{
			cylinder{
				<0,0,0>
				<50,0,0>
				20
			}
			plane{
				<-1,-tan(pi/8),0>,0
				translate y*100
			}
		}
		torus{
			20,2
			rotate z*90
			scale <1,1/cos(pi/8),1>
			translate y*-100/cos(pi/8)
			rotate z*22.5
			translate y*100
		}	
			
		difference{
			cylinder{
				<-50,0,0>
				<50,0,0>
				20
				translate y*-100
				rotate z*45
				translate y*100
			}
			plane{
				<1,tan(pi/8),0>,0
				translate y*100
			}
			plane{
				<-tan(pi/8),-1,0>,0
				translate y*100
			}
		}
		
		torus{
			20,2
			rotate z*90
			scale <1,1/cos(pi/8),1>
			translate y*-100/cos(pi/8)
			rotate z*67.5
			translate y*100
		}	
		
		difference{
			cylinder{
				<-50,0,0>
				<0,0,0>
				20
				translate y*-100
				rotate z*90
				translate y*100
			}
			plane{
				<tan(pi/8),1,0>,0
				translate y*100
			}
		}	
	}	
	

//Piston pipe 1
union{
	cylinder{
		<100,0,0>
		<sqrt(125600)-100,0,0>
		20
	}
	
	object{
		pipebend90
		rotate y*180
		translate x*100
	}
	cylinder{
		<0,99,0>
		<0,150,0>
		20
	}
	torus{
		20,3
		translate y*130
	}	
	
	object{
		pipebend90
		translate x*(sqrt(125600)-100)
	}
	cylinder{
		<sqrt(125600),99,0>
		<sqrt(125600),200,0>
		20
	}
	torus{
		20,3
		translate x*sqrt(125600)
		translate y*170
	}	
	
	
	texture{brass1 finish{ambient 1}}
	rotate y*180*atan2(-340,100)/pi
	translate <-105,103,215>
}	

//Piston pipe 2
union{
	cylinder{
		<100,0,0>
		<sqrt(141200)-100,0,0>
		20
	}
	
	object{
		pipebend90
		rotate y*180
		translate x*100
	}
	cylinder{
		<0,99,0>
		<0,150,0>
		20
	}
	torus{
		20,3
		translate y*130
	}	
	
	object{
		pipebend90
		translate x*(sqrt(141200)-100)
	}
	cylinder{
		<sqrt(141200),99,0>
		<sqrt(141200),200,0>
		20
	}
	torus{
		20,3
		translate x*sqrt(141200)
		translate y*170
	}	
	
	
	texture{brass1 finish{ambient 1}}
	rotate y*180*atan2(-340,160)/pi
	translate <-525,103,215>
}	
	

//Steam supply pipe
union{
	torus{
		20,2
		rotate z*90
		translate <-425,303,385>
	}		
	object{
		pipebend90
		scale <-1,-1,1>
		translate <-425,303,385>
	}
	cylinder{
		<-525,203,385>
		<-525,49,385>
		20
	}
	object{
		pipebend90
		scale <-1,1,1>
		translate <-425,-50,385>
	}
	cylinder{
		<-426,-50,385>
		<-99,-50,385>
		20
	}
	object{
		pipebend90
		scale <1,-1,1>
		translate <-100,-50,385>
	}
	cylinder{
		<0,-149,385>
		<0,-250,385>
		20
	}
	torus{
		20,2
		translate <0,-250,385>
	}	
	texture{brass1}
}//Connects to boiler	

translate z*oops //horribly sloppy
}


//Big Gear's Casing
difference{
	union{
		cylinder{
			<0,0,-50>
			<0,0,50>
			630
		}
		cylinder{
			<0,0,-40.000000001>
			<0,0,40.000000001>
			640
		}
		torus{
			630,10
			rotate x*90
			translate z*40
		}
		torus{
			630,10
			rotate x*90
			translate z*-40
		}
		box{
			<630,0,50>
			<-630,-1000,-50>
		}
		box{
			<640,0,40.000001>
			<-640,-1000,-40.000001>
		}
		cylinder{
			<630,0,40.000001>
			<630,-1000,40.000001>
			10
		}
		cylinder{
			<630,0,-40.000001>
			<630,-1000,-40.000001>
			10
		}
		cylinder{
			<-630,0,40.000001>
			<-630,-1000,40.000001>
			10
		}
		cylinder{
			<-630,0,-40.000001>
			<-630,-1000,-40.000001>
			10
		}
		
		
		//Little piece to hold the drive gear
		torus{
			50,10
			rotate x*90
			translate <400,608,40>
		}
		cylinder{
			<400,608,0>
			<400,608,50>
			50
		}
		intersection{
			union{
				torus{
					100,10
					rotate x*90
					translate y*730
					translate z*40
					rotate z*-45
				}
				torus{
					100,10
					rotate x*90
					translate y*730
					translate z*40
					rotate z*-22
				}
			}
			intersection{
				cylinder{
					<0,0,-100>
					<0,0,100>
					730
				}
				plane{
					x,0
					rotate z*-45.000001
				}
				plane{
					-x,0
					rotate z*-21.99999
				}	
			}	
		} 
		difference{
			intersection{
				cylinder{
					<0,0,-50>
					<0,0,50>
					730
				}
				plane{
					x,0
					rotate z*-44.999999999
				}
				plane{
					-x,0
					rotate z*-22
				}
			}
			cylinder{
				<0,730,-100>
				<0,730,100>
				100
				rotate z*-22
			}
			cylinder{
				<0,730,-100>
				<0,730,100>
				100
				rotate z*-45
			}	
		}
		texture{caststeel}
	}
	union{
		cylinder{
			<0,0,-60>
			<0,0,60>
			540
		}
		cylinder{
			<0,0,-39.999999999999>
			<0,0,39.999999999999>
			620
		}
		intersection{
			plane{
				<2,-2,0>
				0
			}
			plane{
				<-3,1,0>
				0
			}
			plane{
				z,39.999999999999	
			}	
		}	
		texture{polishedsteel}
	}
}
object{
	roller
	translate y*570
	rotate z*-46.3
}
object{
	roller
	translate y*570
	rotate z*-46.3
	scale <1,1,-1>
}
object{
	roller
	translate y*570
	rotate z*-17
}
object{
	roller
	translate y*570
	rotate z*-17
	scale <1,1,-1>
}	

#declare shaving1=difference{
		sphere{
			<0,0,1>
			1
			scale <2,5,10>
		}
		sphere{
			<0,0,1.1>
			1
			scale <4,5.3,10>
		}
		scale<1,1,0.2>
    texture{T_Wood3 scale 10 rotate x*90}
  }  
    
//Plaque
union{
	difference{
		/*box{
			<30,20,0>
			<-30,-20,5>
			texture{polishedsteel}
		}*/
		union{
			cylinder{
				<20,10,0>
				<20,10,5>
				10
			}
			cylinder{
				<20,-10,0>
				<20,-10,5>
				10
			}
			cylinder{
				<-20,10,0>
				<-20,10,5>
				10
			}
			cylinder{
				<-20,-10,0>
				<-20,-10,5>
				10
			}
			box{
				<30,10,0>
				<-30,-10,5>
			}
			box{
				<20,20,0>
				<-20,-20,5>
			}	
			texture{polishedsteel}
		}	
		union{
			cylinder{
				<30,20,5>
				<30,-20,5>
				5
			}
			cylinder{
				<-30,20,5>
				<-30,-20,5>
				5
			}
			cylinder{
				<30,-20,5>
				<-30,-20,5>
				5
			}
			cylinder{
				<30,20,5>
				<-30,20,5>
				5
			}
			intersection{
				box{
					<20,10,10>
					<40,30,-10>
				}
				torus{
					10,5
					rotate x*90
					translate<20,10,5>
				}
			}
			intersection{
				box{
					<-20,10,10>
					<-40,30,-10>
				}
				torus{
					10,5
					rotate x*90
					translate<-20,10,5>
				}
			}
			intersection{
				box{
					<20,-10,10>
					<40,-30,-10>
				}
				torus{
					10,5
					rotate x*90
					translate<20,-10,5>
				}
			}               
			intersection{
				box{
					<-20,-10,10>
					<-40,-30,-10>
				}
				torus{
					10,5
					rotate x*90
					translate<-20,-10,5>
				}
			}
			texture{caststeel translate <-640,50,0> rotate y*-90}
		}	
	}
	text{
		ttf "C:\windows\fonts\framd.ttf"
		"BRASS AND STEEL"
		1,0
		scale <-5,5,0.5>
		translate <20,7,5>
		texture{T_Copper_1C finish{ambient 1.5}}
	}
	text{
		ttf "C:\windows\fonts\framd.ttf"
		"BY DANIEL DRESSER"
		1,0
		scale <-4,4,0.5>
		translate <20,0,5>
		texture{T_Copper_1C finish{ambient 1.5}}
	}
	
	/*#declare R=seed(3453532);
	#declare i=0;
	#while (i<20) 
	object{
		shaving1
		scale 1
		rotate <rand(R)*360,rand(R)*360,rand(R)*360>
		translate <-5+(rand(R)-0.5)*20,-5-rand(R)*40,10>
	} 
	#declare i=i+1;
	#end*/
	rotate y*90
	translate <640,-50,0>
}	

//Back to offset by oops
union{

//Rear drive gear casing
difference{
	union{
		torus{
			50,20
			rotate x*90
			translate<400,608,260>
		}
		torus{
			50,20
			rotate x*90
			translate<400,608,340>
		}
		cylinder{
			<400,608,240>
			<400,608,360>
			50
		}
		
		cylinder{
			<350,608,340>
			<320,303,340>
			20
		}
		cylinder{
			<450,608,340>
			<480,303,340>
			20
		}
		cylinder{
			<350,608,260>
			<320,303,260>
			20
		}
		cylinder{
			<450,608,260>
			<480,303,260>
			20
		}
		prism{
			240,360,5
			<350,608>
			<320,303>
			<480,303>
			<450,608>
			<350,608>
			rotate x*-90
			scale <1,1,-1>
		}	
		
		torus{
			80,20
			rotate x*90
			translate<400,303,260>
		}
		torus{
			80,20
			rotate x*90
			translate<400,303,340>
		}
		cylinder{
			<400,303,240>
			<400,303,360>
			80
		}
		
		prism{
			240,360,5
			<320,0>
			<320,303>
			<480,303>
			<620,0>
			<320,0>
			rotate x*-90
			scale <1,1,-1>
		}
		prism{
			260.1,340.1,5
			<300,0>
			<300,303>
			<502,303>
			<638.16,8.39>
			<300,0>
			rotate x*-90
			scale <1,1,-1>
		}
		
		cylinder{
			<480,303,340>
			<620,0,340>
			20
		}
		cylinder{
			<480,303,260>
			<620,0,260>
			20
		}
		cylinder{
			<320,303,340>
			<320,-1000,340>
			20
		}
		cylinder{
			<320,303,260>
			<320,-1000,260>
			20
		}
		
		sphere{
			<620,0,340>
			20
		}
		sphere{
			<620,0,260>
			20
		}
		cylinder{
			<620,0,340>
			<620,0,260>
			20
		}
		
		box{
			<640,0,340>
			<300,-1000,260>
		}
		box{
			<620,0,360>
			<320,-1000,240>
		}
		cylinder{
			<620,0,340>
			<620,-1000,340>
			20
		}
		cylinder{
			<620,0,260>
			<620,-1000,260>
			20
		}
		
		
		texture{caststeel}
	}	
	box{
		<100,900,260>
		<700,150,340>
		texture{polishedsteel}
	}
}	

//Piston support
difference{
	union{
		/*box{
			<-415,343,300>
			<-375,263,600>
		}*/
		//Section reaching to valve blocks
		box{
			<-405,333,200>
			<-385,273,600>
		}
		box{
			<-405,343,200>
			<-385,263,590>
		}
		box{
			<-415,333,200>
			<-375,273,590>
		}
		
		cylinder{
			<-405,333,590>
			<-405,333,200>
			10
		}
		cylinder{
			<-385,333,590>
			<-385,333,200>
			10
		}
		cylinder{
			<-405,273,590>
			<-405,273,200>
			10
		}
		cylinder{
			<-385,273,590>
			<-385,273,200>
			10
		}
		
		cylinder{
			<-405,333,590>
			<-385,333,590>
			10
		} 
		cylinder{
			<-405,273,590>
			<-385,273,590>
			10
		}
		cylinder{
			<-385,273,590>
			<-385,333,590>
			10
		}
		cylinder{
			<-405,273,590>
			<-405,333,590>
			10
		}
		sphere{
			<-405,273,590>
			10
		}
		sphere{
			<-405,333,590>
			10
		}
		sphere{
			<-385,273,590>
			10
		}
		sphere{
			<-385,333,590>
			10
		}
		
		//Rings on shaft
		cylinder{
			<-425,303,215>
			<-365,303,215>
			100
		}
		cylinder{
			<-445,303,215>
			<-345,303,215>
			80
		}
		torus{
			80,20
			rotate z*90
			translate <-425,303,215>
		}
		torus{
			80,20
			rotate z*90
			translate <-365,303,215>
		}
		
		cylinder{
			<-225,303,215>
			<-165,303,215>
			100
		}
		cylinder{
			<-245,303,215>
			<-145,303,215>
			80
		}
		torus{
			80,20
			rotate z*90
			translate <-225,303,215>
		}
		torus{
			80,20
			rotate z*90
			translate <-165,303,215>
		}
		
		//Arch on bottom of piston shaft
		difference{
			union{
				difference{
					cylinder{
				  	<-295,203,245>
			  		<-295,203,185>
			  		140
					}
					cylinder{
				  	<-295,203,300>
			  		<-295,203,100>
			  		60
					}
				}
				difference{
					cylinder{
				  	<-295,203,265>
			  		<-295,203,165>
			  		120
					}
					cylinder{
				  	<-295,203,300>
			  		<-295,203,100>
			  		80
					}
				}
				torus{
					120,20
					rotate x*90
					translate<-295,203,245>
				}
				torus{
					120,20
					rotate x*90
					translate<-295,203,185>
				}
				torus{
					80,20
					rotate x*90
					translate<-295,203,245>
				}
				torus{
					80,20
					rotate x*90
					translate<-295,203,185>
				}
			}
			plane{
				-y,-303
			}
		}
		
		//Trunk
		/*cylinder{
			<-295,203,215>
			<-295,-1000,215>
			20
		}*/
		
		cylinder{
			<-275,103,235>
			<-275,-1000,235>
			20
		}
		cylinder{
			<-275,103,195>
			<-275,-1000,195>
			20
		}
		cylinder{
			<-315,103,195>
			<-315,-1000,195>
			20
		}
		cylinder{
			<-315,103,235>
			<-315,-1000,235>
			20
		}
		box{
			<-255,103,235>
			<-335,-1000,195>
		}
		box{
			<-275,103,255>
			<-315,-1000,175>
		}
		texture{caststeel}
	}
	cylinder{
		<-365,350,555>
		<-365,250,555>
		30
		texture{polishedsteel}
	}
	box{
		<-395,400,430>
		<-100,200,340>
		texture{polishedsteel}
	}	
}	
		
//Steam supply block/intake block support
// and boiler support
difference{
	union{
		//holder for piston intake block
		box{
			<25,333,520>
			<5,273,600>
		}
		box{
			<25,343,530>
			<5,263,590>
		}
		box{
			<35,333,530>
			<-5,273,590>
		}
		
		cylinder{
			<25,333,590>
			<25,333,530>
			10
		}
		cylinder{
			<5,333,590>
			<5,333,530>
			10
		}
		cylinder{
			<25,333,590>
			<5,333,590>
			10
		} 
		cylinder{
			<25,273,590>
			<5,273,590>
			10
		}
		cylinder{
			<25,273,590>
			<25,333,590>
			10
		}
		cylinder{
			<5,273,590>
			<5,333,590>
			10
		}
		cylinder{
			<25,333,530>
			<5,333,530>
			10
		}	
		sphere{
			<25,273,590>
			10
		}
		sphere{
			<25,333,590>
			10
		}
		sphere{
			<5,273,590>
			10
		}
		sphere{
			<5,333,590>
			10
		}
		sphere{
			<5,333,530>
			10
		}
		sphere{
			<25,333,530>
			10
		}
		
		cylinder{
			<25,273,590>
			<25,98,415>
			10
		}
		cylinder{
			<5,273,590>
			<5,98,415>
			10
		}
		cylinder{
			<25,333,530>
			<25,158,355>
			10
		}
		cylinder{
			<5,333,530>
			<5,158,355>
			10
		}
		union{
			box{
				<0,0,0>
				<40,-sqrt(60*60*2),-sqrt(175*175*2)>
			}
			box{
				<10,10,0>
				<30,-sqrt(60*60*2)-10,-sqrt(175*175*2)-10>
			}
			rotate x*-45
			translate <-5,333,530>
		}
		
		//holder for steam supply block
		box{
			<5,363,395>
			<95,100,375>
		}
		box{
			<15,373,395>
			<85,100,375>
		}
		box{
			<15,363,405>
			<85,100,365>
		}
				
		cylinder{
			<15,363,395>
		  <85,363,395>
		  10
		}
		cylinder{
			<15,363,375>
		  <85,363,375>
		  10
		}
		cylinder{
			<15,363,375>
		  <15,363,395>
		  10
		}
		cylinder{
			<85,363,375>
		  <85,363,395>
		  10
		}
		sphere{
			<15,363,395>
			10
		}
		sphere{
			<85,363,395>
			10
		}
		sphere{
			<15,363,375>
			10
		}
		sphere{
			<85,363,375>
			10
		}
		cylinder{
			<15,363,395>
			<15,100,395>
			10
		}
		cylinder{
			<85,363,395>
			<85,100,395>
			10
		}
		cylinder{
			<15,363,375>
			<15,100,375>
			10
		}
		cylinder{
			<85,363,375>
			<85,100,375>
			10
		}
		
		//Trunk
		cylinder{
			<-15,0,0>
			<100,0,0>
			55
			translate <0,100,385>
		}
		cylinder{
			<5,0,0>
			<80,0,0>
			75
			translate <0,100,385>
		}
		torus{
			55,20
			rotate z*90
			translate <5,100,385>
		}
		torus{
			55,20
			rotate z*90
			translate <80,100,385>
		}
		
		box{
			<5,100,310>
			<80,-500,460>
		}
		box{
			<-15,100,330>
			<100,-500,440>
		}
		cylinder{
			<5,100,330>
			<5,-500,330>
			20
		}
		cylinder{
			<5,100,440>
			<5,-500,440>
			20
		}
		cylinder{
			<80,100,330>
			<80,-500,330>
			20
		}
		cylinder{
			<80,100,440>
			<80,-500,440>
			20
		}
		
		
		//Part that wraps around boiler
		cylinder{
			<0,-400,330>
			<0,-400,440>
			220
			scale <300/220,1,1>
		}
		cylinder{
			<0,-400,310>
			<0,-400,460>
			200
			scale <280/200,1,1>
		}
		torus{
			280,20
			rotate x*90
			scale <1,220/300,1>
			translate <0,-400,330>
		}
		torus{
			200,20
			rotate x*90
			scale <300/220,1,1>
			translate <0,-400,330>
		}
		torus{
			280,20
			rotate x*90
			scale <1,220/300,1>
			translate <0,-400,440>
		}
		torus{
			200,20
			rotate x*90
			scale <300/220,1,1>
			translate <0,-400,440>
		}
		
		box{
			<300,-400,330>
			<190,-1000,440>
		}
		box{
			<280,-400,310>
			<210,-1000,460>
		}
		cylinder{
			<280,-400,330>
			<280,-1000,330>
			20
		}
		cylinder{
			<280,-400,440>
			<280,-1000,440>
			20
		}
		cylinder{
			<210,-400,330>
			<210,-1000,330>
			20
		}
		cylinder{
			<210,-400,440>
			<210,-1000,440>
			20
		}
		
		box{
			<-300,-400,330>
			<-190,-1000,440>
		}
		box{
			<-280,-400,310>
			<-210,-1000,460>
		}
		cylinder{
			<-280,-400,330>
			<-280,-1000,330>
			20
		}
		cylinder{
			<-280,-400,440>
			<-280,-1000,440>
			20
		}
		cylinder{
			<-210,-400,330>
			<-210,-1000,330>
			20
		}
		cylinder{
			<-210,-400,440>
			<-210,-1000,440>
			20
		}

		texture{caststeel}
	}
	cylinder{
		<-15,350,555>
		<-15,150,555>
		30
		texture{polishedsteel}
	}
	cylinder{
		<0,-50,385>
		<0,-1000,385>
		30
		texture{polishedsteel}
	}
	sphere{
		<0,-50,385>
		30
		texture{polishedsteel}
	}
		
}		


#declare bolt = union{
		prism{
			linear_sweep
			linear_spline
			0,3
			7
			#declare theta=0;
			#while (theta<360)
				vrotate(<6,0>,z*theta) 
				#declare theta=theta+60;
			#end
			<6,0>
		rotate x*90	
		}
		cylinder{
			<0,0,5>
			<0,0,0>
			2
		}	
		bounded_by{box{
			<5,5,5>
			<-5,-5,0>
		}}	
	}	

#declare boilerring = union{
		cylinder{
			<0,-10,0>
			<0,10,0>
			233
		}
		#declare theta=0;
		#while (theta<360)
			object{
				bolt
				translate z*232
				rotate y*theta
			}	
			#declare theta=theta+30;
		#end
	}		
	
#declare roundedsquare = union{
		cylinder{
			<0.8,0.8,1>
			<0.8,0.8,0>
			0.2
		}
		cylinder{
			<-0.8,0.8,1>
			<-0.8,0.8,0>
			0.2
		}
		cylinder{
			<0.8,-0.8,1>
			<0.8,-0.8,0>
			0.2
		}
		cylinder{
			<-0.8,-0.8,1>
			<-0.8,-0.8,0>
			0.2
		}
		box{
			<0.8,1,1>
			<-0.8,-1,0>
		}
		box{
			<1,0.8,1>
			<-1,-0.8,0>
		}
	}//Used by boiler door	
		


//Boiler

union{
	difference{
		union{
			sphere{
				<0,0,0>,1
				scale <230,150,230>
				translate <0,-400,385>
			}
			object{
				boilerring
				translate <0,-400,385>
			}	
			cylinder{
				<0,-400,385>
				<0,-850,385>
				230
			}
			object{
				boilerring
				translate <0,-600,385>
			}
			object{
				boilerring
				translate <0,-850,385>
			}
			sphere{
				<0,0,0>,1
				scale <230,150,230>
				translate <0,-850,385>
			}
		}
		union{
			box{
				<95,75,0>
				<-95,-75,250>
				translate <0,-725,385>
			}
			cylinder{
				<0,-399,385>
				<0,-851,385>
				210
			}
			sphere{
				<0,0,0>,1
				scale <210,130,210>
				translate <0,-850,385>
			}
			#if(FireOn) 
			texture{pigment{rgb<1,0.5,0.5>} finish{ambient rgb<0.7,0,0>}}
			#else
			texture{pigment{rgb<0.5,0.5,0.5>}}
			#end
			
		}	
	}
	
	
	//Dark stuff in boiler (coal,logs? whatever you think it is)
	#declare R=seed(534525);
	union{
		#declare i=0;
		#while (i<40)
			cylinder{
				<30,0,0>
				<-30,0,0>
				5
				rotate 360*<rand(R)/4-0.125,rand(R),rand(R)/4-0.125>
				translate <pow(rand(R)-0.5,1),rand(R)/10,pow(rand(R)-0.5,1)>*200
			}
			#declare i=i+1;
		#end
		translate <0,-950,385>
		texture{#if (FireOn) 
							pigment{rgb<1,1,1>} finish{ambient rgb<0.5,0,0>}
						#else
							#if (FlareOn)	
								pigment{spherical color_map{[0 White][1 Black]} scale 100 translate <0,-800,550>}
							#end	
						#end}
	}
	
	//This is a last minute effect that a friend thought up
	//as an improvement over the fire just switching on 
	#if (FlareOn)
		light_source{
			<0,-700,550>				
			rgb FlareOn*4
			fade_distance 1000
			fade_power 3
		}
	#end
	
	#if (FireOn)
		//Fire
		/*light_source{
			//Smooth pseudorandom movement by overlapping
			//out of phase sin waves
			<0,-700,385>+20/3*<
				sin((FireTime-0.4))+
				sin((FireTime+0.3)/2)+
				sin((FireTime-0.2)/3),
				sin((FireTime+0.9)/2)+
				sin((FireTime-0.1)/3)+
				sin((FireTime-0.4)/4),
				sin((FireTime+0.7))+
				sin((FireTime-0.2)/3)+
				sin((FireTime-0.5)/4)>
			rgb<2,0,0>
			fade_distance 1000
			fade_power 3
		}*/
		light_source{
			<0,-700,385>+20/3*<
				sin((FireTime+0.3)/4)+
				sin((FireTime-0.2)/2)+
				sin((FireTime+0.5)),
				sin((FireTime+0.1)/1)+
				sin((FireTime-0.6)/5)+
				sin((FireTime+0.2)/3),
				sin((FireTime+0.8)/4)+
				sin((FireTime-0.2)/2)+
				sin((FireTime-0.8)/1)>
			rgb<4,1,0>
			fade_distance 1000
			fade_power 3
		}
	#end
	
	//door
	union{
		intersection{
			difference{
				object{
					roundedsquare
					scale <100,80,250>
				}
				object{
					roundedsquare
					scale <80,60,250>
				}
			}
			difference{
				cylinder{
					<0,150,0>
					<0,-150,0>
					240
				}
				cylinder{
					<0,150,0>
					<0,-150,0>
					230
				}
			}
		}
		intersection{
			box{
				<95,75,0>
				<-95,-75,250>
			}	
			difference{
				cylinder{
					<0,150,0>
					<0,-150,0>
					237
				}
				cylinder{
					<0,150,0>
					<0,-150,0>
					233
				}
			}
			//texture{T_Glass3}
			texture{pigment{rgbt<0,0,0,1>}}
			//interior{I_Glass}
		}
		
		//handle
		union{
			cylinder{
				<0,30,260>
				<0,-30,260>
				5
			}
			cylinder{
				<0,0,235>
				<0,0,260>
				5
			}
			rotate y*-22
		}	
		
		//hinge
		cylinder{
			<0,45,241>
			<0,54,241>
			10
			rotate y*30
		}
		
		cylinder{
			<0,65,241>
			<0,55,241>
			10
			rotate y*30
		}
		cylinder{
			<0,70,241>
			<0,40,241>
			5
			rotate y*30
		}
		box{
			<-30,5,10>
			<15,-5,0>
			translate <0,60,235>
			rotate y*28
		}
		
		cylinder{
			<0,-45,241>
			<0,-54,241>
			10
			rotate y*30
		}
		
		cylinder{
			<0,-65,241>
			<0,-55,241>
			10
			rotate y*30
		}
		cylinder{
			<0,-70,241>
			<0,-40,241>
			5
			rotate y*30
		}
		box{
			<-30,5,10>
			<15,-5,0>
			translate <0,-60,235>
			rotate y*28
		}
		rotate y*-30
		translate z*-241
		rotate y*DoorPos
		translate z*241
		rotate y*30
		translate <0,-725,385>
	}			
	texture{polishedsteel}
}

translate z*oops //I grimace every time I look at this
}                                               


#declare pencilgear = union{
		prism{
			linear_sweep
			linear_spline
			-3,3,
			49
			#declare theta=0;
			#while (theta<360)
				vrotate(<26,-5>,z*theta) 
				vrotate(<30,-2>,z*theta)
				vrotate(<30,2>,z*theta)
				vrotate(<26,5>,z*theta)
				#declare theta=theta+30;
			#end
			<26,-5>
			rotate z*90
		}
		cylinder{
			<-15,0,0>
			<15,0,0>
			5
		}	
		cylinder{
			<-7,0,0>
			<7,0,0>
			20
		}
		texture{brass1}
	}	

//Pencil Feeder Support
union{
	//Primary strut
	union{
		difference{
			union{
				sphere{
					<0,0,-732.0508>
					50
				}
				difference{
					torus{
						2000,50
						rotate z*90
						translate <0,-1000,1000>
					}
				  plane{
				  	-<0,1732.0508,1000>
				  	0
				  	translate <0,-1000,1000>
				  }
				}  
				texture{caststeel}
			}	
			union{
				cylinder{
					<0,0,100>
					<0,0,-100>
					12
				}
				box{
					<100,10,35>
					<-100,-10,-35>
				}
				box{
					<10,-300,35>
					<-10,100,-35>
				}
				
				cylinder{
					<20,35,0>
					<60,35,0>
					10
				}
				cylinder{
					<-20,35,0>
					<-60,35,0>
					10
				}
				//plane{x,0}
				texture{polishedsteel}
				translate<0,0,-732.0508>
			}
		}
		union{
			union{
				object{pencilgear}
				cylinder{
					<-50,0,0>
					<80,0,0>
					5
				}
				cylinder{
					<80,0,-40>
					<80,0,40>
					5
				}
				cylinder{
					<80,40,0>
					<80,-40,0>
					5
				}
				/*difference{
					cylinder{
						<85,0,0>
						<75,0,0>
						45
					}
					cylinder{
						<90,0,0>
						<70,0,0>
						35
					}
				}*/
				torus{
					40,5
					rotate z*90
					translate x*80
				}	
				cylinder{
					<80,40,0>
					<120,40,0>
					5
				}	
					
					
				texture{brass1}
				rotate x*FeedRot
				translate y*35
			}
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35
				rotate z*90
			}
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35
				rotate z*180
			}
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35  
				rotate z*270
			}
		  translate<0,0,-732.0508>
		}  
	}
	
	//Secondary strut
	union{
		difference{
			union{
				sphere{
					<0,0,-1500>
					50
				}
				difference{
					torus{
						800,20
						rotate z*90
						translate <0,-750,-1800>
					}
				  plane{
				  	<0,-300,750>
				  	0
				  	translate <0,-750,-1800>
				  }
				}
				texture{caststeel}
			}	
			union{
				cylinder{
					<0,0,100>
					<0,0,-100>
					12
				}
				box{
					<100,10,35>
					<-100,-10,-35>
				}
				box{
					<10,-300,35>
					<-10,100,-35>
				}
				texture{polishedsteel}
				translate<0,0,-1500>
			}	
		}
		union{
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35
			}
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35
				rotate z*90
			}
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35
				rotate z*180
			}
			object{
				pencilgear
				rotate x*FeedRot
				translate y*35  
				rotate z*270
			}
		  translate<0,0,-1500>
		}
	}
}	

//Pencil feeder slider
union{
	cylinder{
		<0,0,0>
		<0,0,30>
		10
	}
	cylinder{
		<0,0,0>
		<0,0,-2000>
		5
	}
	
	#declare curlength = 0;
	#while (curlength<1999)
		cone{
			<0,0,0-curlength>,9
			<0,0,-3-curlength>,5
		}
		/*cylinder{
			<0,0,-3-curlength>
			<0,0,-7-curlength>
			5
		}*/
		cone{
			<0,0,-7-curlength>,5
			<0,0,-10-curlength>,9
		}
		cylinder{
			<0,0,-10-curlength>
			<0,0,-14-curlength>
			9
		}
		#declare curlength=curlength+14;
	#end
	cylinder{
		<0,0,-2002>
		<0,0,-2030>
		10
	}
	
	//Actual holder
	cylinder{
		<0,0,30>
		<0,0,50>
		5
	}	
	difference{
		cylinder{
			<0,0,50>
			<0,0,200>
			5
		}
		cylinder{
			<0,0,40>
			<0,0,250>
			4
		}
		plane{
			-y,0
		}
	}
	difference{
		union{
			cylinder{
				<0,0,95>
				<0,0,105>
				5
			}
			cylinder{
				<0,0,145>
				<0,0,155>
				5
			}
		}
		cylinder{
			<0,0,40>
			<0,0,250>
			4
		}
		plane{y,0}
		translate x*5
		rotate z*ClaspRot
		translate x*-5
	}	
	translate z*74
	translate z*-732.0508
	translate z*-FeedSlide
	texture{polishedsteel}
}	

#declare Coat=texture{pigment{rgb<1,0.7,0.3>} finish{specular 0.3 ambient 1}}
#declare Wood=texture{T_Wood3 rotate x*90 scale 10.1 translate y*-100}
#declare Lead=texture{pigment{rgb<0.1,0.1,0.1>} finish{specular 0.5}}


#if (PencilPos>0|PencilPos=0) //A stupid fix to a stupid bug
															// = checks for rounding errors
															// >= doesn't
//Pencil
union{
	difference{
		/*prism{
			10,190
			7
			#declare theta=0;
			#while (theta<360)
				vrotate(<4,0>,z*theta) 
				#declare theta=theta+60;
			#end
			<4,0>
			rotate x*90
		}*/
		#declare PencilStick=union{
			#declare theta=0;
			#while (theta<360)
					cylinder{
						<3.5,0,10>
						<3.5,0,190>
						0.5
						rotate z*theta
					}	
				#declare theta=theta+60;
			#end
			#declare theta=0;
			#while (theta<360)
					box{
						<1.75,sqrt(3.5*3.5-1.75*1.75)+0.5,10>
						<-1.75,-sqrt(3.5*3.5-1.75*1.75)-0.5,190>
						rotate z*theta
					}	
				#declare theta=theta+120;
			#end
		}
		object{PencilStick}
				
		torus{
			200,200
			rotate x*90
			scale <1,0.8,1>
			translate z*ChopFeedSlide
			translate z*610
		}
							
		texture{
			hexagon        
				texture{
					cylindrical
					scale 0.25*0.75
					texture_map{ 
						[0 Wood]
						[0 Lead]						
						[1 Lead]
					}
				}	
				texture{Coat}
				texture{Coat}	
				
			rotate x*90
			scale 3.9	
		}
	}
	
	#declare flat = normal{bumps 0}
	#declare rings = normal{gradient y sine_wave scale 0.2}
	#declare stripes = normal{radial frequency 15 sine_wave}
	cylinder{
		<0,0,5>
		<0,0,19>
		4.1
		texture{T_Chrome_5C}
		normal{
			planar rotate x*90
			scale 7
			translate z*12
			normal_map{
				[0.0 flat]
				[0.2 flat]
				[0.3 rings]
				[0.6 rings]
				[0.8 stripes]
				[1.0 stripes]
			}	
		}		
	}	
	
	union{
		cylinder{
			<0,0,1>
			<0,0,5>
			3.7
		}
		cylinder{
			<0,0,0>
			<0,0,5>
			2.7
		}
		torus{
			2.7,1
			rotate x*90
			translate z*1
		}
		pigment{rgb<1,0.7,0.7>}
	}
	translate z*200
	rotate x*-90*PencilPos
	translate z*-200
	translate <280,-100,-300>*PencilPos
	translate z+sin(pi*PencilPos)*100
	translate z*(-732.0508+74+50-FeedSlide)
}	
#end		

//Pencil Shavings			
//This could be done through precise and
//complex math or it could be done randomly.
//Since I doubt if anyone could tell the 
//difference in the final result, and I'm 
//getting short on time, I'm doing random.
#debug str(ChopRotTime,3,3)
#declare R=seed(423463752);
#declare curchop=43;
#while (curchop<ChopRotTime&curchop<51)
	#declare time=ChopRotTime-curchop;
	intersection{
		object{PencilStick scale -1 translate z*0}
		difference{
			sphere{
				<0,200,10>,200
				scale <1,1,0.8>
			}
			sphere{
		   	<0,200,10>,200
				scale <1,1,0.8>
				translate z*(1+rand(R)*0.5)
				rotate z*(rand(R)-0.5)*20
			}
			#declare rotation=360*rand(R);
		  rotate z*rotation
		}
		scale 1
		texture{
			hexagon        
				texture{
					cylindrical
					scale 0.25*0.75
					texture_map{ 
						[0 Wood]
						[0 Lead]						
						[1 Lead]
					}
				}	
				texture{Coat}
				texture{Coat}	
				
			rotate x*90
			scale 3.9	
		}
		rotate <rand(R),rand(R),rand(R)>*360*time
		translate (vrotate(<0,200,0>,z*rotation)+z*(rand(R)-0.5)*400)*time/12
							-y*time*time*2-z*15
	}
	intersection{
		object{PencilStick scale -1 translate z*100}
		difference{
			sphere{
				<0,200,10>,200
				scale <1,1,0.8>
			}
			sphere{
		   	<0,200,10>,200
				scale <1,1,0.8>
				translate z*(1+rand(R)*0.5)
				rotate z*(rand(R)-0.5)*20
			}
			#declare rotation=rotation+180;
		  rotate z*rotation
		}
		scale 1
		texture{
			hexagon        
				texture{
					cylindrical
					scale 0.25*0.75
					texture_map{ 
						[0 Wood]
						[0 Lead]						
						[1 Lead]
					}
				}	
				texture{Coat}
				texture{Coat}	
				
			rotate x*90
			scale 3.9	
		}
		rotate <rand(R),rand(R),rand(R)>*360*time
		translate (vrotate(<0,200,0>,z*rotation)+z*(rand(R)-0.5)*500)*time/12
							-y*time*time*2-z*15
	}
	#declare curchop=curchop+0.5;
#end	
		  

#declare web = union{
		intersection{
			torus{
				400,20
				rotate z*90
			}
			box{
				<50,0,0>
				<-50,-380,-380>
			}
		}
		difference{
			box{
				<20,0,0>
				<-20,-380,-380>
			}
			cylinder{
				<50,0,0>
				<-50,0,0>
				400
			}
		}
		translate <0,380,380>
	}	
			

//Support to tie feeder in
union{
	box{
		<30,-1000,0>
		<-30,-1000+80,-1050>
	}
	box{
		<50,-1000,0>
		<-50,-1000+60,-1050>
	}
	box{
		<30,-1000,0>
		<-30,-1000+60,-1070>
	}
	
	cylinder{
		<-30,-1000+60,0>
		<-30,-1000+60,-1050>
		20
	}
	cylinder{
		<30,-1000+60,0>
		<30,-1000+60,-1050>
		20
	}
	cylinder{
		<30,-1000+60,-1050>
		<-30,-1000+60,-1050>
		20
	}
	cylinder{
		<30,-1000+60,-1050>
		<30,-1000,-1050>
		20
	} 
	cylinder{
		<-30,-1000+60,-1050>
		<-30,-1000,-1050>
		20
	}
	sphere{
		<-30,-1000+60,-1050>
		20
	}	   
	sphere{
		<30,-1000+60,-1050>
		20
	}
	
	object{
		web
		translate <0,-1000+50,-950>
	}
	object{
		web
		rotate y*90
		translate <35,-1000,-1000>
	}
	object{
		web
		rotate -y*90
		translate <-35,-1000,-1000>
	}
	object{
		web
		rotate y*180
		translate <0,-1000+50,-50>
	}
	cylinder{
		<400,-1000,-1000>
		<-400,-1000,-1000>
		30
	}
	sphere{
		<-400,-1000,-1000>
		30
	}
	sphere{
		<400,-1000,-1000>
		30
	}
	texture{caststeel}
}

//Horizontal connector support on +x side
union{
	difference{
		intersection{
			union{
				cylinder{
					<0,50,0>
					<0,-50,0>
			  	340
				}
				cylinder{
					<0,30,0>
					<0,-30,0>
					360
				}
				torus{
					340,20
					translate y*30
				}
				torus{
					340,20
					translate y*-30
				}
			}
			box{
				<-400,60,400>
				<0,-60,0>
			}	
			scale <1,1,(420+oops)/360>
			translate <-280,-500,40>
		}
		cylinder{
			<0,60,0>
			<0,-60,0>
			50
			scale <2,1,1>
			translate<-280,-500,280+oops>
		}
		cylinder{
			<0,60,0>
			<0,-60,0>
			160+oops
			translate <-280,-500,40>
		}
		cylinder{
			<0,30,0>
			<0,60,0>
			180+oops
			translate <-280,-500,40>
		}
		cylinder{
			<0,-30,0>
			<0,-60,0>
			180+oops
			translate <-280,-500,40>
		}
	}
	intersection{
		union{
			torus{
				180+oops,20
				translate y*30
			}
			torus{
				180+oops,20
				translate y*-30
			}
		}
		box{
			<0,-70,0>
			<-500,70,500>
		}
		translate <-280,-500,40>
	}	
	texture{caststeel}
}	
/*box{
			<-255,103,235>
			<-335,-1000,195>
		}*/



//Horizontal connector support on +x side
union{
	box{
		<640,-470,0>
		<400,-530,340+oops>
	}
	box{
		<620,-450,0>
		<420,-550,340+oops>
	}
	cylinder{
		<620,-470,0>
		<620,-470,340+oops>
		20
	}
	cylinder{
		<420,-470,0>
		<420,-470,340+oops>
		20
	}
	cylinder{
		<620,-530,0>
		<620,-530,340+oops>
		20
	}
	cylinder{
		<420,-530,0>
		<420,-530,340+oops>
		20
	}
	
	intersection{
		union{
			cylinder{
				<0,50,0>
				<0,-50,0>
				320
			}
			cylinder{
				<0,30,0>
				<0,-30,0>
				340
			}
			torus{
				320,20
				translate y*30
			}
			torus{
				320,20
				translate y*-30
			}
			scale <1,1,120/360>
			translate <300,-500,340+oops>
		}	
		box{
			<641,-449,339+oops>
			<189,-551,461+oops>		 	
		}
	}	
	texture{caststeel}		
}	
		
//Base
union{
	union{
		cylinder{
			<0,-990,0>
			<0,-1000,0>
			700
		}
		torus{
			700,10
			translate y*-1000
		}
		scale <1,1,1.5>
	}
	cylinder{
		<0,-990,-1000>
		<0,-1000,-1000>
		500
	}
	torus{
		500,10
		translate <0,-1000,-1000>
	}                
	texture{caststeel}
}	

/*plane{
	z,-6000
	texture{
		pigment{White}
		finish{ambient 0.5}
	}
}*/

/*difference{
	cylinder{
		<0,0,0>
		<0,100,0>
		3.5
	}
	union{
	cylinder{
		<0,0,0>
		<0,50,0>
		0.5
	}
	torus{
		200,200
		scale y*0.8
	}    
	}
	pigment{
		cylindrical color_map{
			[0.0 rgb<0.9,0.8,0.6>]
			[0.0 rgb<0,0,1>]
			[1.0 rgb<0,0,1>]
		}
	}
	translate y*-20
	scale 50
}*/

/*object{
	bladeholder(-RotTime)
	scale <-1,1,1>
	//rotate -y*180*(RotTime)
	//translate<0,0,0>
}*/

/*object{
	littlegear
	rotate x*90
	rotate z*clock*-22.5
	translate x*-16
}
object{
	littlegear
	rotate x*90
	rotate z*11.25
	rotate z*clock*22.5
	translate x*16
}*/