#include "metals.inc"

#declare laserpos=-clock*30+7;

camera{
	//up    <0,1,0>
  //right  <2,0,0>
  sky <0,5,0>
  location <0,-7,30>
  look_at <0,-3,0>
  orthographic
}

light_source{<10,10,10> rgb<1,1,1>*2}
light_source{<-10,10,10> rgb<1,1,1>*2}

#macro emboss(Angle,Object)
	intersection{
		object{
			Object 
			matrix<1,0,0,
						 0,1,0,
					   1,1,1,
						 0,0,0>										
		}
		object{
			Object 
			matrix<1,0,0,
						 0,1,0,
					   1,-1,1,
						 0,0,0>										
			translate z*0.000000001
		}
		object{
			Object 
			matrix<1,0,0,
						 0,1,0,
					   -1,1,1,
						 0,0,0>
			translate z*0.000000002			 										
		}
		object{
			Object 
			matrix<1,0,0,
						 0,1,0,
					   -1,-1,1,
						 0,0,0>
			translate z*0.000000003			 										
		}
	}
#end

emboss(
		45,
		text{
			ttf "C:\windows\fonts\abaexbc.ttf"
			"DOCTRINE:"
			0.3,0
			scale <-4.5,5,0.5>
			translate <17,-1,0>
			texture{T_Chrome_3B}
		}
	)
	
emboss(
		45,
		text{
			ttf "C:\windows\fonts\abaexbc.ttf"
			"MANOEUVRABILITY"
			0.3,0
			scale <-4.5,5,0.5>
			translate <17,-5,0>
			texture{T_Chrome_3B}
		}
	)

intersection{	
	text{
		ttf "C:\windows\fonts\abaexbc.ttf"
		"By Daniel Dresser"
		0.3,0
		scale <-3,3,0.2>
		translate <5,-10,0>
		pigment{rgb<0,0,1>}
		finish{ambient 1}
	}
	box{
		<10,-5,-1>
		<laserpos,-15,2>
	}
}	
		

intersection{
	text{
		ttf "C:\windows\fonts\abaexbc.ttf"
		"By Daniel Dresser"
		0.3,0
		scale <-3,3,100>
		translate <5,-10,0>
	}
	box{
		<0,-5,0>
		<1,-15,100>
		translate x*laserpos
	}
	matrix<1,0,0,
				 0,1,0,
			   1+clock,1,1,
				 0,0,0>
	pigment{rgbt 1}			 
	hollow			 
	interior{
		media{
			emission rgb<1,2,1>
		}
	}	
}	
		