/* Soft Fruit of Doom */
/* Created by Daniel Dresser*/

#include "colors.inc"
#include "metals.inc"
#include "glass.inc"
#include "skies.inc"
#include "shapes.inc"
 
/*global_settings { ambient_light rgb<1, 1, 1> max_trace_level 3}

camera {
  //up    <0,0.3,0>
  //right  <0.4,0,0>
  //location <cos(clock*2*pi)*4000*sqrt(2),sin(clock*2*pi)*4000*sqrt(2),1500>
  location <4500,2000,2000>
  sky <0,0,50>
  look_at <0,0,500>
  //orthographic
}

light_source{
  <2000,8000,7000> rgb<3,3,3>
}*/
/*
//light_source{
//  <8000,-2000,2000> rgb<3,3,3>
//}

plane{
  <0,0,1>,-1000
  pigment{rgb<0.5,0,0>}
}


sphere {
  <0,0,-900000>,920000
  texture{
   T_Cloud3 scale 25000
  }
  hollow
}*/

#declare hullmetal = 
  texture{
    pigment{rgb<0.9,0.9,0.9>}  
  }
#declare hullmetal =
  texture{
    T_Chrome_1B
    //pigment{rgb<0.7,0.7,0.7>}
    finish{ambient 0.4}
  }

#declare rings=pigment{
    wood color_map{
      [0.0 Clear]
      [0.5 Clear]
      [0.5 Red]
      [1.0 Red]
    }
    turbulence <1,1,1>
    rotate x*90
    scale 0.3
  }
  
#declare pigment2= pigment{rgbf<0,0,0,1>}  
  
/*#declare banana = 
    union{
    }
    
#declare Count = -0.98
#while (Count <= 0.98)
  #declare banana=merge{
       object{
         banana
       }  
       sphere{
         <Count,0,0.5-pow(Count,2)*0.5>
         0.2-pow(Count,2)*0.2
       }
     }  
  #declare Count= Count+0.03-abs(Count)*0.02;
#end*/

#declare banana = union{
   bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
     <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
     <0.500000, 0.275000, 0.675000>, <0.500000, 0.275000, 1.025000>, <0.500000, -0.275000, 1.025000>, <0.500000, -0.275000, 0.675000>, 
     <-0.500000, 0.275000, 0.675000>, <-0.500000, 0.275000, 1.025000>, <-0.500000, -0.275000, 1.025000>, <-0.500000, -0.275000, 0.675000>, 
     <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>
   }
   bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
     <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
     <0.500000, -0.275000, 0.675000>, <0.500000, -0.275000, 0.325000>, <0.500000, 0.275000, 0.325000>, <0.500000, 0.275000, 0.675000>, 
     <-0.500000, -0.275000, 0.675000>, <-0.500000, -0.275000, 0.325000>, <-0.500000, 0.275000, 0.325000>, <-0.500000, 0.275000, 0.675000>, 
     <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>
   }
   texture{hullmetal}
   texture{
     pigment{
       radial pigment_map{
         [0.0 rings]
         [0.1 rings]
         [0.1 pigment2]
         [1.0 pigment2]
       }
       frequency 20
       turbulence 0.1
       rotate y*-0.9
       rotate z*90 
       warp{
         black_hole <0,0,-0.2>,1
         strength 2
         falloff 1
         inverse
       }  
       //translate z*0.5
     }
     finish{ambient 1000}
   }
 } 

#declare guns = union{
    difference{
      cylinder{
        <-300,-150,0>
        <200,-150,0>
        40
      }
      cylinder{
        <-400,-150,0>
        <1000,-150,0>
        30
      }
    }
    difference{
      cylinder{
        <-300,0,0>
        <125,0,0>
        40
      }
      cylinder{
        <-400,0,0>
        <1000,0,0>
        30
      }
    }
    difference{
      cylinder{
        <-300,150,0>
        <50,150,0>
        40
      }
      cylinder{
        <-400,150,0>
        <1000,150,0>
        30
      }
    }
    texture{T_Chrome_2D}
  }                   

#declare engine = union{
    difference{
      cylinder{
        <0,0,0>
        <-800,0,0>
        200
      }
      union{  
        cylinder{
          <0,0,0>
          <-1000,0,0>
          150
        }
        cone{  
          <-900,0,0>
          200
          <0,0,0>
          0
        }
      }
      texture{hullmetal}
    }
    cone{
      <-600,0,0>
      175
      <-1500,0,0>
      0
      texture{
        pigment{Clear}      
      }
      hollow on
      interior{
        media{
          emission rgb<0.003,0.003,1>
          //scattering{1,<0.01,0.01,0.01> extinction (0)}
        }
      }    
    }
  } 
       
       
#declare sfod = union{
	union{
		
		//Main Hull
	  object{
	    banana
	    scale 2000
	  }
	  
	  //Side Hull
	  intersection{
	    object{
	      banana
	      scale 1200
	      rotate <90,30,-20>
	      translate <-100,-100,500>           
	    }
	    
	    //Trim off so it doesn't stick out the other side
	    plane{
	      <0,1,0>,0
	    }
	  }
	  
	  //Side Hull
	  intersection{
  	  object{
  	    banana
  	    scale 1200
  	    rotate <90,30,-20>
  	    translate <-100,-100,500>
  	    scale y*-1           
  	  }
  	  
  	  //Trim off so it doesn't stick out the other side
  	  plane{
  	    <0,-1,0>,0
  	  }
	  }
	  
	  
	  //Sphere with holes for gun bays
	  difference{
	    sphere{
	      <0,0,0>
	      1
	      scale <400,800,250>
	      translate <-450,0,650>
	      texture{hullmetal}
	    }
	    union{
	      cylinder{
	        <0,0,0>
	        <-1000,0,0>
	        1
	        scale <1,200,75>
	        rotate x*60
	        translate <0,380,625>
	        texture {hullmetal}
  	    }
  	    cylinder{
  	      <0,0,0>
  	      <-300,0,0>
  	      1
  	      scale <1,200,75>
  	      rotate x*60
  	      translate <0,380,625>
  	      scale y*-1
  	      texture {pigment{White}}
  	    }    
  	  }      
	  }
	  
	  
	  object{
	    guns
	    rotate x*60
	    translate <0,380,625>
	  }
	  object{
	    guns
	    rotate x*60
	    translate <0,380,625>
	    scale y*-1
	  }
    
    //Hole for cockpit
		clipped_by{
			difference{
				box{
					<-4000,-4000,-4000>,<4000,4000,4000>
				}	
				sphere{
				  <0,0,0>,1
				  scale <820,320,420>
				  rotate y*15
				  translate <400,0,1000>
				}
			}
		}
	}
	
	//Cockpit glass
	difference{
		sphere{
		  <0,0,0>,1
		  scale <830,330,430>
		  rotate y*15
		  translate <400,0,1000>
		}
		sphere{
		  <0,0,0>,1
		  scale <820,320,420>
		  rotate y*15
		  translate <400,0,1000>
		}
		texture{T_Glass3}
		interior{I_Glass}
	}
	
	//Inside of cockpit - sticks out to form rim
	intersection{
		difference{
		  sphere{
		    <0,0,0>,1
		    scale <840,340,440>
		    rotate y*15
		    translate <400,0,1000>
		    texture{hullmetal} 
		    //texture{pigment{Blue}}
		  }
		  sphere{
		    <0,0,0>,1
  		  scale <815,315,415>
			  rotate y*15
  		  translate <400,0,1000>
 			  texture{hullmetal} 
		  }
		}
		quartic{
 			< 1,   0,   0,    0,     2,   0,   0,   0,  -2, -104,
        0,   0,   0,    0,     0,   0,   0,   0,   0,    0,
        1,   0,   0,    0,    -2,  56,   0,   0,   0,    0,
        0,   0,   1,  104,   784>
     	scale <225,200,-15>
			translate z*-20
			texture{hullmetal}
	  }
	}

	object{
	  engine
	  translate <-500,0,1100>
	}
	object{
	  engine
	  scale 0.75
	  translate <-100,700,300>
	} 
	object{
	  engine
	  scale 0.75
	  translate <-100,-700,300>
	}
	//rotate z*360*clock
	//scale <1,1,0.9>
}

/*object{
	sfod
	translate y*3000
}

object{
	sfod
	translate x*3000
}	

object{
	sfod
	translate y*-3000
}*/
