#include "hanger.pov"
#include "ship2.pov"
#include "devmath.inc"

global_settings{max_trace_level 6}
//light_source{<-10000,-10000,10000> rgb<2,2,2>}

#declare upthrust=0;
#declare forwardthrust=0;
#declare ShipPos=<0,0,0>;
#declare ShipRot=<0,0,0>;

#declare LocalClock=clock*2;
#switch(LocalClock)
	#range(0,1)
		#declare ShipPos=<-Smooth(LocalClock)*1000,0,1000+1000*Smooth(LocalClock)>;
		#declare upthrust=1-abs(0.5-LocalClock)*2;
		#declare ShipRot=<0,-25*Smooth(LocalClock),0>;
	#break
	#range(1,2)
		#declare ShipPos=<Smooth((LocalClock-1)/1.5)*2*20000-1000,0,Smooth(LocalClock-1)*500+2000>;
		#declare forwardthrust=Smooth((LocalClock-1)*2)*2;
		#declare ShipRot=<0,-25+25*Smooth(LocalClock-1),0>;
	#break	
	#range(2,4)
		#declare ShipPos=<Smooth((LocalClock-1)/1.5)*2*20000-1000,0,2500>;
		#declare forwardthrust=1;
#end


camera{
	location <6000,2000,500>
	sky z
	look_at ShipPos
}	

object{
	ship2(forwardthrust,0,upthrust,upthrust) 
	rotate ShipRot 
	translate ShipPos
	no_shadow
}	