#include "devmath.inc"
#include "ship4.pov"
#include "ship2.pov"
#include "terrain.pov"

global_settings{max_trace_level 7}

#declare Clock=clock*1.5;
#switch(Clock)
	#range(0,0.5)
		#declare RealTime=Clock;
	#break
	#range(0.5,1)
		#declare RealTime=0.5+(Clock-0.5)/4
	#break
	#range(1,2)
		#declare RealTime=0.625
	#break	
#end		
#declare Toggle=(RealTime>0.2);

#declare ShipPos=z*3000-x*50000+x*60000*RealTime
#declare Ship1Rot=<0,0,0>;
#declare Ship2Rot=<0,0,0>;   
#declare ShotPos=0
#switch(RealTime)
	#range(0.1,1)
		#declare ShotPos=(RealTime-0.1)*60000
  #break
#end 

#declare GoodShipRot2=<0,0,0>;
#switch(RealTime)
	#range(0,0.2)
		#declare GoodShipRot=x*(45-45*Smooth(RealTime/0.2));
	#break
	#range(0.2,2)
		#declare GoodShipRot=<-400,0,0>*(RealTime-0.2)/0.3
		#declare GoodShipRot2=<0,200,0>*(RealTime-0.2)/0.3
	#break
#end
#if(RealTime>0.55)
	#declare GoodShipRot2=GoodShipRot2-y*45*(RealTime-0.55)/0.05
#end	
			
#declare GoodShipHeading=-<0,0,0>;							
																 											
#declare GoodShipPos=	z*3000-x*60000*RealTime;
#if (RealTime>0.2)
	#declare GoodShipPos=z*3000
											-x*12000-x*60000*pow(RealTime-0.2,0.5)
											+z*pow((RealTime-0.2)/0.3,0.5)*12000;
#end																 								

/*#switch(Clock)
	#range(0,0.4)
		#declare GoodShipPos=GoodShipPos+x*3000*(Clock/0.4)-y*Smooth(Clock/0.4)*4000;
		#declare GoodShipRot=x*(45-90*Smooth(Clock/0.4));
		#declare GoodShipHeading=Smooth(Clock/0.2)*-30*z;
	#break
	#range(0.4,1.01)
		#declare GoodShipPos=GoodShipPos+x*3000-y*4000
													+y*20000+vrotate(y*-20000,z*90*(Clock-0.4)/0.6)*<0.7,1,1>;
		#declare GoodShipRot=x*-45;
		#declare GoodShipHeading=z*90*(Clock-0.4)/0.6;
#end*/

#declare FireTime1=0.4;
#declare FireTime2=0.5;
#declare FireTime3=0.6;

#declare FireDelay=0.05;

#switch(RealTime)
	#range(FireTime1,FireTime1+FireDelay)
		cylinder{
			GoodShipPos-z*150,ShipPos+<-3000,3000,0>
			100
			pigment{rgbt 1}
			hollow
			interior{
				media{
					emission rgb<0.005,0.03,0.005>*0.07
				}
			}
		}	
	#break
	#range(FireTime2,FireTime2+FireDelay-0.03)
		cylinder{
			GoodShipPos-z*150,ShipPos+<0,0,0>
			100
			pigment{rgbt 1}
			hollow
			interior{
				media{
					emission rgb<0.005,0.03,0.005>*0.07
				}
			}
		}	
	#break
	#range(FireTime3,FireTime3+FireDelay-0.03)
		cylinder{
			GoodShipPos-z*150,GoodShipPos+vrotate(vrotate(x*-2000000,GoodShipRot),GoodShipRot2)
			100
			pigment{rgbt 1}
			hollow
			interior{
				media{
					emission rgb<0.005,0.03,0.005>*0.07
				}
			}
		}	
	#break
#end		

#switch(Clock)
	#range(0,0.5)
		camera{
			location <10000,0,5000>-x*60000*RealTime
			sky z
			look_at x*-10000-x*60000*RealTime
		}
	#break	
	#range(0.5,0.6)
		camera{
			location <-20000,0,5000>+Smooth((Clock-0.5)/0.1)*<0,5000,10000>
			sky z
			look_at (x*-40000)*(1-(Clock-0.5)/0.1)+GoodShipPos*((Clock-0.5)/0.1)
			//look_at GoodShipPos
		}
	#break
	#range(0.6,1)
		camera{
			location <7000,0,5000>+<0,5000,10000>-x*40000+vrotate(x*40000,z*360*(Clock-0.6)/0.4)
			sky z
			look_at GoodShipPos
		}
	#break
	#range(1,1.6)
		camera{
			location<7000,0,5000>+<0,5000,10000>-x*40000+vrotate(x*(40000+(Clock-1)*30000),z*360*(Clock-1)/0.5)
			sky z
			look_at GoodShipPos*0.5+GoodShipPos*0.5*(1-(Clock-1)/0.5)
														+ShipPos*0.5*((Clock-1)/0.5)
		}
	#break	
#end	
		

/*camera{
	location <320000,3000,10000>+x*60000*Clock
	sky z
	look_at ShipPos-x*15000+y*8000
}*/

//Explosion
#macro explosion(size) 
sphere{
	0,20
	pigment{rgbt<0,0,0,1>}
	//finish{ambient 10}
	hollow
	interior{
		media{
			density{
				spherical                
				warp{turbulence 0.5 lambda 1.01}
				scale <10,10,10>
				warp{turbulence 2 octaves 9 lambda 2 omega 0.6}
				//warp{turbulence 4 octaves 0 lambda 0 omega 0}
				rotate x*-45
				//rotate z*clock*360
				translate <0,0,0>
				color_map{
					[0 	 rgb<0,0,0>*0.005]
					[0.1 rgb<0.5,0.2,0>*0.005]
					[0.5 rgb<0.5,0,0.2>*0.005]
					[1   rgb<0.5,0.2,1>*0.005]
				}	
			}
			emission rgb<0.5,0.5,0.5>
		}
	}
	scale 750*size
}
#end

#declare Shot=union{
	#if (!(ShotPos=0))
		sphere{
			<0,0,0>,1
			pigment{rgbft <1,0.2,0.2,0.2,0.5>}
			//finish{ambient 1}
			pigment{rgbt 1}
			hollow
			interior{
				media{
					density{spherical}
					emission rgb <1,0.001,0.001>
				}
			}
			scale <1000,200,200>
			translate x*ShotPos
		}
	#end
	}

union{
	union{
		object{
			sfod
			rotate Ship2Rot
		}
		#switch(RealTime)
			#range(FireTime2,2)
				object{explosion(RealTime-FireTime2)}
				rotate <568*(RealTime-FireTime2),
								-464*(RealTime-FireTime2),
								235*(RealTime-FireTime2)>
				translate z*(10000*(RealTime-FireTime2)
							-20000*pow((RealTime-FireTime2),2))
			#break
		#end
	}
	union{
		object{
			Shot
			translate <125,380,625>
		}
		object{
			Shot
			translate <125,-380,625>
		}
	}
	
	union{
	  object{
			sfod                    
			rotate Ship2Rot
	  }
	  #switch(RealTime)
			#range(FireTime1,2)
				object{explosion(RealTime-FireTime1)}
				rotate <-325*(RealTime-FireTime1),
								568*(RealTime-FireTime1),
								457*(RealTime-FireTime1)>
				translate z*(10000*(RealTime-FireTime1)
							-20000*pow((RealTime-FireTime1),2))			
			#break
		#end
		translate <-3000,3000,0>
	}	
  union{
		object{
			Shot
			translate <125,380,625>
		}
		object{
			Shot
			translate <125,-380,625>
		}                  
		translate <-3000,3000,0>
	}
  
  union{
		object{
			sfod          
			rotate Ship2Rot
		}
		#switch(RealTime)
			#range(FireTime3,2)
				object{explosion(RealTime-FireTime3)}
				rotate <532*(RealTime-FireTime3),
								-547*(RealTime-FireTime3),
								234*(RealTime-FireTime3)>
				translate z*(10000*(RealTime-FireTime3)
							-20000*pow((RealTime-FireTime3),2))			
			#break
		#end
		translate <-3000,-3000,0>
	}	
	union{
		object{
			Shot
			translate <125,380,625>
		}
		object{
			Shot
			translate <125,-380,625>
		}
		translate <-3000,-3000,0>
	}
	translate ShipPos
}

object{
	ship2(1-Toggle,0,Toggle,0)
	rotate z*180
	rotate GoodShipRot
	rotate GoodShipRot2
	rotate GoodShipHeading
	translate GoodShipPos
}	

