/* CELLULOSE.POV - Programmed by Maarten Hofman */
/* 110902: Started programming */
/* 260902: Added animation (hopefully) */
/* 270902: Changed the type of wood */

#include "colors.inc"
#include "woods.inc"
 
#if (clock<1)
#declare ac=0;             
#declare cc=0; 
#declare bc=clock;
#else
#if (clock<2)             
#declare ac=clock-1;
#declare cc=0;
#else
#declare ac=0;
#declare cc=clock-2;
#end
#declare bc=0;
#end
        
background {
#if (clock<2) 
  colour rgb <0,0,1>
#else
  colour rgb <clock-2,(clock-2)/3,1-(clock-2)>
#end  
}

camera {
//  location <10,15,5>
//  look_at <9,0,3>

#if (clock<1)
  location <13,13,13>
  look_at <8,0,3>
#else
#if (clock<2)  
  location <-50+40*ac,ac*15,100-95*ac>
  look_at <-100+109*ac,0,3*ac>
#else
  location <-10,15,5>
  look_at <9+cc*91,0,3-cc*3>
#end
#end
}

plane {
  z,-100
  texture {
    T_Wood7  
    scale 100
  }
}
           
light_source { <100,100,100> colour White }

#declare oxygen = union {
  sphere { <0.5,0,0>,1.2 pigment { colour White } finish { phong 1 }}
  sphere { <-0.5,0,0>,1.2 pigment { colour White } finish { phong 1 }}
}

#declare carbondioxide = union {
  sphere { <0,0,0>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <1,0,1>,1.2 pigment { colour White } finish { phong 1 }}
  sphere { <-1,0,1>,1.2 pigment { colour White } finish { phong 1 }}
}

#declare carbonmonoxide = union {
  sphere { <0.5,0,0>,1.2 pigment { colour White } finish { phong 1 }}
  sphere { <-0.5,0,0>,1.4 pigment { colour Black } finish { phong 1 }}
}

#declare water = union {
  sphere { <0,0,0>,1.2 pigment { colour White } finish { phong 1 }}
  sphere { <1,0,1>,1 pigment { colour Red } finish { phong 1 }}
  sphere { <-1,0,1>,1 pigment { colour Red } finish { phong 1 }}
}

#declare cellulose = union {
  /* Carbons */
  sphere { <2,0,3>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <3,0,2>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <3,0,4>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <4,0,4>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <5,0,3>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <7,0,3>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <3,0,1>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <8,0,1>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <8,0,2>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <8,0,4>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <9,0,4>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <10,0,3>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <12,0,3>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <13,0,1>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <13,0,2>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <13,0,4>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <14,0,4>,1.4 pigment { colour Black } finish { phong 1 }}
  sphere { <15,0,3>,1.4 pigment { colour Black } finish { phong 1 }}
  /* Oxygens */
  sphere { <1,0,3>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <2,0,1>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <3,0,5>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <4,0,2>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <5,0,5>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <6,0,3>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <7,0,1>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <8,0,5>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <9,0,2>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <10,0,5>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <11,0,3>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <12,0,1>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <13,0,5>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <14,0,2>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <15,0,5>,1.2 pigment { colour Red } finish { phong 1 }}
  sphere { <16,0,3>,1.2 pigment { colour Red } finish { phong 1 }}
  /* Hydrogens */
  sphere { <0,0,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <1,0,1>,1 pigment { colour White } finish { phong 1 }}
  sphere { <2,1,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <3,0,0>,1 pigment { colour White } finish { phong 1 }}
  sphere { <3,1,1>,1 pigment { colour White } finish { phong 1 }}
  sphere { <3,-1,2>,1 pigment { colour White } finish { phong 1 }}
  sphere { <3,-1,4>,1 pigment { colour White } finish { phong 1 }}
  sphere { <4,1,4>,1 pigment { colour White } finish { phong 1 }}
  sphere { <3,0,6>,1 pigment { colour White } finish { phong 1 }}
   sphere { <5,-1,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <5,0,6>,1 pigment { colour White } finish { phong 1 }}
  sphere { <6,0,1>,1 pigment { colour White } finish { phong 1 }}
  sphere { <7,1,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <8,0,0>,1 pigment { colour White } finish { phong 1 }}
  sphere { <8,1,1>,1 pigment { colour White } finish { phong 1 }}
  sphere { <8,-1,2>,1 pigment { colour White } finish { phong 1 }}
  sphere { <8,-1,4>,1 pigment { colour White } finish { phong 1 }}
  sphere { <8,0,6>,1 pigment { colour White } finish { phong 1 }}
  sphere { <9,1,4>,1 pigment { colour White } finish { phong 1 }}
   sphere { <10,-1,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <10,0,6>,1 pigment { colour White } finish { phong 1 }}
  sphere { <11,0,1>,1 pigment { colour White } finish { phong 1 }}
  sphere { <12,1,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <13,0,0>,1 pigment { colour White } finish { phong 1 }}
  sphere { <13,1,1>,1 pigment { colour White } finish { phong 1 }}
  sphere { <13,-1,2>,1 pigment { colour White } finish { phong 1 }}
  sphere { <13,-1,4>,1 pigment { colour White } finish { phong 1 }}
  sphere { <13,0,6>,1 pigment { colour White } finish { phong 1 }}
  sphere { <14,1,4>,1 pigment { colour White } finish { phong 1 }}
   sphere { <15,-1,3>,1 pigment { colour White } finish { phong 1 }}
  sphere { <15,0,6>,1 pigment { colour White } finish { phong 1 }}
  sphere { <17,0,3>,1 pigment { colour White } finish { phong 1 }}
}

#if (clock<2)
object {
  cellulose
  rotate <bc*360,bc*360,bc*360>
}
#if (clock>=1)
object { oxygen rotate <0,0,ac*360> translate <-82+ac*82,-10+ac*9,-27+ac*27> } /* 0,-1,0 */
object { oxygen rotate <0,ac*360,0> translate <-53+ac*58,-23+ac*22,18-ac*15> } /* 5,-1,3 */
object { oxygen rotate <ac*360,0,0> translate <-68+ac*70,-3+ac*3,-1+ac*2>    } /* 2,0,1 */
object { oxygen rotate <0,0,ac*180> translate <-47+ac*60,-13+ac*12,26-ac*20> } /* 13,-1,6 */
object { oxygen rotate <0,ac*180,0> translate <-76+ac*79,45-ac*44,94-ac*92>  } /* 3,1,2 */
object { oxygen rotate <ac*180,0,0> translate <-85+ac*99,-84+ac*83,13-ac*11> } /* 14,-1,2 */
object { oxygen rotate <0,0,270-ac*180> translate <-92+ac*106,63-ac*62,-96+ac*91> } /* 11,1,5 */
object { oxygen rotate <0,270-ac*180,0> translate <-40+ac*44,30-ac*29,43-ac*37>   } /* 4,0,6 */
object { oxygen rotate <270-ac*180,0,0> translate <-91+ac*98,28-ac*28,6-ac*2>     } /* 7,0,4 */
object { oxygen rotate <0,ac*360,ac*360> translate <-75+ac*81,-86+ac*85,-71+ac*76> } /* 6,-1,5 */
object { oxygen rotate <ac*360,0,ac*360> translate <-89+ac*99,95-ac*94,-15+ac*19>  } /* 10,1,4 */
object { oxygen rotate <ac*360,ac*360,0> translate <-56+ac*73,-18+ac*18,48-ac*48>  }  /* 17,0,0 */
object { oxygen rotate <0,270-ac*180,270-ac*180> translate <-83+ac*95,16-ac*16,10-ac*7>  } /* 12,0,3 */
object { oxygen rotate <270-ac*180,0,270-ac*180> translate <-72+ac*87,37-ac*36,23-ac*22> } /* 15,1,1 */
#end
#else
object { carbondioxide rotate <0,0,ac*360> translate <35*cc,-1-97*cc,17*cc> } /* 35,-98,17 */
object { carbondioxide rotate <0,ac*360,0> translate <3+51*cc,-1+54*cc,3+45*cc> } /* 54,53,48 */
object { carbondioxide rotate <ac*360,0,0> translate <6+26*cc,-1+31*cc,6-35*cc> } /* 32,30,-29 */
object { carbondioxide rotate <0,0,ac*180> translate <9+36*cc,-1-49*cc,2-83*cc> } /* 45,-50,-81 */
object { carbondioxide rotate <0,ac*180,0> translate <12+64*cc,-1+12*cc,5-68*cc> } /* 76,11,-63 */
object { carbondioxide rotate <ac*180,0,0> translate <15+61*cc,-1-13*cc,1-94*cc> } /* 76,-14,-93 */
object { carbondioxide rotate <0,0,270-ac*180> translate <4+93*cc,-1-22*cc,-22*cc> } /* 97,-23,-22 */
object { carbondioxide rotate <0,270-ac*180,0> translate <7+74*cc,-1-20*cc,3-36*cc> } /* 81,-21,-33 */
object { carbondioxide rotate <270-ac*180,0,0> translate <11+48*cc,-15*cc,-34*cc> } /* 59,-15,-34 */
object { carbondioxide rotate <0,ac*360,ac*360> translate <14+74*cc,85*cc,3-25*cc> } /* 88,85,-22 */
object { carbonmonoxide rotate <ac*360,0,ac*360> translate <1+79*cc,-57*cc,1-15*cc> } /* 80,-57,-14 */
object { carbonmonoxide rotate <ac*360,ac*360,0> translate <4+85*cc,43*cc,4+21*cc> } /* 89,43,25 */
object { carbonmonoxide rotate <0,270-ac*180,270-ac*180> translate <7+91*cc,-35*cc,63*cc> } /* 98,-35,63 */
object { carbonmonoxide rotate <270-ac*180,0,270-ac*180> translate <16+77*cc,-94*cc,3-62*cc> } /* 93,-94,-59 */
object { carbonmonoxide rotate <270-ac*180,270-ac*180,0> translate <13+67*cc,93*cc,6-15*cc> } /* 80,93,-9 */
object { carbonmonoxide rotate <0,ac*180,ac*180> translate <16+28*cc,4*cc,2+9*cc> } /* 44,4,11 */
object { carbonmonoxide rotate <ac*180,0,ac*180> translate <2+79*cc,-42*cc,5-37*cc> } /* 81,-42,-32 */
object { carbonmonoxide rotate <ac*180,ac*180,0> translate <5+76*cc,89*cc,1-25*cc> } /* 81,89,-24 */
object { water rotate <ac*360,ac*360,ac*360> translate <2+80*cc,1-37*cc,2+12*cc> } /* 82,-36,14 */
object { water rotate <ac*180,ac*180,ac*180> translate <5+71*cc,1+34*cc,5+22*cc> } /* 76,35,27 */
object { water rotate <270-ac*180,270-ac*180,270-ac*180> translate <8+37*cc,1-18*cc,1+26*cc> } /* 45,-17,27 */
object { water rotate <0,0,ac*360> translate <11+51*cc,1-2*cc,4+26*cc> } /* 62,-1,30 */
object { water rotate <0,ac*360,0> translate <14+44*cc,1+43*cc,56*cc> } /* 58,44,56 */
object { water rotate <ac*360,0,0> translate <17+42*cc,1-53*cc,3+67*cc> } /* 59,-52,70 */
object { water rotate <0,0,ac*180> translate <53*cc,-1+19*cc,1+13*cc> } /* 53,18,14 */
object { water rotate <0,ac*180,0> translate <3+88*cc,1+10*cc,6-90*cc> } /* 91,11,-84 */
object { water rotate <ac*180,0,0> translate <6+85*cc,1+58*cc,2-57*cc> } /* 91,59,-55 */
object { water rotate <0,0,270-ac*180> translate <8+58*cc,78*cc,4+83*cc> } /* 66,78,87 */
object { water rotate <0,270-ac*180,0> translate <9+72*cc,1+13*cc,5+9*cc> } /* 81,14,14 */
object { water rotate <270-ac*180,0,0> translate <10+41*cc,-1-21*cc,6-84*cc> } /* 51,-22,-78 */
object { water rotate <0,ac*360,ac*360> translate <12+54*cc,1-81*cc,1+49*cc> } /* 68,-80,50 */
object { water rotate <ac*360,0,ac*360> translate <13+85*cc,-1-43*cc,2> } /* 98,-44,-14 */
object { water rotate <ac*360,ac*360,0> translate <15+68*cc,1-17*cc,4-30*cc> } /* 83,-16,-26 */
object { water rotate <0,270-ac*180,270-ac*180> translate <16+78*cc,-1-47*cc,5-101*cc> } /* 94,-48,-96 */
#end